/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.crypt;

import com.swimap.external.sf.clientutil.ClientUtil;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.common.RpcInvoker;
import com.swimap.sm.client.loginui.common.SMTraceProxy;

public class RSAEncrypt {
    private static final IviewLogger log = SMTraceProxy.getLogger(RSAEncrypt.class);
    private static RSAEncrypt instance = new RSAEncrypt();

    public static void setInstance(RSAEncrypt mock) {
        instance = mock;
    }

    public static RSAEncrypt getInstance() {
        return instance;
    }

    private RSAEncrypt() {
    }

    public boolean initRSAPublickey() throws Exception {
        byte[] publickey = RpcInvoker.getInstance().getRSAPublickey();
        if (null == publickey || publickey.length == 0) {
            log.error((Object)"get fail.");
            return false;
        }
        log.info((Object)("lenght:" + publickey.length));
        ClientUtil.setPublicKey((byte[])publickey);
        return true;
    }

    public byte[] encrypt(byte[] source) {
        return ClientUtil.encryptByPublicKey((byte[])source);
    }

    public byte[] getDynamicAESKey() {
        return ClientUtil.getEncryptedDynamicKey();
    }

    public char[] decryptByDynamicAESKey(byte[] ciphertext) {
        if (null == ciphertext) {
            return null;
        }
        if (0 == ciphertext.length) {
            return new char[0];
        }
        char[] tmp = new char[ciphertext.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = (char)ciphertext[i];
        }
        return ClientUtil.decryptByDynamicKey((char[])tmp);
    }
}

