/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.config;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.framework.pluginmanagement.CommStyleParser;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.loginui.common.SMTraceProxy;

public class UpgradeIntevalParser {
    private IviewLogger log = SMTraceProxy.getLogger(UpgradeIntevalParser.class);
    private CommStyleInfo upgradeStyleInfo;
    private CommStyleParser commStyleParser;

    public UpgradeIntevalParser(CommStyleParser commStyleParser) {
        this.commStyleParser = commStyleParser;
        this.upgradeStyleInfo = commStyleParser.getUserCommStyleInfo("authentication/upgradeinterval");
    }

    public int getUpgradeInterval() {
        int result = -1;
        int value = -1;
        String interval = "0";
        try {
            interval = this.upgradeStyleInfo.getParasItemValue("UpgradeSettings", "TimeInterval");
        }
        catch (Exception e) {
            this.log.error((Object)"UpgradeIntevalParser | getUpgradeInteval | error.", (Throwable)e);
        }
        this.log.info((Object)("UpgradeIntevalParser | getUpgradeInteval | TimeInterval = " + interval));
        try {
            value = Integer.parseInt(interval);
        }
        catch (NumberFormatException e) {
            this.log.info((Object)"UpgradeIntevalParser | getUpgradeInterval | the value is not number...");
            return 0;
        }
        result = value < 0 || value > 3 ? 0 : value;
        if (value == 1000) {
            result = value;
        }
        return result;
    }

    public void saveUpgradeInterval(int interval) {
        try {
            this.upgradeStyleInfo.setParasItemValue("UpgradeSettings", "TimeInterval", String.valueOf(interval));
            this.commStyleParser.writeToUser(this.upgradeStyleInfo);
        }
        catch (Exception e) {
            this.log.error((Object)"UpgradeIntevalParser | saveUpgradeInterval | error.", (Throwable)e);
        }
    }
}

