/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.config;

import com.swimap.external.sf.sound.SoundInfo;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.PluginService;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SoundConfig {
    private IviewLogger log = SMTraceProxy.getLogger(SoundConfig.class);
    public static final String LOGIN_FAILED_WARNING = "LOGIN_FAILED_WARNING";
    public static final String UNLOCK_FAILED_WARNING = "UNLOCK_FAILED_WARNING";
    private static final String SOUND_FLAG = "flag";
    private static final String SOUND_PATH = "path";
    private static final String SOUND_TIME = "time";
    private static final String DEFAULT_SOUND_PATH = "plugins/authentication/style/conf/authentication/loginfail.wav";
    private static final int SOUND_ENABLE = 1;
    private static final int SOUND_DISENABLE = 0;
    private static final int DAFAULT_TIME = 3;
    private static final int TIME_MAX = 1000;
    private static final int TIME_MIN = 1;
    private AreaDescContainer serverCurrentDesc;
    private AreaDescContainer clientCurrentDesc;
    private CommStyleInfo serverStyleInfo;
    private CommStyleInfo clientStyleInfo;
    private List<SoundInfo> currentSoundSettingCache = new ArrayList<SoundInfo>();
    private static final SoundConfig instance = new SoundConfig();

    private SoundConfig() {
    }

    public static SoundConfig getInstance() {
        return instance;
    }

    private void load() {
        if (this.currentSoundSettingCache.isEmpty()) {
            this.loadClientStyleInfo();
            this.loadServerStyleInfo();
        }
    }

    private void loadClientStyleInfo() {
        try {
            this.clientStyleInfo = PluginService.getInstance().getPluginCommStyleInfo("authentication", "authentication/soundconfig");
            if (null != this.clientStyleInfo && this.clientStyleInfo.getAreaDescContainerCount() > 0) {
                this.clientCurrentDesc = this.clientStyleInfo.getAreaDescContainer(0);
                this.currentSoundSettingCache.add(this.parseSound(this.clientCurrentDesc.getDescContainer(LOGIN_FAILED_WARNING), LOGIN_FAILED_WARNING, ResCenter.getInstance().getString(LOGIN_FAILED_WARNING)));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"", (Throwable)e);
            this.currentSoundSettingCache.add(new SoundInfo(LOGIN_FAILED_WARNING, ResCenter.getInstance().getString(LOGIN_FAILED_WARNING), false, this.getDefaultAbsPath(), 3, null));
        }
    }

    private void loadServerStyleInfo() {
        try {
            this.serverStyleInfo = PluginService.getInstance().getUserCommStyleInfo("authentication", "authentication/soundconfig");
            if (null != this.serverStyleInfo && this.serverStyleInfo.getAreaDescContainerCount() > 0) {
                this.serverCurrentDesc = this.serverStyleInfo.getAreaDescContainer(0);
                this.currentSoundSettingCache.add(this.parseSound(this.serverCurrentDesc.getDescContainer(UNLOCK_FAILED_WARNING), UNLOCK_FAILED_WARNING, ResCenter.getInstance().getString(UNLOCK_FAILED_WARNING)));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"", (Throwable)e);
            this.currentSoundSettingCache.add(new SoundInfo(UNLOCK_FAILED_WARNING, ResCenter.getInstance().getString(UNLOCK_FAILED_WARNING), false, this.getDefaultAbsPath(), 3, null));
        }
    }

    private SoundInfo parseSound(DescContainer desc, String key, String name) {
        String path = this.getAbsPath(desc.getParasItemValue(SOUND_PATH));
        boolean flag = this.toInt(desc.getParasItemValue(SOUND_FLAG)) == 1;
        int time = this.toInt(desc.getParasItemValue(SOUND_TIME));
        if (time > 1000 || time < 1) {
            time = 3;
        }
        return new SoundInfo(key, name, flag, path, time, null);
    }

    public List<SoundInfo> getDefaultSoundInfo() {
        ArrayList<SoundInfo> defaultSoundSettingCache = new ArrayList<SoundInfo>();
        defaultSoundSettingCache.add(new SoundInfo(LOGIN_FAILED_WARNING, ResCenter.getInstance().getString(LOGIN_FAILED_WARNING), false, this.getDefaultAbsPath(), 3, null));
        defaultSoundSettingCache.add(new SoundInfo(UNLOCK_FAILED_WARNING, ResCenter.getInstance().getString(UNLOCK_FAILED_WARNING), false, this.getDefaultAbsPath(), 3, null));
        return defaultSoundSettingCache;
    }

    public List<SoundInfo> getCurrenSoundInfo() {
        this.load();
        return this.currentSoundSettingCache;
    }

    public boolean save(List<SoundInfo> soundList) {
        this.clearCache();
        for (SoundInfo info : soundList) {
            this.currentSoundSettingCache.add(info);
            this.save(info);
        }
        try {
            PluginService.getInstance().writeCommStyleInfo(this.clientStyleInfo);
            PluginService.getInstance().writeUserCommStyleInfo("authentication", this.serverStyleInfo);
            return true;
        }
        catch (IOException e) {
            this.log.error((Object)"Error while saving sound settings for user", (Throwable)e);
            return false;
        }
    }

    public void clearCache() {
        this.currentSoundSettingCache.clear();
    }

    private void save(SoundInfo soundInfo) {
        try {
            if (LOGIN_FAILED_WARNING.equals(soundInfo.getKey())) {
                this.save(this.clientCurrentDesc.getDescContainer(LOGIN_FAILED_WARNING), soundInfo);
            } else if (UNLOCK_FAILED_WARNING.equals(soundInfo.getKey())) {
                this.save(this.serverCurrentDesc.getDescContainer(UNLOCK_FAILED_WARNING), soundInfo);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"", (Throwable)e);
        }
    }

    private void save(DescContainer desc, SoundInfo soundInfo) {
        desc.setParasItem(SOUND_PATH, soundInfo.getSoundFile());
        desc.setParasItem(SOUND_FLAG, soundInfo.isPlay() ? "1" : "0");
        desc.setParasItem(SOUND_TIME, Integer.toString(soundInfo.getPlayTime()));
    }

    private int toInt(String str) {
        try {
            return Integer.valueOf(str);
        }
        catch (Exception e) {
            this.log.error((Object)"", (Throwable)e);
            return 0;
        }
    }

    private String getAbsPath(String p) {
        File f = new File(p);
        if (f.exists()) {
            return f.getAbsolutePath();
        }
        this.log.error((Object)("Error file path : " + p));
        return this.getDefaultAbsPath();
    }

    private String getDefaultAbsPath() {
        return new File(DEFAULT_SOUND_PATH).getAbsolutePath();
    }
}

