/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.config;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.framework.pluginmanagement.CommStyleParser;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.util.jni.Os;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.loginui.common.GlobalUtil;
import com.swimap.sm.client.loginui.common.SMTraceProxy;

public class SecurityConfig {
    private IviewLogger log = SMTraceProxy.getLogger(SecurityConfig.class);
    private CommStyleInfo info;
    private long accChangePromptDelayTime = -1L;
    private static SecurityConfig instance = null;

    public static SecurityConfig getInstance() {
        if (instance == null) {
            CommStyleParser parser = PluginManager.getInstance().getPlugin("authentication").getCommStyleParser();
            instance = new SecurityConfig(parser);
        }
        return instance;
    }

    private SecurityConfig(CommStyleParser commStyleParser) {
        CommStyleInfo info;
        this.info = info = commStyleParser.getCommStyleInfo("authentication/securityconfig");
    }

    public String getParasItemValue(String path, String desc) {
        return this.info.getParasItemValue(path, desc);
    }

    private boolean getParasItemBooleanValue(String path, String desc) {
        return Boolean.valueOf(this.info.getParasItemValue(path, desc));
    }

    public boolean isBShowLoginInfo() {
        return this.getParasItemBooleanValue("login", "ShowLoginInfo");
    }

    public boolean isSupportComponent() {
        return this.getParasItemBooleanValue("upgrade", "supportComponent");
    }

    public String getVersionCompareClassName() {
        return this.getParasItemValue("ProductVersionCheckClassPath", "ClientVersionCompareClassName");
    }

    public String getComponentVersionCompareClassName() {
        return this.getParasItemValue("ProductVersionCheckClassPath", "ClientComponentVersionCompareClassName");
    }

    public String getClientUpgradeClassName() {
        return this.getParasItemValue("clientupgrade_mutex_paras", "ClientUpgradeClassName");
    }

    public String getClientUpgradeTitle() {
        return this.getParasItemValue("clientupgrade_mutex_paras", "ClientUpgradeTitle");
    }

    public String getClientMainClassName() {
        return this.getParasItemValue("clientupgrade_mutex_paras", "ClientMainFrameClassName");
    }

    public String getEncryptClassName() {
        return this.getParasItemValue("ProductPasswordClassPath", "PasswordClassName");
    }

    public String getProductLoginClassPath() {
        return this.getParasItemValue("ProductILoginClassPath", "classpath");
    }

    public String getProductPreExitActionClassPath() {
        return this.getParasItemValue("ProductPreExitActionClassPath", "classpath");
    }

    public int getAllowLoginFailedSetting() {
        return this.toInt(this.getParasItemValue("ALLOW_LOGIN_FAILED_SETTING", "ALLOW_LOGIN_FAILED_TIMES"));
    }

    public int getAllowUnlockFailedSetting() {
        return this.toInt(this.getParasItemValue("ALLOW_UNLOCK_FAILED_SETTING", "ALLOW_UNLOCK_FAILED_TIMES"));
    }

    public long getAccChangePromptDelaySetting() {
        if (this.accChangePromptDelayTime < 0L) {
            try {
                String paramValue = this.getParasItemValue("ACC_CHANGE_PROMPT_DELAY_TIME", "ACC_CHANGE_PROMPT_DELAY_TIME");
                this.accChangePromptDelayTime = Long.valueOf(paramValue) * 1000L;
            }
            catch (Exception ex) {
                this.log.error((Object)"Fail to get accChangePromptDelayTime...", (Throwable)ex);
                this.accChangePromptDelayTime = 5000L;
            }
            if (this.accChangePromptDelayTime < 5000L) {
                this.accChangePromptDelayTime = 5000L;
            } else if (this.accChangePromptDelayTime > 3600000L) {
                this.accChangePromptDelayTime = 3600000L;
            }
        }
        return this.accChangePromptDelayTime;
    }

    private int toInt(String v) {
        try {
            return Integer.valueOf(v);
        }
        catch (Exception e) {
            this.log.error((Object)"", (Throwable)e);
            return 3;
        }
    }

    public String getProductExitClassPath() {
        return this.getParasItemValue("ProductExitClassPath", "ProductExitClassName");
    }

    public int getUpgradeCount(Os os) {
        String upgradeClassName = this.getClientUpgradeClassName();
        String upgradeTitle = this.getClientUpgradeTitle();
        this.log.info((Object)("The ClientUpgradeClassName = " + upgradeClassName + " , " + "Upgrade Tool Title = " + upgradeTitle));
        return os.getOnlineWindowNumber(upgradeClassName, upgradeTitle);
    }

    public boolean isShowOSTime() {
        boolean result = false;
        String showTime = this.getParasItemValue("ShowTime", "ShowOSTime");
        if (showTime != null && "true".equals(GlobalUtil.globalDealWithToLowerCase((String)showTime.trim()))) {
            result = true;
        }
        return result;
    }

    public int getShowIPOrServerNameParam() {
        int result = 1;
        String state = this.getParasItemValue("ShowIpServernameParam", "ShowState");
        try {
            int temp = Integer.parseInt(state);
            if (temp == 0 || temp == 10 || temp == 11) {
                result = temp;
            }
        }
        catch (Exception e) {
            this.log.info((Object)"SecurityConfig   getShowIPOrServerNameParam", (Throwable)e);
        }
        return result;
    }

    public int getShowIpParam() {
        int result = 2;
        String position = this.getParasItemValue("ShowIpParam", "PrefixOrPostfix");
        try {
            int temp = Integer.parseInt(position);
            if (temp == 1) {
                result = temp;
            }
        }
        catch (Exception e) {
            this.log.info((Object)"SecurityConfig   getShowIpParam", (Throwable)e);
        }
        return result;
    }
}

