/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.common;

import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.common.PasswordCheckFactory;
import com.swimap.sm.client.base.common.ResourceProxy4Base;
import com.swimap.sm.client.base.common.SMBubbleComponent;
import com.swimap.sm.client.base.policy.member.PolicyUtil;
import com.swimap.sm.client.base.policy.service.PolicyService;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import com.swimap.sm.client.loginui.common.SecurityRedLineUtil;
import com.swimap.sm.client.loginui.common.model.SMPasswordFieldEx;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class UserPasswordField
extends SMPasswordFieldEx
implements FocusListener {
    private static IviewLogger log = SMTraceProxy.getLogger(UserPasswordField.class);
    private ImtInfoCapslockTipBubble bubble;
    private StringBuilder tipMessage;
    int minImtInfoLength = PolicyService.getInstance().getPolicyValue("MinPwdLength");
    int adminMinImtInfoLength = PolicyService.getInstance().getPolicyValue("SuperUserMinPwdLength");
    int maxImtInfoLength = PolicyService.getInstance().getPolicyValue("MaxPwdLength");
    private boolean isAdmin = false;
    private DisplayMoreDetail isShowMoreDetail;
    private boolean disableTips;

    public void setIsAdmin(boolean value) {
        this.isAdmin = value;
    }

    public boolean getIsAdmin(boolean value) {
        return this.isAdmin;
    }

    public UserPasswordField(DisplayMoreDetail isShowMoreDetail) {
        this.isShowMoreDetail = isShowMoreDetail;
    }

    @Override
    public void focusGained(FocusEvent e) {
        super.focusGained(e);
    }

    @Override
    public void focusLost(FocusEvent e) {
        try {
            super.focusLost(e);
            if (this.disableTips) {
                return;
            }
            if (this.bubble == null) {
                this.bubble = new ImtInfoCapslockTipBubble();
            }
            if (this.isEnabled() && this.getPassword().length > 0 && !this.checkPxx()) {
                this.bubble.setBubbleText(this.tipMessage.toString());
                this.bubble.showBubble((JComponent)((Object)this));
            }
        }
        catch (Exception e1) {
            log.error((Object)"", (Throwable)e1);
        }
    }

    public void setDisableTips(boolean disableTips) {
        this.disableTips = disableTips;
    }

    public String getPolicyMessage() {
        return this.tipMessage.toString();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (null != this.bubble && !enabled) {
            this.bubble.hideBubble();
        }
    }

    public boolean checkPxx() {
        boolean checkPolicyResult = true;
        boolean lenValidity = this.checkLength();
        Map<String, String> policyMap = PasswordCheckFactory.getInstance().getChecker();
        Map<String, Integer> updatedPolicyMap = PolicyService.getInstance().getPolicyValues(policyMap.keySet());
        HashMap<String, Integer> policyResult = new HashMap<String, Integer>();
        HashMap<String, Integer> policyResultProhibited = new HashMap<String, Integer>();
        for (Map.Entry<String, String> policy : policyMap.entrySet()) {
            if (!updatedPolicyMap.containsKey(policy.getKey()) || this.check(this.getPassword(), policy, updatedPolicyMap.get(policy.getKey()), policyResult, policyResultProhibited)) continue;
            checkPolicyResult = false;
        }
        if (!checkPolicyResult || !lenValidity) {
            checkPolicyResult = false;
            this.parseToolTip(policyResult, lenValidity, policyResultProhibited);
        }
        return checkPolicyResult;
    }

    private boolean check(char[] imtInfo, Map.Entry policy, int policyValue, Map<String, Integer> policyResult, Map<String, Integer> policyResultProhibited) {
        String policyName = policy.getKey().toString();
        String checkCharactor = policy.getValue().toString();
        if (policyValue != 0 && imtInfo != null) {
            int v = PolicyUtil.getMatchCharCounter(imtInfo, checkCharactor);
            if (policyValue == -1) {
                if (v > 0) {
                    policyResultProhibited.put(policyName, policyValue);
                }
            } else if (v < policyValue) {
                policyResult.put(policyName, policyValue);
            }
        }
        SecurityRedLineUtil.clearArray((char[])imtInfo);
        return policyResult.isEmpty() && policyResultProhibited.isEmpty();
    }

    private boolean checkLength() {
        char[] imtInfo = this.getPassword();
        if (this.isAdmin) {
            if (imtInfo.length < this.adminMinImtInfoLength || imtInfo.length > this.maxImtInfoLength) {
                SecurityRedLineUtil.clearArray((char[])imtInfo);
                return false;
            }
        } else if (imtInfo.length < this.minImtInfoLength || imtInfo.length > this.maxImtInfoLength) {
            SecurityRedLineUtil.clearArray((char[])imtInfo);
            return false;
        }
        SecurityRedLineUtil.clearArray((char[])imtInfo);
        return true;
    }

    private void parseToolTip(Map<String, Integer> policyResult, boolean lenValidity, Map<String, Integer> policyResultProhibited) {
        String policyName;
        int i;
        int minValue = this.isAdmin ? this.adminMinImtInfoLength : this.minImtInfoLength;
        this.tipMessage = new StringBuilder();
        if (!lenValidity) {
            if (minValue != this.maxImtInfoLength) {
                if (policyResult.size() > 0) {
                    this.tipMessage.append(GuiUtilForBase.bundleString(ResourceProxy4Base.getInstance().getResource("Password_PolicyLimit_Length"), String.valueOf(minValue), String.valueOf(this.maxImtInfoLength)));
                } else if (policyResultProhibited.size() > 0) {
                    this.tipMessage.append(GuiUtilForBase.bundleString(ResourceProxy4Base.getInstance().getResource("Password_Prohibited_Length"), String.valueOf(minValue), String.valueOf(this.maxImtInfoLength)));
                    this.tipMessage.append(GuiUtilForBase.bundleString(ResourceProxy4Base.getInstance().getResource("Password_Prohibited"), String.valueOf("")));
                } else {
                    this.tipMessage.append(GuiUtilForBase.bundleString(ResourceProxy4Base.getInstance().getResource("Password_Limit_Length"), String.valueOf(minValue), String.valueOf(this.maxImtInfoLength)));
                }
            } else if (policyResult.size() > 0) {
                this.tipMessage.append(GuiUtilForBase.bundleString(ResourceProxy4Base.getInstance().getResource("Password_PolicyLimit_Length_WhenMaxEqualsMin"), String.valueOf(this.maxImtInfoLength)));
            } else if (policyResultProhibited.size() > 0) {
                this.tipMessage.append(GuiUtilForBase.bundleString(ResourceProxy4Base.getInstance().getResource("Password_Prohibited_Length_WhenMaxEqualsMin"), String.valueOf(this.maxImtInfoLength)));
                this.tipMessage.append(GuiUtilForBase.bundleString(ResourceProxy4Base.getInstance().getResource("Password_Prohibited"), String.valueOf("")));
            } else {
                this.tipMessage.append(GuiUtilForBase.bundleString(ResourceProxy4Base.getInstance().getResource("Password_Limit_Length_WhenMaxEqualsMin"), String.valueOf(this.maxImtInfoLength)));
            }
        } else if (policyResult.size() > 0) {
            this.tipMessage.append(ResourceProxy4Base.getInstance().getResource("Password_NOLimit_Length"));
        } else if (policyResultProhibited.size() > 0) {
            this.tipMessage.append(ResourceProxy4Base.getInstance().getResource("Password_Limit"));
        }
        List<String> policyNameList = PasswordCheckFactory.getInstance().getCheckerNameList();
        int j = 0;
        for (i = 0; i < policyNameList.size(); ++i) {
            policyName = policyNameList.get(i);
            if (!policyResult.containsKey(policyName)) continue;
            int policyValue = policyResult.get(policyName);
            if ("MinUppercaseNum".equals(policyName)) {
                this.tipMessage.append(GuiUtilForBase.bundleString(ResourceProxy4Base.getInstance().getResource("Pwd_Policy_Upperletter"), String.valueOf(policyValue)));
            } else if ("MinLowercaseNum".equals(policyName)) {
                this.tipMessage.append(GuiUtilForBase.bundleString(ResourceProxy4Base.getInstance().getResource("Pwd_Policy_Lowerletter"), String.valueOf(policyValue)));
            } else if ("MinNumberNum".equals(policyName)) {
                this.tipMessage.append(GuiUtilForBase.bundleString(ResourceProxy4Base.getInstance().getResource("Pwd_Policy_Number"), String.valueOf(policyValue)));
            } else if ("MinSpecCharNum".equals(policyName)) {
                this.tipMessage.append(GuiUtilForBase.bundleString(ResourceProxy4Base.getInstance().getResource("Pwd_Policy_Specialchar"), String.valueOf(policyValue)));
            }
            if (j != policyResult.size() - 1) {
                this.tipMessage.append(ResourceProxy4Base.getInstance().getResource("Pwd_Policy_Comma"));
            } else if (0 == policyResultProhibited.size()) {
                this.tipMessage.append(ResourceProxy4Base.getInstance().getResource("Pwd_Policy_Dot"));
            } else {
                this.tipMessage.append(ResourceProxy4Base.getInstance().getResource("Pwd_Policy_Comma"));
                this.tipMessage.append(GuiUtilForBase.bundleString(ResourceProxy4Base.getInstance().getResource("Password_Prohibited"), String.valueOf("")));
            }
            ++j;
        }
        j = 0;
        for (i = 0; i < policyNameList.size(); ++i) {
            policyName = policyNameList.get(i);
            if (!policyResultProhibited.containsKey(policyName)) continue;
            if ("MinUppercaseNum".equals(policyName)) {
                this.tipMessage.append(GuiUtilForBase.bundleString(ResourceProxy4Base.getInstance().getResource("Policy_Upperletter"), String.valueOf("")));
            } else if ("MinLowercaseNum".equals(policyName)) {
                this.tipMessage.append(GuiUtilForBase.bundleString(ResourceProxy4Base.getInstance().getResource("Policy_Lowerletter"), String.valueOf("")));
            } else if ("MinNumberNum".equals(policyName)) {
                this.tipMessage.append(GuiUtilForBase.bundleString(ResourceProxy4Base.getInstance().getResource("Policy_Number"), String.valueOf("")));
            } else if ("MinSpecCharNum".equals(policyName)) {
                this.tipMessage.append(GuiUtilForBase.bundleString(ResourceProxy4Base.getInstance().getResource("Policy_Specialchar"), String.valueOf("")));
            }
            if (j == policyResultProhibited.size() - 1) {
                this.tipMessage.append(ResourceProxy4Base.getInstance().getResource("Pwd_Policy_Dot"));
            } else {
                this.tipMessage.append(ResourceProxy4Base.getInstance().getResource("Pwd_Policy_Comma"));
            }
            ++j;
        }
        if (this.isShowMoreDetail == DisplayMoreDetail.YES) {
            this.tipMessage.append(ResourceProxy4Base.getInstance().getResource("Pwd_Policy_MoreInfo"));
        }
    }

    public class ImtInfoCapslockTipBubble
    extends SMBubbleComponent {
        protected static final int DEFAULT_HIDE_TIME = 10;
        private static final int MILLI_TO_SEC = 1000;
        protected static final int ARROW_FIRST_X = 20;
        protected static final int ARROW_SECOND_X = 35;
        protected static final double DEFAULT_REL_POS = 0.0;
        protected static final int MIN_GAP = 0;
        private HideAction hideAction = new HideAction();
        private int hideTime = 10000;
        private Timer hideTimer = new Timer(this.hideTime, this.hideAction);
        protected double relativeBubblePosition = 0.0;

        ImtInfoCapslockTipBubble() {
            this.setName("CapsLock_Tip");
            this.label.setVisible(false);
            this.addMouseListener(this.hideAction);
            this.hideTimer.setRepeats(false);
            this.textArea.addMouseListener(this.hideAction);
        }

        @Override
        protected void reShape() {
            this.width = this.getPreferredSize().width - 1;
            this.height = this.getPreferredSize().height - 1;
            this.initPolygonPoints();
            this.shape = new Polygon(this.xpoints, this.ypoints, 11);
            if (5 == this.position) {
                this.convertShape(5, this.width, this.height);
            }
        }

        protected void initPolygonPoints() {
            this.xpoints[0] = 5;
            this.xpoints[1] = 0;
            this.xpoints[2] = 0;
            this.xpoints[3] = 5;
            this.xpoints[4] = 20;
            this.xpoints[5] = 20;
            this.xpoints[6] = 35;
            this.xpoints[7] = this.width - 1 - 5;
            this.xpoints[8] = this.width - 1;
            this.xpoints[9] = this.width - 1;
            this.xpoints[10] = this.width - 1 - 5;
            this.ypoints[0] = 0;
            this.ypoints[1] = 5;
            this.ypoints[2] = this.height - 19 - 5;
            this.ypoints[3] = this.height - 19;
            this.ypoints[4] = this.height - 19;
            this.ypoints[5] = this.height - 1;
            this.ypoints[6] = this.height - 19;
            this.ypoints[7] = this.height - 19;
            this.ypoints[8] = this.height - 19 - 5;
            this.ypoints[9] = 5;
            this.ypoints[10] = 0;
        }

        @Override
        protected JLayeredPane updateBounds() {
            JRootPane rootPane = SwingUtilities.getRootPane(this.invoker);
            if (rootPane == null) {
                return null;
            }
            JLayeredPane layeredPane = rootPane.getLayeredPane();
            Point p = this.invoker.getLocation();
            p = SwingUtilities.convertPoint(this.invoker.getParent(), p, layeredPane);
            int width = this.getPreferredSize().width;
            int height = this.getPreferredSize().height;
            if (p.y - height + 8 < 0) {
                this.position = 5;
                this.convertShape(5, width, height);
            } else {
                this.position = 1;
            }
            if (this.position == 1) {
                this.textArea.setLocation(this.insets.left, this.insets.top);
                int loc = p.x + (int)((double)this.invoker.getWidth() * this.relativeBubblePosition) - 20;
                if (loc + width > layeredPane.getWidth()) {
                    loc = layeredPane.getWidth() - width - 0;
                }
                if (loc + 20 < p.x) {
                    loc = p.x - 20;
                }
                if (loc < 0) {
                    loc = 0;
                }
                if (loc + 20 > p.x + this.invoker.getWidth()) {
                    loc = p.x + this.invoker.getWidth() - 20;
                }
                this.setBounds(loc, p.y - height + 8, width, height);
            } else if (this.position == 5) {
                this.textArea.setLocation(this.insets.left, this.insets.top + 19);
                int loc = p.x - width + (int)((double)this.invoker.getWidth() * this.relativeBubblePosition) + 20;
                if (loc < 0) {
                    loc = 0;
                }
                if (loc + width - 20 > p.x + this.invoker.getWidth()) {
                    loc = p.x + this.invoker.getWidth() - width + 20;
                }
                this.setBounds(loc, p.y + this.invoker.getHeight() - 8, width, height);
            }
            this.reShape();
            return layeredPane;
        }

        public void setHideTime(int seconds) {
            if (seconds <= 0) {
                throw new IllegalArgumentException("The seconds value should be greater than 0");
            }
            this.hideTime = seconds * 1000;
        }

        public void setRelativeBubblePosition(double pos) {
            if (pos < 0.0 || pos > 1.0) {
                throw new IllegalArgumentException("The pos value should lie between 0 and 1");
            }
            this.relativeBubblePosition = pos;
        }

        public void hideBubble() {
            this.setVisible(false);
            this.hideTimer.stop();
        }

        public void showBubble(JComponent parent) {
            super.showBubble(parent);
            this.hideTimer.stop();
            this.hideTimer.setInitialDelay(this.hideTime);
            this.hideTimer.start();
        }

        private void convertShape(int position, int width, int height) {
            if (position == 5) {
                AffineTransform at = new AffineTransform();
                at.translate((double)width / 2.0, (double)height / 2.0);
                at.rotate(Math.toRadians(180.0));
                at.translate((double)(-width) / 2.0, (double)(-height) / 2.0);
                this.shape = at.createTransformedShape(this.shape);
            }
        }

        public class HideAction
        extends MouseAdapter
        implements ActionListener {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (ImtInfoCapslockTipBubble.this.isBubbleComponentShowing()) {
                    ImtInfoCapslockTipBubble.this.hideBubble();
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ImtInfoCapslockTipBubble.this.isBubbleComponentShowing()) {
                    ImtInfoCapslockTipBubble.this.hideBubble();
                }
            }
        }
    }

    public static enum DisplayMoreDetail {
        NO,
        YES;

    }
}

