/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.common;

import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.loginui.common.SMTraceProxy;

public abstract class SecurityTimer
extends Thread {
    private IviewLogger log = SMTraceProxy.getLogger(SecurityTimer.class);
    private boolean running = true;
    private long interval;

    public SecurityTimer() {
    }

    public SecurityTimer(long interval) {
        this.interval = interval;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(this.interval);
            if (this.interval > 0L) {
                while (this.isRunning()) {
                    this.process();
                    Thread.sleep(this.interval);
                }
                this.log.info((Object)"SecurityTimer | timer stops...");
            } else {
                this.log.info((Object)"SecurityTimer | interval <= 0, Timer will not run.");
            }
        }
        catch (Exception e) {
            this.log.error((Object)"SecurityTimer with error.", (Throwable)e);
        }
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    private synchronized boolean isRunning() {
        return this.running;
    }

    private synchronized void setRunning(boolean flag) {
        this.running = flag;
    }

    public void stopTimer() {
        this.setRunning(false);
    }

    protected abstract void process();
}

