/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.common;

import com.swimap.iview.templates.bubble.BubbleCloseIcon;
import com.swimap.iview.util.IconCloseListener;
import com.swimap.iview.util.ScreenToolKit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.EventListener;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JTextArea;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SMBubbleComponent
extends JComponent
implements SwingConstants {
    private FontMetrics stringMeasure = null;
    private static final int MAX_WIDTH = 200;
    protected final int x = 0;
    protected final int y = 0;
    protected final int dogear = 5;
    protected static final int ARROW_HEIGHT = 19;
    protected static final int INVERT_ANGLE = 180;
    protected static final int TIP_DIP = 8;
    protected int width = 90;
    protected int height = 36;
    protected final int npoints = 11;
    protected int[] xpoints = new int[11];
    protected int[] ypoints = new int[11];
    protected Shape shape = null;
    protected JTextArea textArea = new JTextArea();
    protected Insets insets = new Insets(10, 20, 30, 25);
    private String text = " ";
    private Font font = UIManager.getFont("Label.font");
    protected BubbleCloseIcon label = null;
    protected Component invoker = null;
    private transient HierarchyBoundsListener boundsUpdater = new BubbleBoundUpdater();
    protected int position = 1;

    public SMBubbleComponent() {
        this.setLayout(null);
        this.setDoubleBuffered(true);
        this.textArea.setLocation(this.insets.left, this.insets.top);
        this.textArea.setFont(this.font);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setOpaque(false);
        this.textArea.setFocusable(false);
        this.label = new BubbleCloseIcon();
        this.label.addIconCloseListener(new IconCloseListener(){

            public void close() {
                SMBubbleComponent.this.hideBubble();
            }
        });
        this.label.setIcon((Icon)this.label);
        this.add((Component)this.label);
        this.add(this.textArea);
        this.setOpaque(false);
        this.enableEvents(16L);
        this.resize();
        this.reShape();
    }

    public void setBubbleText(String paramString) {
        if (null == paramString) {
            throw new IllegalArgumentException("Only String is allowed");
        }
        this.text = paramString;
        this.resize();
        this.reShape();
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    private void resize() {
        int j;
        String str1 = ScreenToolKit.getLineWrapString((String)this.text, (int)204, (Font)this.font);
        if (str1.length() == 0) {
            this.width = 0;
            this.height = 0;
        }
        String str2 = System.getProperty("line.separator");
        StringTokenizer localStringTokenizer = new StringTokenizer(str1, str2);
        int i = localStringTokenizer.countTokens();
        String[] arrayOfString = new String[i];
        for (j = 0; j < arrayOfString.length; ++j) {
            arrayOfString[j] = localStringTokenizer.nextToken();
        }
        this.setFont(this.font);
        j = 0;
        String str3 = null;
        str3 = String.valueOf('\n');
        int k = 0;
        while ((k = str1.indexOf(str3, k)) >= 0) {
            ++j;
            ++k;
        }
        if (str1.endsWith(str3)) {
            --j;
        }
        int m = this.stringMeasure.getHeight() * ++j;
        int n = 0;
        for (int i1 = 0; i1 < arrayOfString.length; ++i1) {
            if (n >= this.stringMeasure.stringWidth(arrayOfString[i1])) continue;
            n = this.stringMeasure.stringWidth(arrayOfString[i1]);
        }
        this.textArea.setSize(new Dimension(n + 10, m + 2));
        this.textArea.setText(this.text);
        this.label.setBounds(this.getWidth() - 18, 6, this.label.getIconWidth() + 6, this.label.getIconHeight() + 8);
        this.setPreferredSize(new Dimension(n + this.insets.left + this.insets.right, m + this.insets.top + this.insets.bottom));
    }

    @Override
    public void setFont(Font paramFont) {
        if (null != paramFont) {
            super.setFont(paramFont);
            BufferedImage localBufferedImage = new BufferedImage(10, 10, 2);
            Graphics localGraphics = localBufferedImage.getGraphics();
            this.stringMeasure = localGraphics.getFontMetrics(paramFont);
        }
    }

    protected void reShape() {
        this.width = this.getPreferredSize().width - 1;
        this.height = this.getPreferredSize().height - 1;
        this.xpoints[0] = 5;
        this.xpoints[1] = 0;
        this.xpoints[2] = 0;
        this.xpoints[3] = 5;
        this.xpoints[4] = this.width - 33;
        this.xpoints[5] = this.width - 15;
        this.xpoints[6] = this.width - 15;
        this.xpoints[7] = this.width - 1 - 5;
        this.xpoints[8] = this.width - 1;
        this.xpoints[9] = this.width - 1;
        this.xpoints[10] = this.width - 1 - 5;
        this.ypoints[0] = 0;
        this.ypoints[1] = 5;
        this.ypoints[2] = this.height - 19 - 5;
        this.ypoints[3] = this.height - 19;
        this.ypoints[4] = this.height - 19;
        this.ypoints[5] = this.height - 1;
        this.ypoints[6] = this.height - 19;
        this.ypoints[7] = this.height - 19;
        this.ypoints[8] = this.height - 19 - 5;
        this.ypoints[9] = 5;
        this.ypoints[10] = 0;
        this.shape = new Polygon(this.xpoints, this.ypoints, 11);
        if (this.position == 5) {
            AffineTransform localAffineTransform = new AffineTransform();
            localAffineTransform.translate(this.width / 2, this.height / 2);
            localAffineTransform.rotate(Math.toRadians(180.0));
            localAffineTransform.translate(-this.width / 2, -this.height / 2);
            this.shape = localAffineTransform.createTransformedShape(this.shape);
        }
    }

    @Override
    public void paint(Graphics paramGraphics) {
        Graphics2D localGraphics2D = (Graphics2D)paramGraphics;
        this.updateBounds();
        localGraphics2D.setColor(UIManager.getColor("text"));
        localGraphics2D.fill(this.shape);
        localGraphics2D.setColor(Color.black);
        localGraphics2D.draw(this.shape);
        super.paint(localGraphics2D);
    }

    @Override
    public boolean contains(Point paramPoint) {
        return this.contains(paramPoint.x, paramPoint.y);
    }

    @Override
    public boolean contains(int paramInt1, int paramInt2) {
        return this.shape.contains(paramInt1, paramInt2);
    }

    private void setInvoker(Component paramComponent) {
        JLayeredPane localJLayeredPane = this.updateBounds();
        if (localJLayeredPane != null) {
            this.checkAndAddHierarchyBoundsListener(localJLayeredPane);
            this.resize();
            this.reShape();
            localJLayeredPane.add(this, JLayeredPane.POPUP_LAYER, 0);
            this.setVisible(false);
        }
    }

    protected JLayeredPane updateBounds() {
        JRootPane localJRootPane = SwingUtilities.getRootPane(this.invoker);
        if (localJRootPane == null) {
            return null;
        }
        JLayeredPane localJLayeredPane = localJRootPane.getLayeredPane();
        Point localPoint = this.invoker.getLocation();
        localPoint = SwingUtilities.convertPoint(this.invoker.getParent(), localPoint, localJLayeredPane);
        int i = this.getPreferredSize().width;
        int j = this.getPreferredSize().height;
        if (localPoint.y - j + 8 < 0) {
            this.position = 5;
            AffineTransform localAffineTransform = new AffineTransform();
            localAffineTransform.translate(i / 2, j / 2);
            localAffineTransform.rotate(Math.toRadians(180.0));
            localAffineTransform.translate(-i / 2, -j / 2);
            this.shape = localAffineTransform.createTransformedShape(this.shape);
        } else {
            this.position = 1;
        }
        if (this.position == 1) {
            this.textArea.setLocation(this.insets.left, this.insets.top);
            this.label.setBounds(this.getWidth() - 18, 6, this.label.getIconWidth() + 6, this.label.getIconHeight() + 8);
            this.setBounds(localPoint.x - i + this.invoker.getWidth() / 2 + 15, localPoint.y - j + 8, i, j);
        } else if (this.position == 5) {
            this.textArea.setLocation(this.insets.left, this.insets.top + 19);
            this.label.setBounds(this.getWidth() - 18, this.insets.top + 12, this.label.getIconWidth() + 6, this.label.getIconHeight() + 8);
            this.setBounds(localPoint.x + this.invoker.getWidth() / 2 - 15, localPoint.y + this.invoker.getHeight() - 8, i, j);
        }
        this.reShape();
        return localJLayeredPane;
    }

    private void hideBubble() {
        if (null != this.invoker) {
            this.invoker.removeHierarchyBoundsListener(this.boundsUpdater);
        }
        this.setVisible(false);
    }

    private void checkAndAddHierarchyBoundsListener(Component paramComponent) {
        boolean i = true;
        EventListener[] arrayOfEventListener = paramComponent.getListeners(HierarchyBoundsListener.class);
        for (int j = 0; j < arrayOfEventListener.length; ++j) {
            if (arrayOfEventListener[j] != this.boundsUpdater) continue;
            i = false;
            break;
        }
        if (i) {
            paramComponent.addHierarchyBoundsListener(this.boundsUpdater);
        }
    }

    public void showBubble(Component paramComponent) {
        if (null == paramComponent) {
            throw new IllegalArgumentException("Only Component and its child is allowed");
        }
        this.invoker = paramComponent;
        this.checkAndAddHierarchyBoundsListener(paramComponent);
        this.setInvoker(paramComponent);
        this.setVisible(true);
        this.repaint();
    }

    public boolean isBubbleComponentShowing() {
        return this.isShowing();
    }

    private class BubbleBoundUpdater
    implements HierarchyBoundsListener {
        private BubbleBoundUpdater() {
        }

        @Override
        public void ancestorMoved(HierarchyEvent paramHierarchyEvent) {
            SMBubbleComponent.this.updateBounds();
        }

        @Override
        public void ancestorResized(HierarchyEvent paramHierarchyEvent) {
            SMBubbleComponent.this.updateBounds();
        }
    }
}

