/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.common;

import com.swimap.external.dsf.base.framework.AppError;
import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.dsf.base.rpc.RpcError;
import com.swimap.external.dsf.base.rpc.RpcErrorSecurity;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import com.swimap.external.dsf.base.rpc.RpcResponse;
import com.swimap.external.sm.client.base.common.model.AccBit;
import com.swimap.external.sm.client.base.common.model.Right;
import com.swimap.external.sm.client.base.common.model.RightInfo;
import com.swimap.external.sm.client.base.common.model.StaticRight;
import com.swimap.external.sm.client.base.common.model.UserInfo;
import com.swimap.iview.clientutil.ClientUtilModule;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.auth.CheckVersionInfo;
import com.swimap.sm.client.base.common.LoginUserInfo;
import com.swimap.sm.client.base.common.ResourceProxy4Base;
import com.swimap.sm.client.base.common.SmAppError;
import com.swimap.sm.client.base.common.SmRpcError;
import com.swimap.sm.client.base.common.model.AuthConfInfo;
import com.swimap.sm.client.base.common.model.CAUServerInfo;
import com.swimap.sm.client.base.common.model.LawInfo;
import com.swimap.sm.client.base.common.model.LoginRecInfo;
import com.swimap.sm.client.base.common.model.SessionInfo;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import com.swimap.sm.client.loginui.common.proxy.rpc.RpcNamingProxy;
import com.swimap.sm.client.loginui.common.proxy.rpc.RpcRequestProxy;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class RpcInvoker {
    private static IviewLogger log = SMTraceProxy.getLogger(RpcInvoker.class);
    private static RpcInvoker instance = new RpcInvoker();
    private RpcRequestProxy rpcRequest;

    public static RpcInvoker getInstance() {
        return instance;
    }

    public static void setInstance(RpcInvoker mockRpc) {
        instance = mockRpc;
    }

    public String initConnectionParam(String dsServerIP, String dsServerPort, boolean isSupportSSL) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | setNamingAddress |start");
        String rpcNaming = "";
        rpcNaming = ClientUtilModule.initConnectionParam((String)dsServerIP, (String)dsServerPort, (boolean)isSupportSSL);
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | setNamingAddress |end " + t));
        return rpcNaming;
    }

    public void setCurrentSession(byte[] token) {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | setCurrentSession |start");
        RpcRequest.setCurrentSession((byte[])token);
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | setCurrentSession |end " + t));
    }

    private RpcRequestProxy getRpcRequest(String reqestCommand) throws Exception {
        if (this.rpcRequest == null) {
            return this.createRequest(reqestCommand);
        }
        return this.rpcRequest;
    }

    protected RpcRequestProxy createRequest(String reqeustCommand) throws Exception {
        return RpcNamingProxy.getInstance().createRequest(reqeustCommand);
    }

    public Map<String, Object> getLoginInfo() throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getLoginInfo |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sessionmgr.login");
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | getLoginInfo |end " + t));
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("SystemMode", msg.getInt("SystemMode"));
        this.setEmergencyMode(msg);
        info.put("isRestrict", msg.getBoolean("isRestrict"));
        info.put("backendCurrentData", msg.getLong("backendCurrentData"));
        info.put("PasswordExpiryDays", msg.getInt("PasswordExpiryDays"));
        info.put("pwdStatus", msg.getInt("pwdStatus"));
        info.put("SessionInfo", this.getSessionInfo(msg, false));
        UserInfo userInfo = this.getLoginUserInfo(msg);
        info.put("UserInfo", userInfo);
        return info;
    }

    public Map<String, Object> login(String userName, byte[] imfInfo, String terminal, int clientType) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | login |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sessionmgr.login");
        req.addArgument("username", (Object)userName);
        req.addArgument("password", (Object)imfInfo);
        req.addArgument("terminal", (Object)terminal);
        req.addArgument("clientType", (Object)clientType);
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        return this.changeRpcMsg2Map(msg, t);
    }

    private Map<String, Object> changeRpcMsg2Map(RpcMessage msg, long t) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        byte[] token = msg.getByteArray("token");
        if (null != token) {
            RpcRequest.setCurrentSession((byte[])token);
        }
        info.put("token", token);
        info.put("SystemMode", msg.getInt("SystemMode"));
        this.setEmergencyMode(msg);
        info.put("SessionInfo", this.getSessionInfo(msg, true));
        info.put("isRestrict", msg.getBoolean("isRestrict"));
        info.put("backendCurrentData", msg.getLong("backendCurrentData"));
        UserInfo userInfo = this.getLoginUserInfo(msg);
        info.put("UserInfo", userInfo);
        info.put("PasswordExpiryDays", msg.getInt("PasswordExpiryDays"));
        info.put("pwdStatus", msg.getInt("pwdStatus"));
        info.put("authMode", msg.getInt("authMode"));
        if (msg.getString("isShowLoginUserName") == null) {
            info.put("isShowLoginUserName", null);
        } else {
            info.put("isShowLoginUserName", msg.getBoolean("isShowLoginUserName"));
        }
        info.put("loginCase", msg.getInt("loginCase"));
        log.info((Object)("loginCase:" + msg.getInt("loginCase")));
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | login |end " + t));
        return info;
    }

    private SessionInfo getSessionInfo(RpcMessage msg, boolean isLogin) {
        String[] userGroupNames = msg.getStringArray("userGroups");
        StringBuilder ugBuilder = new StringBuilder();
        for (int i = 0; i < userGroupNames.length; ++i) {
            ugBuilder.append(":");
            ugBuilder.append(userGroupNames[i]);
        }
        String usergroups = ugBuilder.toString();
        if (usergroups.length() > 0) {
            usergroups = usergroups.substring(1);
        }
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.setUserGroups(usergroups);
        sessionInfo.setSessionID(msg.getInt("sessionID"));
        sessionInfo.setStartDateTime(msg.getInt("sessionStartDateTime"));
        sessionInfo.setState(msg.getInt("state"));
        sessionInfo.setTerminalID(msg.getString("terminalID"));
        sessionInfo.setUserName(msg.getString("userName"));
        if (isLogin) {
            sessionInfo.setUserAuthType(msg.getInt("userAuthType"));
        }
        return sessionInfo;
    }

    private void setEmergencyMode(RpcMessage msg) {
        boolean isEmergencyMode = msg.getBoolean("isEmergencyMode");
        log.info((Object)("RpcInvoker | login | isEmergencyMode " + isEmergencyMode));
        if (isEmergencyMode) {
            System.setProperty("SpecificLoadingState", "1");
            String title = FrameworkUtilities.getWindowManager().getMDITitle();
            title = title + ResourceProxy4Base.getInstance().getResource("EMERGENCY_SYSTEM");
            FrameworkUtilities.getWindowManager().setMDITitle(title);
        } else {
            System.clearProperty("SpecificLoadingState");
        }
    }

    private UserInfo getLoginUserInfo(RpcMessage msg) {
        DataTable userInfoTable = msg.getTable("UserInfo");
        UserInfo userInfo = new UserInfo();
        DataRecord record = userInfoTable.get(0);
        GregorianCalendar startLoginDurationDate = new GregorianCalendar(0, 0, 0, 0, 0, 0);
        GregorianCalendar endLoginDurationDate = new GregorianCalendar(2037, 11, 31, 0, 0, 0);
        GregorianCalendar startLoginDurationTime = new GregorianCalendar(0, 0, 0, 0, 0, 0);
        GregorianCalendar endLoginDurationTime = new GregorianCalendar(2037, 11, 31, 0, 0, 0);
        startLoginDurationDate.setTimeInMillis(record.getDate("startloginDurationDate").getTime());
        endLoginDurationDate.setTimeInMillis(record.getDate("endloginDurationDate").getTime());
        startLoginDurationTime.setTimeInMillis(record.getDate("startloginDurationTime").getTime());
        endLoginDurationTime.setTimeInMillis(record.getDate("endloginDurationTime").getTime());
        userInfo = new UserInfo(record.getInt("id"), record.get("username"), record.get("desc"), record.getInt("userType"), record.getByteArray("password"), startLoginDurationDate, endLoginDurationDate, startLoginDurationTime, endLoginDurationTime, record.getIntArray("durationWeekDays"), record.getBoolean("accountValidFlag"), record.getBoolean("ignoreDurationFlag"), record.getBoolean("lockFlag"), record.getInt("pwdValidDays"), record.getBoolean("online"), record.getLong("loginTime"), record.getLong("logoutTime"), record.get("terminal"), record.getLong("pwdChangeDate"), (short)record.getInt("pwdStatus"));
        userInfo.inactiveTime = record.getInt("inactiveTime");
        userInfo.isAutoLogout = record.getBoolean("isAutoLogout");
        return userInfo;
    }

    public LoginUserInfo getLoginUserInfo(UserInfo curUser) throws Exception {
        LoginUserInfo loginUserInfo = new LoginUserInfo();
        loginUserInfo.setCurUser(curUser);
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getLoginUserInfo |start ");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sysparammgr.getLoginUserInfo");
        req.addArgument("userID", (Object)curUser.getId());
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        loginUserInfo.setAdmin(msg.getBoolean("isAdminUser"));
        loginUserInfo.setAdminGroup(msg.getBoolean("isAdminGroupUser"));
        loginUserInfo.setSMGroup(msg.getBoolean("isSecurityMgrGroup"));
        loginUserInfo.setSSAUser(msg.getBoolean("isSSAUser"));
        loginUserInfo.setIsUserNameSensitive(msg.getBoolean("isUserNameSensitive"));
        req = this.getRpcRequest("sm.ds.base.checkrightm.getLoginUserRight");
        req.addArgument("userID", (Object)curUser.getId());
        rsp = RpcInvoker.invokeRpcRequest(req);
        msg = rsp.getMessage();
        ArrayList<Map<String, Right>> userAllAppAccessMap = new ArrayList<Map<String, Right>>();
        HashMap<String, Right> userAppAccessMap = new HashMap<String, Right>();
        DataTable userAppAccessTable = msg.getTable("userAppRight");
        for (DataRecord record : userAppAccessTable) {
            if (record.getInt("type") == -1) {
                userAllAppAccessMap.add(userAppAccessMap);
                userAppAccessMap = new HashMap();
                continue;
            }
            DataTable accTable = record.getTable("accessbit");
            List<AccBit> list = AccBit.readTable(accTable);
            Right rightInfo = new Right(record.getInt("type"), record.get("classname"), record.get("oid"));
            rightInfo.accessBit = list;
            userAppAccessMap.put(rightInfo.so.getKey(), rightInfo);
        }
        loginUserInfo.setUserAppRightMap(userAllAppAccessMap);
        loginUserInfo.setHasAllAppOperationSet(msg.getBoolean("hasAllOperationSetRight"));
        loginUserInfo.setHasSmAppOperationSetRight(msg.getBoolean("hasSmOperationSetRight"));
        HashMap<String, StaticRight> staticRightMap = new HashMap<String, StaticRight>();
        DataTable staticRightTable = msg.getTable("staticRight");
        for (DataRecord record : staticRightTable) {
            StaticRight staticRight = new StaticRight(record.getInt("type"), record.get("classname"), record.get("operationid"), "", "", record.getInt("accbit"));
            staticRightMap.put(staticRight.type + staticRight.className + staticRight.operationID, staticRight);
        }
        loginUserInfo.setStaticRightMap(staticRightMap);
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | getLoginUserInfo |end " + t));
        return loginUserInfo;
    }

    public void logout() throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | logout |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sessionmgr.logout");
        req.setTimeout(10000);
        RpcInvoker.invokeRpcRequest(req);
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | logout |end " + t));
    }

    public LawInfo getLawInfo() throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getLawInfo |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sysparammgr.getLawInfo");
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        boolean isShow = msg.getBoolean("isShow");
        String content = msg.getString("content");
        LawInfo lawInfo = new LawInfo(isShow, content);
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | getLawInfo |end " + t));
        return lawInfo;
    }

    public int[] getGroupsByUser(int userid) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getGroupsByUser |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.usermgr.getGroupsByUser");
        req.addArgument("userid", (Object)userid);
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | getGroupsByUser |end " + t));
        return msg.getIntArray("groupids");
    }

    public int getSystemMode() throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getSystemMode |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sessionmgr.getSystemMode");
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        int result = msg.getInt("SystemMode");
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | getSystemMode |end " + t));
        return result;
    }

    public LoginRecInfo[] getLoginHistory() throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getLoginHistory |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sessionmgr.getLoginRec");
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        DataTable dataTable = msg.getTable("LoginRec");
        LoginRecInfo[] recInfos = new LoginRecInfo[dataTable.size()];
        for (int i = 0; i < recInfos.length; ++i) {
            DataRecord dataRecord = dataTable.get(i);
            recInfos[i] = new LoginRecInfo();
            recInfos[i].setDuration(dataRecord.getInt("duration"));
            recInfos[i].setEndTime(dataRecord.getInt("endTime"));
            recInfos[i].setOpType(dataRecord.get("opType"));
            recInfos[i].setResult(dataRecord.getBoolean("result"));
            recInfos[i].setResultDescription(dataRecord.get("resultDescription"));
            recInfos[i].setStartTime(dataRecord.getInt("startTime"));
            recInfos[i].setStatus(dataRecord.get("status"));
            recInfos[i].setTerminalIP(dataRecord.get("terminalIP"));
            recInfos[i].setUserName(dataRecord.get("userName"));
        }
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | getLoginHistory |end " + t));
        return recInfos;
    }

    public static RpcResponse invokeRpcRequest(RpcRequestProxy req) throws Exception {
        try {
            return req.invoke();
        }
        catch (RpcErrorSecurity res) {
            throw res;
        }
        catch (RpcError e) {
            throw new SmRpcError(e);
        }
        catch (AppError e) {
            String errorCode;
            if (e.is("SM_INVALID_TOKEN")) {
                log.info((Object)("DS return invalid token. errorCode= " + e.getDetail("errorCode") + "  InvalidTokenType = " + e.getDetail("InvalidTokenType")));
                throw new RpcErrorSecurity(e.getDetail("errorCode") + ":" + e.getDetail("InvalidTokenType"));
            }
            int internalError = e.getInternalErrorCode();
            if (internalError == 9999 && (errorCode = e.getDetail("errorCode")) != null && errorCode.matches("^-?[1-9]\\d*$")) {
                e.setInternalErrorCode(201392378 + Integer.valueOf(errorCode));
            }
            String errorName = e.getName();
            String internalDes = e.getInternalErrorDesc();
            if (errorName != null && (internalDes == null || "".equals(internalDes))) {
                e.setInternalErrorDesc(errorName);
            }
            throw new SmAppError(e);
        }
        catch (Exception e) {
            throw e;
        }
    }

    public CheckVersionInfo getServerVersion() throws Exception {
        CheckVersionInfo info = new CheckVersionInfo();
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getServerVersion |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.upgrademgr.getVersion");
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        int result = msg.getInt("result");
        String[] versions = msg.getStringArray("clientVersion");
        info.versions = versions;
        info.result = result;
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | getServerVersion |end " + t));
        return info;
    }

    public HashMap<String, Object> getClientMatchVersion() throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getServerVersion |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.upgrademgr.getVersion");
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        HashMap<String, Object> container = new HashMap<String, Object>(2);
        int result = msg.getInt("result");
        String[] versions = msg.getStringArray("clientVersion");
        container.put("result", result);
        container.put("clientVersion", versions);
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | getServerVersion |end " + t));
        return container;
    }

    public CAUServerInfo getCAUServerInfo() throws Exception {
        CAUServerInfo info = new CAUServerInfo();
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getUpgradeInfo |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.upgrademgr.getUpgradeInfo");
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        info.setServerIP(msg.getString("serverIP"));
        info.setCommonPort(msg.getString("commonPort"));
        info.setSslPort(msg.getString("sslPort"));
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | getUpgradeInfo |end " + t));
        return info;
    }

    public UserInfo getUserInfo(String username) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)("RpcInvoker | getUserInfo |start with useranme = " + username));
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.usermgr.getAccountInfo");
        req.addArgument("username", (Object)username);
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        UserInfo[] userInfo = this.getUserInfoFromDataTable(msg);
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | getUserInfo |with useranme end =" + t));
        return userInfo[0];
    }

    public UserInfo getUserInfo(int userid) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)("RpcInvoker | getUserInfo |with userid = " + userid));
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.usermgr.getAccountInfo");
        req.addArgument("userid", (Object)userid);
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        UserInfo[] userInfo = this.getUserInfoFromDataTable(msg);
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | getUserInfo |with userid end =" + t));
        return userInfo[0];
    }

    private UserInfo[] getUserInfoFromDataTable(RpcMessage msg) {
        DataTable userInfoTable = msg.getTable("UserInfo");
        UserInfo[] userInfo = new UserInfo[userInfoTable.size()];
        int i = 0;
        for (DataRecord record : userInfoTable) {
            GregorianCalendar startLoginDurationDate = new GregorianCalendar(0, 0, 0, 0, 0, 0);
            GregorianCalendar endLoginDurationDate = new GregorianCalendar(2037, 11, 31, 0, 0, 0);
            GregorianCalendar startLoginDurationTime = new GregorianCalendar(0, 0, 0, 0, 0, 0);
            GregorianCalendar endLoginDurationTime = new GregorianCalendar(2037, 11, 31, 0, 0, 0);
            startLoginDurationDate.setTimeInMillis(record.getDate("startloginDurationDate").getTime());
            endLoginDurationDate.setTimeInMillis(record.getDate("endloginDurationDate").getTime());
            startLoginDurationTime.setTimeInMillis(record.getDate("startloginDurationTime").getTime());
            endLoginDurationTime.setTimeInMillis(record.getDate("endloginDurationTime").getTime());
            UserInfo uInfo = new UserInfo(record.getInt("id"), record.get("username"), record.get("desc"), record.getInt("userType"), record.getByteArray("password"), startLoginDurationDate, endLoginDurationDate, startLoginDurationTime, endLoginDurationTime, record.getIntArray("durationWeekDays"), record.getBoolean("accountValidFlag"), record.getBoolean("ignoreDurationFlag"), record.getBoolean("lockFlag"), record.getInt("pwdValidDays"), record.getBoolean("online"), record.getLong("loginTime"), record.getLong("logoutTime"), record.get("terminal"), record.getLong("pwdChangeDate"), (short)record.getInt("pwdStatus"));
            uInfo.isAutoLogout = record.getBoolean("isAutoLogout");
            uInfo.inactiveTime = record.getInt("inactiveTime");
            userInfo[i++] = uInfo;
        }
        return userInfo;
    }

    public int getPasswordStatus() throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getPasswordStatus |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.usermgr.getPasswordStatus");
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        int status = msg.getInt("passwordStatus");
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | getPasswordStatus |end " + t));
        return status;
    }

    public int[] isPWDMustChanged(String userName) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getPasswordExpiryDays |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.usermgr.isPWDMustChanged");
        req.addArgument("username", (Object)userName);
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        int[] result = new int[]{msg.getInt("PasswordExpiryDays"), msg.getInt("pwdStatus")};
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | getPasswordExpiryDays |end " + t));
        return result;
    }

    public void setSystemMode(int systemMode, int waitSec) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | setSystemMode |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sessionmgr.setSystemMode");
        req.addArgument("systemMode", (Object)systemMode);
        req.addArgument("waitSec", (Object)waitSec);
        RpcInvoker.invokeRpcRequest(req);
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | setSystemMode |end " + t));
    }

    public void cancelSystemMode() throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | cancelSystemMode |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sessionmgr.cancelSystemMode");
        RpcInvoker.invokeRpcRequest(req);
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | cancelSystemMode |end " + t));
    }

    public void sendHeartBeat() throws Exception {
        long t = System.currentTimeMillis();
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.heartbeatmgr.sendHeartBeat");
        RpcInvoker.invokeRpcRequest(req);
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | sendHeartBeat |end " + t));
    }

    public long getBackendCurrentData() throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getBackendCurrentData |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sysparammgr.getBackendCurrentData");
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | getBackendCurrentData |end " + t));
        return msg.getLong("backendCurrentData");
    }

    public SessionInfo getCurrentSession() throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getCurrentSession |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sessionmgr.getSession");
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        String[] userGroupNames = msg.getStringArray("userGroups");
        StringBuilder ugBuilder = new StringBuilder();
        for (int i = 0; i < userGroupNames.length; ++i) {
            ugBuilder.append(":");
            ugBuilder.append(userGroupNames[i]);
        }
        String usergroups = ugBuilder.toString();
        if (usergroups.length() > 0) {
            usergroups = usergroups.substring(1);
        }
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.setUserGroups(usergroups);
        sessionInfo.setSessionID(msg.getInt("sessionID"));
        sessionInfo.setStartDateTime(msg.getInt("sessionStartDateTime"));
        sessionInfo.setState(msg.getInt("state"));
        sessionInfo.setTerminalID(msg.getString("terminalID"));
        sessionInfo.setUserName(msg.getString("userName"));
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | getCurrentSession |end " + t));
        return sessionInfo;
    }

    public boolean isAdminGroupUser(String userName) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | isAdminGroupUser |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sysparammgr.isAdminGroupUser");
        req.addArgument("username", (Object)userName);
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | isAdminGroupUser |end " + t));
        return msg.getBoolean("isAdminGroupUser");
    }

    public boolean unlockTerminal(String unlockUserName, byte[] imtInfo) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | unlockTerminal |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sessionmgr.unlockTerminal");
        req.addArgument("username", (Object)unlockUserName);
        req.addArgument("password", (Object)imtInfo);
        RpcInvoker.invokeRpcRequest(req);
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | unlockTerminal |end " + t));
        return true;
    }

    public void modifyPassword(String username, String terminal, byte[] oldImtInfo, byte[] newImtInfo) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | modifyPassword |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.usermgr.modifyPassword");
        req.addArgument("username", (Object)username);
        req.addArgument("terminal", (Object)terminal);
        req.addArgument("oldPassword", (Object)oldImtInfo);
        req.addArgument("newPassword", (Object)newImtInfo);
        RpcInvoker.invokeRpcRequest(req);
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | modifyPassword |end " + t));
    }

    public boolean isAdminUser(String userName) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | isAdminUser |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sysparammgr.isAdminUser");
        req.addArgument("username", (Object)userName);
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        boolean isAminUser = msg.getBoolean("isAdminUser");
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | isAdminUser |end " + t));
        return isAminUser;
    }

    public boolean[] isAdminUsers(String[] userNameArray) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sysparammgr.isAdminUsers");
        req.addArgument("usernames", (Object)userNameArray);
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        int[] isAdminUsersArray = msg.getIntArray("isAdminUsers");
        boolean[] isAdminUsers = new boolean[userNameArray.length];
        for (int i = 0; i < isAdminUsersArray.length; ++i) {
            isAdminUsers[i] = isAdminUsersArray[i] == 1;
        }
        t = System.currentTimeMillis() - t;
        log.info((Object)("end " + t));
        return isAdminUsers;
    }

    public boolean isAdminUser(int userid) throws Exception {
        return RpcInvoker.getInstance().getUserInfo((int)userid).userType == 1;
    }

    public boolean isSecurityMgrGroup(String userGroupName) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | isSecurityMgrGroup |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sysparammgr.isSecurityMgrGroup");
        req.addArgument("usergroupname", (Object)userGroupName);
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        boolean isSecurityMgrGroup = msg.getBoolean("isSecurityMgrGroup");
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | isSecurityMgrGroup |end " + t));
        return isSecurityMgrGroup;
    }

    public boolean isSecurityMgrGroupUser(int userid) throws Exception {
        return this.isSecurityMgrGroupUsers(new int[]{userid})[0] == 1;
    }

    public int[] isSecurityMgrGroupUsers(int[] userids) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"isSecurityMgrGroupUsers() |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sysparammgr.isSecurityMgrGroupUsers");
        req.addArgument("userids", (Object)userids);
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        int[] result = msg.getIntArray("isSecurityMgrGroupUsers");
        t = System.currentTimeMillis() - t;
        log.info((Object)("isSecurityMgrGroupUsers() |end " + t));
        return result;
    }

    public int[] isSSAUsers(int[] userIds) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"isSSAUsers() |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sysparammgr.isSSAUsers");
        req.addArgument("userIds", (Object)userIds);
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        int[] result = msg.getIntArray("isSSAUsers");
        t = System.currentTimeMillis() - t;
        log.info((Object)("isSSAUsers() | end " + t));
        return result;
    }

    public void resetPassword(String userName, byte[] imtInfo) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | resetPassword |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.usermgr.resetPassword");
        req.addArgument("username", (Object)userName);
        req.addArgument("newPassword", (Object)imtInfo);
        RpcInvoker.invokeRpcRequest(req);
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | resetPassword |end " + t));
    }

    public List<Map<String, Right>> getAllAppRightByUserID(int userID) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getAllAppRightByUserID |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.checkrightm.getAllAppRightByUserID");
        req.addArgument("userID", (Object)userID);
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        ArrayList<Map<String, Right>> userAllAppAccessMap = new ArrayList<Map<String, Right>>();
        HashMap<String, Right> userAppAccessMap = new HashMap<String, Right>();
        DataTable userAppAccessTable = msg.getTable("userAppRight");
        for (DataRecord record : userAppAccessTable) {
            if (record.getInt("type") == -1) {
                userAllAppAccessMap.add(userAppAccessMap);
                userAppAccessMap = new HashMap();
                continue;
            }
            DataTable accTable = record.getTable("accessbit");
            List<AccBit> list = AccBit.readTable(accTable);
            Right rightInfo = new Right(record.getInt("type"), record.get("classname"), record.get("oid"));
            rightInfo.accessBit = list;
            userAppAccessMap.put(rightInfo.so.getKey(), rightInfo);
        }
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | getAllAppRightByUserID |end " + t));
        return userAllAppAccessMap;
    }

    public boolean hasAllAppOperationSetByUserID(int userID) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | hasAllAppOperationSetByUserID |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.checkrightm.hasAllAppOperationSetByUserID");
        req.addArgument("userID", (Object)userID);
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | hasAllAppOperationSetByUserID |end " + t));
        RpcMessage msg = rsp.getMessage();
        return msg.getBoolean("hasAllOperationSetRight");
    }

    public Map<String, StaticRight> getStaticRight() throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getStaticRight |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.checkrightm.getStaticRight");
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        HashMap<String, StaticRight> staticRightMap = new HashMap<String, StaticRight>();
        DataTable staticRightTable = msg.getTable("staticRight");
        for (DataRecord record : staticRightTable) {
            StaticRight staticRight = new StaticRight(record.getInt("type"), record.get("classname"), record.get("operationid"), "", "", record.getInt("accbit"));
            staticRightMap.put(staticRight.type + staticRight.className + staticRight.operationID, staticRight);
        }
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | getStaticRight |end " + t));
        return staticRightMap;
    }

    public int[] checkRight(RightInfo[] rightInfos) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | checkRight |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.checkrightm.checkRight");
        DataTable dataTable = new DataTable("rightInfoTable");
        dataTable.setColumns(new String[]{"objectclasstype", "objectclassname", "objectid", "operation"});
        for (int i = 0; i < rightInfos.length; ++i) {
            dataTable.add(new Object[]{rightInfos[i].getObjectClassType(), rightInfos[i].getObjectClassName(), rightInfos[i].getObjectID(), rightInfos[i].getOperationID()});
        }
        req.addTable(dataTable);
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        int[] results = msg.getIntArray("result");
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | checkRight |end " + t));
        return results;
    }

    public String getAdminUserName() {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getAdminUserName |start");
        try {
            RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sysparammgr.getAdminUserName");
            RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
            RpcMessage msg = rsp.getMessage();
            String adminUserName = msg.getString("AdminUserName");
            t = System.currentTimeMillis() - t;
            log.info((Object)("RpcInvoker | getAdminUserName |end " + t));
            return adminUserName;
        }
        catch (Exception ex) {
            log.error((Object)"RpcInvoke | getAdminUserName with error.", (Throwable)ex);
            return null;
        }
    }

    public String getAdminGroupName() {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getAdminGroupName |start");
        try {
            RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sysparammgr.getAdminGroupName");
            RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
            RpcMessage msg = rsp.getMessage();
            String adminGroupName = msg.getString("AdminGroupName");
            t = System.currentTimeMillis() - t;
            log.info((Object)("RpcInvoker | getAdminGroupName |end " + t));
            return adminGroupName;
        }
        catch (Exception ex) {
            log.error((Object)"RpcInvoke | getAdminGroupName with error.", (Throwable)ex);
            return null;
        }
    }

    public String getSMGroupName() {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getSMGroupName |start");
        try {
            RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sysparammgr.getSMGroupName");
            RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
            RpcMessage msg = rsp.getMessage();
            String smGroupName = msg.getString("SMGroupName");
            t = System.currentTimeMillis() - t;
            log.info((Object)("RpcInvoker | getSMGroupName |end " + t));
            return smGroupName;
        }
        catch (Exception ex) {
            log.error((Object)"RpcInvoke | getSMGroupName with error.", (Throwable)ex);
            return null;
        }
    }

    public int getMaxConnection() throws Exception {
        RpcRequestProxy req = RpcNamingProxy.getInstance().createRequest("sm.ds.base.sysparammgr.getMaxLoginClient");
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        int maxConnection = msg.getInt("maxLoginClient");
        return maxConnection;
    }

    public boolean isSystemRestricted() throws Exception {
        RpcRequestProxy req = RpcNamingProxy.getInstance().createRequest("sm.ds.base.sysparammgr.isSystemRestricted");
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        return msg.getBoolean("isRestrict");
    }

    public boolean isAdminGroup(String usergroupname) {
        try {
            RpcRequestProxy req = RpcNamingProxy.getInstance().createRequest("sm.ds.base.sysparammgr.getAdminGroupName");
            RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
            RpcMessage msg = rsp.getMessage();
            String adminGroupName = msg.getString("AdminGroupName");
            boolean result = false;
            if (adminGroupName.equals(usergroupname)) {
                result = true;
            }
            return result;
        }
        catch (Exception ex) {
            log.info((Object)ex, (Throwable)ex);
            return false;
        }
    }

    public int getLoginScheduleType() {
        try {
            RpcRequestProxy req = RpcNamingProxy.getInstance().createRequest("sm.ds.base.sysparammgr.getLoginScheduleType");
            RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
            RpcMessage msg = rsp.getMessage();
            return msg.getInt("LoginScheduleType");
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            return 0;
        }
    }

    public AuthConfInfo getServerAuthConf() throws Exception {
        RpcRequestProxy req = RpcNamingProxy.getInstance().createRequest("sm.ds.base.sysparammgr.getAuthConf");
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        AuthConfInfo authConf = new AuthConfInfo(msg.getInt("LoginMode"), msg.getInt("SupportUserManager"));
        authConf.setSycnRemoteUserGroup(msg.getInt("SycnRemoteUserGroup"));
        log.info((Object)("ServerAuthConf : loginMode:" + msg.getInt("LoginMode") + ";" + "SupportUserManager:" + msg.getInt("SupportUserManager") + ";" + "SycnRemoteUserGroup:" + authConf.getSycnRemoteUserGroup()));
        return authConf;
    }

    public int getInvaildLoginDelayTimePolicy() throws Exception {
        RpcRequestProxy req = RpcNamingProxy.getInstance().createRequest("sm.ds.base.sysparammgr.getInvaildLoginDelayTimePolicy");
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        return msg.getInt("delay");
    }

    public List<Object[]> getPolicy() throws Exception {
        RpcRequestProxy req = RpcNamingProxy.getInstance().createRequest("sm.ds.base.sysparammgr.getPolicy");
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        DataTable table = rsp.getMessage().getTable("policytable");
        String policyname = "";
        String policyvalue = "";
        for (DataRecord record : table) {
            policyname = record.get("policyname");
            policyvalue = record.get("policyvalue");
            if (policyname.equals("MaxPwdLength")) {
                if (Integer.parseInt(policyvalue) > 16) {
                    list.add(new String[]{policyname, "16"});
                    continue;
                }
                list.add(new String[]{policyname, policyvalue});
                continue;
            }
            list.add(new String[]{policyname, policyvalue});
        }
        return list;
    }

    public void setPolicy(List<Object[]> policys) throws Exception {
        RpcRequestProxy req = RpcNamingProxy.getInstance().createRequest("sm.ds.base.sysparammgr.setPolicy");
        DataTable table = new DataTable("policytable");
        table.setColumns(new String[]{"policyname", "policyvalue", "policytype"});
        for (Object[] policy : policys) {
            table.add(policy);
        }
        req.addTable(table);
        RpcInvoker.invokeRpcRequest(req);
    }

    public HashMap<String, Object> ssoLogin(String userName, byte[] imtInfo, String terminal) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | ssoLogin |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sessionmgr.ssoLogin");
        req.addArgument("username", (Object)userName);
        req.addArgument("password", (Object)imtInfo);
        req.addArgument("terminal", (Object)terminal);
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        HashMap<String, Object> info = new HashMap<String, Object>();
        String key = msg.getString("key");
        info.put("key", key);
        if (msg.getInt("isoversession") != 0) {
            info.put("isOverMaxSession", true);
        } else {
            info.put("isOverMaxSession", false);
        }
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | ssoLogin |end " + t));
        return info;
    }

    private List<UserInfo> getAllUserInfo(boolean bNeedCheckRight) throws Exception {
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.usermgr.getAllUserInfo");
        req.addArgument("bNeedCheckRight", (Object)bNeedCheckRight);
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        DataTable userInfoTable = msg.getTable("alluserinfos");
        ArrayList<UserInfo> result = new ArrayList<UserInfo>();
        GregorianCalendar startLoginDurationDate = null;
        GregorianCalendar endLoginDurationDate = null;
        GregorianCalendar startLoginDurationTime = null;
        GregorianCalendar endLoginDurationTime = null;
        for (DataRecord record : userInfoTable) {
            startLoginDurationDate = new GregorianCalendar(0, 0, 0, 0, 0, 0);
            endLoginDurationDate = new GregorianCalendar(2037, 11, 31, 0, 0, 0);
            startLoginDurationTime = new GregorianCalendar(0, 0, 0, 0, 0, 0);
            endLoginDurationTime = new GregorianCalendar(2037, 11, 31, 0, 0, 0);
            startLoginDurationDate.setTimeInMillis(record.getDate("startloginDurationDate").getTime());
            endLoginDurationDate.setTimeInMillis(record.getDate("endloginDurationDate").getTime());
            startLoginDurationTime.setTimeInMillis(record.getDate("startloginDurationTime").getTime());
            endLoginDurationTime.setTimeInMillis(record.getDate("endloginDurationTime").getTime());
            UserInfo userInfo = new UserInfo(record.getInt("id"), record.get("username"), record.get("desc"), record.getInt("userType"), record.getByteArray("password"), startLoginDurationDate, endLoginDurationDate, startLoginDurationTime, endLoginDurationTime, record.getIntArray("durationWeekDays"), record.getBoolean("accountValidFlag"), record.getBoolean("ignoreDurationFlag"), record.getBoolean("lockFlag"), record.getInt("pwdValidDays"), record.getBoolean("online"), record.getLong("loginTime"), record.getLong("logoutTime"), record.get("terminal"), record.getLong("pwdChangeDate"), (short)record.getInt("pwdStatus"));
            userInfo.isAutoLogout = record.getBoolean("isAutoLogout");
            userInfo.inactiveTime = record.getInt("inactiveTime");
            userInfo.fullName = record.get("fullname");
            userInfo.maxOnlineCount = record.getInt("maxOnlineCount");
            userInfo.isStartInactivePolicy = record.getBoolean("isStartInactivePolicy");
            userInfo.inactivePolicyAction = record.getInt("inactivePolicyAction");
            userInfo.inactivePolicyDay = record.getInt("inactivePolicyDay");
            result.add(userInfo);
        }
        return result;
    }

    public Map<String, Integer> getAllUserNameIDs(boolean bNeedCheckRight) throws Exception {
        List<UserInfo> allUserInfo = this.getAllUserInfo(bNeedCheckRight);
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (UserInfo info : allUserInfo) {
            result.put(info.name, info.id);
        }
        return result;
    }

    public Vector<SessionInfo> getAllLoginSessions() throws Exception {
        RpcRequestProxy req = RpcNamingProxy.getInstance().createRequest("sm.ds.base.sessionmgr.getAllLoginSessions");
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        DataTable table = msg.getTable("SessionInfo");
        Vector<SessionInfo> infos = new Vector<SessionInfo>();
        int id = 0;
        String name = null;
        long startDateTime = 0L;
        int state = 0;
        String terminalID = null;
        String[] groups = null;
        StringBuffer tmpStr = null;
        SessionInfo info = null;
        for (DataRecord record : table) {
            id = record.getInt("sessionID");
            name = record.get("userName");
            state = record.getInt("state");
            startDateTime = record.getInt("sessionStartDateTime");
            terminalID = record.get("terminalID");
            groups = record.getStringArray("userGroups");
            tmpStr = new StringBuffer();
            if (groups != null) {
                for (int j = 0; j < groups.length; ++j) {
                    tmpStr.append(groups[j]);
                    if (j == groups.length - 1) continue;
                    tmpStr.append(":");
                }
            } else {
                log.info((Object)"com.swimap.external.dsf.base.rpc.DataRecord.getStringArray() return null ");
            }
            info = new SessionInfo(name, id, state, startDateTime, terminalID, "");
            infos.add(info);
        }
        return infos;
    }

    public int logoutOtherBySessionid(int sessionId) throws Exception {
        RpcRequestProxy req = RpcNamingProxy.getInstance().createRequest("sm.ds.base.sessionmgr.logoutOtherBySessionid");
        req.addArgument("sessionId", (Object)sessionId);
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        int result = msg.getInt("result");
        return result;
    }

    public boolean isIPassModel() {
        try {
            RpcRequestProxy req = RpcNamingProxy.getInstance().createRequest("sm.ds.base.sysparammgr.isIPassModel");
            RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
            RpcMessage msg = rsp.getMessage();
            return msg.getBoolean("isipassmodel");
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            return false;
        }
    }

    public Map<String, String> getServerComponentVersion() throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getServerComponentVersion |start");
        HashMap<String, String> serverVerMap = new HashMap<String, String>(2);
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.upgrademgr.getComponentVersion");
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        DataTable table = msg.getTable("compVersionsTable");
        if (table.size() <= 0) {
            log.info((Object)"RpcInvoker|getServerComponentVersion()| errorcode is send from server ");
            return serverVerMap;
        }
        String key = "key";
        String server = "server";
        for (DataRecord record : table) {
            if (record.get(key).equalsIgnoreCase(server)) continue;
            serverVerMap.put(record.get("key"), record.get("value"));
            log.info((Object)("server component versions: " + key + " = " + record.get("value")));
        }
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | getServerComponentVersion |end " + t));
        return serverVerMap;
    }

    public String getPasswordEncrypAlg() throws Exception {
        log.info((Object)"RpcInvoker | getPasswordEncrypAlg |start");
        RpcRequestProxy req = RpcNamingProxy.getInstance().createRequest("sm.ds.sysparammgr.getPasswordEncrypAlg");
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        String encryAlg = msg.getString("PasswordEncrypAlg");
        log.info((Object)("RpcInvoker | getPasswordEncrypAlg |end. The result is: " + encryAlg));
        return encryAlg;
    }

    public byte[] getRSAPublickey() throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | getRSAPublickey |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sysparammgr.getPublicKey");
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        t = System.currentTimeMillis() - t;
        log.info((Object)("RpcInvoker | getRSAPublickey |end" + t));
        return msg.getByteArray("publickey");
    }

    public RpcMessage getLMTLoginInfoFromRPC(byte[] encryptDynamicAESKey) throws Exception {
        RpcRequestProxy req = RpcNamingProxy.getInstance().createRequest("sm.ds.base.sessionmgr.getLMTLoginInfo");
        req.addArgument("dynamickey", (Object)encryptDynamicAESKey);
        RpcResponse rsp = req.invoke();
        RpcMessage msg = rsp.getMessage();
        return msg;
    }

    public Map<String, Object> loginByST(String userName, byte[] stInfo, String terminal, int clientType) throws Exception {
        long t = System.currentTimeMillis();
        log.info((Object)"RpcInvoker | loginByST |start");
        RpcRequestProxy req = this.getRpcRequest("sm.ds.base.sessionmgr.cspSSOLogin");
        req.addArgument("username", (Object)userName);
        req.addArgument("st", (Object)stInfo);
        req.addArgument("clientType", (Object)clientType);
        RpcResponse rsp = RpcInvoker.invokeRpcRequest(req);
        RpcMessage msg = rsp.getMessage();
        return this.changeRpcMsg2Map(msg, t);
    }
}

