/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.common;

import com.swimap.iview.templates.utils.MultiRowToolTip;
import com.swimap.iview.templates.utils.TextAreaCellRenderer;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class MaxConnectionMessageDlg
extends JDialog {
    private static IviewLogger logger = SMTraceProxy.getLogger(MaxConnectionMessageDlg.class);
    private static boolean debug = false;
    public static final int YES_OPTION = 0;
    public static final int NO_OPTION = 1;
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 2;
    public static final int CLOSE_OPTION = 3;
    public static final int YES_NO_OPTION = 1;
    private static final int MIN_DETAIL_INFO_HEIGHT = 96;
    private static final int MAX_DETAIL_INFO_HEIGHT = 144;
    private static final Dimension DEFAULT_BUTTON_SIZE = new Dimension(100, 21);
    private int option = 0;
    private Container rootContainer = null;
    private GridBagConstraints constraints = null;
    protected ArrayList<URI> ipInfo = null;
    private JButton detailInfoButton = new JButton();
    private JButton okButton = new JButton();
    private JPanel buttonPanel = new JPanel();
    private JPanel detailInfoPanel = new JPanel();
    private boolean bDetailShowed = false;
    private Object message = "";
    private OptionPane tempPane = null;
    private JTable detailInfoTable = null;
    private JTextArea detailInfoTextArea = null;
    private int minWidthWhenShowDetail = 0;
    private int minHeightWhenShowDetail = 0;
    private int minWidthWhenHideDetail = 0;
    private int minHeightWhenHideDetail = 0;
    private boolean resizable = false;
    private transient ActionListener buttonAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MaxConnectionMessageDlg.this.setOption(Integer.parseInt(ae.getActionCommand()));
            MaxConnectionMessageDlg.this.closeWindow();
        }
    };

    public MaxConnectionMessageDlg(Frame owner, String title, Object message, int messageType, ArrayList<URI> ipInfo, boolean resizable) {
        super(owner);
        this.resizable = resizable;
        try {
            this.setTitle(title);
            this.message = message;
            this.ipInfo = ipInfo;
            this.tempPane = new OptionPane(this.message, messageType, 1);
            this.init(0);
        }
        catch (Exception e) {
            logger.trace((Object)"", (Throwable)e);
        }
    }

    private void init(int optionType) throws Exception {
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(this.resizable);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (MaxConnectionMessageDlg.this.minWidthWhenHideDetail == 0 && !MaxConnectionMessageDlg.this.bDetailShowed) {
                    MaxConnectionMessageDlg.this.minWidthWhenHideDetail = MaxConnectionMessageDlg.this.getWidth();
                    MaxConnectionMessageDlg.this.minHeightWhenHideDetail = MaxConnectionMessageDlg.this.getHeight();
                }
                if (MaxConnectionMessageDlg.this.bDetailShowed) {
                    int currentWidth = MaxConnectionMessageDlg.this.getWidth();
                    int currentHeight = MaxConnectionMessageDlg.this.getHeight();
                    if (currentWidth < MaxConnectionMessageDlg.this.minWidthWhenShowDetail && currentHeight < MaxConnectionMessageDlg.this.minHeightWhenShowDetail) {
                        MaxConnectionMessageDlg.this.setSize(MaxConnectionMessageDlg.this.minWidthWhenShowDetail, MaxConnectionMessageDlg.this.minHeightWhenShowDetail);
                    } else if (currentWidth < MaxConnectionMessageDlg.this.minWidthWhenShowDetail) {
                        MaxConnectionMessageDlg.this.setSize(MaxConnectionMessageDlg.this.minWidthWhenShowDetail, currentHeight);
                    } else if (currentHeight < MaxConnectionMessageDlg.this.minHeightWhenShowDetail) {
                        MaxConnectionMessageDlg.this.setSize(currentWidth, MaxConnectionMessageDlg.this.minHeightWhenShowDetail);
                    }
                } else {
                    MaxConnectionMessageDlg.this.setSize(MaxConnectionMessageDlg.this.minWidthWhenHideDetail, MaxConnectionMessageDlg.this.minHeightWhenHideDetail);
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                ScreenToolKit.saveDialogLocation((Component)e.getComponent());
            }
        });
        this.rootContainer = this.getContentPane();
        this.rootContainer.setLayout(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.constraints.gridwidth = 1;
        this.constraints.insets = new Insets(12, 12, 12, 12);
        this.constraints.anchor = 17;
        this.rootContainer.add(this.tempPane.getComponent(0), this.constraints);
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.setName("DetailMessageDlg_buttonPanel");
        JButton firstButton = null;
        if (this.ipInfo != null) {
            firstButton = this.detailInfoButton;
            this.detailInfoButton.setMargin(new Insets(0, 0, 0, 0));
            this.detailInfoButton.setMnemonic('D');
            this.buttonPanel.add(Box.createRigidArea(new Dimension(60, 0)));
            this.detailInfoButton.setText(ResCenter.RES.getString("detailInfoButton.text") + ">>");
            this.detailInfoButton.setName("DetailMessageDlg_detailInfoButton");
            this.detailInfoButton.setMargin(new Insets(0, 0, 0, 0));
            this.detailInfoButton.setPreferredSize(DEFAULT_BUTTON_SIZE);
            this.detailInfoButton.setMaximumSize(DEFAULT_BUTTON_SIZE);
            this.detailInfoButton.setMinimumSize(DEFAULT_BUTTON_SIZE);
            this.detailInfoButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MaxConnectionMessageDlg.this.detailInfoButton_actionPerformed();
                }
            });
            this.buttonPanel.add(this.detailInfoButton);
            this.buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            this.setDetailInformation(this.ipInfo);
        } else {
            firstButton = this.okButton;
            this.buttonPanel.add(Box.createRigidArea(new Dimension(100, 0)));
        }
        if (optionType == 1) {
            JButton[] btnGroup = this.createYesNoButton();
            for (int i = 0; i < btnGroup.length; ++i) {
                this.buttonPanel.add(btnGroup[i]);
                if (i == btnGroup.length - 1) continue;
                this.buttonPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            }
            ScreenToolKit.setDefaultButtons((AbstractButton)btnGroup[0], (AbstractButton)btnGroup[1]);
        } else {
            this.okButton.setText(ResCenter.RES.getString("okButton.text"));
            this.okButton.setName("DetailMessageDlg_okButton");
            this.okButton.setPreferredSize(DEFAULT_BUTTON_SIZE);
            this.okButton.setMaximumSize(DEFAULT_BUTTON_SIZE);
            this.okButton.setMinimumSize(DEFAULT_BUTTON_SIZE);
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MaxConnectionMessageDlg.this.okButton_actionPerformed();
                }
            });
            this.buttonPanel.add(this.okButton);
            ScreenToolKit.setDefaultButtons((AbstractButton)firstButton, (AbstractButton)this.okButton);
        }
        if (this.ipInfo != null) {
            this.buttonPanel.add(Box.createRigidArea(new Dimension(60, 0)));
        } else {
            this.buttonPanel.add(Box.createRigidArea(new Dimension(100, 0)));
        }
        this.detailInfoPanel.setLayout(new GridLayout(1, 1));
        this.detailInfoPanel.setName("DetailMessageDlg_detailInfoPanel");
        this.constraints = new GridBagConstraints();
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.gridwidth = 1;
        this.constraints.insets = new Insets(12, 12, 11, 11);
        this.constraints.anchor = 10;
        if (debug) {
            this.buttonPanel.setBorder(BorderFactory.createLineBorder(Color.red));
        }
        this.rootContainer.add((Component)this.buttonPanel, this.constraints);
        this.pack();
        if (this.detailInfoTable != null) {
            int countWidth = (int)this.getSize().getWidth();
            TableColumn column = null;
            FontMetrics fontMetrics = this.detailInfoTable.getFontMetrics(this.detailInfoTable.getFont());
            int columnMinWidth = fontMetrics.stringWidth("\u2014");
            int j = this.detailInfoTable.getColumnCount();
            for (int i = 0; i < j; ++i) {
                column = this.detailInfoTable.getColumnModel().getColumn(i);
                column.setMinWidth(columnMinWidth + 3);
                column.setPreferredWidth(countWidth / j);
            }
            this.detailInfoTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() >= 2) {
                        MaxConnectionMessageDlg.this.dispose();
                    }
                }
            });
        }
        ScreenToolKit.restoreOldLocation((Component)this);
    }

    private JButton[] createYesNoButton() {
        JButton[] btnGroup = new JButton[2];
        btnGroup[0] = new JButton(ResCenter.RES.getString("yesButton.text"));
        btnGroup[0].setName("DetailMessageDlg_YesButton");
        btnGroup[0].setActionCommand("0");
        btnGroup[0].setMnemonic('y');
        btnGroup[1] = new JButton(ResCenter.RES.getString("noButton.text"));
        btnGroup[1].setName("DetailMessageDlg_NoButton");
        btnGroup[1].setActionCommand("1");
        btnGroup[1].setMnemonic('n');
        for (int i = 0; i < btnGroup.length; ++i) {
            btnGroup[i].setPreferredSize(DEFAULT_BUTTON_SIZE);
            btnGroup[i].setMaximumSize(DEFAULT_BUTTON_SIZE);
            btnGroup[i].addActionListener(this.buttonAction);
        }
        return btnGroup;
    }

    private void detailInfoButton_actionPerformed() {
        if (!this.bDetailShowed) {
            this.showDetailInformation();
            this.minWidthWhenShowDetail = this.getWidth();
            this.minHeightWhenShowDetail = this.getHeight();
        } else {
            this.hideDetailInformation();
        }
    }

    private void okButton_actionPerformed() {
        this.setOption(0);
        this.closeWindow();
    }

    private void closeWindow() {
        this.setVisible(false);
        this.dispose();
    }

    private void hideDetailInformation() {
        this.detailInfoButton.setText(ResCenter.RES.getString("detailInfoButton.text") + ">>");
        this.rootContainer.remove(this.detailInfoPanel);
        this.bDetailShowed = false;
        this.pack();
    }

    private void showDetailInformation() {
        this.constraints = new GridBagConstraints();
        this.constraints.gridx = 0;
        this.constraints.gridy = 3;
        this.constraints.gridwidth = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.fill = 1;
        this.constraints.anchor = 11;
        this.rootContainer.add((Component)this.detailInfoPanel, this.constraints);
        this.detailInfoButton.setText(ResCenter.RES.getString("detailInfoButton.text") + "<<");
        this.bDetailShowed = true;
        this.pack();
    }

    private void setDetailInformation(final ArrayList<URI> ipInfo) {
        this.detailInfoTable = new JTable(){

            @Override
            public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (ks.getKeyCode() == 27) {
                    return false;
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }

            @Override
            public JToolTip createToolTip() {
                MultiRowToolTip tip = new MultiRowToolTip();
                tip.setComponent((JComponent)this);
                return tip;
            }
        };
        this.detailInfoTable.setName("DetailMessageDlg_detailInfoTable");
        this.detailInfoTable.setModel(new DefaultTableModel(new String[]{ResCenter.RES.getString("ServerName"), ResCenter.RES.getString("ServerPort"), ResCenter.RES.getString("servermode")}, ipInfo.size()){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (ipInfo != null) {
                    URI uri = (URI)ipInfo.get(row);
                    switch (column) {
                        case 0: {
                            return uri.getHost();
                        }
                        case 1: {
                            return uri.getPort();
                        }
                        case 2: {
                            return uri.getScheme().toLowerCase().indexOf(115) >= 0 ? "SSL" : "Common";
                        }
                    }
                    return "";
                }
                return "";
            }
        });
        TextAreaCellRenderer render = new TextAreaCellRenderer();
        render.setShowToolTip(true);
        this.detailInfoTable.setDefaultRenderer(Object.class, (TableCellRenderer)render);
        this.detailInfoTable.getTableHeader().setReorderingAllowed(false);
        Dimension d = this.detailInfoTable.getPreferredSize();
        logger.trace((Object)("detailInfoTable PerferredSize Size:" + d.height + ' ' + d.width));
        if (d.height < 96) {
            d.height = 96;
        }
        if (d.height > 144) {
            d.height = 144;
        }
        JScrollPane scrollPane = new JScrollPane(this.detailInfoTable);
        scrollPane.setPreferredSize(d);
        this.detailInfoPanel.add(scrollPane);
    }

    public JTable getDetailTable() {
        return this.detailInfoTable;
    }

    private void setOption(int opt) {
        if (opt != 0 && opt != 1 && opt != 0 && opt != 2 && opt != 3) {
            throw new IllegalArgumentException("Para 'option' must one of YES, NO, OK, CANCEL, CLOSE, options");
        }
        this.option = opt;
    }
}

