/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.common;

import com.swimap.base.rpc.InternalErrorUtil;
import com.swimap.external.dsf.base.framework.AppError;
import com.swimap.external.dsf.base.rpc.RpcError;
import com.swimap.external.dsf.base.rpc.RpcErrorMetMax;
import com.swimap.external.dsf.base.rpc.RpcErrorSecurity;
import com.swimap.external.dsf.base.rpc.RpcNaming;
import com.swimap.external.sm.client.base.SessionService;
import com.swimap.external.sm.client.base.product.interfaces.IPreExitAction;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.statusbar.BubbleStatusBarItem;
import com.swimap.iview.templates.textfield.ValidCharDocument;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.SecurityBaseModule;
import com.swimap.sm.client.base.SecurityBaseModuleImpl;
import com.swimap.sm.client.base.auth.HeartBeatManager;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.common.MaxConnectionMessageDlg;
import com.swimap.sm.client.base.common.OptionPaneProxy4SmBase;
import com.swimap.sm.client.base.common.ValidUserPasswordDocument;
import com.swimap.sm.client.base.config.SecurityConfig;
import com.swimap.sm.client.base.event.LogEventDispatch;
import com.swimap.sm.client.base.event.SMEventDispatch;
import com.swimap.sm.client.base.sessionact.ActivateSessionHandler;
import com.swimap.sm.client.loginui.LoginUIBaseModule;
import com.swimap.sm.client.loginui.auth.LoginMgr;
import com.swimap.sm.client.loginui.auth.LogoutDlg;
import com.swimap.sm.client.loginui.common.GlobalUtil;
import com.swimap.sm.client.loginui.common.LogoutProxy;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import com.swimap.sm.client.loginui.common.proxy.rpc.RpcNamingProxy;
import com.swimap.sm.client.loginui.common.proxy.rpc.RpcRequestProxy;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;

public class GuiUtilForBase {
    private static IviewLogger log = SMTraceProxy.getLogger(GuiUtilForBase.class);
    private static final int COUNTDOWN_MSG_DELAY = 30000;
    public static boolean isLoginFinished = false;
    private static long delay1;
    private static long delay2;
    private static boolean isChangePxxWhenLogin;
    private static GuiUtilForBase instance;
    private static final String OVER_TIME_KICTOUT_FLAGE = "OverLoginTime";
    public static boolean isSetSingleUserModeDelayed;
    public static boolean bUserKickouted;
    public static boolean isSSL;
    private static boolean isAuthModeChangedMsgShow;
    private static boolean isInvalidTokenMsgShow;
    private boolean isBlockEvent;
    public static boolean bExit;

    public static boolean isbExit() {
        return bExit;
    }

    public static void resetExitFlag() {
        log.error((Object)"", (Throwable)new Exception("bExit is setting to false"));
        bExit = false;
    }

    public static void setToBeingExit() {
        log.error((Object)"", (Throwable)new Exception("bExit is setting to true"));
        bExit = true;
    }

    private GuiUtilForBase() {
    }

    public static GuiUtilForBase getInstance() {
        return instance;
    }

    public static void prepareToLogout() {
        log.info((Object)"GuiUtil | prepareToLogout | pauseLockWindow() ...");
        FrameworkUtilities.getTerminalManager().pauseLockWindow();
    }

    public void showMessageEx(String msg) {
        GuiUtilForBase.showErrorMessageWithInvokeLater(msg);
    }

    public String separateStringWith(String content, int width, String flg) {
        return OptionPane.separateStringWith((String)content, (int)width, (String)flg).toString();
    }

    public void showDetailMessageDlg(Exception e) {
        if (e instanceof RpcErrorMetMax) {
            RpcErrorMetMax error = (RpcErrorMetMax)e;
            if (error.getValidIps().size() > 0) {
                MaxConnectionMessageDlg dlg = new MaxConnectionMessageDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("NoteTitle"), ResCenter.RES.getString("MetMAXConnection"), 1, error.getValidIps(), false);
                dlg.setVisible(true);
                int index = dlg.getDetailTable().getSelectedRow();
                if (index < error.getValidIps().size() && index >= 0) {
                    URI uri = (URI)error.getValidIps().get(index);
                    LoginMgr loginMgr = LoginUIBaseModule.getLoginUIBaseModuleRef().getLoginMgr();
                    Vector serverInfo = loginMgr.getServerInfoVect();
                    for (Vector vector : serverInfo) {
                        if (!((String)vector.get(1)).equals(uri.getHost()) || !((String)vector.get(2)).equals(String.valueOf(uri.getPort()))) continue;
                        loginMgr.setCurIPPort(uri.getHost(), String.valueOf(uri.getPort()));
                        loginMgr.getUserLoginDlg().reloadloadServersData();
                        return;
                    }
                    Vector<String> serverInfoAsVector = new Vector<String>(0);
                    serverInfoAsVector.add(uri.getHost());
                    serverInfoAsVector.add(uri.getHost());
                    serverInfoAsVector.add(String.valueOf(uri.getPort()));
                    serverInfoAsVector.add(uri.getScheme().toLowerCase().indexOf(115) >= 0 ? "sslservermode" : "commonservermode");
                    serverInfoAsVector.add("");
                    serverInfoAsVector.add("");
                    loginMgr.getServerInfoVect().add(serverInfoAsVector);
                    loginMgr.setCurIPPort(uri.getHost(), String.valueOf(uri.getPort()));
                    loginMgr.getUserLoginDlg().reloadloadServersData();
                }
            } else {
                OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("MetMAX_ConnectFailed"));
            }
        }
    }

    public static String bundleString(String mainString, String firstString) {
        String bundledString = mainString;
        MessageFormat mf = new MessageFormat(bundledString);
        bundledString = mf.format(new String[]{firstString});
        return bundledString;
    }

    public static String bundleString(String mainString, String firstString, String secondString) {
        String bundledString = mainString;
        MessageFormat mf = new MessageFormat(bundledString);
        bundledString = mf.format(new String[]{firstString, secondString});
        return bundledString;
    }

    public static void displayCentered(JDialog dialog) {
        ScreenToolKit.centerLocateToScreen((Component)dialog);
        dialog.setVisible(true);
    }

    public boolean handleExceptionEx(Exception e) {
        return GuiUtilForBase.handleException(e);
    }

    public static void showHintMessageWithInvokeLater(final String message) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (bExit) {
                return;
            }
            OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), message);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (bExit) {
                        return;
                    }
                    OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), message);
                }
            });
        }
    }

    public static boolean handleException(Exception e) {
        if (e instanceof RpcErrorSecurity) {
            GuiUtilForBase.handleInvalidTokenException(e.getMessage());
            return true;
        }
        if (e instanceof RpcError) {
            if (bExit) {
                return true;
            }
            log.error((Object)"", (Throwable)e);
            GuiUtilForBase.showHintMessageWithInvokeLater(ResCenter.RES.getString("corbaerror"));
            return true;
        }
        if (!(e instanceof AppError)) {
            if ("socket not connected.".equals(e.getMessage())) {
                if (bExit) {
                    return true;
                }
                log.error((Object)"", (Throwable)e);
                log.info((Object)"socket not connected");
                GuiUtilForBase.showHintMessageWithInvokeLater(ResCenter.RES.getString("corbaerror"));
                return true;
            }
            return false;
        }
        AppError error = (AppError)((Object)e);
        if (error.is("SM_MDP_ERROR")) {
            if (!bExit) {
                GuiUtilForBase.showHintMessageWithInvokeLater(ResCenter.RES.getString("corbaerror"));
            }
            return true;
        }
        return false;
    }

    public static void dealWithAppError(AppError err) {
        if (err.is("SM_EXCEED_RIGHT")) {
            GuiUtilForBase.showHintMessageWithInvokeLater(ResCenter.RES.getString("errexcrigtxt0"));
        } else if (err.is("SM_MIT_ERROR") || err.is("SM_DB_ERROR") || err.is("SM_DATABASE_FAILURE")) {
            GuiUtilForBase.showHintMessageWithInvokeLater(ResCenter.RES.getString("errmiterrtxt0"));
        } else if (err.is("BAD_PARAM")) {
            GuiUtilForBase.showHintMessageWithInvokeLater(ResCenter.RES.getString("err_BAD_PARAM"));
        } else if (err.is("SM_MDP_ERROR")) {
            GuiUtilForBase.showHintMessageWithInvokeLater(ResCenter.RES.getString("corbaerror"));
        }
    }

    public static void initInValidTextField(JTextField fields, int maxLength) {
        String text = fields.getText();
        fields.setPreferredSize(new Dimension(fields.getPreferredSize().width, 21));
        ValidUserPasswordDocument inValidCharDocument = new ValidUserPasswordDocument(maxLength);
        fields.setDocument((Document)((Object)inValidCharDocument));
        fields.setText(text);
    }

    public static void initValidTextField(JTextField fields, int maxLength, String str) {
        String text = fields.getText();
        fields.setPreferredSize(new Dimension(fields.getPreferredSize().width, 21));
        ValidCharDocument validCharDocument = new ValidCharDocument(maxLength, str);
        fields.setDocument((Document)validCharDocument);
        fields.setText(text);
    }

    public static void showErrorMessageWithInvokeLater(String message) {
        if (bExit) {
            return;
        }
        GuiUtilForBase.showErrorInfo(message);
    }

    public static void showErrorInfo(final String message) {
        final JFrame component = FrameworkUtilities.getMainFrame();
        if (SwingUtilities.isEventDispatchThread()) {
            OptionPaneProxy4SmBase.showInformationDlg(component, message);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OptionPaneProxy4SmBase.showInformationDlg(component, message);
                }
            });
        }
    }

    public void handleModeSwitchEx(int waitSeconds) {
        GuiUtilForBase.handleModeSwitch(waitSeconds);
    }

    public static void handleModeSwitch(int waitSeconds) {
        String description = null;
        if (waitSeconds <= 0) {
            description = ResCenter.RES.getString("Switch_To_SingleMode_Exit");
            GuiUtilForBase.handleExitAction(description);
        } else {
            description = GuiUtilForBase.bundleString(ResCenter.RES.getString("System_Mode_Change1"), Integer.toString(waitSeconds));
            GuiUtilForBase.showBubble(description);
        }
    }

    public void handleKickoutConditionEx(String desc) {
        if (OVER_TIME_KICTOUT_FLAGE.equals(desc)) {
            String errorDescription = ResCenter.getInstance().getMergeString("userForceQuit", new String[]{TimeDateFormatUtil.convertFromUTC((long)System.currentTimeMillis())});
            GuiUtilForBase.handleKickout(errorDescription);
        } else {
            GuiUtilForBase.handleKickoutCondition(desc);
        }
    }

    public static void handleInvalidTokenException(String tokenInvalidError) {
        log.info((Object)("GuiUtil | handleInvalidTokenException | Invalid Token: " + tokenInvalidError));
        int type = GuiUtilForBase.getTokenInvalidType(tokenInvalidError);
        InternalErrorUtil.printInternalError((String)"Security", (int)(201392279 + type), (String)"Invalid user token.");
        if (type == -1) {
            if (bExit) {
                return;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                OptionPaneProxy4SmBase.showErrorDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("getUnkonwnToken"));
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OptionPaneProxy4SmBase.showErrorDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("getUnkonwnToken"));
                    }
                });
            }
            return;
        }
        if (bExit) {
            return;
        }
        if (type == 0) {
            GuiUtilForBase.handleKickoutCondition(ResCenter.RES.getString("anotheruser"));
            return;
        }
        if (type == 1) {
            GuiUtilForBase.handleModeSwitch(0);
            return;
        }
        if (type == 5) {
            GuiUtilForBase.handleExitAction(ResCenter.RES.getString("InvalidToken_UserDeleted"));
            return;
        }
        if (type == 6) {
            GuiUtilForBase.handleExitAction(ResCenter.RES.getString("InvalidToken_SingleSessionMode"));
            return;
        }
        if (type == 8) {
            GuiUtilForBase.handleExitAction(ResCenter.RES.getString("InvalidToken_OverMaxLink"));
            return;
        }
        if (type == 7) {
            GuiUtilForBase.handleExitAction(ResCenter.RES.getString("InvalidToken_OverMaxSession"));
            return;
        }
        if (type == 4) {
            GuiUtilForBase.handleExitAction(ResCenter.RES.getString("InvalidToken_UserInvalid"));
            return;
        }
        if (type == 9) {
            GuiUtilForBase.handleExitAction(ResCenter.RES.getString("InvalidToken_NotInDuration"));
            return;
        }
        ActivateSessionHandler handler = ActivateSessionHandler.getActivateSessionHandler();
        if (null != handler && handler.activateSessionOnce()) {
            GuiUtilForBase.showHintMessageWithInvokeLater(ResCenter.RES.getString("corbaerror"));
            return;
        }
        GuiUtilForBase.handleUnKnownToken(false);
    }

    private static int getTokenInvalidType(String tokenValidError) {
        String[] error = GlobalUtil.dealSplitToGlobal((String)tokenValidError, (String)":");
        if (error != null && error.length == 2) {
            return Integer.valueOf(error[1]);
        }
        return -1;
    }

    public static void handleKickoutCondition(String kickUser) {
        bUserKickouted = true;
        String errorDescription = "";
        errorDescription = kickUser == null || "".equals(kickUser) ? ResCenter.getInstance().getMergeString("userForceQuit", new String[]{TimeDateFormatUtil.convertFromUTC((long)System.currentTimeMillis())}) : ResCenter.getInstance().getMergeString("kickoutuser", new String[]{kickUser, TimeDateFormatUtil.convertFromUTC((long)System.currentTimeMillis())});
        GuiUtilForBase.handleKickout(errorDescription);
    }

    public static void handleKickout(String errorDescription) {
        if (bExit) {
            return;
        }
        log.info((Object)"pauseLockWindow() ...");
        FrameworkUtilities.getTerminalManager().pauseLockWindow();
        GuiUtilForBase.handleKickoutInEDT(errorDescription);
    }

    private static void handleKickoutInEDT(final String errorDescription) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (bExit) {
                return;
            }
            GuiUtilForBase.setToBeingExit();
            OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), errorDescription);
            log.info((Object)"logoutImmediately begin");
            LogoutProxy.getInstance().logoutImmediately();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GuiUtilForBase.handleKickoutInEDT(errorDescription);
                }
            });
        }
    }

    public void handleExitActionEx(String errorDescription) {
        GuiUtilForBase.handleExitAction(errorDescription);
    }

    public static void handleUnKnownToken(boolean unlockingTerminalFlag) {
        log.error((Object)("when unlocking terminal " + unlockingTerminalFlag));
        if (!unlockingTerminalFlag && bExit) {
            return;
        }
        SecurityBaseModuleImpl.removeConnectionStatusListener();
        GuiUtilForBase.clearConnection();
        GuiUtilForBase.processAfterUnkownTokenInEDT(unlockingTerminalFlag);
    }

    private static void processAfterUnkownTokenInEDT(final boolean unlockingTerminalFlag) {
        block7: {
            if (SwingUtilities.isEventDispatchThread()) {
                if (!unlockingTerminalFlag && bExit) {
                    log.info((Object)"is bExit, so return");
                    return;
                }
                GuiUtilForBase.setToBeingExit();
                if (isInvalidTokenMsgShow) {
                    log.info((Object)"The invalid Token tip dialog has showed, return directly.");
                    return;
                }
                isInvalidTokenMsgShow = true;
                try {
                    if (isChangePxxWhenLogin) {
                        OptionPane.showErrorDialog((Component)FrameworkUtilities.getMainFrame(), (Object)ResCenter.RES.getString("InvalidToken_NoSession_ChangePxx"));
                        isInvalidTokenMsgShow = false;
                        log.info((Object)"show invalid token when changpxx");
                        GuiUtilForBase.preExit();
                        break block7;
                    }
                    LogoutProxy.getInstance().preLogout();
                    OptionPane.showErrorDialog((Component)FrameworkUtilities.getMainFrame(), (Object)ResCenter.RES.getString("InvalidToken_NoSession"));
                    isInvalidTokenMsgShow = false;
                    log.info((Object)"show invalid token");
                    LogoutDlg.close();
                    LogoutProxy.getInstance().logout();
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GuiUtilForBase.processAfterUnkownTokenInEDT(unlockingTerminalFlag);
                    }
                });
            }
        }
    }

    public static void handleExitAction(String errorDescription) {
        if (bExit) {
            return;
        }
        SecurityBaseModuleImpl.removeConnectionStatusListener();
        try {
            SMEventDispatch.getInstance().stop();
            LogEventDispatch.getInstance().stop();
            HeartBeatManager.getInstance().stop();
        }
        catch (Exception e) {
            log.info((Object)"GuiUtil | handleExitAction | catch exception.");
        }
        log.info((Object)"GuiUtil | handleExitAction | pauseLockWindow() ...");
        FrameworkUtilities.getTerminalManager().pauseLockWindow();
        GuiUtilForBase.handleExitInEDT(errorDescription);
    }

    private static void handleExitInEDT(final String errorDescription) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (bExit) {
                return;
            }
            GuiUtilForBase.setToBeingExit();
            OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), errorDescription);
            GuiUtilForBase.clearConnection();
            log.info((Object)"GuiUtil | handleExitAction | System.exit ( -1 )");
            GuiUtilForBase.preExit();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GuiUtilForBase.handleExitInEDT(errorDescription);
                }
            });
        }
    }

    public static void clearConnection() {
        try {
            log.info((Object)"close rpcNaming when login fail...");
            RpcNaming.close();
        }
        catch (Exception e) {
            log.error((Object)"close rpcNaming with error when login fail.", (Throwable)e);
        }
    }

    private static IPreExitAction getProductIPreExitActionInterface() {
        try {
            String productClassName = SecurityConfig.getInstance().getProductPreExitActionClassPath();
            if (null == productClassName || productClassName.isEmpty()) {
                return null;
            }
            Class<?> productClass = Class.forName(productClassName);
            IPreExitAction intf = (IPreExitAction)productClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return intf;
        }
        catch (Exception e) {
            log.error((Object)"GuiUtil | getProductIPreExitActionInterface with error.", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void preExit() {
        int TIMEOUT = 10000;
        try {
            IPreExitAction preExitAction = GuiUtilForBase.getProductIPreExitActionInterface();
            if (preExitAction != null) {
                Timer timer = new Timer();
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        log.info((Object)"GuiUtil | PreExit | exit().");
                        GuiUtilForBase.exit();
                    }
                }, 10000L);
                log.info((Object)"GuiUtil | PreExit | begin to doPreExitAction.");
                boolean bSeccuse = preExitAction.doPreExitAction();
                log.info((Object)("GuiUtil | PreExit | doPreExitAction return:" + bSeccuse));
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        finally {
            GuiUtilForBase.exit();
        }
    }

    public static void showRightChangeBubble(final String message) {
        final BubbleStatusBarItem bar = (BubbleStatusBarItem)FrameworkUtilities.getStatusBarManager().getStatusBarItem("Bubble");
        bar.setName("SM_StatusBar_TextItem");
        if (SwingUtilities.isEventDispatchThread()) {
            if (FrameworkCommandProcessor.getInstance().isLogin()) {
                bar.setMessage(message);
                bar.setEnableAutoHide(false);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (FrameworkCommandProcessor.getInstance().isLogin()) {
                        bar.setMessage(message);
                        bar.setEnableAutoHide(false);
                    }
                }
            });
        }
    }

    public static void showBubble(String message) {
        BubbleStatusBarItem bar = (BubbleStatusBarItem)FrameworkUtilities.getStatusBarManager().getStatusBarItem("Bubble");
        delay1 = System.currentTimeMillis();
        if (SwingUtilities.isEventDispatchThread()) {
            bar.setName("SM_StatusBar_TextItem");
            bar.setMessage(message);
            bar.setEnableAutoHide(true);
            bar.setHideDelayTime(30000);
        } else {
            final BubbleStatusBarItem tempBar = bar;
            final String tempMessage = message;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    tempBar.setName("SM_StatusBar_TextItem");
                    tempBar.setMessage(tempMessage);
                    tempBar.setEnableAutoHide(true);
                    tempBar.setHideDelayTime(30000);
                }
            });
        }
    }

    public void cancelModeSwitchEx() {
        GuiUtilForBase.cancelModeSwitch();
    }

    public static void cancelModeSwitch() {
        GuiUtilForBase.stopBubble();
    }

    public static void stopBubble() {
        BubbleStatusBarItem bar = (BubbleStatusBarItem)FrameworkUtilities.getStatusBarManager().getStatusBarItem("Bubble");
        delay2 = System.currentTimeMillis();
        long temp = delay2 - delay1;
        if (temp < 1000L) {
            try {
                Thread.sleep(1000 - (int)temp);
            }
            catch (InterruptedException ex) {
                log.error((Object)"GuiUtil | stopBubble | sleep with error.", (Throwable)ex);
            }
        }
        final String description = ResCenter.RES.getString("System_Mode_Change5");
        if (SwingUtilities.isEventDispatchThread()) {
            bar.setName("SM_StatusBar_TextItem");
            bar.setMessage(description);
            bar.setEnableAutoHide(true);
            bar.setHideDelayTime(5000);
        } else {
            final BubbleStatusBarItem tempBar = bar;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    tempBar.setName("SM_StatusBar_TextItem");
                    tempBar.setMessage(description);
                    tempBar.setEnableAutoHide(true);
                    tempBar.setHideDelayTime(5000);
                }
            });
        }
    }

    public static void handleUserGroupChanged() {
        if (!SessionService.getInstance().isAdminUser()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (FrameworkCommandProcessor.getInstance().isLogin()) {
                        if (0 == OptionPaneProxy4SmBase.showConfirmDlgFocOnNo(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("Binding_Relation_Changed"))) {
                            log.info((Object)"user click yes! ");
                            LogoutProxy.getInstance().logoutImmediately();
                        } else {
                            log.info((Object)"user click no! ");
                        }
                    }
                }
            });
        }
    }

    public void setBlockEvent(boolean b) {
        this.isBlockEvent = b;
    }

    public boolean isBlockEvent() {
        return this.isBlockEvent;
    }

    public static void exit() {
        System.exit(-1);
    }

    public static void handleAuthModeChanged(int newMode, int localAuthMode) {
        log.info((Object)("local auth mode is : " + localAuthMode + ", AS' auth mode is : " + newMode));
        if (newMode == localAuthMode) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (bExit) {
                    return;
                }
                if (isAuthModeChangedMsgShow) {
                    log.info((Object)"The AuthMode changed msg dialog has displayed.");
                    return;
                }
                isAuthModeChangedMsgShow = true;
                LogoutProxy.getInstance().preLogout();
                OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("AuthMode_is_Chaged"));
                isAuthModeChangedMsgShow = false;
                LogoutProxy.getInstance().logout();
            }
        });
    }

    public static void setStatusBarWhenSysModeChange() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!bExit && isSetSingleUserModeDelayed) {
                        SecurityBaseModule.getSecuityModuleRef().getSessionManager().resetCurrentSysModel();
                        if (SecurityBaseModule.getSecuityModuleRef().getSessionManager().getSystemMode() == 0) {
                            SecurityBaseModule.getSecuityModuleRef().getStatusBarSettingProxy().setSystemModelMessageItemTooltip(ResCenter.RES.getString("maintenencemode"));
                        }
                        isSetSingleUserModeDelayed = false;
                    }
                }
                catch (Exception e) {
                    log.debug((Object)"", (Throwable)e);
                }
            }
        });
    }

    public static String getMsgString(Object msg) {
        return msg == null ? "" : msg.toString();
    }

    public static void setChangePxxWhenLogin(boolean isChangePxxWhenLogin) {
        GuiUtilForBase.isChangePxxWhenLogin = isChangePxxWhenLogin;
    }

    public static boolean isSecurityServiceException() {
        return GuiUtilForBase.isSMServiceException();
    }

    private static boolean isSMServiceException() {
        block3: {
            try {
                RpcRequestProxy reqPolicy = RpcNamingProxy.getInstance().createRequest("sm.ds.base.sysparammgr.getPolicy");
                reqPolicy.invoke();
            }
            catch (Exception ex) {
                log.error((Object)"", (Throwable)ex);
                if (!(ex instanceof AppError) || !((AppError)((Object)ex)).is("SM_MDP_ERROR")) break block3;
                if (!bExit) {
                    GuiUtilForBase.showHintMessageWithInvokeLater(ResCenter.RES.getString("corbaerror"));
                }
                return true;
            }
        }
        return false;
    }

    static {
        isChangePxxWhenLogin = false;
        instance = new GuiUtilForBase();
        isSetSingleUserModeDelayed = false;
        bUserKickouted = false;
        isSSL = false;
        isAuthModeChangedMsgShow = false;
        isInvalidTokenMsgShow = false;
        bExit = false;
    }
}

