/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.checkright;

import com.swimap.external.dsf.base.rpc.RpcErrorSecurity;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.sm.client.base.common.model.AccBit;
import com.swimap.external.sm.client.base.common.model.Right;
import com.swimap.external.sm.client.base.common.model.RightInfo;
import com.swimap.external.sm.client.base.common.model.StaticRight;
import com.swimap.external.sm.client.base.common.model.UserInfo;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.SessionService;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.common.RpcInvoker;
import com.swimap.sm.client.base.event.IEventHandler;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppRightAuthService
implements IEventHandler {
    private IviewLogger log = SMTraceProxy.getLogger(AppRightAuthService.class);
    private Map<String, StaticRight> staticRightMap = new HashMap<String, StaticRight>();
    private List<Map<String, Right>> userAppRightMap = new ArrayList<Map<String, Right>>();
    private RpcInvoker rpcInvoker = new RpcInvoker();
    private SessionService sessionService = SessionService.getInstance();
    private UserInfo curUser = null;
    private boolean isAdmin;
    private boolean isAdminGroup;
    private boolean isSMGroup;
    private boolean isSSAUser;
    private boolean hasAllAppOperationSet;
    private static final Object userAppRightLock = new Object();
    private boolean hasLoadUserAppRight;
    private static AppRightAuthService instance = new AppRightAuthService();

    public static AppRightAuthService getInstance() {
        return instance;
    }

    @Override
    public boolean handle(RpcEvent event) {
        this.hasLoadUserAppRight = false;
        this.userAppRightMap.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Right>> getUserAppRightMap() {
        if (!this.hasLoadUserAppRight) {
            Object object = userAppRightLock;
            synchronized (object) {
                if (!this.hasLoadUserAppRight) {
                    try {
                        this.userAppRightMap = this.rpcInvoker.getAllAppRightByUserID(this.curUser.id);
                        this.hasLoadUserAppRight = true;
                    }
                    catch (RpcErrorSecurity app) {
                        GuiUtilForBase.handleInvalidTokenException(app.getMessage());
                    }
                    catch (Exception e) {
                        this.log.error((Object)e, (Throwable)e);
                    }
                }
            }
        }
        return this.userAppRightMap;
    }

    public void getCurUserInfo() {
        long t1 = System.currentTimeMillis();
        this.curUser = SessionService.getInstance().getCurUser();
        this.isAdmin = this.sessionService.isAdminUser();
        this.isAdminGroup = this.sessionService.isAdminUserGroup();
        this.isSMGroup = this.sessionService.isSecurityMgrGroup(this.curUser.id);
        this.isSSAUser = this.sessionService.isSSAUser();
        this.userAppRightMap = this.sessionService.getAllAppRightByUserID(this.curUser.id);
        this.hasLoadUserAppRight = true;
        this.log.info((Object)" getCurUserInfo | set hasLoadUserAppRight for : true");
        this.staticRightMap = this.sessionService.getStaticRight();
        this.hasAllAppOperationSet = this.sessionService.hasAllAppOperationSetByUserID(this.curUser.id);
        long t2 = System.currentTimeMillis();
        this.log.info((Object)("==============get right cost time:" + (t2 - t1)));
    }

    public int[] checkRight(RightInfo[] rightInfos) throws Exception {
        int i;
        int[] result = new int[rightInfos.length];
        long t1 = System.currentTimeMillis();
        if (this.isAdmin) {
            for (int i2 = 0; i2 < result.length; ++i2) {
                result[i2] = 1;
            }
            this.log.info((Object)"admin check right pass.");
            return result;
        }
        if (this.isAdminGroup) {
            for (i = 0; i < result.length; ++i) {
                if (!rightInfos[i].getObjectClassType().equals("APPLICATION") || rightInfos[i].getObjectClassName().equals("SecurityApplication") || this.staticRightMap.get(2 + rightInfos[i].getObjectClassName() + rightInfos[i].getOperationID()) == null) continue;
                result[i] = 1;
            }
        }
        if (this.isSMGroup || this.isSSAUser) {
            for (i = 0; i < result.length; ++i) {
                if (result[i] != 0 || !rightInfos[i].getObjectClassType().equals("APPLICATION") || !rightInfos[i].getObjectClassName().equals("SecurityApplication") || this.staticRightMap.get(2 + rightInfos[i].getObjectClassName() + rightInfos[i].getOperationID()) == null) continue;
                result[i] = 1;
            }
        }
        if (this.hasAllAppOperationSet) {
            for (i = 0; i < result.length; ++i) {
                if (result[i] != 0 || !rightInfos[i].getObjectClassType().equals("APPLICATION") || rightInfos[i].getObjectClassName().equals("SecurityApplication") || this.staticRightMap.get(2 + rightInfos[i].getObjectClassName() + rightInfos[i].getOperationID()) == null) continue;
                result[i] = 1;
            }
        }
        for (i = 0; i < result.length; ++i) {
            if (result[i] != 0) continue;
            String strType = rightInfos[i].getObjectClassType();
            int type = strType.equals("APPLICATION") ? 2 : (strType.equals("MANAGED_OBJECT") ? 1 : -1);
            String className = rightInfos[i].getObjectClassName();
            Right right = new Right(type, className, rightInfos[i].getObjectID());
            StaticRight staticRight = this.staticRightMap.get(type + className + rightInfos[i].getOperationID());
            if (null == staticRight || !this.check(right.so.getKey(), staticRight.accBitSite, this.getUserAppRightMap())) continue;
            result[i] = 1;
        }
        long t2 = System.currentTimeMillis();
        this.debug(rightInfos, result);
        this.log.info((Object)("==============check right cost time:" + (t2 - t1)));
        return result;
    }

    private void debug(RightInfo[] rightInfos, int[] result) {
        for (int index = 0; index < rightInfos.length; ++index) {
            this.log.info((Object)("RightInfo : " + rightInfos[index] + " result: " + result[index]));
        }
    }

    private boolean check(String key, int bitSite, List<Map<String, Right>> userRightList) {
        for (Map<String, Right> map : userRightList) {
            if (!this.isPass(bitSite, this.getRightAccessBit(map, key))) continue;
            return true;
        }
        return false;
    }

    private List<AccBit> getRightAccessBit(Map<String, Right> map, String key) {
        Right tmp;
        List<AccBit> accBit = new ArrayList<AccBit>();
        if (map != null && !map.isEmpty() && (tmp = map.get(key)) != null) {
            accBit = tmp.accessBit;
        }
        return accBit;
    }

    private boolean isPass(int bitSite, List<AccBit> accBitList) {
        boolean isPass = false;
        for (AccBit acc : accBitList) {
            if (!acc.hasRight(bitSite)) continue;
            isPass = true;
            break;
        }
        return isPass;
    }

    public List<AccBit> getAccBit(List<AccBit> accBit, int bitSite) {
        for (AccBit bit : accBit) {
            bit.addBit(bitSite);
        }
        return accBit;
    }
}

