/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.autologout;

import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.autologout.AutoLogoutManager;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.FocusManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class AutoLogoutMonitor {
    private Timer m_autoLogtoutTimer = null;
    private AutoLogoutManager m_autoLogoutManager = null;
    private IviewLogger log = SMTraceProxy.getLogger(AutoLogoutMonitor.class);
    private static final int INTERVAL_TIME = 60000;
    private static final int WAIT_TIME = 30000;
    ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FrameworkUtilities.getMainFrame().toFront();
                    AutoLogoutMonitor.this.log.trace((Object)"AutoLogoutMonitor | Count down dialog is shown...");
                    AutoLogoutMonitor.this.m_autoLogoutManager.showTerminalDialog();
                }
            });
        }
    };
    private AWTEventListener awtListener = new AWTEventListener(){

        @Override
        public void eventDispatched(AWTEvent e) {
            Window window = FocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            AutoLogoutMonitor.this.log.trace((Object)"eventDispatched is executing");
            if (AutoLogoutMonitor.this.m_autoLogtoutTimer != null && AutoLogoutMonitor.this.m_autoLogtoutTimer.isRunning() && window != null) {
                AutoLogoutMonitor.this.restartTimer();
            }
        }
    };

    public AutoLogoutMonitor(AutoLogoutManager terminalManager) {
        this.m_autoLogoutManager = terminalManager;
    }

    public void doStartTimer() {
        Runnable doStartTimer = new Runnable(){

            @Override
            public void run() {
                AutoLogoutMonitor.this.newAndBeginTimer();
            }
        };
        SwingUtilities.invokeLater(doStartTimer);
    }

    private void newAndBeginTimer() {
        if (SwingUtilities.isEventDispatchThread()) {
            int currentInterval;
            if (this.m_autoLogtoutTimer != null) {
                this.m_autoLogtoutTimer.stop();
            }
            if (0 < (currentInterval = this.m_autoLogoutManager.getIdleTime())) {
                if (this.m_autoLogtoutTimer != null) {
                    this.m_autoLogtoutTimer.setDelay(currentInterval * 60000 - 30000);
                    this.m_autoLogtoutTimer.setInitialDelay(currentInterval * 60000 - 30000);
                } else {
                    this.m_autoLogtoutTimer = new Timer(currentInterval * 60000 - 30000, this.actionListener);
                }
            } else {
                return;
            }
            this.m_autoLogtoutTimer.start();
            this.hookUserEvent();
        }
    }

    public void startTimer() {
        if (null != this.m_autoLogtoutTimer) {
            this.m_autoLogtoutTimer.start();
        }
    }

    public void restartTimer() {
        this.log.info((Object)"restartTimer() is executing");
        boolean enableAutoLogout = this.m_autoLogoutManager.enableAutoLogout();
        int currentInterval = this.m_autoLogoutManager.getIdleTime();
        if (enableAutoLogout && currentInterval > 0) {
            if (null != this.m_autoLogtoutTimer) {
                this.m_autoLogtoutTimer.setDelay(currentInterval * 60000 - 30000);
                this.m_autoLogtoutTimer.setInitialDelay(currentInterval * 60000 - 30000);
            } else {
                this.m_autoLogtoutTimer = new Timer(currentInterval * 60000 - 30000, this.actionListener);
            }
            this.m_autoLogtoutTimer.restart();
        } else {
            this.m_autoLogtoutTimer.stop();
        }
    }

    public void stopTimer() {
        if (null != this.m_autoLogtoutTimer) {
            this.m_autoLogtoutTimer.stop();
        }
    }

    public void clear() {
        if (null != this.m_autoLogtoutTimer) {
            this.m_autoLogtoutTimer.stop();
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtListener);
    }

    private void hookUserEvent() {
        if (SwingUtilities.isEventDispatchThread()) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.awtListener, 56L);
        }
    }
}

