/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.autologout;

import com.swimap.external.sm.client.base.common.model.UserInfo;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.autologout.AutoLogoutDialog;
import com.swimap.sm.client.base.autologout.AutoLogoutMonitor;
import com.swimap.sm.client.loginui.common.SMTraceProxy;

public class AutoLogoutManager {
    private AutoLogoutMonitor theEventMonitor = null;
    private AutoLogoutDialog m_terminalDialog = null;
    private IviewLogger log = SMTraceProxy.getLogger(AutoLogoutManager.class);
    private UserInfo info;

    public AutoLogoutManager(UserInfo info) {
        this.info = info;
        this.theEventMonitor = new AutoLogoutMonitor(this);
        this.m_terminalDialog = new AutoLogoutDialog(this);
    }

    public void startTimer() {
        if (!this.enableAutoLogout()) {
            return;
        }
        int idleTime = this.getIdleTime();
        if (this.theEventMonitor != null) {
            if (idleTime <= 0) {
                this.log.trace((Object)"Auto_logout Checking Operation Thread is started, But current threshold is -1 minutes.");
            } else {
                this.log.trace((Object)("Auto_logout Checking Operation Thread is started, threshold is " + idleTime + " minutes."));
            }
            this.theEventMonitor.stopTimer();
            this.theEventMonitor.doStartTimer();
        }
    }

    public void stopTimer() {
        if (this.theEventMonitor != null) {
            this.log.trace((Object)"AutoLogoutManager | Stop key and mouse EventMonitor Timer ...");
            this.theEventMonitor.stopTimer();
        }
    }

    public void stopAutoLogout() {
        if (this.m_terminalDialog != null) {
            this.m_terminalDialog.dispose();
        }
        this.stopTimer();
    }

    public boolean enableAutoLogout() {
        return this.info.isAutoLogout;
    }

    public void setEnableAutoLogout(boolean isAutoLogout) {
        this.info.isAutoLogout = isAutoLogout;
    }

    public int getIdleTime() {
        return this.info.inactiveTime;
    }

    public void showTerminalDialog() {
        if (null == this.m_terminalDialog) {
            this.m_terminalDialog = new AutoLogoutDialog(this);
        }
        this.m_terminalDialog.setVisible(true);
        this.m_terminalDialog = null;
    }

    public void restart() {
        if (this.theEventMonitor == null) {
            this.log.trace((Object)"theEventMonitor is null.");
            return;
        }
        this.theEventMonitor.restartTimer();
    }

    public void enableIdleTimer(boolean enable) {
        if (this.theEventMonitor != null) {
            if (enable) {
                this.theEventMonitor.startTimer();
            } else {
                this.theEventMonitor.stopTimer();
            }
        }
    }

    public void clear() {
        if (this.theEventMonitor != null) {
            this.theEventMonitor.clear();
            this.theEventMonitor = null;
        }
        if (this.m_terminalDialog != null) {
            this.m_terminalDialog.dispose();
            this.m_terminalDialog = null;
        }
    }
}

