/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.autologout;

import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.autologout.AutoLogoutManager;
import com.swimap.sm.client.loginui.LoginUIBaseModule;
import com.swimap.sm.client.loginui.common.GuiUtilForLoginui;
import com.swimap.sm.client.loginui.common.LogoutProxy;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class AutoLogoutDialog
extends JDialog {
    private IviewLogger log = SMTraceProxy.getLogger(AutoLogoutDialog.class);
    private JTextArea textArea;
    private AutoLogoutManager m_autoLogoutmanager;
    private Timer logoutTimer = null;
    private Timer labelTimer = null;
    private static final int INTERVAL_TIME = 30000;
    private static final int REFRESH_LABEL_TIME = 1000;
    private int logoutTime;
    private ActionListener logoutActionListener;
    private ActionListener refreshLabelActionListener;
    private ActionListener cancelActionListener;
    private Icon informImageIcon = null;
    private JLabel iconlabel = null;
    private JButton cancelButton = null;
    private String msg;

    public AutoLogoutDialog(AutoLogoutManager autoLogoutmanager) {
        super(FrameworkUtilities.getMainFrame());
        this.m_autoLogoutmanager = autoLogoutmanager;
        this.initComponentes();
        this.initListener();
        this.addListener();
        this.getContentPane().add(this.buildPanel());
        this.doSetName();
        this.setDefaultCloseOperation(2);
        ScreenToolKit.centerLocateToScreen((Component)this);
    }

    private void initListener() {
        this.logoutActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoLogoutDialog.this.dispose();
                LoginUIBaseModule.getLoginUIBaseModuleRef().setAutoLogoutFlag();
                GuiUtilForLoginui.isLogout = true;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AutoLogoutDialog.this.log.info((Object)"AutoLogoutDialog | Call logoutDirectly() ...");
                        LogoutProxy.getInstance().logoutImmediately();
                    }
                });
            }
        };
        this.refreshLabelActionListener = new ActionListener(){
            private int counter = 29;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.counter > 0) {
                    AutoLogoutDialog.this.refreshLabel(this.counter--);
                }
            }
        };
        this.cancelActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoLogoutDialog.this.setVisible(false);
            }
        };
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                AutoLogoutDialog.this.setVisible(false);
            }
        });
    }

    private void addListener() {
        this.cancelButton.addActionListener(this.cancelActionListener);
    }

    private void removeListener() {
        if (null != this.cancelActionListener) {
            this.cancelButton.removeActionListener(this.cancelActionListener);
            this.cancelActionListener = null;
        }
        this.stopCountDownTimer();
        if (null != this.logoutActionListener && null != this.logoutTimer) {
            this.logoutTimer.removeActionListener(this.logoutActionListener);
            this.logoutActionListener = null;
            this.logoutTimer = null;
        }
        if (null != this.refreshLabelActionListener && null != this.labelTimer) {
            this.labelTimer.removeActionListener(this.refreshLabelActionListener);
            this.refreshLabelActionListener = null;
            this.labelTimer = null;
        }
    }

    @Override
    public void dispose() {
        this.removeListener();
        super.dispose();
    }

    private void refreshLabel(int seconds) {
        this.msg = GuiUtilForLoginui.bundleString((String)ResCenter.getInstance().getString("SecurityTerminalAutoLogoutDialog_Msg"), (String)Integer.toString(seconds));
        this.textArea.setText(this.msg);
    }

    private void initComponentes() {
        this.logoutTime = 30;
        this.iconlabel = new JLabel();
        this.informImageIcon = UIManager.getIcon("OptionPane.informationIcon");
        this.iconlabel.setIcon(this.informImageIcon);
        this.iconlabel.setBounds(10, 20, 32, 32);
        this.iconlabel.setMaximumSize(new Dimension(32, 32));
        this.iconlabel.setMinimumSize(new Dimension(32, 32));
        this.iconlabel.setPreferredSize(new Dimension(32, 32));
        this.textArea = new JTextArea();
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.textArea.setRequestFocusEnabled(false);
        this.textArea.setBorder(BorderFactory.createEmptyBorder());
        this.textArea.setEditable(false);
        this.textArea.setBackground(UIManager.getColor("Label.background"));
        Font font = this.iconlabel.getFont();
        this.textArea.setFont(font);
        this.refreshLabel(this.logoutTime);
        this.textArea.setFocusable(false);
        this.cancelButton = new JButton();
        this.cancelButton.setText(ResCenter.getInstance().getString("CancelButton"));
        this.cancelButton.setBounds(210, 70, 80, 21);
        Dimension dim = new Dimension(80, 21);
        this.cancelButton.setPreferredSize(dim);
        this.cancelButton.setMaximumSize(dim);
        this.cancelButton.setMinimumSize(dim);
        ScreenToolKit.setDefaultButtons((AbstractButton)this.cancelButton, (AbstractButton)this.cancelButton);
        this.setTitle(ResCenter.getInstance().getString("NoteTitle"));
        this.setModal(true);
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        if ("zh".equalsIgnoreCase(lang)) {
            this.setSize(500, 120);
        } else {
            this.setSize(500, 150);
        }
        this.setResizable(false);
    }

    private JPanel buildPanel() {
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        pane.add((Component)this.iconlabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 1, new Insets(10, 12, 0, 12), 0, 0));
        pane.add((Component)this.textArea, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 12, 0, 12), 0, 0));
        pane.add((Component)this.cancelButton, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 12, 12, 12), 0, 0));
        return pane;
    }

    @Override
    public void setVisible(boolean bVisible) {
        if (bVisible) {
            this.m_autoLogoutmanager.stopTimer();
            this.startCountDownTimer();
        } else {
            this.stopCountDownTimer();
            this.m_autoLogoutmanager.restart();
        }
        super.setVisible(bVisible);
    }

    private void stopCountDownTimer() {
        if (null != this.logoutTimer) {
            this.logoutTimer.stop();
        }
        if (null != this.labelTimer) {
            this.labelTimer.stop();
        }
    }

    private void startCountDownTimer() {
        Runnable doStartTimer = new Runnable(){

            @Override
            public void run() {
                AutoLogoutDialog.this.initCountDownTimers();
            }
        };
        SwingUtilities.invokeLater(doStartTimer);
    }

    private void initCountDownTimers() {
        if (null == this.logoutTimer) {
            this.logoutTimer = new Timer(30000, this.logoutActionListener);
        } else {
            this.logoutTimer.setDelay(30000);
            this.logoutTimer.setInitialDelay(30000);
        }
        this.logoutTime = 30;
        if (null == this.labelTimer) {
            this.labelTimer = new Timer(1000, this.refreshLabelActionListener);
        } else {
            this.labelTimer.setDelay(1000);
            this.labelTimer.setInitialDelay(1000);
        }
        this.logoutTimer.setRepeats(false);
        this.logoutTimer.start();
        this.labelTimer.start();
    }

    private void doSetName() {
        this.textArea.setName("JTextArea_textArea");
        this.iconlabel.setName("JLabel_iconlabel");
        this.cancelButton.setName("JButon_cancelButton");
    }
}

