/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.auth.checker;

import com.swimap.base.rpc.InternalErrorUtil;
import com.swimap.iview.clientutil.ClientUtilModule;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.SyncCommand;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.auth.CheckComponentVersionInfo;
import com.swimap.sm.client.base.auth.CheckVersionInfo;
import com.swimap.sm.client.base.auth.UpgradeClient;
import com.swimap.sm.client.base.auth.VersionCheckErrorInfo;
import com.swimap.sm.client.base.common.BaseConstants;
import com.swimap.sm.client.base.common.DetailMessageDialog;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.common.ResourceProxy4Base;
import com.swimap.sm.client.base.common.RpcInvoker;
import com.swimap.sm.client.base.common.model.CAUServerInfo;
import com.swimap.sm.client.base.common.model.VersionCheckInfo;
import com.swimap.sm.client.base.config.SecurityConfig;
import com.swimap.sm.client.loginui.auth.checker.AbstractChecker;
import com.swimap.sm.client.loginui.cmlinelogin.MainProxy;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class VersionChecker
extends AbstractChecker {
    private static IviewLogger log = SMTraceProxy.getLogger(VersionChecker.class);
    private GuiUtilForBase guiUtil;
    private String[] curIPPort;
    private static final String SYSTEM_PROPERTY_USE_ALL_IP = "use_all_ip";
    private static final String SYSTEM_PROPERTY_TEST_ALL_IP_TIMEOUT = "test_all_ip_timeout";
    private static final int SYSTEM_PROPERTY_DEFAULT_TIME_OUT = 5000;
    private boolean directUpgrade = false;
    private Map<String, String> compVersionSerMap = new HashMap<String, String>(1);
    private Map<String, CheckComponentVersionInfo> checkComponentVersionInfoMap = new HashMap<String, CheckComponentVersionInfo>(2);
    private Object[] parameters = new Object[1];

    public VersionChecker(GuiUtilForBase guiUtil, String[] curIPPort) {
        this.guiUtil = guiUtil;
        this.curIPPort = curIPPort;
    }

    public boolean check() {
        VersionCheckInfo result = this.checkVersionEx(this.curIPPort);
        if (result.updateType == BaseConstants.CheckVersionResult.VERSION_NEED_UPDATE) {
            this.handleUpdate();
            return false;
        }
        if (result.updateType == BaseConstants.CheckVersionResult.CHECK_VERSION_FAILED) {
            this.showErrorMessage(result);
            log.info((Object)"check version failed ...");
            return false;
        }
        log.info((Object)"check version matched.");
        return true;
    }

    private VersionCheckInfo checkVersionEx(String[] curIPPort) {
        VersionCheckInfo result = this.checkVersion(curIPPort);
        if (result.updateType != BaseConstants.CheckVersionResult.VESION_MATCHED) {
            return result;
        }
        if (SecurityConfig.getInstance().isSupportComponent()) {
            log.info((Object)"isSupportComponent = true");
            result = this.checkComponentVersion(curIPPort);
        }
        return result;
    }

    private VersionCheckInfo checkVersion(String[] curIPPort) {
        String errMessage = "";
        int updateResult = BaseConstants.CheckVersionResult.CHECK_VERSION_FAILED;
        VersionCheckInfo info = new VersionCheckInfo();
        try {
            CheckVersionInfo checkVersionInfo = this.getServerVersionInfo();
            int result = checkVersionInfo.result;
            String[] serverVersion = checkVersionInfo.versions;
            String clientVersion = this.getClientVersion();
            if (result == 30006) {
                InternalErrorUtil.printInternalError((String)"Security", (int)0xC010001, (String)"Check Version Failed.System is in init state.");
                errMessage = ResourceProxy4Base.getInstance().getResource("System_Init_State_Error");
                updateResult = BaseConstants.CheckVersionResult.CHECK_VERSION_FAILED;
                log.info((Object)"Server is in init State.");
            } else if (result == 0) {
                int checkResult = this.checkSysVersion(clientVersion, serverVersion);
                if (1 == checkResult) {
                    checkResult = this.configUpgradeParas(checkResult);
                }
                Object[] errorInfo = VersionCheckErrorInfo.getInstance().getVersionCheckErrorInfo(checkResult, clientVersion, serverVersion);
                errMessage = (String)errorInfo[0];
                updateResult = (Integer)errorInfo[1];
            } else {
                log.info((Object)("Get server version error , Error code = " + result));
                errMessage = ResourceProxy4Base.getInstance().getResource("GetServerVersionListErr");
            }
        }
        catch (Exception e) {
            errMessage = ResourceProxy4Base.getInstance().getResource("corbaerror");
            log.error((Object)"checkVersion with error.", (Throwable)e);
        }
        info.message = errMessage;
        info.updateType = updateResult;
        return info;
    }

    private int checkSysVersion(String clientVersion, String[] serverVersions) {
        ArrayList<String> serverVersionList = null;
        if (null != serverVersions) {
            serverVersionList = new ArrayList<String>(serverVersions.length);
            for (int i = 0; i < serverVersions.length; ++i) {
                serverVersionList.add(serverVersions[i]);
                log.info((Object)("Server Version : " + serverVersions[i]));
            }
        }
        int checkResult = 0;
        String className = SecurityConfig.getInstance().getVersionCompareClassName();
        log.info((Object)("the configured version checker calss name is " + className));
        if (className == null || className.trim().isEmpty()) {
            checkResult = this.platformVersionCompare(clientVersion, serverVersions);
        } else {
            try {
                Class<?> iVersionManager = Class.forName(className.trim());
                Class[] params = new Class[]{String.class, ArrayList.class};
                Method methods = iVersionManager.getMethod("compareVersion", params);
                Object[] objs = new Object[]{clientVersion, serverVersionList};
                checkResult = (Integer)methods.invoke(iVersionManager.newInstance(), objs);
            }
            catch (ClassNotFoundException e) {
                checkResult = this.platformVersionCompare(clientVersion, serverVersions);
            }
            catch (NoSuchMethodException e) {
                checkResult = this.platformVersionCompare(clientVersion, serverVersions);
            }
            catch (Exception e) {
                log.error((Object)"checkSysVersion reflect with error.", (Throwable)e);
                checkResult = BaseConstants.CheckVersionResult.CHECK_VERSION_FAILED;
            }
        }
        log.info((Object)("check version result = " + checkResult));
        return checkResult;
    }

    private int platformVersionCompare(String clientVersion, String[] serverVersions) {
        int checkResult = 1;
        if (null == serverVersions) {
            return 2;
        }
        for (int i = 0; i < serverVersions.length; ++i) {
            if (!serverVersions[i].equalsIgnoreCase(clientVersion)) continue;
            checkResult = 0;
            break;
        }
        return checkResult;
    }

    private VersionCheckInfo checkComponentVersion(String[] curIPPort) {
        VersionCheckInfo info = new VersionCheckInfo();
        int updateResult = BaseConstants.CheckVersionResult.VESION_MATCHED;
        String errMessage = "";
        try {
            try {
                this.compVersionSerMap = this.getServerComponentVersionInfo();
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
                info.updateType = BaseConstants.CheckVersionResult.CHECK_VERSION_FAILED;
                info.message = ResourceProxy4Base.getInstance().getResource("GetServerVersionListErr");
                return info;
            }
            log.info((Object)("get component versions from server is empty :" + this.compVersionSerMap.isEmpty()));
            Map<String, String> ClientVersions = this.getClientCompVersions();
            log.info((Object)("get component versions from client is empty :" + ClientVersions.isEmpty()));
            ArrayList<String> mismatchedComponents = new ArrayList<String>(0);
            String className = SecurityConfig.getInstance().getComponentVersionCompareClassName();
            log.info((Object)("configured components comparer is " + className));
            int checkResult = className == null || className.trim().length() == 0 ? this.platformComponentVersionComparer(ClientVersions, this.compVersionSerMap, mismatchedComponents) : this.productComponentVesrsionComperer(ClientVersions, mismatchedComponents, className);
            log.info((Object)("Component version checkResult = " + checkResult));
            Object[] errorInfo = this.getCompVersionCheckErrorInfo(checkResult);
            errMessage = (String)errorInfo[0];
            if (checkResult == 0) {
                updateResult = 0;
            } else if (checkResult == 1 || checkResult == 2) {
                if (1 == checkResult) {
                    checkResult = this.configUpgradeParas(checkResult);
                }
                updateResult = this.showDetailDialog(ClientVersions, mismatchedComponents, checkResult);
            } else {
                updateResult = BaseConstants.CheckVersionResult.CHECK_VERSION_FAILED;
            }
        }
        catch (Exception e) {
            errMessage = ResourceProxy4Base.getInstance().getResource("corbaerror");
            log.error((Object)"VersionChecker | checkVersion with error.", (Throwable)e);
        }
        info.message = errMessage;
        info.updateType = updateResult;
        return info;
    }

    private int productComponentVesrsionComperer(Map<String, String> clientVersions, List<String> mismatchedComponents, String className) {
        int checkResult = 0;
        log.info((Object)"Call product components versions comparer.");
        try {
            Class<?> iVersionManagerEx = Class.forName(className.trim());
            Class[] params = new Class[]{Map.class, Map.class, List.class};
            Method methods = iVersionManagerEx.getMethod("compareVersion", params);
            Object[] objs = new Object[]{clientVersions, this.compVersionSerMap, mismatchedComponents};
            checkResult = (Integer)methods.invoke(iVersionManagerEx.newInstance(), objs);
            log.info((Object)("Call product components versions compare checkresult is " + checkResult));
            if (1 == checkResult || 2 == checkResult) {
                this.directUpgrade = false;
                Set<String> servKeySet = this.compVersionSerMap.keySet();
                for (String compName : servKeySet) {
                    CheckComponentVersionInfo checkComponentVersionInfo = this.getClientVersionFromServer(compName);
                    this.checkComponentVersionInfoMap.put(compName, checkComponentVersionInfo);
                }
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"product component comperer Class not found error.", (Throwable)e);
            checkResult = this.platformComponentVersionComparer(clientVersions, this.compVersionSerMap, mismatchedComponents);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)"product component comperer has no such method error.", (Throwable)e);
            checkResult = this.platformComponentVersionComparer(clientVersions, this.compVersionSerMap, mismatchedComponents);
        }
        catch (Exception e) {
            log.error((Object)"product component comperer reflect with error.", (Throwable)e);
            checkResult = BaseConstants.CheckVersionResult.CHECK_VERSION_FAILED;
        }
        return checkResult;
    }

    private int platformComponentVersionComparer(Map<String, String> clientVersions, Map<String, String> compVersionSerMap, List<String> mismatchedComponents) {
        int checkResult = BaseConstants.CheckVersionResult.VESION_MATCHED;
        Set<String> servCompKeySet = compVersionSerMap.keySet();
        boolean isClientMismatch = false;
        for (String compName : servCompKeySet) {
            int result = 0;
            String clientVersion = clientVersions.get(compName);
            CheckComponentVersionInfo versionOfServ = this.getClientVersionFromServer(compName);
            if (null == versionOfServ) {
                mismatchedComponents.add(compName);
                result = 1;
            } else {
                this.checkComponentVersionInfoMap.put(compName, versionOfServ);
                result = this.platformVersionCompare(clientVersion, versionOfServ.getVersions());
                if (0 != result && !mismatchedComponents.contains(compName)) {
                    mismatchedComponents.add(compName);
                    if (null != clientVersion && !clientVersion.isEmpty()) {
                        isClientMismatch = true;
                    }
                }
            }
            checkResult = checkResult < result ? result : checkResult;
        }
        if (!compVersionSerMap.keySet().containsAll(clientVersions.keySet())) {
            isClientMismatch = true;
            Set<String> clientCompKeyset = clientVersions.keySet();
            for (String compName : clientCompKeyset) {
                if (compVersionSerMap.containsKey(compName)) continue;
                mismatchedComponents.add(compName);
                if (0 != checkResult) continue;
                checkResult = 1;
            }
        }
        if (!isClientMismatch && !this.directUpgrade) {
            log.info((Object)"platform check !isClientMismatch && !isDirectUpgrade() is retirning true");
            checkResult = BaseConstants.CheckVersionResult.VESION_MATCHED;
        }
        return checkResult;
    }

    private CheckComponentVersionInfo getClientVersionFromServer(String compName) {
        String versionValue = this.compVersionSerMap.get(compName);
        if (versionValue == null) {
            return null;
        }
        String[] versions = null;
        int result = 0;
        boolean isCommon = false;
        String[] values = versionValue.split("\\|");
        String lhs = null;
        String rhs = null;
        String[] valArray = null;
        for (String temp : values) {
            valArray = temp.split("=");
            if (null != valArray && valArray.length > 1) {
                lhs = valArray[0];
                rhs = valArray[1];
                if (lhs.equalsIgnoreCase("iscommon")) {
                    isCommon = Boolean.valueOf(rhs);
                } else if (lhs.equalsIgnoreCase("clients")) {
                    versions = rhs.split(",");
                }
            }
            valArray = null;
        }
        if (isCommon) {
            this.directUpgrade = true;
        }
        return new CheckComponentVersionInfo(compName, versions, isCommon, result);
    }

    private int showDetailDialog(Map<String, String> clientVersions, List<String> mismatchedComponents, int checkResult) {
        int result;
        HashMap<String, String[]> detailMsgMap = new HashMap<String, String[]>();
        if (mismatchedComponents.isEmpty()) {
            return BaseConstants.CheckVersionResult.VESION_MATCHED;
        }
        this.formatComponentVersionMap(clientVersions, mismatchedComponents, detailMsgMap);
        String[][] details = new String[detailMsgMap.size() + 1][3];
        details[0][0] = ResourceProxy4Base.getInstance().getResource("componentName");
        details[0][1] = ResourceProxy4Base.getInstance().getResource("ClientComponentVersion");
        details[0][2] = ResourceProxy4Base.getInstance().getResource("ServerComponentVersion");
        if (!detailMsgMap.isEmpty()) {
            Set keySet = detailMsgMap.keySet();
            int idx = 1;
            for (String compName : keySet) {
                String[] versions = (String[])detailMsgMap.get(compName);
                details[idx][0] = compName;
                details[idx][1] = versions[0];
                details[idx][2] = versions[1];
                ++idx;
            }
        }
        if (0 == (result = this.showDeatilDlg(checkResult, details)) && 1 == checkResult) {
            return BaseConstants.CheckVersionResult.VERSION_NEED_UPDATE;
        }
        return BaseConstants.CheckVersionResult.CHECK_VERSION_FAILED;
    }

    private int showDeatilDlg(int checkResult, String[][] details) {
        if (checkResult == 1) {
            return DetailMessageDialog.showQuestionDlg(FrameworkUtilities.getMainFrame(), ResourceProxy4Base.getInstance().getResource("Component_NoMatched_NeedUpdate"), details);
        }
        return DetailMessageDialog.showErrorDlg(FrameworkUtilities.getMainFrame(), ResourceProxy4Base.getInstance().getResource("ComponentMisMatched_NeedManualUpdate"), details);
    }

    private void formatComponentVersionMap(Map<String, String> clientVersions, List<String> mismatchedComponents, Map<String, String[]> detailMsgMap) {
        CheckComponentVersionInfo checkComponentVersionInfo = null;
        for (String mCompName : mismatchedComponents) {
            checkComponentVersionInfo = this.checkComponentVersionInfoMap.get(mCompName);
            String clientVersion = clientVersions.get(mCompName);
            if (null != checkComponentVersionInfo && null != checkComponentVersionInfo.getVersions()) {
                String[] serverClientVersions = checkComponentVersionInfo.getVersions();
                int size = serverClientVersions.length;
                String[] versions = new String[2];
                versions[0] = null == clientVersion ? "--" : clientVersion;
                StringBuilder serverVersion = new StringBuilder();
                for (int i = 0; i < size; ++i) {
                    serverVersion.append(serverClientVersions[i]).append(",");
                }
                versions[1] = serverVersion.length() == 0 ? "--" : serverVersion.substring(0, serverVersion.length() - 1);
                detailMsgMap.put(mCompName, versions);
                continue;
            }
            String[] versions = new String[]{null == clientVersion ? "--" : clientVersion, "--"};
            detailMsgMap.put(mCompName, versions);
        }
    }

    protected String getClientVersion() {
        String clientVersion = MainProxy.getInstance().getVersionID();
        log.info((Object)("Client version is :" + clientVersion));
        return clientVersion;
    }

    private CheckVersionInfo getServerVersionInfo() throws Exception {
        SyncCommand version = new SyncCommand(){

            public Object call() throws Exception {
                log.info((Object)"begin to invoke getServerVersion...");
                long t1 = System.currentTimeMillis();
                CheckVersionInfo checkVersionInfo = RpcInvoker.getInstance().getServerVersion();
                long t2 = System.currentTimeMillis();
                log.info((Object)("finished getServerVersion. cost time = " + (t2 - t1)));
                return checkVersionInfo;
            }
        };
        if (!version.startCall()) {
            Exception ex = version.getException();
            throw ex;
        }
        return (CheckVersionInfo)version.getResult();
    }

    protected Map<String, String> getClientCompVersions() {
        ResourceBundle[] resBundles = MainProxy.getInstance().getComponentVersionIDs();
        HashMap<String, String> compVersionMap = new HashMap<String, String>(2);
        if (resBundles == null) {
            return compVersionMap;
        }
        this.getCompVersionMap(resBundles, compVersionMap);
        return compVersionMap;
    }

    private void getCompVersionMap(ResourceBundle[] resBundles, Map<String, String> compVersionMap) {
        String version = null;
        String component = null;
        ResourceBundle resBu = null;
        Enumeration<String> keys = null;
        String key = "";
        String value = null;
        String VersionID = "VersionID";
        String ComponentName = "ComponentName";
        for (int index = 0; index < resBundles.length; ++index) {
            resBu = resBundles[index];
            if (resBu == null) {
                log.info((Object)"No component resource configured in client");
                continue;
            }
            keys = resBu.getKeys();
            if (keys == null) {
                log.info((Object)"There is not any key in resource file from client ");
                continue;
            }
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                value = resBu.getString(key);
                if (key.equals(VersionID)) {
                    version = value;
                } else if (key.equals(ComponentName)) {
                    component = value;
                }
                log.info((Object)("Client component version: component : " + key + " version : " + value));
            }
            compVersionMap.put(component, version);
            version = null;
            component = null;
        }
    }

    private Map<String, String> getServerComponentVersionInfo() throws Exception {
        SyncCommand version = new SyncCommand(){

            public Object call() throws Exception {
                log.info((Object)"begin to invoke getServercomponentVersion...");
                long t1 = System.currentTimeMillis();
                Map<String, String> map = RpcInvoker.getInstance().getServerComponentVersion();
                long t2 = System.currentTimeMillis();
                log.info((Object)(" finished getServercomponentVersion. cost time = " + (t2 - t1)));
                return map;
            }
        };
        if (!version.startCall()) {
            Exception ex = version.getException();
            throw ex;
        }
        return (Map)version.getResult();
    }

    private int configUpgradeParas(int checkResult) {
        log.info((Object)("configUpdateParas, input result: " + checkResult));
        int result = checkResult;
        if (1 == result) {
            try {
                boolean isSSL;
                GuiUtilForBase.isSSL = isSSL = this.curIPPort[2].equals("sslservermode");
                log.info((Object)("updating parameters[], is SSL " + isSSL));
                this.parameters[0] = this.getUpdateInfo(isSSL);
            }
            catch (Exception e) {
                result = 2;
                log.error((Object)"configUpdateParas with error.", (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryConnect(String ip, String port, int timeout) {
        Socket socket = null;
        try {
            socket = new Socket();
            InetSocketAddress socketAddress = new InetSocketAddress(ip, (int)Integer.valueOf(port));
            socket.connect(socketAddress, timeout);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
    }

    public static boolean isUseAllIp() {
        String s = System.getProperty(SYSTEM_PROPERTY_USE_ALL_IP);
        if (null == s || s.isEmpty()) {
            return false;
        }
        try {
            return Boolean.valueOf(s);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            return false;
        }
    }

    public static int getTestAllIpTimeout() {
        String s = System.getProperty(SYSTEM_PROPERTY_TEST_ALL_IP_TIMEOUT);
        if (null == s || s.isEmpty()) {
            return 5000;
        }
        try {
            return Integer.valueOf(s);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            return 5000;
        }
    }

    private ArrayList<String> getUpdateInfo(boolean isSSL) {
        ArrayList<String> list = new ArrayList<String>(20);
        CAUServerInfo cauServerInfo = null;
        try {
            cauServerInfo = RpcInvoker.getInstance().getCAUServerInfo();
        }
        catch (Exception ex) {
            log.error((Object)"get CAU server info with error.", (Throwable)ex);
        }
        if (cauServerInfo != null) {
            String port;
            String serverIP = VersionChecker.getRealServerIP(cauServerInfo.getServerIP());
            String commonPort = cauServerInfo.getCommonPort();
            String sslPort = cauServerInfo.getSslPort();
            log.info((Object)("serverIP:" + serverIP + " commonPort:" + commonPort + " sslPort:" + sslPort));
            if (serverIP == null || commonPort == null || sslPort == null) {
                return list;
            }
            list.add(serverIP);
            String string = port = isSSL ? sslPort : commonPort;
            if (VersionChecker.isUseAllIp() && null != this.curIPPort && this.curIPPort.length > 0 && VersionChecker.tryConnect(this.curIPPort[0], port, VersionChecker.getTestAllIpTimeout())) {
                list.clear();
                list.add(this.curIPPort[0]);
            }
            list.add(port);
        }
        return list;
    }

    private static String getRealServerIP(String serverIP) {
        try {
            log.info((Object)("before getValidIP:" + serverIP));
            String ip = ClientUtilModule.getValidIP((String)serverIP, (int)-1);
            log.info((Object)("after getValidIP:" + ip));
            return ip == null ? serverIP : ip;
        }
        catch (Exception e) {
            log.error((Object)"ClientUtilModule.getValidIP with error. ", (Throwable)e);
            return serverIP;
        }
    }

    private Object[] getCompVersionCheckErrorInfo(int checkResult) {
        String errMessage = "";
        int updateResult = BaseConstants.CheckVersionResult.CHECK_VERSION_FAILED;
        switch (checkResult) {
            case 0: {
                updateResult = BaseConstants.CheckVersionResult.VESION_MATCHED;
                break;
            }
            case 1: {
                updateResult = BaseConstants.CheckVersionResult.VERSION_NEED_UPDATE;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                errMessage = ResourceProxy4Base.getInstance().getResource("ClientVersionErr");
                break;
            }
            case 4: {
                errMessage = ResourceProxy4Base.getInstance().getResource("ServerVersionListErr");
                break;
            }
            default: {
                errMessage = ResourceProxy4Base.getInstance().getResource("CheckVersionErr");
                log.info((Object)"Check components' version with error result.");
            }
        }
        Object[] result = new Object[]{errMessage, updateResult};
        return result;
    }

    protected void showErrorMessage(VersionCheckInfo result) {
        if (GuiUtilForBase.isbExit()) {
            return;
        }
        if (result != null && result.message != null && result.message.length() > 0) {
            this.guiUtil.showMessageEx(result.message);
        }
    }

    private void handleUpdate() {
        UpgradeClient.getInstance().handleUpdateClient(this.parameters);
    }
}

