/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.auth.checker;

import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.SyncCommand;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.auth.SessionManager;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.common.model.LawInfo;
import com.swimap.sm.client.loginui.auth.checker.AbstractChecker;
import com.swimap.sm.client.loginui.common.OptionDlg;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.awt.Component;
import java.awt.Window;

public class LawChecker
extends AbstractChecker {
    private IviewLogger log = SMTraceProxy.getLogger(LawChecker.class);
    private SessionManager sessionManager;
    private GuiUtilForBase guiUtil;
    private ResCenter resCenter;
    private String[] curIPPort;

    public LawChecker(SessionManager sessionManager, String[] curIPPort, GuiUtilForBase guiUtil, ResCenter resCenter) {
        this.sessionManager = sessionManager;
        this.guiUtil = guiUtil;
        this.resCenter = resCenter;
        this.curIPPort = curIPPort;
    }

    public boolean check() {
        if (this.curIPPort[0] != null && this.curIPPort[1] != null && !this.isReadLawFileSuccess(this.sessionManager, this.guiUtil, this.resCenter)) {
            this.log.info((Object)"LawChecker | check | get result with false");
            return false;
        }
        return true;
    }

    private boolean isReadLawFileSuccess(final SessionManager sessionManager, GuiUtilForBase guiUtil, ResCenter resCenter) {
        boolean isLawOpen = false;
        String lawContent = "";
        try {
            Exception ex;
            SyncCommand syn = new SyncCommand(){

                public Object call() throws Exception {
                    LawInfo resultList = sessionManager.getLawInfo();
                    return resultList;
                }
            };
            boolean synOK = syn.startCall((Component)FrameworkUtilities.getMainFrame(), true);
            if (!synOK && (ex = syn.getException()) != null) {
                throw ex;
            }
            LawInfo lawInfo = (LawInfo)syn.getResult();
            isLawOpen = lawInfo.isShow;
            lawContent = lawInfo.info;
        }
        catch (Exception e) {
            this.log.error((Object)"LawChecker | isReadLawFileSuccess with error.", (Throwable)e);
            return true;
        }
        if (isLawOpen) {
            return 6 == OptionDlg.showAgreeDisAgreeDialog((Window)FrameworkUtilities.getMainFrame(), (String)lawContent, (String)resCenter.getString("LawDeclare"));
        }
        return true;
    }
}

