/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.auth.checker;

import com.swimap.base.rpc.RpcErrorVerUnMatch;
import com.swimap.base.rpc.handshake.ServerHello;
import com.swimap.external.dsf.base.rpc.NATUtility;
import com.swimap.external.dsf.base.rpc.RpcErrorMetMax;
import com.swimap.external.dsf.base.rpc.RpcNaming;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.auth.SessionManager;
import com.swimap.sm.client.base.auth.UpgradeClient;
import com.swimap.sm.client.base.auth.checker.VersionChecker;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.common.OptionPaneProxy4SmBase;
import com.swimap.sm.client.base.sessionact.DoubleHostSwitchHandler;
import com.swimap.sm.client.loginui.auth.checker.AbstractChecker;
import com.swimap.sm.client.loginui.auth.diagnose.InitCommException;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class InitCommunicationChecker
extends AbstractChecker {
    private IviewLogger log = SMTraceProxy.getLogger(InitCommunicationChecker.class);
    private SessionManager sessionMgr;
    private String[] serverInfo;
    private GuiUtilForBase guiUtil;

    public InitCommunicationChecker(SessionManager sessionMgr, String[] serverInfo, GuiUtilForBase guiUtil, String curIPName) {
        this.sessionMgr = sessionMgr;
        this.guiUtil = guiUtil;
        this.serverInfo = serverInfo;
    }

    public boolean check() throws Exception {
        boolean isSupportSSL = this.serverInfo[2].equals("sslservermode");
        try {
            DoubleHostSwitchHandler handler = DoubleHostSwitchHandler.getResumeTimeoutHandler();
            if (null != handler && handler.isSwitching()) {
                handler.setSessionManager(SessionManager.getInstance());
                if (handler.connectSecondHostForLogin()) {
                    return true;
                }
            } else {
                this.sessionMgr.initRpcNamingAddress(this.serverInfo[0], this.serverInfo[1], isSupportSSL);
                this.sessionMgr.setServerName(this.serverInfo[3]);
                this.sessionMgr.setServerIP(RpcNaming.getCurrentIp());
                this.sessionMgr.setServerPort(RpcNaming.getCurrentPort());
            }
        }
        catch (Exception e) {
            if (e instanceof RpcErrorMetMax) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.guiUtil.showDetailMessageDlg(e);
                } else {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                InitCommunicationChecker.this.guiUtil.showDetailMessageDlg(e);
                            }
                        });
                    }
                    catch (Exception ex) {
                        this.log.error((Object)ex, (Throwable)ex);
                    }
                }
            } else if (e instanceof RpcErrorVerUnMatch) {
                String port;
                this.log.info((Object)"RpcErrorVerUnMatch handle begin...");
                if (1 == OptionPaneProxy4SmBase.showConfirmDlgFocOnNo(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("RPCNoMatched_NeedUpdate"))) {
                    this.log.info((Object)"user confirm is not upgrade.");
                    return false;
                }
                RpcErrorVerUnMatch rpcErrorVerUnMatch = (RpcErrorVerUnMatch)e;
                ServerHello.RpcUpgradeInfo rpcUpgradeInfo = rpcErrorVerUnMatch.getRpcUpgradeInfo();
                StringBuffer natIPStr = new StringBuffer();
                String[] natIPs = rpcUpgradeInfo.getNatIPs();
                if (natIPs != null) {
                    for (int i = 0; i < natIPs.length; ++i) {
                        natIPStr.append(natIPs[i]);
                        natIPStr.append(", ");
                    }
                }
                this.log.info((Object)("RpcErrorVerUnMatch handle (" + rpcUpgradeInfo.getCauIP() + ", " + rpcUpgradeInfo.getCauSSLPort() + ", " + rpcUpgradeInfo.getCauCommonPort() + ", nat:" + natIPStr.toString() + ")"));
                Object[] parameters = new Object[1];
                ArrayList<String> list = new ArrayList<String>(20);
                String string = port = isSupportSSL ? rpcUpgradeInfo.getCauSSLPort() : rpcUpgradeInfo.getCauCommonPort();
                if (VersionChecker.isUseAllIp() && null != this.serverInfo && this.serverInfo.length > 0 && VersionChecker.tryConnect(this.serverInfo[0], port, VersionChecker.getTestAllIpTimeout())) {
                    list.add(this.serverInfo[0]);
                } else if (natIPs != null) {
                    ArrayList<String> ipMapLines = new ArrayList<String>();
                    for (int i = 0; i < natIPs.length; ++i) {
                        ipMapLines.add(natIPs[i]);
                    }
                    String natIP = NATUtility.getValidIp((String)rpcUpgradeInfo.getCauIP(), ipMapLines);
                    list.add(natIP == null ? rpcUpgradeInfo.getCauIP() : natIP);
                } else {
                    list.add(rpcUpgradeInfo.getCauIP());
                }
                list.add(port);
                parameters[0] = list;
                this.log.info((Object)("RpcErrorVerUnMatch handle handleUpdateClient:" + (String)list.get(0) + ", " + (String)list.get(1)));
                UpgradeClient.getInstance().handleUpdateClient(parameters);
                this.log.info((Object)"RpcErrorVerUnMatch handle end...");
            } else {
                throw new InitCommException();
            }
            return false;
        }
        return true;
    }
}

