/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.auth;

import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.common.BaseConstants;
import com.swimap.sm.client.base.common.OptionPaneProxy4SmBase;
import com.swimap.sm.client.base.common.ResourceProxy4Base;
import java.awt.Component;
import javax.swing.JFrame;

public class VersionCheckErrorInfo {
    private static IviewLogger log = IviewLogger.getLogger(VersionCheckErrorInfo.class);
    private static VersionCheckErrorInfo instance = new VersionCheckErrorInfo();

    public static VersionCheckErrorInfo getInstance() {
        return instance;
    }

    public Object[] getVersionCheckErrorInfo(int checkResult, String clientVersion, String[] serverVersion) {
        String errMessage = "";
        int updateResult = BaseConstants.CheckVersionResult.CHECK_VERSION_FAILED;
        JFrame parentComponent = FrameworkUtilities.getMainFrame();
        switch (checkResult) {
            case 0: {
                updateResult = BaseConstants.CheckVersionResult.VESION_MATCHED;
                break;
            }
            case 1: {
                String versionStr = ResourceProxy4Base.getInstance().getMergeString("NoMatched_NeedUpdate", new String[]{this.getAllServerVersion(serverVersion), clientVersion});
                if (0 == this.showConfirmDlg(parentComponent, versionStr)) {
                    updateResult = BaseConstants.CheckVersionResult.VERSION_NEED_UPDATE;
                    break;
                }
                updateResult = BaseConstants.CheckVersionResult.CHECK_VERSION_FAILED;
                break;
            }
            case 2: {
                errMessage = ResourceProxy4Base.getInstance().getMergeString("NoMatched_NeedManualUpdate", new String[]{this.getAllServerVersion(serverVersion), clientVersion});
                break;
            }
            case 3: {
                errMessage = ResourceProxy4Base.getInstance().getResource("ClientVersionErr");
                break;
            }
            case 4: {
                errMessage = ResourceProxy4Base.getInstance().getResource("ServerVersionListErr");
                break;
            }
            default: {
                errMessage = ResourceProxy4Base.getInstance().getResource("CheckVersionErr");
                log.info((Object)"VersionChecker | checkVersion | product Check Version with error.");
            }
        }
        Object[] result = new Object[]{errMessage, updateResult};
        return result;
    }

    private String getAllServerVersion(String[] serverVersion) {
        if (null == serverVersion || serverVersion.length == 0) {
            return "--";
        }
        StringBuffer sVersionBuf = new StringBuffer();
        for (int i = 0; i < serverVersion.length; ++i) {
            sVersionBuf.append(serverVersion[i]);
            sVersionBuf.append(ResourceProxy4Base.getInstance().getResource("Stir"));
        }
        String sVersion = sVersionBuf.substring(0, sVersionBuf.length() - 1);
        return sVersion;
    }

    private int showConfirmDlg(Component parentComp, String versionStr) {
        return OptionPaneProxy4SmBase.showConfirmDlgFocOnNo(parentComp, versionStr);
    }
}

