/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.auth;

import com.swimap.base.rpc.InternalErrorUtil;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.jni.Os;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.common.OptionPaneProxy4SmBase;
import com.swimap.sm.client.base.common.ResourceProxy4Base;
import com.swimap.sm.client.base.common.ScriptExecutor;
import com.swimap.sm.client.base.common.UpgradingShowMessage;
import com.swimap.sm.client.base.config.SecurityConfig;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class UpgradeClient {
    private static IviewLogger log = IviewLogger.getLogger(UpgradeClient.class);
    private Object[] parameters = new Object[1];
    private static UpgradeClient instance = new UpgradeClient();

    public static UpgradeClient getInstance() {
        return instance;
    }

    public void handleUpdateClient(Object[] upPara) {
        this.parameters = upPara;
        if (this.isReadytoUpdate((short)0)) {
            this.upgradeClient((short)0);
        }
    }

    private void upgradeClient(short type) {
        ScriptExecutor.executeBatFile();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String methodName = "startClientAutoUpgrade";
                Class[] args = new Class[]{ArrayList.class};
                StringBuffer sb = new StringBuffer();
                int size = ((ArrayList)UpgradeClient.this.parameters[0]).size();
                for (int i = 0; i < size; ++i) {
                    sb.append(((ArrayList)UpgradeClient.this.parameters[0]).get(i));
                    sb.append(" ");
                }
                log.info((Object)("UpgradeClient | updateClient | Update script is : " + sb));
                try {
                    Class<?> responds = Class.forName("com.swimap.cmf.cau.ClientAutoUpgrade");
                    Method method = responds.getMethod(methodName, args);
                    Object resutl = method.invoke(responds.newInstance(), UpgradeClient.this.parameters);
                    log.info((Object)("UpgradeClient | updateClient | reflect method return result is " + resutl));
                }
                catch (Exception ex) {
                    log.error((Object)"UpgradeClient | updateClient | reflect with error.", (Throwable)ex);
                    InternalErrorUtil.printInternalError((String)"Security", (int)99999999, (String)"'com.swimap.cmf.cau.ClientAutoUpgrade' class or 'startClientAutoUpgrade' not found.");
                    OptionPaneProxy4SmBase.showErrorDlg(FrameworkUtilities.getMainFrame(), ResourceProxy4Base.getInstance().getResource("SM_UpgradeWRONG_PARAM"));
                    return;
                }
                GuiUtilForBase.exit();
            }
        });
    }

    private boolean isReadytoUpdate(short type) {
        int clientCount = this.getClientCount();
        int updateCount = this.getUpgradeCount();
        log.info((Object)("UpgradeClient | isReadytoUpdate clientCount = " + clientCount + " , updateCount = " + updateCount));
        if (clientCount > 1) {
            UpgradingShowMessage.showMessage(type, ResourceProxy4Base.getInstance().getResource("Upgrade_MoreThanOneClient"));
            return false;
        }
        if (updateCount > 0) {
            UpgradingShowMessage.showMessage(type, ResourceProxy4Base.getInstance().getResource("Upgrade_IsUpgrading"));
            return false;
        }
        return true;
    }

    private int getClientCount() {
        String mainClassName = SecurityConfig.getInstance().getClientMainClassName();
        String frameTitle = FrameworkUtilities.getMainFrame().getTitle();
        log.info((Object)("UpgradeClient | getClientCount | mainClassName = " + mainClassName + " , " + "Main_MDIFrame_Title = " + frameTitle));
        return Os.getOs().getOnlineWindowNumber(mainClassName, frameTitle);
    }

    private int getUpgradeCount() {
        return SecurityConfig.getInstance().getUpgradeCount(Os.getOs());
    }
}

