/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.auth;

import com.swimap.base.rpc.InternalErrorUtil;
import com.swimap.external.dsf.base.framework.AppError;
import com.swimap.external.dsf.base.rpc.RpcError;
import com.swimap.external.dsf.base.rpc.RpcErrorSecurity;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.sm.client.base.common.model.BaseInfo;
import com.swimap.external.sm.client.base.common.model.Right;
import com.swimap.external.sm.client.base.common.model.StaticRight;
import com.swimap.external.sm.client.base.common.model.UserInfo;
import com.swimap.external.sm.client.base.product.interfaces.IOperation;
import com.swimap.iview.clientutil.ClientUtilModule;
import com.swimap.iview.communicate.CommHandle;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.lm.client.LicenseManager;
import com.swimap.lm.client.LicenseUtil;
import com.swimap.lm.client.UpdateLicenseManager;
import com.swimap.sm.client.base.SessionService;
import com.swimap.sm.client.base.auth.ChangePasswordDlg;
import com.swimap.sm.client.base.auth.CheckVersionInfo;
import com.swimap.sm.client.base.auth.HeartBeatManager;
import com.swimap.sm.client.base.auth.LoginUserInfoDlg;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.common.LoginUserInfo;
import com.swimap.sm.client.base.common.OptionPaneProxy4SmBase;
import com.swimap.sm.client.base.common.RpcInvoker;
import com.swimap.sm.client.base.common.SmAppError;
import com.swimap.sm.client.base.common.model.AuthConfInfo;
import com.swimap.sm.client.base.common.model.CAUServerInfo;
import com.swimap.sm.client.base.common.model.LawInfo;
import com.swimap.sm.client.base.common.model.LoginRecInfo;
import com.swimap.sm.client.base.common.model.SessionInfo;
import com.swimap.sm.client.base.config.SecurityConfig;
import com.swimap.sm.client.base.crypt.RSAEncrypt;
import com.swimap.sm.client.base.event.EventConstants;
import com.swimap.sm.client.base.event.EventRegisterFactory;
import com.swimap.sm.client.base.event.IEventHandler;
import com.swimap.sm.client.base.event.handle.ACLChangedEventHandler;
import com.swimap.sm.client.base.event.handle.AccChangeHandler;
import com.swimap.sm.client.base.event.handle.AuthModeChangedEvent;
import com.swimap.sm.client.base.event.handle.CurrentUserAccoutValidityChangedEventHandler;
import com.swimap.sm.client.base.event.handle.GroupDevAccChangedEventHandler;
import com.swimap.sm.client.base.event.handle.GroupDeviceSetAccChanged;
import com.swimap.sm.client.base.event.handle.SMServiceUPHandler;
import com.swimap.sm.client.base.event.handle.SecurityPolicyChangedEventHandler;
import com.swimap.sm.client.base.event.handle.Set2SetRightChangedEventHandler;
import com.swimap.sm.client.base.event.handle.StaticRightUpdateEventHandle;
import com.swimap.sm.client.base.event.handle.TransferDataChangedEventHandler;
import com.swimap.sm.client.base.event.handle.UserAutoLockEventHandler;
import com.swimap.sm.client.base.event.handle.UserBelongGroupChangedEventHandler;
import com.swimap.sm.client.base.event.handle.UserDeletedNotifyProductEventHandler;
import com.swimap.sm.client.base.event.handle.UserPwdChangedEventHandler;
import com.swimap.sm.client.base.event.handle.UserReceiveMessageEventHandler;
import com.swimap.sm.client.base.hedexhelp.HedexHelpImpl;
import com.swimap.sm.client.base.product.interfaces.ILogin;
import com.swimap.sm.client.base.sessionact.ActivateSessionHandler;
import com.swimap.sm.client.base.sound.LoginFailSoundManager;
import com.swimap.sm.client.loginui.LoginUIBaseModule;
import com.swimap.sm.client.loginui.auth.ServerInfo;
import com.swimap.sm.client.loginui.cmlinelogin.MainProxy;
import com.swimap.sm.client.loginui.common.GlobalUtil;
import com.swimap.sm.client.loginui.common.LoginUIConstants;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import com.swimap.sm.client.loginui.common.SecurityRedLineUtil;
import com.swimap.sm.client.loginui.config.LoginUIConfig;
import com.swimap.sm.client.loginui.switchlogin.SwitchLogin;
import java.net.BindException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class SessionManager {
    private static final IviewLogger log = SMTraceProxy.getLogger(SessionManager.class);
    private static final int TOKEN_ITEMS = 7;
    private static final int LOGIN_STATUS_SUCCESS = 0;
    private static final int LOGIN_STATUS_INVALID_LICENSE = 1;
    private static final int LOGIN_STATUS_MAXLINK = 2;
    private byte[] securityToken;
    private SessionInfo curSession;
    private String login_userName;
    private UserInfo curUserInfo;
    private String curIPAddress;
    private String curTerminalID;
    private String serverIP;
    private String showServerIP;
    private String serverPort;
    private String serverName;
    private String adminUserName;
    private String adminGroupName;
    private boolean loginFinished = false;
    private String namingAddress = null;
    private GuiUtilForBase guiUtil;
    private int[] pwdStatusInfo = new int[0];
    private ResCenter resCenter;
    private boolean enableSSL = false;
    private RpcInvoker rpcInvoker;
    private static final RpcInvoker DEFAULT_RPC_INVOKER = new RpcInvoker();
    private LoginUserInfo loginUserInfo = null;
    private int loginFailCounter;
    private AuthConfInfo serverAuthInfo;
    private String commTerminalIP = "";
    private boolean isIPassMode = false;
    private boolean isRemoteLoginSuccess = false;
    private static int REMOTE_AUTHHENTICATION = 1;
    private static SessionManager instance;
    private static final int NOTNEED_CHANGE_PWD = 0;
    private static final int CHANGE_PWD_SUCC = 1;
    private static final int CHANGE_PWD_FAIL = 2;
    private byte[] modifyImtInfo = null;
    private boolean isLogout;
    private boolean loginSuccful = false;
    private boolean isRestrict = false;
    private int authMode = -1;
    private int currentSysModel = -1;
    private LoginRecInfo[] recInfos = null;
    private long backendCurrentData = 0L;

    public static SessionManager getInstance() {
        if (null == instance) {
            instance = new SessionManager(GuiUtilForBase.getInstance(), ResCenter.getInstance());
        }
        return instance;
    }

    public static void clearInstance() {
        instance = null;
    }

    private SessionManager(GuiUtilForBase guiUtil, ResCenter resCenter) {
        this.guiUtil = guiUtil;
        this.resCenter = resCenter;
    }

    public void registerEvent() {
        EventRegisterFactory.create().register("2:7", new SystemModeSwitchEventHandler());
        EventRegisterFactory.create().register("2:25", new UserBeKickedOutEventHandler());
        EventRegisterFactory.create().register("3:8", new UserBelongGroupChangedEventHandler(this.getCurUser()));
        EventRegisterFactory.create().register("3:6", new GroupDevAccChangedEventHandler(this.getCurUser(), new RpcInvoker()));
        EventRegisterFactory.create().register("3:5", new GroupDeviceSetAccChanged());
        EventRegisterFactory.create().register("3:2", new GroupDevAccChangedEventHandler(this.getCurUser(), new RpcInvoker()));
        EventRegisterFactory.create().register("1:16", new Set2SetRightChangedEventHandler(GuiUtilForBase.getInstance(), this.getCurUser(), new RpcInvoker()));
        EventRegisterFactory.create().register("1:20", new Set2SetRightChangedEventHandler(GuiUtilForBase.getInstance(), this.getCurUser(), new RpcInvoker()));
        EventRegisterFactory.create().register("2:25", new CurrentUserAccoutValidityChangedEventHandler(this.getCurUser(), ResCenter.getInstance(), GuiUtilForBase.getInstance()));
        EventRegisterFactory.create().register("3:23", new StaticRightUpdateEventHandle());
        EventRegisterFactory.create().register("2:23", new UserReceiveMessageEventHandler(this.getCurSessionID()));
        EventRegisterFactory.create().register("1:7", new UserDeletedNotifyProductEventHandler());
        EventRegisterFactory.create().register("99:1", new SMServiceUPHandler());
        EventRegisterFactory.create().register("3:27", new AuthModeChangedEvent());
        EventRegisterFactory.create().register("1:6", new UserAutoLockEventHandler());
        EventRegisterFactory.create().register("1:6", new SecurityPolicyChangedEventHandler());
        EventRegisterFactory.create().register("2:22", UserPwdChangedEventHandler.getInstance());
        EventRegisterFactory.create().register("2:11", UserPwdChangedEventHandler.getInstance());
        EventRegisterFactory.create().register("1:27", TransferDataChangedEventHandler.getInstance());
        EventRegisterFactory.create().register("2:25", ACLChangedEventHandler.getInstance());
    }

    public void setCurIPName(String curIPName) {
        this.serverIP = curIPName;
    }

    public String getCurIPName() {
        return this.serverIP;
    }

    public boolean isLoginFinished() {
        return this.loginFinished;
    }

    public boolean isRemoteLoginSuccess() {
        return this.isRemoteLoginSuccess;
    }

    public String getServerIP() {
        return this.serverIP;
    }

    public String getShowServerIP() {
        return this.showServerIP;
    }

    public void setShowServerIP(String showServerIP) {
        this.showServerIP = showServerIP;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public String getCommTerminalIP() {
        return this.commTerminalIP;
    }

    public String initRpcNamingAddress(String dsServerIP, String dsServerPort, boolean isSupportSSL) throws Exception {
        this.serverPort = dsServerPort;
        this.enableSSL = isSupportSSL;
        Vector<String> ipVector = this.getServerList(dsServerIP);
        Iterator<String> ipIterator = ipVector.iterator();
        while (ipIterator.hasNext()) {
            String strIp = ipIterator.next();
            log.trace((Object)("IP: " + strIp));
            this.serverIP = strIp;
            this.showServerIP = strIp;
            try {
                String connectingMsg = GuiUtilForBase.bundleString(ResCenter.RES.getString("Login_Comm_Connecting"), strIp);
                this.addMessage(connectingMsg);
                this.namingAddress = this.getRpcInvoker().initConnectionParam(strIp, dsServerPort, isSupportSSL);
                if (this.namingAddress == null || !RSAEncrypt.getInstance().initRSAPublickey()) continue;
                String succeededMsg = GuiUtilForBase.bundleString(ResCenter.RES.getString("Login_Comm_Connect_Succeeded"), strIp);
                this.addMessage(succeededMsg);
                break;
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
                String failedMsg = GuiUtilForBase.bundleString(ResCenter.RES.getString("Login_Comm_Connect_Failed"), strIp);
                this.addMessage(failedMsg);
                if (ipIterator.hasNext() && !(e.getCause() instanceof BindException)) continue;
                throw e;
            }
        }
        log.info((Object)("SessionManager | initRpcNamingAddress |" + this.namingAddress));
        return this.namingAddress;
    }

    private Vector<String> getServerList(String dsServerIP) {
        Vector<String> ipVector = new Vector<String>();
        if (dsServerIP == null) {
            return ipVector;
        }
        String[] ipArray = ServerInfo.getIPArray((String)dsServerIP);
        if (!LoginUIConfig.getInstance().isMSupportSecondaryServer() || ipArray.length < 2) {
            ipVector.clear();
            ipVector.add(ipArray[0]);
        } else if (LoginUIConfig.getInstance().getConnectSequence() == 1) {
            ipVector.clear();
            ipVector.add(ipArray[1]);
            ipVector.add(ipArray[0]);
        } else {
            ipVector.clear();
            ipVector.add(ipArray[0]);
            ipVector.add(ipArray[1]);
        }
        return ipVector;
    }

    private void addMessage(final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    log.info((Object)msg);
                    FrameworkUtilities.getOutputManager().addMessage(msg);
                }
                catch (Exception e) {
                    log.error((Object)"catch exception:");
                    log.error((Object)e, (Throwable)e);
                }
            }
        });
    }

    public boolean getLoginInfo(byte[] token, String terminal) throws Exception {
        Map<String, Object> loginResult = this.getRpcInvoker().getLoginInfo();
        HeartBeatManager.getInstance().start();
        this.currentSysModel = (Integer)loginResult.get("SystemMode");
        this.isRestrict = (Boolean)loginResult.get("isRestrict");
        this.backendCurrentData = (Long)loginResult.get("backendCurrentData");
        this.pwdStatusInfo = new int[2];
        this.pwdStatusInfo[0] = (Integer)loginResult.get("PasswordExpiryDays");
        this.pwdStatusInfo[1] = (Integer)loginResult.get("pwdStatus");
        this.securityToken = token;
        String[] items = GlobalUtil.dealSplitToGlobal((String)new String(token), (String)";");
        if (items.length != 7) {
            log.error((Object)"token parse error.");
        } else {
            this.commTerminalIP = items[2];
            log.info((Object)("login successful:" + items[4]));
        }
        CommHandle.setCurrentSession((byte[])this.securityToken);
        RpcInvoker.getInstance().setCurrentSession(this.securityToken);
        this.curSession = (SessionInfo)loginResult.get("SessionInfo");
        this.curUserInfo = (UserInfo)loginResult.get("UserInfo");
        this.login_userName = this.curUserInfo.getUserName();
        this.curTerminalID = terminal;
        this.loginSuccful = true;
        this.initalLoginUserInfo();
        HedexHelpImpl.getInstance().addHedexHelpListeners();
        HedexHelpImpl.getInstance().setUserName(this.curUserInfo.getUserName());
        this.isIPassMode = this.isIPassModel();
        SwitchLogin.getInstance().getLoginArguments().userName = this.curUserInfo.getUserName();
        this.authMode = SwitchLogin.getInstance().getLoginArguments().authMode;
        this.curSession.setUserAuthType(SwitchLogin.getInstance().getLoginArguments().authUserType);
        return true;
    }

    public LicenseManager getLicenseManager() {
        ModuleManager moduleMgr = MainProxy.getInstance().getModuleManager();
        LicenseManager licenseModule = (LicenseManager)moduleMgr.getLocalModule(LicenseManager.getLicenseModuleName());
        if (licenseModule == null) {
            licenseModule = (LicenseManager)FrameworkUtilities.loadModule((String)"com.swimap.lm.client.LicenseManager", (ModuleManager)moduleMgr);
        }
        return licenseModule;
    }

    private boolean checkPWDStatus() throws Exception {
        if (this.handlePwdChange(this.pwdStatusInfo[1]) == 2) {
            return false;
        }
        ClientUtilModule.postInitConnectionParam();
        if (!this.checkAccount()) {
            return false;
        }
        this.initalLoginUserInfo();
        try {
            UpdateLicenseManager.getInstance().setCurUserName(this.getCurUserName());
            this.setHasRightForLicense();
            this.loadIPassMode();
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean checkAccount() {
        int days = -1;
        boolean isValid = true;
        String msg = "";
        days = this.checkAccountValidity();
        log.info((Object)("SecurityModule | checkAccountValidity() | Expiry day is " + days));
        switch (days) {
            case 10002: {
                msg = ResCenter.RES.getString("Accountexpiried");
                isValid = false;
                break;
            }
            case 10000: {
                break;
            }
            case 0: {
                msg = ResCenter.RES.getString("AccountWillExpireInfoNow");
                break;
            }
            default: {
                msg = GuiUtilForBase.bundleString(ResCenter.RES.getString("AccountWillExpireInfo"), Integer.toString(days));
            }
        }
        if (msg.length() > 0) {
            OptionPaneProxy4SmBase.showWarningDlgOnlyOneBtn(FrameworkUtilities.getMainFrame(), msg);
        }
        return isValid;
    }

    public ILogin getProductILgoinInterface() {
        try {
            String productClassName = SecurityConfig.getInstance().getProductLoginClassPath();
            if (null == productClassName || productClassName.isEmpty()) {
                return null;
            }
            Class<?> productClass = Class.forName(productClassName);
            ILogin intf = (ILogin)productClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return intf;
        }
        catch (Exception e) {
            log.error((Object)"SecurityBaseModuleImpl | getProductILgoinInterface with error.", (Throwable)e);
            return null;
        }
    }

    private int handlePwdChange(int imtInfoStatus) {
        try {
            switch (imtInfoStatus) {
                case 0: {
                    this.willExpireHint();
                    return 0;
                }
                case 1: {
                    return this.mustChangePassword() ? 1 : 2;
                }
                case 2: {
                    return this.expiredChangePassword() ? 1 : 2;
                }
                case 3: {
                    this.willExpireHint();
                    return 0;
                }
                case 4: {
                    if (SwingUtilities.isEventDispatchThread()) {
                        OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("PasswordExpired_CannotChange"));
                    } else {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("PasswordExpired_CannotChange"));
                                }
                            });
                        }
                        catch (Exception e) {
                            log.error((Object)"", (Throwable)e);
                        }
                    }
                    this.logout();
                    GuiUtilForBase.exit();
                }
            }
            return 0;
        }
        catch (Exception ex) {
            log.error((Object)"SecurityBaseModuleImpl | handlePwdChange | getPasswordStatus with error.", (Throwable)ex);
            return 0;
        }
    }

    private void willExpireHint() {
        int expiryDays = SessionManager.getInstance().getPasswordExpiryDays();
        String msg = null;
        if (0 < expiryDays && expiryDays != 1000) {
            msg = GuiUtilForBase.bundleString(ResCenter.RES.getString("PassWordWillExpireInformation"), expiryDays + "");
        } else if (0 == expiryDays) {
            msg = ResCenter.RES.getString("PassWordWillExpireInfoNow");
        } else {
            log.info((Object)("willExpireHint | expiryDays is " + expiryDays));
        }
        if (msg != null && !"".equals(msg.trim())) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.showMessageThenChangePx(msg);
            } else {
                final String finalMsg = msg;
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            SessionManager.this.showMessageThenChangePx(finalMsg);
                        }
                    });
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
        }
    }

    private void showMessageThenChangePx(String msg) {
        if (GuiUtilForBase.isSecurityServiceException()) {
            return;
        }
        if (0 != OptionPaneProxy4SmBase.showConfirmDlgFocOnNo(FrameworkUtilities.getMainFrame(), msg)) {
            return;
        }
        ChangePasswordDlg imfInfoDialog = new ChangePasswordDlg(true, 10004, SessionManager.getInstance().getCurUser(), GuiUtilForBase.getInstance(), ResCenter.getInstance(), SessionManager.getInstance(), this.getOperationIntf(), this.getProductILgoinInterface());
        if (imfInfoDialog.getInitResult()) {
            GuiUtilForBase.displayCentered(imfInfoDialog);
            imfInfoDialog.validate();
        }
    }

    public boolean changePassword() {
        if (GuiUtilForBase.isSecurityServiceException()) {
            return false;
        }
        ChangePasswordDlg imtInfoDialog = new ChangePasswordDlg(false, 10004, SessionManager.getInstance().getCurUser(), GuiUtilForBase.getInstance(), ResCenter.getInstance(), SessionManager.getInstance(), this.getOperationIntf(), this.getProductILgoinInterface());
        if (imtInfoDialog.getInitResult()) {
            GuiUtilForBase.displayCentered(imtInfoDialog);
        }
        return imtInfoDialog.isBPasswordChanged();
    }

    public IOperation getOperationIntf() {
        return null;
    }

    public boolean mustChangePassword() {
        if (SessionManager.getInstance().getCurUser() != null) {
            ChangePasswordRunnable runnable = new ChangePasswordRunnable();
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    return this.modifyPassword();
                }
                SwingUtilities.invokeAndWait(runnable);
                return runnable.result;
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return true;
    }

    private boolean modifyPassword() {
        String str = ResCenter.RES.getString("LoginForFirstTimeHint");
        if (0 != OptionPaneProxy4SmBase.showWarnDlgFocOnCancel(FrameworkUtilities.getMainFrame(), str)) {
            return false;
        }
        ChangePasswordDlg imtInfoDialog = new ChangePasswordDlg(true, 10002, SessionManager.getInstance().getCurUser(), GuiUtilForBase.getInstance(), ResCenter.getInstance(), SessionManager.getInstance(), this.getOperationIntf(), this.getProductILgoinInterface());
        if (imtInfoDialog.getInitResult()) {
            GuiUtilForBase.displayCentered(imtInfoDialog);
            imtInfoDialog.validate();
        }
        return imtInfoDialog.isBPasswordChanged();
    }

    private boolean expiredChangePassword() {
        if (SwingUtilities.isEventDispatchThread()) {
            OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("passwordexpiried"));
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("passwordexpiried"));
                    }
                });
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        if (GuiUtilForBase.isSecurityServiceException()) {
            return false;
        }
        ChangePasswordDlg imtInfoDialog = new ChangePasswordDlg(true, 10002, SessionManager.getInstance().getCurUser(), GuiUtilForBase.getInstance(), ResCenter.getInstance(), SessionManager.getInstance(), this.getOperationIntf(), this.getProductILgoinInterface());
        if (imtInfoDialog.getInitResult()) {
            GuiUtilForBase.displayCentered(imtInfoDialog);
        }
        return imtInfoDialog.isBPasswordChanged();
    }

    public void setModifyImtInfo(byte[] imtInfo) {
        this.modifyImtInfo = Arrays.copyOf(imtInfo, imtInfo.length);
    }

    public boolean isLogout() {
        return this.isLogout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] login(String userName, byte[] imfInfo, String terminal, int clientType, boolean isStLogin) throws Exception {
        try {
            boolean isShow;
            String tokenStr;
            String[] items;
            Map<String, Object> loginResult;
            block26: {
                this.modifyImtInfo = null;
                this.isLogout = false;
                this.getLicenseManager();
                UpdateLicenseManager.getInstance().setCurUserName(userName);
                this.login_userName = userName;
                this.curTerminalID = terminal;
                log.info((Object)("username = " + userName + " terminal = " + terminal + ",clientType=" + clientType));
                loginResult = null;
                try {
                    loginResult = isStLogin ? this.getLoginByStResult(userName, imfInfo, terminal, clientType) : this.getLoginResult(userName, imfInfo, terminal, clientType);
                    this.isRemoteLoginSuccess = ((SessionInfo)loginResult.get("SessionInfo")).getUserAuthType() == REMOTE_AUTHHENTICATION;
                    HeartBeatManager.getInstance().start();
                    this.clearLoginFailCounter();
                    this.curUserInfo = (UserInfo)loginResult.get("UserInfo");
                    this.pwdStatusInfo = new int[2];
                    this.pwdStatusInfo[0] = (Integer)loginResult.get("PasswordExpiryDays");
                    this.pwdStatusInfo[1] = (Integer)loginResult.get("pwdStatus");
                    if (this.checkPWDStatus()) break block26;
                    this.isLogout = true;
                    try {
                        HeartBeatManager.getInstance().stop();
                        LoginUIBaseModule.getLoginUIBaseModuleRef().getDelayMgr().clear();
                        SessionManager.getInstance().logout();
                    }
                    catch (Exception er) {
                        log.error((Object)"", (Throwable)er);
                    }
                    byte[] er = null;
                    return er;
                }
                catch (AppError e) {
                    log.error((Object)"", (Throwable)e);
                    this.soundAlarmWithLoginFailed();
                    if (!e.is("SM_LOGIN_FAILURE")) break block26;
                    int type = Integer.parseInt(e.getDetail("type"));
                    if (type == 10) {
                        e.setInternalErrorCode(201392178 + type);
                        e.setInternalErrorDesc("Login failed due to invalid license. errorID=" + type + ".");
                        InternalErrorUtil.printInternalError((String)"Security", (AppError)e);
                        UpdateLicenseManager.getInstance().updateLicenseWithNoDialog(false);
                    } else if (type == 9) {
                        e.setInternalErrorCode(201392178 + type);
                        e.setInternalErrorDesc("Login failed due to max session limitation in license. errorID=" + type + ".");
                        InternalErrorUtil.printInternalError((String)"Security", (AppError)e);
                    }
                    throw e;
                }
            }
            this.securityToken = (byte[])loginResult.get("token");
            int loginCase = Integer.valueOf(loginResult.get("loginCase").toString());
            if (loginCase != 0) {
                if (loginCase == 1) {
                    boolean isSuccess = this.handleLicCheckNUpdateErr(true);
                    if (isSuccess) {
                        byte[] byArray = this.login(userName, this.modifyImtInfo == null ? imfInfo : this.modifyImtInfo, terminal, clientType, false);
                        return byArray;
                    }
                    AppError appError = new AppError("SM_LOGIN_FAILURE");
                    appError.addDetail("type", String.valueOf(10));
                    appError.addDetail("errorCode", String.valueOf(7));
                    appError.addDetail("authMode", String.valueOf(LoginUIConstants.LoginAuthMode.LOCAL_AUTH.ordinal()));
                    throw appError;
                }
                if (loginCase == 2) {
                    LoginUserInfoDlg dlg = this.getLoginUserInfoDlg();
                    log.error((Object)"LoginUserInfoDlg has no data.so can't kick out other session.");
                    AppError appError = new AppError("SM_LOGIN_FAILURE");
                    if (dlg.hasModelData()) {
                        dlg.setVisible(true);
                        if (dlg.isSessionTimeout()) {
                            log.info((Object)"LoginUserInfoDlg has no data.so can't kick out other session.");
                            AppError appError1 = new AppError("SM_TOKEN_EXPIRED");
                            appError1.addDetail("errorCode", String.valueOf(91));
                            throw appError1;
                        }
                        if (dlg.getIsConfirm() == 0) {
                            byte[] appError1 = this.login(userName, this.modifyImtInfo == null ? imfInfo : this.modifyImtInfo, terminal, clientType, false);
                            return appError1;
                        }
                        if (dlg.getIsConfirm() == 1) {
                            appError.addDetail("isadminkickoutfail", "true");
                        } else if (dlg.getIsConfirm() == 2) {
                            appError.addDetail("showErrorMsg", "false");
                        }
                    }
                    this.throwMaxSessionAppError(appError);
                }
            }
            if ((items = GlobalUtil.dealSplitToGlobal((String)(tokenStr = new String(this.securityToken)), (String)";")).length != 7) {
                log.error((Object)"token parse error.");
            } else {
                this.commTerminalIP = items[2];
                log.info((Object)("login successful:" + items[4]));
            }
            CommHandle.setCurrentSession((byte[])this.securityToken);
            RpcInvoker.getInstance().setCurrentSession(this.securityToken);
            this.curSession = (SessionInfo)loginResult.get("SessionInfo");
            this.currentSysModel = (Integer)loginResult.get("SystemMode");
            this.isRestrict = (Boolean)loginResult.get("isRestrict");
            this.backendCurrentData = (Long)loginResult.get("backendCurrentData");
            this.authMode = (Integer)loginResult.get("authMode");
            Object obj = loginResult.get("isShowLoginUserName");
            if (obj != null && !(isShow = ((Boolean)obj).booleanValue())) {
                LoginUIConfig.getInstance().setIsShowLoginUserName(isShow);
            }
            this.loginSuccful = true;
            UpdateLicenseManager.getInstance().setSystemRestrictMode(this.isRestrict);
            HedexHelpImpl.getInstance().addHedexHelpListeners();
            HedexHelpImpl.getInstance().setUserName(userName);
            byte[] byArray = this.securityToken;
            return byArray;
        }
        finally {
            SecurityRedLineUtil.clearArray((byte[])this.modifyImtInfo);
            SecurityRedLineUtil.clearArray((byte[])imfInfo);
        }
    }

    protected void throwMaxSessionAppError(AppError appError) throws AppError {
        appError.addDetail("type", String.valueOf(9));
        appError.addDetail("errorCode", String.valueOf(7));
        appError.addDetail("authMode", String.valueOf(LoginUIConstants.LoginAuthMode.LOCAL_AUTH.ordinal()));
        throw appError;
    }

    public void setHasRightForLicense() {
        if (this.loginUserInfo != null) {
            UpdateLicenseManager.getInstance().setHasRight(this.loginUserInfo.isAdminGroup() || this.loginUserInfo.isSMGroup());
        }
    }

    public LoginUserInfo getLoginUserInfo() {
        if (null == this.loginUserInfo) {
            log.info((Object)"Invoking getLoginUserInfo to get userInfo");
            this.initalLoginUserInfo();
        }
        return this.loginUserInfo;
    }

    protected boolean handleLicCheckNUpdateErr(boolean isHaveRight) {
        String[] checkResult = null;
        try {
            checkResult = com.swimap.lm.client.RpcInvoker.getInstance().checkLicenseEx();
        }
        catch (Exception e1) {
            log.error((Object)"checkLicenseEx error...", (Throwable)e1);
        }
        int errorCode = 0;
        String errorMsg = LicenseUtil.getResCenter().getString("Licence_Update");
        if (null != checkResult && checkResult.length >= 1) {
            try {
                errorCode = Integer.parseInt(checkResult[0]);
            }
            catch (Exception e) {
                log.error((Object)"checkLicenseEx error...", (Throwable)e);
            }
            if (errorCode == 1) {
                return true;
            }
            if (errorCode == 0) {
                errorMsg = LicenseUtil.getResCenter().getString("Licence_Update");
            } else if (errorCode == 2) {
                errorMsg = GuiUtilForBase.bundleString(LicenseUtil.getResCenter().getString("Init_License_Check_Lib_ERROR"), checkResult.length >= 2 ? checkResult[1] : "");
            } else if (errorCode == 3) {
                errorMsg = GuiUtilForBase.bundleString(LicenseUtil.getResCenter().getString("Init_License_Load_Lib_ERROR"), checkResult.length >= 2 ? checkResult[1] : "");
            } else if (errorCode == 4) {
                errorMsg = LicenseUtil.getResCenter().getString("Init_License_DB_ERROR");
            }
        }
        if (0 == OptionPaneProxy4SmBase.showConfirmDlgFocOnNo(FrameworkUtilities.getMainFrame(), errorMsg)) {
            return UpdateLicenseManager.getInstance().updateLicenseWithNoDialog(isHaveRight);
        }
        return false;
    }

    public boolean isSystemRestricted() {
        try {
            if (this.loginSuccful) {
                return this.isRestrict;
            }
            return RpcInvoker.getInstance().isSystemRestricted();
        }
        catch (RpcErrorSecurity app) {
            GuiUtilForBase.handleInvalidTokenException(app.getMessage());
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public int getLoginAuthMode() {
        return this.authMode;
    }

    public void logout() throws Exception {
        AccChangeHandler.getInstance().DelAccChangeTimer();
        AccChangeHandler.clearInstance();
        this.getRpcInvoker().logout();
        HedexHelpImpl.getInstance().removeSelectionListener();
    }

    public LawInfo getLawInfo() throws Exception {
        LawInfo lawInfo = this.getRpcInvoker().getLawInfo();
        return lawInfo;
    }

    public CheckVersionInfo getServerVersion() throws Exception {
        CheckVersionInfo versions = this.getRpcInvoker().getServerVersion();
        return versions;
    }

    public byte[] getSecurityToken() {
        return this.securityToken;
    }

    public SessionInfo getCurrentSession() throws Exception {
        if (null == this.curSession) {
            this.curSession = this.getRpcInvoker().getCurrentSession();
        }
        return this.curSession;
    }

    public SessionInfo getCurrentSessionByLocal() {
        return this.curSession;
    }

    public int getCurSessionID() {
        try {
            return this.getCurrentSession().getSessionID();
        }
        catch (RpcErrorSecurity app) {
            GuiUtilForBase.handleInvalidTokenException(app.getMessage());
            return 0;
        }
        catch (Exception ex) {
            log.error((Object)"SessionManager | getCurSessionID | getSessionID with error.", (Throwable)ex);
            return 0;
        }
    }

    public void resetCurrentSysModel() {
        this.currentSysModel = -1;
    }

    public int getSystemMode() {
        if (this.currentSysModel == -1) {
            try {
                this.currentSysModel = this.getRpcInvoker().getSystemMode();
            }
            catch (RpcErrorSecurity e) {
                GuiUtilForBase.handleInvalidTokenException(e.getMessage());
            }
            catch (Exception e) {
                log.info((Object)"get system mode error.", (Throwable)e);
            }
        }
        return this.currentSysModel;
    }

    public LoginRecInfo[] getLoginHistory() throws Exception {
        if (null == this.recInfos) {
            this.recInfos = this.getRpcInvoker().getLoginHistory();
            this.shellSort(this.recInfos);
        }
        return this.recInfos;
    }

    public void shellSort(LoginRecInfo[] theArray) {
        int inner = 0;
        int outer = 0;
        int length = theArray.length;
        int h = 1;
        LoginRecInfo temp = null;
        while (h <= length / 3) {
            h = h * 3 + 1;
        }
        while (h > 0) {
            for (outer = h; outer < length; ++outer) {
                temp = theArray[outer];
                for (inner = outer; inner > h - 1 && theArray[inner - h].getStartTime() >= temp.getStartTime(); inner -= h) {
                    theArray[inner] = theArray[inner - h];
                }
                theArray[inner] = temp;
            }
            h = (h - 1) / 3;
        }
    }

    public CAUServerInfo getUpgradeInfo() throws Exception {
        return this.getRpcInvoker().getCAUServerInfo();
    }

    public String getCurUserName() {
        return this.loginUserInfo.getCurUser().name;
    }

    public boolean isAdminGroupUser(String userName) {
        try {
            return this.getRpcInvoker().isAdminGroupUser(userName);
        }
        catch (RpcErrorSecurity app) {
            GuiUtilForBase.handleInvalidTokenException(app.getMessage());
            return false;
        }
        catch (Exception ex) {
            log.error((Object)"SessionManager | isAdminGroupUser | get result with error.", (Throwable)ex);
            return false;
        }
    }

    public void initalLoginUserInfo() {
        try {
            if (this.curUserInfo != null) {
                this.loginUserInfo = this.getRpcInvoker().getLoginUserInfo(this.curUserInfo);
            }
        }
        catch (RpcErrorSecurity app) {
            GuiUtilForBase.handleInvalidTokenException(app.getMessage());
        }
        catch (SmAppError smapp) {
            log.error((Object)"SessionManager | initalLoginUserInfo | initalLoginUserInfo with error.", (Throwable)((Object)smapp));
            this.setLoginErrorDefaultValue(smapp);
        }
        catch (Exception ex) {
            log.error((Object)"SessionManager | getLoginUserInfo | get result with error.", (Throwable)ex);
        }
    }

    private void setLoginErrorDefaultValue(SmAppError smapp) {
        this.loginUserInfo = new LoginUserInfo();
        HashMap<String, StaticRight> emptyStaticRightMap = new HashMap<String, StaticRight>();
        ArrayList<Map<String, Right>> emptyUserAppRightMap = new ArrayList<Map<String, Right>>();
        if ("SM_DATABASE_FAILURE".equalsIgnoreCase(smapp.getName()) || "SM_DB_ERROR".equalsIgnoreCase(smapp.getName())) {
            log.error((Object)"SessionManager | setLoginErrorDefaultValue | Database error, all menu will be disabled.");
            this.loginUserInfo.setCurUser(this.curUserInfo);
            this.loginUserInfo.setAdmin(false);
            this.loginUserInfo.setAdminGroup(false);
            this.loginUserInfo.setSMGroup(false);
            this.loginUserInfo.setSSAUser(false);
            this.loginUserInfo.setIsUserNameSensitive(false);
            this.loginUserInfo.setUserAppRightMap(emptyUserAppRightMap);
            this.loginUserInfo.setHasAllAppOperationSet(false);
            this.loginUserInfo.setHasSmAppOperationSetRight(false);
            this.loginUserInfo.setStaticRightMap(emptyStaticRightMap);
        }
    }

    public boolean isAdminUserGroup() {
        return this.loginUserInfo.isAdminGroup();
    }

    public boolean isUserNameSensitive() {
        return this.loginUserInfo.isUserNameSensitive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlockTerminal(String unlockUserName, byte[] transferedImtInfo, GuiUtilForBase guiUtil) {
        block25: {
            try {
                boolean result = this.getRpcInvoker().unlockTerminal(unlockUserName, transferedImtInfo);
                this.clearLoginFailCounter();
                boolean bl = result;
                return bl;
            }
            catch (RpcErrorSecurity e) {
                String[] error = GlobalUtil.dealSplitToGlobal((String)e.getMessage(), (String)":");
                if (error != null && error.length == 2) {
                    if ("9:3".equals(e.getMessage())) {
                        this.handlerUnknownToken();
                    } else {
                        GuiUtilForBase.handleInvalidTokenException(e.getMessage());
                    }
                    break block25;
                }
                if (0 != OptionPaneProxy4SmBase.showWarnDlgFocOnCancel(FrameworkUtilities.getMainFrame(), this.resCenter.getString("FailureType_Unlock_Corba_Err"))) {
                    boolean bl = false;
                    return bl;
                }
                GuiUtilForBase.exit();
                boolean bl = false;
                return bl;
            }
            catch (RpcError rpcError) {
                if (0 != OptionPaneProxy4SmBase.showWarnDlgFocOnCancel(FrameworkUtilities.getMainFrame(), this.resCenter.getString("FailureType_Unlock_Corba_Err"))) {
                    boolean error = false;
                    return error;
                }
                GuiUtilForBase.exit();
                boolean error = false;
                return error;
            }
            catch (AppError ex) {
                this.soundAlarm(SecurityConfig.getInstance().getAllowUnlockFailedSetting(), "UNLOCK_FAILED_WARNING");
                String loginError = "";
                if (ex.is("SM_LOGIN_FAILURE")) {
                    String lockedInfo;
                    int errorID = Integer.parseInt(ex.getDetail("type"));
                    ex.setInternalErrorDesc("unlock failed. errorID= " + errorID + ".");
                    InternalErrorUtil.printInternalError((String)"Security", (AppError)ex);
                    loginError = errorID == 0 || errorID == 1 ? ((lockedInfo = this.getBeforLockedInfo(ex)) == null ? this.resCenter.getString("UnlockFailureType_UNKNOWN_USER") : lockedInfo) : this.getLoginError(this.resCenter, unlockUserName, ex);
                    LoginUIBaseModule.getLoginUIBaseModuleRef().getDelayMgr().dealWithLoginOrUnlockException();
                    if (loginError == null || "".equals(loginError.trim())) {
                        log.error((Object)("unlockTerminal still error!!!!" + errorID));
                        loginError = this.resCenter.getString("TSRESULT_FAILED_txt");
                    }
                    GuiUtilForBase.showHintMessageWithInvokeLater(loginError);
                    break block25;
                }
                log.error((Object)"Unlock error ", (Throwable)ex);
                if (0 != OptionPaneProxy4SmBase.showWarnDlgFocOnCancel(FrameworkUtilities.getMainFrame(), this.resCenter.getString("FailureType_Unlock_Corba_Err"))) {
                    boolean bl = false;
                    return bl;
                }
                GuiUtilForBase.exit();
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                log.error((Object)"Unlock error ", (Throwable)e);
                if ("socket not connected.".equals(e.getMessage())) {
                    log.info((Object)"socket not connected.");
                    this.handlerConnectionExcp();
                    boolean bl = false;
                    return bl;
                }
                if (!guiUtil.handleExceptionEx(e)) {
                    log.error((Object)"SessionManager | unlockTerminal with error.", (Throwable)e);
                    this.handlerConnectionExcp();
                }
            }
            finally {
                SecurityRedLineUtil.clearArray((byte[])transferedImtInfo);
            }
        }
        return false;
    }

    private void handlerConnectionExcp() {
        if (0 == OptionPaneProxy4SmBase.showWarnDlgFocOnCancel(FrameworkUtilities.getMainFrame(), this.resCenter.getString("FailureType_Unlock_Corba_Err"))) {
            GuiUtilForBase.exit();
        }
    }

    private void handlerUnknownToken() {
        ActivateSessionHandler handler = ActivateSessionHandler.getActivateSessionHandler();
        if (null != handler && handler.activateSessionOnce()) {
            GuiUtilForBase.showHintMessageWithInvokeLater(ResCenter.RES.getString("corbaerror"));
            return;
        }
        GuiUtilForBase.handleUnKnownToken(true);
    }

    private void soundAlarm(int times, String key) {
        try {
            ++this.loginFailCounter;
            if (this.loginFailCounter >= times) {
                LoginFailSoundManager.getInstance().play(key);
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    private void clearLoginFailCounter() {
        this.loginFailCounter = 0;
    }

    public String getLoginError(ResCenter resCenter, String userName, AppError fe) {
        String[] reasonSplit;
        String reason;
        int errorID = Integer.parseInt(fe.getDetail("type"));
        String[] errorMessage = new String[]{"FailureType_UNKNOWN_USER", "FailureType_INVALID_PASSWORD", "FailureType_INVALID_LOGINDURATION", "FailureType_INVALID_TERMINAL", "UnlockFailureType_UNKNOWN_USER", "FailureType_PASSWORD_EXPIRED", "FailureType_OVER_MAX_FAILLOGIN2", "FailureType_LOGIN_AGAIN", "FailureType_OVER_MAXSESSION", "FailureType_OVER_MAXLINK", "FailureType_INVALID_LICENSE", "FailureType_SINGLE_USER_MODE3", "FailureType_ILLEGAL_NORTHBOUND_LOGIN", "FailureType_ILLEGAL_INTERNAL_LOGIN", "FailureType_USER_LOCKED", "FailureType_REMOTE_TERMINAL_LOGIN_AGAIN", "errmiterrtxt0", "System_Init_State_Error", "Agent_Server_Login_Fail", "OVER_GROUP_MAX_SESSION_LIMITED", "ClientTypeNotExits", "FailureType_USER_BEEN_DELETED", "FailureType_OVER_MAX_CLIENTTYPE_LINK"};
        if (errorID == 3) {
            return resCenter.getString(errorMessage[errorID]);
        }
        if (errorID == 6 && (reason = fe.getDetail("reason")) != null && (reasonSplit = GlobalUtil.dealSplitToGlobal((String)reason, (String)":")) != null && reasonSplit.length == 2) {
            int minutes = Integer.parseInt(reasonSplit[1]);
            if (minutes > 1) {
                return resCenter.getMergeString(errorMessage[errorID], new String[]{Integer.toString(minutes)});
            }
            if (minutes == -1) {
                return resCenter.getString("FailureType_OVER_MAX_FAILLOGIN_FOREVER");
            }
            return resCenter.getMergeString("FailureType_OVER_MAX_FAILLOGIN1", new String[]{Integer.toString(minutes)});
        }
        if (errorID == 11) {
            boolean flag = "1".equals(fe.getDetail("flag"));
            if (flag) {
                String userIP = fe.getDetail("userIP");
                String uname = fe.getDetail("username");
                if ("".equals(userIP)) {
                    return resCenter.getMergeString(errorMessage[errorID], new String[]{uname});
                }
                return resCenter.getMergeString("FailureType_SINGLE_USER_MODE1", new String[]{uname, userIP});
            }
            return resCenter.getString("FailureType_SINGLE_USER_MODE2");
        }
        if (errorID < 0 || errorID > 22) {
            log.error((Object)("getLoginError====" + errorID));
            return resCenter.getString("TSRESULT_FAILED_txt");
        }
        return resCenter.getString(errorMessage[errorID]);
    }

    public String getCurIPAddress() {
        if (this.curIPAddress == null) {
            try {
                this.curIPAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception ex) {
                log.error((Object)"SessionManager | getCurIPAddress | getHostAddress with error.", (Throwable)ex);
            }
        }
        return this.curIPAddress;
    }

    public String getCurTerminalID() {
        return this.curTerminalID;
    }

    public UserInfo getCurUser() {
        if (this.curUserInfo == null) {
            try {
                this.curUserInfo = this.getRpcInvoker().getUserInfo(this.login_userName);
            }
            catch (RpcErrorSecurity app) {
                GuiUtilForBase.handleInvalidTokenException(app.getMessage());
            }
            catch (Exception ex) {
                log.error((Object)"SessionManager | getCurUser | getUserInfo with error.", (Throwable)ex);
            }
        }
        return this.curUserInfo;
    }

    public void setCurUser(UserInfo info) {
        this.curUserInfo = info;
    }

    public long getBackendCurrentData() {
        try {
            if (this.loginSuccful) {
                return this.backendCurrentData;
            }
            return this.getRpcInvoker().getBackendCurrentData();
        }
        catch (RpcErrorSecurity app) {
            GuiUtilForBase.handleInvalidTokenException(app.getMessage());
            return 0L;
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public int checkAccountValidity() {
        try {
            GregorianCalendar endLoginDurationDate = new GregorianCalendar();
            endLoginDurationDate.setTime(this.curUserInfo.endloginDurationDate.getTime());
            GregorianCalendar endLoginDurationTime = new GregorianCalendar();
            endLoginDurationTime.setTime(this.curUserInfo.endloginDurationTime.getTime());
            int year = endLoginDurationDate.get(1);
            int months = endLoginDurationDate.get(2);
            int date = endLoginDurationDate.get(5);
            int hourse = endLoginDurationTime.get(11);
            int minutes = endLoginDurationTime.get(12);
            int seconds = endLoginDurationTime.get(13);
            GregorianCalendar lastLoginTime = new GregorianCalendar();
            lastLoginTime.set(year, months, date, hourse, minutes, seconds);
            long lastLoginDateTime = lastLoginTime.getTime().getTime();
            long currentTime = this.getBackendCurrentData();
            long betweenTime = lastLoginDateTime - currentTime;
            int miniSecondOfDate = 86400000;
            int age = -1;
            if (betweenTime >= 0L) {
                age = (int)(betweenTime / (long)miniSecondOfDate);
                if (betweenTime % (long)miniSecondOfDate > 0L) {
                    ++age;
                }
            }
            if (age < 0) {
                return 10002;
            }
            if (age < 10) {
                return age;
            }
            return 10000;
        }
        catch (Exception e) {
            log.error((Object)"SessionManager | checkAccountValidity with error.", (Throwable)e);
            return 10000;
        }
    }

    public int getPasswordStatus() throws Exception {
        try {
            if (this.pwdStatusInfo.length == 0) {
                this.pwdStatusInfo = this.getRpcInvoker().isPWDMustChanged(this.login_userName);
                return this.pwdStatusInfo[1];
            }
            return this.pwdStatusInfo[1];
        }
        catch (RpcErrorSecurity app) {
            GuiUtilForBase.handleInvalidTokenException(app.getMessage());
            return -1;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public int getPasswordExpiryDays() {
        return this.pwdStatusInfo[0];
    }

    public boolean changePassword(String userName, byte[] oldImtInfo, byte[] newImtInfo) throws Exception {
        this.getRpcInvoker().modifyPassword(userName, this.curTerminalID, oldImtInfo, newImtInfo);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentUserPassword(byte[] imtInfo) {
        try {
            this.getRpcInvoker().resetPassword(this.login_userName, imtInfo);
        }
        catch (RpcErrorSecurity app) {
            GuiUtilForBase.handleInvalidTokenException(app.getMessage());
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
        }
        finally {
            SecurityRedLineUtil.clearArray((byte[])imtInfo);
        }
    }

    public boolean isAdminUser(String userName) {
        boolean isAminUser = false;
        try {
            isAminUser = this.loginUserInfo != null && userName.equals(this.loginUserInfo.getCurUser().name) ? this.loginUserInfo.isAdmin() : this.getRpcInvoker().isAdminUser(userName);
        }
        catch (RpcErrorSecurity app) {
            GuiUtilForBase.handleInvalidTokenException(app.getMessage());
        }
        catch (Exception ex) {
            log.error((Object)"SessionManager | isAdminUser | get result with error.", (Throwable)ex);
        }
        return isAminUser;
    }

    public boolean[] isAdminUsers(String[] userNameArray) {
        if (null == userNameArray || userNameArray.length == 0) {
            log.error((Object)("userName is null" + userNameArray));
            return new boolean[0];
        }
        boolean[] isAdminUsers = new boolean[userNameArray.length];
        try {
            isAdminUsers = this.getRpcInvoker().isAdminUsers(userNameArray);
        }
        catch (RpcErrorSecurity app) {
            GuiUtilForBase.handleInvalidTokenException(app.getMessage());
        }
        catch (Exception ex) {
            log.error((Object)"get result with error.", (Throwable)ex);
        }
        return isAdminUsers;
    }

    public boolean isSecurityMgrGroupUser() {
        return this.loginUserInfo.isSMGroup();
    }

    public boolean hasSmAppOperationSetRight() {
        return this.loginUserInfo.hasSmAppOperationSetRight();
    }

    public boolean hasSmAppOperationSetRightAndCurUser(BaseInfo info) {
        if (info instanceof UserInfo) {
            return this.hasSmAppOperationSetRight() && ((UserInfo)info).id == this.getCurUser().id;
        }
        return false;
    }

    public boolean isSecurityMgrGroupUserWithoutTry() throws Exception {
        return this.getRpcInvoker().isSecurityMgrGroupUser(this.curUserInfo.id);
    }

    public boolean isSecurityMgrGroup(String userGroupName) {
        boolean isSecurityMgrGroup = false;
        try {
            isSecurityMgrGroup = this.getRpcInvoker().isSecurityMgrGroup(userGroupName);
        }
        catch (RpcErrorSecurity app) {
            GuiUtilForBase.handleInvalidTokenException(app.getMessage());
        }
        catch (Exception ex) {
            log.error((Object)"SessionManager | isSecurityMgrGroup | get result with error.", (Throwable)ex);
        }
        return isSecurityMgrGroup;
    }

    public boolean isSecurityMgrGroup(int userid) {
        boolean isSecurityMgrGroup = false;
        try {
            isSecurityMgrGroup = this.loginUserInfo != null && this.loginUserInfo.getCurUser().getId() == userid ? this.loginUserInfo.isSMGroup() : this.getRpcInvoker().isSecurityMgrGroupUser(userid);
        }
        catch (RpcErrorSecurity app) {
            GuiUtilForBase.handleInvalidTokenException(app.getMessage());
        }
        catch (Exception ex) {
            log.error((Object)"SessionManager | isSecurityMgrGroup | get result with error.", (Throwable)ex);
        }
        return isSecurityMgrGroup;
    }

    public List<Map<String, Right>> getAllAppRightByUserID(int userID) {
        try {
            if (this.loginUserInfo != null && this.loginUserInfo.getCurUser().getId() == userID) {
                return this.loginUserInfo.getUserAppRightMap();
            }
            return this.getRpcInvoker().getAllAppRightByUserID(userID);
        }
        catch (RpcErrorSecurity app) {
            GuiUtilForBase.handleInvalidTokenException(app.getMessage());
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean hasAllAppOperationSetByUserID(int userID) {
        try {
            if (this.loginUserInfo != null && this.loginUserInfo.getCurUser().getId() == userID) {
                return this.loginUserInfo.isHasAllAppOperationSet();
            }
            return this.getRpcInvoker().hasAllAppOperationSetByUserID(userID);
        }
        catch (RpcErrorSecurity app) {
            GuiUtilForBase.handleInvalidTokenException(app.getMessage());
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public Map<String, StaticRight> getStaticRight() {
        try {
            if (this.loginUserInfo != null) {
                return this.loginUserInfo.getStaticRightMap();
            }
            return this.getRpcInvoker().getStaticRight();
        }
        catch (RpcErrorSecurity app) {
            GuiUtilForBase.handleInvalidTokenException(app.getMessage());
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean isAdminUser() {
        return this.curUserInfo.userType == 1;
    }

    public String getAdminUserName() {
        if (null == this.adminUserName) {
            this.adminUserName = this.getRpcInvoker().getAdminUserName();
        }
        return this.adminUserName;
    }

    public String getAdminGroupName() {
        if (null == this.adminGroupName) {
            this.adminGroupName = this.getRpcInvoker().getAdminGroupName();
        }
        return this.adminGroupName;
    }

    public void setRpcInvoker(RpcInvoker invoker) {
        this.rpcInvoker = invoker;
    }

    private RpcInvoker getRpcInvoker() {
        return this.rpcInvoker == null ? DEFAULT_RPC_INVOKER : this.rpcInvoker;
    }

    public boolean isAdminGroup(String usergroupname) {
        return this.getRpcInvoker().isAdminGroup(usergroupname);
    }

    public void setCurServerMode(boolean _curMode) {
        this.enableSSL = _curMode;
    }

    public boolean getCurServerMode() {
        return this.enableSSL;
    }

    public void setServerIP(String ip) {
        this.serverIP = ip;
    }

    public void setServerPort(String port) {
        this.serverPort = port;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        return this.serverName;
    }

    private String getBeforLockedInfo(AppError ex) {
        int times;
        String[] reasonSplit;
        String reason = ex.getDetail("reason");
        String loginError = null;
        if (reason != null && (reasonSplit = GlobalUtil.dealSplitToGlobal((String)reason, (String)":")) != null && reasonSplit.length == 2 && (times = Integer.parseInt(reasonSplit[0])) == 1) {
            int minutes = Integer.parseInt(reasonSplit[1]);
            loginError = minutes > 1 ? this.resCenter.getMergeString("BeforeAccountLocking2", new String[]{Integer.toString(minutes)}) : (minutes == -1 ? this.resCenter.getString("BeforeAccountLocking_FOREVER") : this.resCenter.getMergeString("BeforeAccountLocking1", new String[]{Integer.toString(minutes)}));
        }
        return loginError;
    }

    public AuthConfInfo getServerAuthConf() {
        try {
            this.serverAuthInfo = this.getRpcInvoker().getServerAuthConf();
        }
        catch (Exception e) {
            this.serverAuthInfo = new AuthConfInfo();
            log.error((Object)"", (Throwable)e);
        }
        return this.serverAuthInfo;
    }

    public int getLoginMode() {
        return this.serverAuthInfo.getLoginMode();
    }

    public boolean canSycnRemoteUserGroup() {
        return this.serverAuthInfo.getSycnRemoteUserGroup();
    }

    public boolean enableUserManager() {
        return this.serverAuthInfo.enableUserManager();
    }

    public boolean isLocalLoginMode() {
        return this.serverAuthInfo.isLocalLoginMode();
    }

    public void setCurUserName(String userName) {
        this.login_userName = userName;
    }

    public String ssoLogin(String userName, byte[] imtInfo, String terminal) throws Exception {
        this.login_userName = userName;
        this.curTerminalID = terminal;
        try {
            HashMap<String, Object> loginResult = this.getRpcInvoker().ssoLogin(userName, imtInfo, terminal);
            String key = (String)loginResult.get("key");
            if (((Boolean)loginResult.get("isOverMaxSession")).booleanValue()) {
                GuiUtilForBase.showErrorInfo(ResCenter.getInstance().getString("FailureType_OVER_MAXSESSION"));
            }
            String string = key;
            return string;
        }
        catch (AppError e) {
            throw e;
        }
        finally {
            SecurityRedLineUtil.clearArray((byte[])imtInfo);
        }
    }

    public boolean isLoginUserHigherThan(UserInfo userInfo) {
        if (this.curUserInfo.getId() == userInfo.getId()) {
            return true;
        }
        if (this.curUserInfo.getUserType() == 1) {
            return true;
        }
        boolean issecurityMgrGroup = this.isSecurityMgrGroup(userInfo.id);
        if (this.isSecurityMgrGroupUser() && !issecurityMgrGroup) {
            return true;
        }
        return this.isSSAUser() && !issecurityMgrGroup && !SessionService.getInstance().isSSAUser(userInfo.id);
    }

    public boolean isSSAUser() {
        return this.loginUserInfo.isSSAUser();
    }

    public boolean isSSAUser(int userID) {
        return SessionService.getInstance().isSSAUser(userID);
    }

    public boolean isIPassMode() {
        return this.isIPassMode;
    }

    public void loadIPassMode() {
        this.isIPassMode = this.isIPassModel();
    }

    protected boolean isIPassModel() {
        return this.getRpcInvoker().isIPassModel();
    }

    protected void soundAlarmWithLoginFailed() {
        this.soundAlarm(SecurityConfig.getInstance().getAllowLoginFailedSetting(), "LOGIN_FAILED_WARNING");
    }

    protected Map<String, Object> getLoginResult(String userName, byte[] imtInfo, String terminal, int clientType) throws Exception {
        return this.getRpcInvoker().login(userName, imtInfo, terminal, clientType);
    }

    protected Map<String, Object> getLoginByStResult(String userName, byte[] stInfo, String terminal, int clientType) throws Exception {
        return this.getRpcInvoker().loginByST(userName, stInfo, terminal, clientType);
    }

    protected LoginUserInfoDlg getLoginUserInfoDlg() {
        return new LoginUserInfoDlg();
    }

    public boolean canChangePXX() {
        return this.getCurUser().pwdStatus != 2 && this.getCurUser().getUserType() != 3;
    }

    class ChangePasswordRunnable
    implements Runnable {
        boolean result;

        ChangePasswordRunnable() {
        }

        @Override
        public void run() {
            this.result = SessionManager.this.modifyPassword();
        }
    }

    private class UserBeKickedOutEventHandler
    implements IEventHandler {
        private static final String SM_LOGOUT_KICK_OUT_BY_OTHER_USER = "SM_LOGOUT_KICK_OUT_BY_OTHER_USER";
        private static final String SM_LOGOUT_NOT_IN_DURATION = "SM_LOGOUT_NOT_IN_DURATION";

        private UserBeKickedOutEventHandler() {
        }

        @Override
        public boolean handle(RpcEvent event) {
            RpcMessage message = event.getMessage();
            if (SM_LOGOUT_KICK_OUT_BY_OTHER_USER.equals(message.getString("Description")) || SM_LOGOUT_NOT_IN_DURATION.equals(message.getString("Description"))) {
                try {
                    log.info((Object)"SecurityEventProcessor | sessionInfoKickOut | Kick out by others. ");
                    int sessionID = message.getInt("logoutSessionID");
                    if (sessionID == SessionService.getInstance().getCurSessionID()) {
                        log.info((Object)"SecurityEventProcessor | sessionInfoKickOut | My user account is set invalid.");
                        if (SM_LOGOUT_KICK_OUT_BY_OTHER_USER.equals(message.getString("Description"))) {
                            String exeUserName = message.getString("exeUserName");
                            SessionManager.this.guiUtil.handleKickoutConditionEx(exeUserName);
                        } else {
                            String errorDescription = ResCenter.getInstance().getMergeString("userForceQuit", new String[]{TimeDateFormatUtil.convertFromUTC((long)System.currentTimeMillis())});
                            GuiUtilForBase.handleKickout(errorDescription);
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)"SecurityEventProcessor | sessionInfoKickOut with error.", (Throwable)e);
                    return false;
                }
            }
            return true;
        }
    }

    private class SystemModeSwitchEventHandler
    implements IEventHandler {
        private SystemModeSwitchEventHandler() {
        }

        @Override
        public boolean handle(RpcEvent event) {
            RpcMessage message = event.getMessage();
            try {
                int sessionID = message.getInt("SessionID");
                int curClientSessionID = SessionManager.this.getCurSessionID();
                String description = message.getString("Description");
                log.info((Object)("SecurityEventProcessor | sessionInfoModeSwitch | security event desc = " + description));
                if (sessionID != curClientSessionID) {
                    if (description.equals(EventConstants.Maintenance_Mode)) {
                        int waitSeconds = message.getInt("Additional");
                        log.info((Object)("SecurityEventProcessor | sessionInfoModeSwitch | changing single mode. Countdown = " + waitSeconds));
                        SessionManager.this.guiUtil.handleModeSwitchEx(waitSeconds);
                    } else if (description.equals(EventConstants.Cancel_Mode)) {
                        SessionManager.this.guiUtil.cancelModeSwitchEx();
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"SecurityEventProcessor | sessionInfoModeSwitch with error. ", (Throwable)e);
                return false;
            }
            return true;
        }
    }
}

