/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.auth;

import com.swimap.external.dsf.base.rpc.RpcErrorSecurity;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.extendedtable.ExtendedTable;
import com.swimap.iview.templates.extendedtable.HeaderListener;
import com.swimap.iview.templates.extendedtable.SortButtonRenderer;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.auth.SessionManager;
import com.swimap.sm.client.base.common.RpcInvoker;
import com.swimap.sm.client.base.common.model.SessionInfo;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class LoginUserInfoDlg
extends JDialog {
    private String[] heads = new String[]{ResCenter.RES.getString("SessionID"), ResCenter.RES.getString("UserName"), ResCenter.RES.getString("LOGIN_ADDRESS"), ResCenter.RES.getString("LoginTime")};
    private static IviewLogger log = SMTraceProxy.getLogger(LoginUserInfoDlg.class);
    private static int LOGIN_SESSIONID_COLUMN = 0;
    private static int LOGIN_USER_NAME_COLUMN = 1;
    private static int LOGIN_ADDRESS_COLUMN = 2;
    private static int LOGIN_LOGIN_TIME_COLUMN = 3;
    private static int[] headsWidth = new int[]{120, 160, 210, 120};
    private JScrollPane loginUserInfoScrollPane = null;
    private ExtendedTable loginUserInfoTable = null;
    private SortableTableModel tableModel = null;
    private JTextPane messagePane = new JTextPane();
    private JButton refreshButton = new JButton();
    private JButton continueLoginButton = new JButton();
    private JButton cancelButton = new JButton();
    private ActionListener m_btnActionListener = null;
    private ListSelectionListener m_loginUserInfoTableActionListener = null;
    private LinkedList sessionUserIDList = null;
    private int confirmOption = 1;
    public static final int SUCCESS = 0;
    public static final int FAILURE = 1;
    public static final int CANCEL = 2;
    private boolean isSessionTimeout = false;

    public LoginUserInfoDlg() {
        super(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("LoginUserInfoDlg_title"), true);
        try {
            Vector<SessionInfo> loginUserInfo = RpcInvoker.getInstance().getAllLoginSessions();
            this.initialize();
            this.processRefreshButtonEvent(loginUserInfo);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public LinkedList getSelectUser() {
        return this.sessionUserIDList;
    }

    public int getIsConfirm() {
        return this.confirmOption;
    }

    public boolean isSessionTimeout() {
        return this.isSessionTimeout;
    }

    private void initialize() {
        this.setResizable(false);
        this.setSize(500, 400);
        this.getContentPane().setLayout(new BorderLayout());
        this.setDefaultCloseOperation(0);
        this.tableModel = new SortableTableModel((Object[])this.heads, 0);
        this.loginUserInfoTable = new ExtendedTable(this.tableModel);
        this.setInitColumnWidth((JTable)this.loginUserInfoTable, headsWidth);
        TableColumnModel columnModel = this.loginUserInfoTable.getColumnModel();
        if (null != columnModel) {
            SortButtonRenderer headRenderer = new SortButtonRenderer();
            this.loginUserInfoTable.getTableHeader().setReorderingAllowed(false);
            JTableHeader tableHeader = this.loginUserInfoTable.getTableHeader();
            tableHeader.addMouseListener((MouseListener)new HeaderListener(tableHeader, headRenderer, 1));
            int count = columnModel.getColumnCount();
            for (int index = 0; index < count; ++index) {
                this.loginUserInfoTable.setColumnSortable(index, true);
                TableColumn column = columnModel.getColumn(index);
                if (null == column) continue;
                column.setHeaderRenderer((TableCellRenderer)headRenderer);
            }
        }
        this.loginUserInfoScrollPane = new JScrollPane((Component)this.loginUserInfoTable);
        this.loginUserInfoTable.hideColumn(LOGIN_SESSIONID_COLUMN);
        this.loginUserInfoTable.setSelectionMode(0);
        this.refreshButton.setPreferredSize(new Dimension(80, 21));
        this.refreshButton.setText(ResCenter.RES.getString("Constant_REFRESH"));
        this.refreshButton.setMnemonic('R');
        this.continueLoginButton.setPreferredSize(new Dimension(80, 21));
        this.continueLoginButton.setMargin(new Insets(2, 2, 2, 2));
        this.continueLoginButton.setText(ResCenter.RES.getString("LoginUserInfoDlg_Continue"));
        this.continueLoginButton.setMnemonic('C');
        this.cancelButton.setPreferredSize(new Dimension(80, 21));
        this.cancelButton.setText(ResCenter.RES.getString("Constant_Cancel"));
        this.messagePane.setBackground(UIManager.getColor("Label.background"));
        this.messagePane.setFont((Font)UIManager.get("OptionPane.font"));
        this.messagePane.setEnabled(false);
        this.messagePane.setText(ResCenter.RES.getString("LoginUserInfoDlg_Message"));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        buttonPanel.add(this.refreshButton);
        buttonPanel.add(this.continueLoginButton);
        buttonPanel.add(this.cancelButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.messagePane, "North");
        this.getContentPane().add((Component)this.loginUserInfoScrollPane, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.initListener();
        ScreenToolKit.setDefaultButtons(null, (AbstractButton)this.cancelButton);
        ScreenToolKit.centerLocateToScreen((Component)this);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        switch (e.getID()) {
            case 200: {
                this.cancelButton.requestFocus();
                break;
            }
            case 201: {
                this.processCancelButtonEvent();
                this.confirmOption = 2;
                break;
            }
        }
    }

    private void initListener() {
        this.m_btnActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Object eventSource = event.getSource();
                if (LoginUserInfoDlg.this.refreshButton == eventSource) {
                    LoginUserInfoDlg.this.processRefreshButtonEvent(LoginUserInfoDlg.this.getLoginUserInfoF());
                } else if (LoginUserInfoDlg.this.continueLoginButton == eventSource) {
                    LoginUserInfoDlg.this.processContinueLoginButtonEvent();
                } else if (LoginUserInfoDlg.this.cancelButton == eventSource) {
                    LoginUserInfoDlg.this.processCancelButtonEvent();
                }
            }
        };
        this.refreshButton.addActionListener(this.m_btnActionListener);
        this.continueLoginButton.addActionListener(this.m_btnActionListener);
        this.cancelButton.addActionListener(this.m_btnActionListener);
        this.m_loginUserInfoTableActionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LoginUserInfoDlg.this.setButtonState();
            }
        };
        this.loginUserInfoTable.getSelectionModel().addListSelectionListener(this.m_loginUserInfoTableActionListener);
    }

    private void processRefreshButtonEvent(Vector<SessionInfo> loginUserInfo) {
        if (loginUserInfo != null) {
            Object[] rowData = new Object[6];
            SessionInfo loginuserinfo = null;
            this.tableModel.setRowCount(0);
            int size = loginUserInfo.size();
            String[] userNames = new String[size];
            for (int i = 0; i < size; ++i) {
                userNames[i] = loginUserInfo.elementAt(i).getUserName();
            }
            boolean[] isAdminUsers = SessionManager.getInstance().isAdminUsers(userNames);
            for (int i = 0; i < size; ++i) {
                if (isAdminUsers[i]) continue;
                loginuserinfo = loginUserInfo.elementAt(i);
                rowData[LoginUserInfoDlg.LOGIN_SESSIONID_COLUMN] = loginuserinfo.getSessionID();
                rowData[LoginUserInfoDlg.LOGIN_USER_NAME_COLUMN] = loginuserinfo.getUserName();
                rowData[LoginUserInfoDlg.LOGIN_ADDRESS_COLUMN] = loginuserinfo.getTerminalID();
                rowData[LoginUserInfoDlg.LOGIN_LOGIN_TIME_COLUMN] = new SortDateString(loginuserinfo.getStartDateTime() * 1000L);
                this.tableModel.addRow(rowData);
            }
        }
        if (this.loginUserInfoTable.getRowCount() > 0) {
            this.loginUserInfoTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.setButtonState();
    }

    public boolean hasModelData() {
        boolean result = true;
        if (this.tableModel == null || this.tableModel.getRowCount() == 0) {
            result = false;
        }
        return result;
    }

    public Vector<SessionInfo> getLoginUserInfoF() {
        try {
            return RpcInvoker.getInstance().getAllLoginSessions();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            return new Vector<SessionInfo>();
        }
    }

    private void processContinueLoginButtonEvent() {
        block4: {
            int[] selectRow = this.loginUserInfoTable.getSelectedRows();
            if (selectRow != null && selectRow.length > 0 && this.loginUserInfoTable.getRowCount() > 0) {
                try {
                    for (int index = 0; index < selectRow.length; ++index) {
                        int sessionID = (Integer)this.loginUserInfoTable.getModel().getValueAt(selectRow[index], LOGIN_SESSIONID_COLUMN);
                        int result = RpcInvoker.getInstance().logoutOtherBySessionid(sessionID);
                        this.confirmOption = result == 0 ? 0 : 1;
                    }
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                    if (!(e instanceof RpcErrorSecurity) || !"9:3".equals(e.getMessage())) break block4;
                    this.isSessionTimeout = true;
                }
            }
        }
        this.dispose();
    }

    private void setButtonState() {
        if (this.loginUserInfoTable.getSelectedRowCount() > 0 && this.loginUserInfoTable.getRowCount() > 0) {
            this.continueLoginButton.setEnabled(true);
        } else {
            this.continueLoginButton.setEnabled(false);
        }
    }

    private void processCancelButtonEvent() {
        this.sessionUserIDList = null;
        this.confirmOption = 2;
        this.dispose();
    }

    @Override
    public void dispose() {
        this.refreshButton.removeActionListener(this.m_btnActionListener);
        this.continueLoginButton.removeActionListener(this.m_btnActionListener);
        this.cancelButton.removeActionListener(this.m_btnActionListener);
        this.loginUserInfoTable.getSelectionModel().removeListSelectionListener(this.m_loginUserInfoTableActionListener);
        this.loginUserInfoTable.removeAll();
        super.dispose();
    }

    public void setInitColumnWidth(JTable objectTable, int[] tableColumnWidth) {
        if (null == objectTable || null == tableColumnWidth) {
            return;
        }
        objectTable.setAutoResizeMode(0);
        int colunmIndex = 0;
        for (colunmIndex = 0; colunmIndex < tableColumnWidth.length; ++colunmIndex) {
            TableColumn column = objectTable.getColumnModel().getColumn(colunmIndex);
            column.setPreferredWidth(tableColumnWidth[colunmIndex]);
        }
    }

    private class SortDateString
    implements Comparable<Object> {
        private String dateToShow;
        private Long dateToCompare;

        public SortDateString(Long date) {
            this.dateToCompare = date;
            this.dateToShow = TimeDateFormatUtil.convertFromUTC((long)this.dateToCompare);
        }

        @Override
        public int compareTo(Object o) {
            return this.compareTo((SortDateString)o);
        }

        @Override
        private int compareTo(SortDateString obj) {
            if (null == obj) {
                return 1;
            }
            if (null == this.dateToCompare) {
                return -1;
            }
            if (this.dateToCompare - obj.dateToCompare > 0L) {
                return 1;
            }
            return -1;
        }

        public String toString() {
            return this.dateToShow;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dateToShow == null ? 0 : this.dateToShow.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SortDateString other = (SortDateString)obj;
            return !(this.dateToShow == null ? other.dateToShow != null : !this.dateToShow.equals(other.dateToShow));
        }
    }
}

