/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.auth;

import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.extendedtable.ExtendedTable;
import com.swimap.iview.templates.extendedtable.SortableTableModel;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.auth.SessionManager;
import com.swimap.sm.client.base.common.BaseConstants;
import com.swimap.sm.client.base.common.model.LoginRecInfo;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class HistoryLoginInfoDlg
extends JDialog {
    private static final long serialVersionUID = 4112196877721360881L;
    private IviewLogger log = SMTraceProxy.getLogger(HistoryLoginInfoDlg.class);
    private ExtendedTable table;
    private JButton okButton = new JButton();
    private static final int INIT_VALUE = 20;
    private static final int ONLINE = 0;
    private ResCenter resCenter;
    private SessionManager sessionMgr;

    public HistoryLoginInfoDlg(ResCenter _resCenter, SessionManager _sessionMgr) {
        super((Frame)FrameworkUtilities.getMainFrame(), false);
        this.resCenter = _resCenter;
        this.sessionMgr = _sessionMgr;
        this.setTitle(this.resCenter.getString("HistoryLoginHint"));
        this.jbInit();
    }

    private String[][] getTableData() {
        String lastLoginTime = "";
        String lastLogoutTime = "";
        String lastLoginIP = "";
        String lastUserName = "";
        String lastLoginDetail = "";
        int beginValue = 0;
        String[][] tableData = null;
        try {
            LoginRecInfo[] loginRecs = this.sessionMgr.getLoginHistory();
            int loginCount = loginRecs.length;
            ArrayList<LoginRecInfo> showLoginRecs = new ArrayList<LoginRecInfo>();
            showLoginRecs.add(loginRecs[0]);
            beginValue = loginCount > 20 ? loginRecs.length - 20 + 1 : ++beginValue;
            for (int i = beginValue; i < loginCount; ++i) {
                showLoginRecs.add(loginRecs[i]);
            }
            int len = showLoginRecs.size();
            tableData = new String[len][5];
            for (int i = 0; i < len; ++i) {
                LoginRecInfo loginRecInfo = (LoginRecInfo)showLoginRecs.get(i);
                long startTime = (long)loginRecInfo.getStartTime() * 1000L;
                long endTime = (long)loginRecInfo.getEndTime() * 1000L;
                lastUserName = loginRecInfo.getUserName();
                lastLoginIP = loginRecInfo.getTerminalIP();
                lastLoginTime = TimeDateFormatUtil.convertFromUTC((long)startTime);
                lastLogoutTime = TimeDateFormatUtil.convertFromUTC((long)endTime);
                lastLoginDetail = loginRecInfo.getStatus();
                if (!loginRecInfo.isResult()) {
                    lastLoginDetail = ResCenter.getInstance().getMergeString("HistoryLoginInfoTableResultData", new String[]{loginRecInfo.getResultDescription(), loginRecInfo.getStatus()});
                    lastLogoutTime = this.resCenter.getString("LogoutTimeDesNA");
                } else {
                    lastLoginDetail = loginRecInfo.getResultDescription() + ResCenter.getInstance().getString("HistoryLoginInfoTableResultData2");
                    if (0 == loginRecInfo.getEndTime()) {
                        lastLogoutTime = this.resCenter.getString("LogoutTimeDes_");
                    }
                }
                tableData[i][0] = lastUserName;
                tableData[i][1] = lastLoginIP;
                tableData[i][2] = lastLoginTime;
                tableData[i][3] = lastLogoutTime;
                tableData[i][4] = lastLoginDetail;
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"HistoryLoginInfoDlg | initLoginInfo with error.", (Throwable)ex);
        }
        return tableData;
    }

    private void initTableData() {
        Object[] columnNames = new String[]{this.resCenter.getString("HistoryLoginInfoTableColUserName"), this.resCenter.getString("HistoryLoginInfoTableColClient"), this.resCenter.getString("HistoryLoginInfoTableColLoginTime"), this.resCenter.getString("HistoryLoginInfoTableColLogoutTime"), this.resCenter.getString("HistoryLoginInfoTableColDetail")};
        Object[][] tableData = this.getTableData();
        if (null == tableData || tableData.length <= 0) {
            return;
        }
        SortableTableModel tableModel = new SortableTableModel(tableData, columnNames);
        this.table = new ExtendedTable(tableModel);
        this.table.setSortableClickCount(1);
        this.table.setColumnSortable(new int[]{0, 1, 2, 3, 4}, true);
        this.table.setName("JTable_table");
    }

    private void jbInit() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.getTablePanel(), new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setSize(new Dimension(630, 262));
        this.setDefaultCloseOperation(2);
        ScreenToolKit.setDefaultButtons((AbstractButton)this.okButton, (AbstractButton)this.okButton);
    }

    private JScrollPane getTablePanel() {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setName("JScrollPane_jScrollPane1");
        String enter = "ENTER";
        this.initTableData();
        this.table.getInputMap().put(KeyStroke.getKeyStroke(enter), enter);
        this.table.getActionMap().put(enter, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HistoryLoginInfoDlg.this.okActionPerformed(evt);
            }
        });
        jScrollPane.getViewport().add((Component)this.table, null);
        return jScrollPane;
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setName("JPanel_buttonPanel");
        this.okButton.setName("JButton_okButton");
        this.okButton.setText(this.resCenter.getString("OkButton"));
        this.okButton.setPreferredSize(BaseConstants.Component.ComponentSize.BUTTON_SIZE);
        buttonPanel.add(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryLoginInfoDlg.this.okActionPerformed(e);
            }
        });
        return buttonPanel;
    }

    private void okActionPerformed(ActionEvent e) {
        this.dispose();
    }
}

