/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.auth;

import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.common.RpcInvoker;
import com.swimap.sm.client.loginui.common.SMTraceProxy;

public class HeartBeatManager {
    private IviewLogger log = SMTraceProxy.getLogger(HeartBeatManager.class);
    private boolean isRunning = true;
    private int sleepTime = 60000;
    private HeartBeatThread heartBeatThread = null;
    private static HeartBeatManager instance = null;

    public static HeartBeatManager getInstance() {
        if (null == instance) {
            instance = new HeartBeatManager();
        }
        return instance;
    }

    private HeartBeatManager() {
    }

    public void setSendFrequency(int time) {
        this.sleepTime = time;
    }

    public void start() {
        this.isRunning = true;
        if (null == this.heartBeatThread) {
            this.heartBeatThread = new HeartBeatThread();
            this.log.info((Object)"HeartBeatManager | begin to invoke heartbeat...");
            this.heartBeatThread.start();
        }
    }

    public void stop() {
        this.isRunning = false;
    }

    class HeartBeatThread
    extends Thread {
        HeartBeatThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        HeartBeatThread.sleep(HeartBeatManager.this.sleepTime);
                        if (HeartBeatManager.this.isRunning) {
                            HeartBeatManager.this.log.info((Object)"HeartBeatManager | sendHeartBeat.");
                            RpcInvoker.getInstance().sendHeartBeat();
                            continue;
                        }
                        HeartBeatManager.this.log.info((Object)"HeartBeatManager | no send.");
                    }
                }
                catch (Exception ex) {
                    HeartBeatManager.this.log.error((Object)"HeartBeatManager | sendHeartBeat with error.", (Throwable)ex);
                    continue;
                }
                break;
            }
        }
    }
}

