/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.auth;

import com.swimap.external.dsf.base.framework.AppError;
import com.swimap.external.sm.client.base.common.model.UserInfo;
import com.swimap.external.sm.client.base.product.interfaces.IOperation;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.SyncCommand;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.auth.SessionManager;
import com.swimap.sm.client.base.common.BaseConstants;
import com.swimap.sm.client.base.common.CryptUtil;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.common.OptionPaneProxy4SmBase;
import com.swimap.sm.client.base.common.UserPasswordField;
import com.swimap.sm.client.base.policy.IDoSomethingWhenShowPwdPolicyErrorInfo;
import com.swimap.sm.client.base.policy.ShowPwdErrorInfo;
import com.swimap.sm.client.base.policy.service.PolicyService;
import com.swimap.sm.client.base.product.factory.SetLoginInfoToProduct;
import com.swimap.sm.client.base.product.interfaces.ILogin;
import com.swimap.sm.client.listener.SMActionListener;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import com.swimap.sm.client.loginui.common.SecurityRedLineUtil;
import com.swimap.sm.client.loginui.common.model.SMPasswordFieldEx;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ChangePasswordDlg
extends JDialog
implements IDoSomethingWhenShowPwdPolicyErrorInfo {
    private static final long serialVersionUID = 7492554470482186349L;
    private IviewLogger log = SMTraceProxy.getLogger(ChangePasswordDlg.class);
    private UserInfo userInfo;
    private JPanel imtInfoPanel = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private FlowLayout flowLayout1 = new FlowLayout();
    private JPanel buttonPanel = new JPanel();
    private JButton cancelButton = new JButton();
    private JButton okButton = new JButton();
    private JLabel nameLabel = new JLabel();
    private JTextField nameField = new JTextField();
    private JLabel oldPasswordLabel = new JLabel();
    private SMPasswordFieldEx oldImtInfoField;
    private SMPasswordFieldEx confirmImtInfoField;
    private JLabel confirmPasswordLabel = new JLabel();
    private JLabel newPasswordLabel = new JLabel();
    private SMPasswordFieldEx newImtInfoField;
    private boolean isImtInfoChanged = false;
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private boolean initFinished = false;
    private int status = -1;
    private GuiUtilForBase guiUtil;
    private ResCenter resCenter;
    private SessionManager sessionManager;
    private IOperation operation;
    private ILogin intf;

    public ChangePasswordDlg(boolean isLogin, int status, UserInfo _userInfo, GuiUtilForBase guiUtil, ResCenter resCenter, SessionManager sessionManager, IOperation operation, ILogin login) {
        super((Frame)FrameworkUtilities.getMainFrame(), true);
        this.status = status;
        this.userInfo = _userInfo;
        this.guiUtil = guiUtil;
        this.resCenter = resCenter;
        this.sessionManager = sessionManager;
        this.operation = operation;
        this.intf = login;
        try {
            this.jbInit(isLogin);
        }
        catch (Exception e) {
            if (!GuiUtilForBase.handleException(e)) {
                this.log.error((Object)"ChangePasswordDlg | init with error.", (Throwable)e);
            }
            this.initFinished = false;
        }
    }

    private void jbInit(boolean isLogin) {
        if (isLogin) {
            GuiUtilForBase.setChangePxxWhenLogin(true);
        } else {
            GuiUtilForBase.setChangePxxWhenLogin(false);
        }
        this.oldImtInfoField = new SMPasswordFieldEx();
        this.confirmImtInfoField = new SMPasswordFieldEx();
        this.newImtInfoField = new UserPasswordField(UserPasswordField.DisplayMoreDetail.NO);
        this.setName("SM_ChangePasswordDlg");
        this.imtInfoPanel.setName("SM_ChangePasswordDlg_passwordPanel");
        this.buttonPanel.setName("SM_ChangePasswordDlg_buttonPanel");
        this.cancelButton.setName("SM_ChangePasswordDlg_cancelButton");
        this.okButton.setName("SM_ChangePasswordDlg_okButton");
        this.nameLabel.setName("SM_ChangePasswordDlg_nameLabel");
        this.nameField.setName("SM_ChangePasswordDlg_nameField");
        this.oldPasswordLabel.setName("SM_ChangePasswordDlg_oldPasswordLabel");
        this.oldImtInfoField.setName("SM_ChangePasswordDlg_oldPasswordField");
        this.confirmImtInfoField.setName("SM_ChangePasswordDlg_confirmPasswordField");
        this.confirmPasswordLabel.setName("SM_ChangePasswordDlg_confirmPasswordLabel");
        this.newPasswordLabel.setName("SM_ChangePasswordDlg_newPasswordLabel");
        this.newImtInfoField.setName("SM_ChangePasswordDlg_newPasswordField");
        if (this.newImtInfoField instanceof UserPasswordField) {
            ((UserPasswordField)this.newImtInfoField).setIsAdmin(SessionManager.getInstance().isAdminUser());
        }
        if (this.status == 10003) {
            HelpManager.getInstance().enableHelpKey((Component)this.getRootPane(), "iVIEW.Security.ResetPasswordDlg");
        } else if (!isLogin) {
            HelpManager.getInstance().enableHelpKey((Component)this.getRootPane(), "iVIEW.Security.ChangePasswordDlg");
        }
        this.getContentPane().setLayout(this.gridBagLayout2);
        this.imtInfoPanel.setLayout(this.gridBagLayout1);
        int index = 0;
        this.imtInfoPanel.add((Component)this.nameLabel, new GridBagConstraints(0, index, 1, 1, 0.1, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.imtInfoPanel.add((Component)this.nameField, new GridBagConstraints(1, index, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        ++index;
        if (this.status != 10003) {
            this.imtInfoPanel.add((Component)this.oldPasswordLabel, new GridBagConstraints(0, index, 1, 1, 0.1, 0.0, 10, 1, new Insets(12, 0, 0, 0), 0, 0));
            this.imtInfoPanel.add((Component)this.oldImtInfoField, new GridBagConstraints(1, index, 1, 1, 1.0, 0.0, 10, 1, new Insets(12, 0, 0, 0), 0, 0));
            ++index;
        }
        this.imtInfoPanel.add((Component)this.newPasswordLabel, new GridBagConstraints(0, index, 1, 1, 0.1, 0.0, 10, 1, new Insets(12, 0, 0, 0), 0, 0));
        this.imtInfoPanel.add((Component)this.newImtInfoField, new GridBagConstraints(1, index, 1, 1, 1.0, 0.0, 10, 1, new Insets(12, 0, 0, 0), 0, 0));
        this.imtInfoPanel.add((Component)this.confirmPasswordLabel, new GridBagConstraints(0, ++index, 1, 1, 0.1, 0.0, 10, 1, new Insets(12, 0, 0, 0), 0, 0));
        this.imtInfoPanel.add((Component)this.confirmImtInfoField, new GridBagConstraints(1, index, 1, 1, 1.0, 0.0, 10, 1, new Insets(12, 0, 0, 0), 0, 0));
        this.nameLabel.setText(this.resCenter.getString("usernamefield"));
        this.nameField.setText(this.userInfo.getUserName());
        this.nameField.setEnabled(true);
        this.nameField.setEditable(false);
        this.nameField.setBackground(this.imtInfoPanel.getBackground());
        this.oldPasswordLabel.setText(this.resCenter.getString("oldpwdfield"));
        this.newPasswordLabel.setText(this.resCenter.getString("newpwdfield"));
        this.confirmPasswordLabel.setText(this.resCenter.getString("confirmfield"));
        int imtInfoMaxLength = PolicyService.getInstance().getPolicyValue("MaxPwdLength");
        GuiUtilForBase.initValidTextField((JTextField)this.oldImtInfoField, 16, "");
        GuiUtilForBase.initInValidTextField((JTextField)this.newImtInfoField, imtInfoMaxLength + 1);
        GuiUtilForBase.initInValidTextField((JTextField)this.confirmImtInfoField, imtInfoMaxLength + 1);
        this.flowLayout1.setAlignment(2);
        this.buttonPanel.setLayout(this.flowLayout1);
        this.cancelButton.setText(this.resCenter.getString("CancelButton"));
        this.cancelButton.setPreferredSize(BaseConstants.Component.ComponentSize.BUTTON_SIZE);
        SMActionListener cancelListener = new SMActionListener(this){

            public void actionProcess(ActionEvent e) {
                ChangePasswordDlg.this.cancelActionPerformed();
            }
        };
        this.cancelButton.addActionListener((ActionListener)cancelListener);
        this.okButton.setText(this.resCenter.getString("OkButton"));
        this.okButton.setPreferredSize(BaseConstants.Component.ComponentSize.BUTTON_SIZE);
        SMActionListener okListener = new SMActionListener(this){

            public void actionProcess(ActionEvent e) {
                ChangePasswordDlg.this.okActionPerformed();
            }
        };
        this.okButton.addActionListener((ActionListener)okListener);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ChangePasswordDlg.this.cancelActionPerformed();
            }
        });
        this.setTitle(this.resCenter.getString("chpwddlgtitle"));
        this.setSize(BaseConstants.Component.ComponentSize.CHANGE_PASSWORD_DLG);
        this.buttonPanel.add((Component)this.okButton, null);
        this.buttonPanel.add((Component)this.cancelButton, null);
        this.getContentPane().add((Component)this.imtInfoPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 12, 0, 12), 0, 0));
        this.getContentPane().add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(6, 12, 0, 12), 0, 0));
        if (this.status == 10002 || this.status == 10002) {
            this.setDefaultCloseOperation(0);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                ChangePasswordDlg.this.oldImtInfoField.requestFocus();
                ChangePasswordDlg.this.oldImtInfoField.selectAll();
            }
        });
        ScreenToolKit.setDefaultButtons((AbstractButton)this.okButton, (AbstractButton)this.cancelButton);
        this.setResizable(false);
        this.initFinished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void okActionPerformed() {
        if (this.checkValid()) {
            char[] newInfo = this.newImtInfoField.getPassword();
            char[] oldInfo = this.oldImtInfoField.getPassword();
            byte[] newImtInfoTemp = new byte[]{};
            byte[] oldImtInfoTemp = new byte[]{};
            if (this.userInfo.userType == 0 || this.userInfo.userType == 1 || this.userInfo.userType == 3) {
                newImtInfoTemp = CryptUtil.transferPassword(newInfo);
                oldImtInfoTemp = CryptUtil.transferPassword(oldInfo);
                if (null == newImtInfoTemp || null == oldImtInfoTemp) {
                    SecurityRedLineUtil.clearArray((byte[])newImtInfoTemp);
                    SecurityRedLineUtil.clearArray((byte[])oldImtInfoTemp);
                    SecurityRedLineUtil.clearArray((char[])newInfo);
                    SecurityRedLineUtil.clearArray((char[])oldInfo);
                    this.log.info((Object)"ChangePasswordDlg | transferPwd with error.");
                    this.guiUtil.showMessageEx(this.resCenter.getString("EncyptFailed_ChangePass"));
                    return;
                }
            } else {
                newImtInfoTemp = SecurityRedLineUtil.charArray2ByteArray((char[])newInfo);
                oldImtInfoTemp = SecurityRedLineUtil.charArray2ByteArray((char[])oldInfo);
            }
            SecurityRedLineUtil.clearArray((char[])oldInfo);
            try {
                if (this.status == 10004 && 0 != OptionPaneProxy4SmBase.showConfirmDlgFocOnNo(this, ResCenter.getInstance().getString("ChangePassword_Confirm"))) {
                    SecurityRedLineUtil.clearArray((char[])newInfo);
                    return;
                }
                if (this.status == 10002 && 0 != OptionPaneProxy4SmBase.showConfirmDlgFocOnNo(this, ResCenter.getInstance().getString("ChangePassword_Confirm"))) {
                    SecurityRedLineUtil.clearArray((char[])newInfo);
                    this.isImtInfoChanged = false;
                    this.clearPwdText();
                    this.dispose();
                    return;
                }
                final byte[] tempOldPassword = oldImtInfoTemp;
                final byte[] tempNewPassword = newImtInfoTemp;
                SyncCommand syn = new SyncCommand(){

                    public Object call() throws Exception {
                        ChangePasswordDlg.this.isImtInfoChanged = ChangePasswordDlg.this.sessionManager.changePassword(ChangePasswordDlg.this.userInfo.getUserName(), tempOldPassword, tempNewPassword);
                        ChangePasswordDlg.this.clearPwdText();
                        return null;
                    }
                };
                if (!syn.startCall()) {
                    throw syn.getException();
                }
                if (!this.isImtInfoChanged) return;
                GuiUtilForBase.setChangePxxWhenLogin(false);
                SetLoginInfoToProduct.getInstance().set(this.nameField.getText(), newInfo, true);
                SessionManager.getInstance().setModifyImtInfo(tempNewPassword);
                OptionPaneProxy4SmBase.showInformationDlg(this, this.resCenter.getString("pwdmodifysuccesstxt"));
                this.dispose();
                return;
            }
            catch (AppError ex) {
                SecurityRedLineUtil.clearArray((char[])newInfo);
                SecurityRedLineUtil.clearArray((char[])oldInfo);
                String errorCode = ex.getDetail("errorCode");
                int errorID = errorCode == null || errorCode.trim().isEmpty() ? 0 : Integer.parseInt(errorCode);
                this.log.info((Object)("ChangePasswordDlg | error code is : " + errorCode));
                if (8 == errorID) {
                    OptionPaneProxy4SmBase.showInformationDlg(this, this.resCenter.getString("Wrong_Password_Input"));
                } else {
                    if (ex.is("SM_DB_ERROR")) {
                        OptionPaneProxy4SmBase.showInformationDlg(this, ResCenter.RES.getString("errdberrtxt0"));
                        this.dispose();
                        return;
                    }
                    if (2 == errorID) {
                        OptionPaneProxy4SmBase.showInformationDlg(this, this.resCenter.getString("Change_Self_Password"));
                    } else if (10 == errorID) {
                        OptionPaneProxy4SmBase.showInformationDlg(this, this.resCenter.getString("errexcrigtxt0"));
                    } else if (11 == errorID) {
                        OptionPaneProxy4SmBase.showInformationDlg(this, this.resCenter.getString("errmiterrtxt0"));
                    } else if (ex.is("SM_PWD_POLICY_CHECK_ERR")) {
                        ShowPwdErrorInfo showPwdErrorInfo = new ShowPwdErrorInfo(this);
                        showPwdErrorInfo.setIsAdmin(SessionManager.getInstance().isAdminUser());
                        showPwdErrorInfo.show(ex);
                    } else if (!GuiUtilForBase.handleException((Exception)((Object)ex))) {
                        OptionPaneProxy4SmBase.showInformationDlg(this, this.resCenter.getString("TSRESULT_FAILED_txt"));
                    }
                }
                this.resetFieldUI();
                return;
            }
            catch (Exception e) {
                SecurityRedLineUtil.clearArray((char[])newInfo);
                SecurityRedLineUtil.clearArray((char[])oldInfo);
                if (!GuiUtilForBase.handleException(e)) {
                    OptionPaneProxy4SmBase.showInformationDlg(this, this.resCenter.getString("TSRESULT_FAILED_txt"));
                    this.log.error((Object)"ChangePasswordDlg | changePassword with error.", (Throwable)e);
                }
                this.resetFieldUI();
                return;
            }
            finally {
                SecurityRedLineUtil.clearArray((char[])newInfo);
                SecurityRedLineUtil.clearArray((char[])oldInfo);
                SecurityRedLineUtil.clearArray((byte[])oldImtInfoTemp);
                SecurityRedLineUtil.clearArray((byte[])newImtInfoTemp);
            }
        } else {
            this.resetFieldUI();
        }
    }

    private void clearPwdText() {
        this.oldImtInfoField.setText("");
        this.newImtInfoField.setText("");
        this.confirmImtInfoField.setText("");
    }

    @Override
    public void doSomethingAfterShowInfo(String policyName) {
        this.resetFieldUI();
    }

    @Override
    public void doSomethingBeforeShowInfo(String policyName) {
    }

    private void resetFieldUI() {
        this.oldImtInfoField.setText("");
        this.newImtInfoField.setText("");
        this.confirmImtInfoField.setText("");
        this.oldImtInfoField.requestFocus();
        this.oldImtInfoField.selectAll();
    }

    private void cancelActionPerformed() {
        String message = null;
        if (this.status == 10002) {
            message = ResCenter.RES.getString("BSureLogoutSys");
        }
        if (this.status == 10002) {
            message = ResCenter.RES.getString("BSureLogoutSys_2");
        }
        if (null != message) {
            if (0 == OptionPaneProxy4SmBase.showConfirmDlgFocOnNo(FrameworkUtilities.getMainFrame(), message)) {
                this.isImtInfoChanged = false;
                this.clearPwdText();
                this.dispose();
            }
        } else {
            this.clearPwdText();
            this.dispose();
        }
    }

    private boolean checkValid() {
        long t2;
        long t1;
        char[] newImtInfoTmp = this.newImtInfoField.getPassword();
        char[] confirmImtInfoTmp = this.confirmImtInfoField.getPassword();
        byte[] newTmp = SecurityRedLineUtil.charArray2ByteArray((char[])newImtInfoTmp);
        if (SecurityRedLineUtil.notEqual((char[])newImtInfoTmp, (char[])confirmImtInfoTmp)) {
            SecurityRedLineUtil.clearArray((char[])newImtInfoTmp);
            SecurityRedLineUtil.clearArray((char[])confirmImtInfoTmp);
            SecurityRedLineUtil.clearArray((byte[])newTmp);
            this.guiUtil.showMessageEx(this.resCenter.getString("pwdnomatchtxt"));
            this.resetFieldUI();
            return false;
        }
        SecurityRedLineUtil.clearArray((char[])newImtInfoTmp);
        SecurityRedLineUtil.clearArray((char[])confirmImtInfoTmp);
        boolean bDoNext = true;
        if (this.operation != null) {
            try {
                this.log.info((Object)"ChangePassword | begin to invoke doPreviousOperation...");
                t1 = System.currentTimeMillis();
                bDoNext = this.operation.doPreviousOperation(2001, null, newTmp);
                t2 = System.currentTimeMillis();
                this.log.info((Object)("ChangePasswordDlg | finished doPreviousOperation = " + (t2 - t1)));
            }
            catch (Exception pe) {
                this.log.error((Object)"ChangePasswordDlg | checkValid | doPreviousOperation product with error .", (Throwable)pe);
            }
        }
        if (!bDoNext) {
            SecurityRedLineUtil.clearArray((byte[])newTmp);
            this.resetFieldUI();
            return bDoNext;
        }
        if (!this.sessionManager.isLoginFinished()) {
            if (this.intf != null) {
                try {
                    this.log.info((Object)"ChangePasswordDlg | begin to invoke checkPassword...");
                    t1 = System.currentTimeMillis();
                    bDoNext = this.intf.checkPassword(newTmp);
                    t2 = System.currentTimeMillis();
                    this.log.info((Object)("ChangePasswordDlg | finished checkPassword = " + (t2 - t1)));
                }
                catch (Exception pe) {
                    this.log.error((Object)"ChangePasswordDlg | checkPassword product with error.", (Throwable)pe);
                }
            }
        } else if (this.operation != null) {
            try {
                this.log.info((Object)"ChangePasswordDlg | begin to invoke doPostOperation...");
                t1 = System.currentTimeMillis();
                bDoNext = this.operation.doPostOperation(2001, null, newTmp);
                t2 = System.currentTimeMillis();
                this.log.info((Object)("ChangePasswordDlg | finished doPostOperation = " + (t2 - t1)));
            }
            catch (Exception pe) {
                this.log.error((Object)"ChangePasswordDlg | doPostOperation product with error.", (Throwable)pe);
            }
        }
        SecurityRedLineUtil.clearArray((byte[])newTmp);
        if (!bDoNext) {
            this.resetFieldUI();
            return bDoNext;
        }
        return true;
    }

    public boolean isBPasswordChanged() {
        return this.isImtInfoChanged;
    }

    public boolean getInitResult() {
        return this.initFinished;
    }
}

