/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base.adapt;

import com.swimap.sm.client.base.adapt.IUserChangedListener;
import java.util.List;

public class UserChangedListenerHandler {
    private static UserChangedListenerHandler instance;
    private static Object lock;
    private IUserChangedListener userChangedListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserChangedListenerHandler getInstance() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new UserChangedListenerHandler();
                }
            }
        }
        return instance;
    }

    public void addUserChangedListener(IUserChangedListener listener) {
        this.userChangedListener = listener;
    }

    public void removeUserChangedListener() {
        this.userChangedListener = null;
    }

    public boolean isUserChangedListener() {
        return this.userChangedListener == null;
    }

    public void notifyUserDeleted(List<Integer> userIDs) {
        if (this.userChangedListener != null && userIDs != null && userIDs.size() > 0) {
            this.userChangedListener.notifyDeleteUsers(userIDs);
        }
    }

    public void clear() {
        this.userChangedListener = null;
    }

    static {
        lock = new Object();
    }
}

