/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base;

import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.statusbarmanagement.StatusBarManager;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.SecurityBaseModule;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.loginui.common.SMTraceProxy;

public class StatusBarSettingProxy {
    private IviewLogger log = SMTraceProxy.getLogger(StatusBarSettingProxy.class);
    private boolean isRestrictedMode = false;
    private int systemMode = 0;
    private ResCenter resCenter;
    private GuiUtilForBase guiUtil;
    private boolean isShowOSTime = false;
    private static StatusBarSettingProxy instance = new StatusBarSettingProxy(ResCenter.getInstance(), GuiUtilForBase.getInstance());
    private IMapTimer timer = null;

    private StatusBarSettingProxy(ResCenter resCenter, GuiUtilForBase guiUtil) {
        this.resCenter = resCenter;
        this.guiUtil = guiUtil;
    }

    public static StatusBarSettingProxy getInstance() {
        return instance;
    }

    public boolean isRestrictedMode() {
        return this.isRestrictedMode;
    }

    public void setRestrictedMode(boolean _isRestrictedMode) {
        this.isRestrictedMode = _isRestrictedMode;
    }

    public void setSystemModeStatus() {
        block10: {
            try {
                this.systemMode = SecurityBaseModule.getSecuityModuleRef().getSessionManager().getSystemMode();
            }
            catch (Exception e) {
                if (this.guiUtil.handleExceptionEx(e)) break block10;
                this.log.error((Object)e, (Throwable)e);
            }
        }
        if (this.isRestrictedMode()) {
            this.setSystemModelMessageItemTooltip(this.resCenter.getString("RESTRICTED_MODE"));
        } else {
            try {
                switch (this.systemMode) {
                    case 0: {
                        this.setSystemModelMessageItemTooltip(this.resCenter.getString("maintenencemode"));
                        break;
                    }
                    case 1: {
                        this.setSystemModelMessageItemTooltip(this.resCenter.getString("runtimemode"));
                        break;
                    }
                    default: {
                        this.setSystemModelMessageItemTooltip(this.resCenter.getString("unknownMode"));
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.log.info((Object)e, (Throwable)e);
            }
        }
    }

    public boolean setSystemModelMessageItemTooltip(String tooltip) {
        this.setStatusBarValue("SystemModelMessageItem", tooltip);
        return true;
    }

    public boolean showIPInfo() {
        String ipData = SecurityBaseModule.getSecuityModuleRef().getSessionManager().getShowServerIP();
        String serverName = SecurityBaseModule.getSecuityModuleRef().getSessionManager().getServerName();
        String message = this.resCenter.getMergeString("theServer", new String[]{serverName, ipData});
        return this.setStatusBarValue("IPMessageItem", message);
    }

    public boolean showCurUserInfo() {
        String message = this.resCenter.getMergeString("thecuruser", new String[]{SecurityBaseModule.getSecuityModuleRef().getSessionManager().getCurUser().getUserName()});
        return this.setStatusBarValue("UserInfo", message);
    }

    public void showLoginTime() {
        this.isShowOSTime = SecurityBaseModule.getSecuityModuleRef().getSecurityConfig().isShowOSTime();
        this.startTimer();
    }

    public boolean setStatusBarValue(String itemName, String value) {
        return this.getStatusBarMgr().refreshItem(itemName, value);
    }

    public StatusBarManager getStatusBarMgr() {
        StatusBarManager statusBarMgr = null;
        try {
            statusBarMgr = (StatusBarManager)SecurityBaseModule.getSecuityModuleRef().getReference("mainstatusbarmanager", "");
        }
        catch (ModuleManagementException e) {
            this.log.debug((Object)e, (Throwable)e);
        }
        return statusBarMgr;
    }

    private void startTimer() {
        if (this.timer == null) {
            this.timer = new IMapTimer();
            this.timer.start();
            this.log.info((Object)"Start imap timer.");
        }
    }

    private String format(long seconds) {
        long hour = seconds / 3600L;
        long minut = (seconds - hour * 60L * 60L) / 60L;
        long second = seconds - hour * 60L * 60L - minut * 60L;
        return hour + ":" + minut + ":" + second;
    }

    public void cancelTimer() {
        if (this.timer != null) {
            this.timer.stopIMapTimer();
        }
    }

    private class IMapTimer
    extends Thread {
        private boolean running = true;
        private long beginLoginTime = System.currentTimeMillis();

        private IMapTimer() {
        }

        @Override
        public void run() {
            while (this.running) {
                long curTime = System.currentTimeMillis();
                String message = "";
                if (StatusBarSettingProxy.this.isShowOSTime) {
                    message = TimeDateFormatUtil.convertFromUTC((long)curTime);
                } else {
                    long lastingTime = curTime - this.beginLoginTime;
                    message = StatusBarSettingProxy.this.format(lastingTime / 1000L);
                }
                StatusBarSettingProxy.this.getStatusBarMgr().refreshItem("loginTime", message);
                try {
                    IMapTimer.sleep(1000L);
                }
                catch (InterruptedException e) {
                    StatusBarSettingProxy.this.log.error((Object)"", (Throwable)e);
                }
            }
        }

        public synchronized void stopIMapTimer() {
            this.running = false;
            StatusBarSettingProxy.this.timer = null;
            StatusBarSettingProxy.this.getStatusBarMgr().refreshItem("loginTime", "");
            StatusBarSettingProxy.this.log.info((Object)"Stop imap timer.");
        }
    }
}

