/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base;

import com.swimap.external.dsf.base.framework.AppError;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.sm.client.base.ISessionService;
import com.swimap.external.sm.client.base.common.model.LMTLoginInfo;
import com.swimap.external.sm.client.base.common.model.Right;
import com.swimap.external.sm.client.base.common.model.StaticRight;
import com.swimap.external.sm.client.base.common.model.UserInfo;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.SecurityBaseModule;
import com.swimap.sm.client.base.auth.SessionManager;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.common.RpcInvoker;
import com.swimap.sm.client.base.crypt.RSAEncrypt;
import com.swimap.sm.client.base.policy.service.PolicyService;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SessionService
implements ISessionService {
    private IviewLogger log = SMTraceProxy.getLogger(SessionService.class);
    private static SessionService instance = new SessionService();

    private SessionService() {
        com.swimap.external.sm.client.base.SessionService.getInstance().setSessionServiceImpl(instance);
    }

    public static SessionService getInstance() {
        return instance;
    }

    @Override
    public int getCurSessionID() {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().getCurSessionID();
    }

    @Override
    public UserInfo getCurUser() {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().getCurUser();
    }

    @Override
    public boolean isSystemRestricted() {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().isSystemRestricted();
    }

    @Override
    public byte[] getSecurityToken() {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().getSecurityToken();
    }

    @Override
    public String getCurTerminalID() {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().getCurTerminalID();
    }

    @Override
    public String getCurUserName() {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().getCurUserName();
    }

    @Override
    public boolean isAdminUser() {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().isAdminUser();
    }

    @Override
    public boolean isAdminUser(String username) {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().isAdminUser(username);
    }

    @Override
    public boolean[] isAdminUsers(String[] userNameArray) {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().isAdminUsers(userNameArray);
    }

    @Override
    public boolean isAdminGroupUser(String username) {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().isAdminGroupUser(username);
    }

    @Override
    public boolean isAdminUserGroup() {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().isAdminUserGroup();
    }

    @Override
    public boolean isUserNameSensitive() {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().isUserNameSensitive();
    }

    @Override
    public boolean isAdminGroup(String usergroupname) {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().isAdminGroup(usergroupname);
    }

    @Override
    public List<Map<String, Right>> getAllAppRightByUserID(int userID) {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().getAllAppRightByUserID(userID);
    }

    @Override
    public boolean hasAllAppOperationSetByUserID(int userID) {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().hasAllAppOperationSetByUserID(userID);
    }

    @Override
    public Map<String, StaticRight> getStaticRight() {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().getStaticRight();
    }

    @Override
    public String getCurServerIP() {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().getServerIP();
    }

    @Override
    public String getUserSelectedServerIP() {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().getShowServerIP();
    }

    @Override
    public String getCurServerPort() {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().getServerPort();
    }

    @Override
    public String getAdminUserName() {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().getAdminUserName();
    }

    @Override
    public String getAdminGroupName() {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().getAdminGroupName();
    }

    @Override
    public boolean isSecurityMgrGroup(String username) {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().isSecurityMgrGroup(username);
    }

    @Override
    public boolean isSecurityMgrGroupUser() {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().isSecurityMgrGroupUser();
    }

    @Override
    public boolean hasSMRight() {
        return this.isSecurityMgrGroupUser() || this.isSSAUser();
    }

    @Override
    public boolean isSecurityMgrGroup(int userid) {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().isSecurityMgrGroup(userid);
    }

    @Override
    public int[] isSecurityMgrGroupUsers(int[] userids) {
        int[] result = new int[userids.length];
        try {
            result = RpcInvoker.getInstance().isSecurityMgrGroupUsers(userids);
        }
        catch (Exception ex) {
            if (!GuiUtilForBase.handleException(ex)) {
                this.log.error((Object)"", (Throwable)ex);
            }
            result = new int[]{};
        }
        return result;
    }

    @Override
    public int getCurPwdPolicyMaxLength() {
        return PolicyService.getInstance().getPolicyValue("MaxPwdLength");
    }

    @Override
    public void handleInvalidTokenException(String tokenValidError) {
        SecurityBaseModule.getSecuityModuleRef().handleInvalidTokenException(tokenValidError);
    }

    @Override
    public void handleInvalidTokenException(int type) {
        int invalidTokenType = 9;
        SecurityBaseModule.getSecuityModuleRef().handleInvalidTokenException("9:" + type);
    }

    @Override
    public void handleKickoutCondition(String kickUser) {
        SecurityBaseModule.getSecuityModuleRef().handleKickoutCondition(kickUser);
    }

    @Override
    public void handleModeSwitch(int waitSeconds) {
        SecurityBaseModule.getSecuityModuleRef().handleModeSwitch(waitSeconds);
    }

    @Override
    public void logout() throws Exception {
        RpcInvoker.getInstance().logout();
    }

    @Override
    public boolean isSSLCommMode() {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().getCurServerMode();
    }

    @Override
    public String getSMGroupName() {
        return RpcInvoker.getInstance().getSMGroupName();
    }

    @Override
    public Map<String, Object> getAuthModeInfo() {
        HashMap<String, Object> authInfo = new HashMap<String, Object>();
        boolean isLocalLoginMode = SecurityBaseModule.getSecuityModuleRef().isLocalLoginMode();
        authInfo.put("isLocalLoginMode", isLocalLoginMode);
        return authInfo;
    }

    @Override
    public String getCurDomainNameStr() {
        return "SM_ROOT";
    }

    @Override
    public boolean isAdminUser(int userid) throws Exception {
        try {
            if (SecurityBaseModule.getSecuityModuleRef().getSessionManager().getCurUser().getId() == userid) {
                return this.isAdminUser();
            }
        }
        catch (Exception e) {
            this.log.info((Object)e, (Throwable)e);
        }
        return RpcInvoker.getInstance().isAdminUser(userid);
    }

    @Override
    public boolean isSSAUser(int userid) {
        boolean isSSAUser;
        block2: {
            isSSAUser = false;
            try {
                isSSAUser = RpcInvoker.getInstance().isSSAUsers(new int[]{userid})[0] == 1;
            }
            catch (Exception ex) {
                if (GuiUtilForBase.handleException(ex)) break block2;
                this.log.error((Object)"", (Throwable)ex);
            }
        }
        return isSSAUser;
    }

    @Override
    public int[] isSSAUsers(int[] userids) {
        int[] result = null;
        try {
            result = RpcInvoker.getInstance().isSSAUsers(userids);
        }
        catch (Exception ex) {
            if (!GuiUtilForBase.handleException(ex)) {
                this.log.error((Object)"", (Throwable)ex);
            }
            result = new int[]{};
        }
        return result;
    }

    @Override
    public boolean isSSAUser() {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().isSSAUser();
    }

    @Override
    public boolean isCurUser(String name) {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().getCurUserName().equals(name);
    }

    @Override
    public String getCommTerminalIP() {
        return SecurityBaseModule.getSecuityModuleRef().getSessionManager().getCommTerminalIP();
    }

    @Override
    public boolean isLogout() {
        return GuiUtilForBase.isbExit();
    }

    @Override
    public boolean isBeingLogOut() {
        return GuiUtilForBase.isbExit();
    }

    @Override
    public void handleInvalidTokenException(Throwable ex) {
        SecurityBaseModule.getSecuityModuleRef().handleInvalidTokenException(ex.getMessage());
    }

    @Override
    public LMTLoginInfo getLMTLoginInfo() {
        LMTLoginInfo lmtLoginInfo = new LMTLoginInfo();
        try {
            byte[] encryptDynamicAESKey = RSAEncrypt.getInstance().getDynamicAESKey();
            RpcMessage rpcMsg = RpcInvoker.getInstance().getLMTLoginInfoFromRPC(encryptDynamicAESKey);
            char[] authCode = rpcMsg.getByteArray("authCode") == null ? new char[]{} : RSAEncrypt.getInstance().decryptByDynamicAESKey(rpcMsg.getByteArray("authCode"));
            char[] digest = rpcMsg.getByteArray("digest") == null ? new char[]{} : RSAEncrypt.getInstance().decryptByDynamicAESKey(rpcMsg.getByteArray("digest"));
            char[] sRan = rpcMsg.getByteArray("sRan") == null ? new char[]{} : RSAEncrypt.getInstance().decryptByDynamicAESKey(rpcMsg.getByteArray("sRan"));
            lmtLoginInfo.setUsername(SessionManager.getInstance().getCurUserName());
            lmtLoginInfo.setAuthCode(authCode);
            lmtLoginInfo.setDigest(digest);
            lmtLoginInfo.setsRan(sRan);
            lmtLoginInfo.setResult(0);
        }
        catch (AppError error) {
            if (error.is("SM_BUILD_LMT_ONE_TIME_KEY_FAILED")) {
                lmtLoginInfo.setResult(1);
            } else if (error.is("SM_INVALID_TOKEN")) {
                lmtLoginInfo.setResult(3);
            } else {
                lmtLoginInfo.setResult(2);
            }
            this.log.error((Object)"", (Throwable)error);
        }
        catch (Exception ex) {
            lmtLoginInfo.setResult(2);
            this.log.error((Object)"", (Throwable)ex);
        }
        return lmtLoginInfo;
    }
}

