/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base;

import com.swimap.base.rpc.nio.SocketClient;
import com.swimap.external.dsf.base.rpc.RpcErrorSecurity;
import com.swimap.external.dsf.base.rpc.RpcNaming;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import com.swimap.external.sf.sound.ISoundSettingModule;
import com.swimap.external.sf.sound.SoundManager;
import com.swimap.external.sm.client.base.common.model.RightInfo;
import com.swimap.external.sm.client.base.product.interfaces.IPreExitAction;
import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.MenuItem;
import com.swimap.iview.framework.mainframe.MDIFrame;
import com.swimap.iview.framework.menumanagement.MenuManager;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.systemsettingsmanagement.SystemSettingsManager;
import com.swimap.iview.framework.terminalmanagement.UnlockDialog;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.welcomepage.WelcomeManager;
import com.swimap.iview.util.log.IviewLogger;
import com.swimap.sm.client.base.SecurityBaseModule;
import com.swimap.sm.client.base.SessionService;
import com.swimap.sm.client.base.StatusBarSettingProxy;
import com.swimap.sm.client.base.auth.HeartBeatManager;
import com.swimap.sm.client.base.auth.HistoryLoginInfoDlg;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.auth.SessionManager;
import com.swimap.sm.client.base.auth.checker.CheckerFactory;
import com.swimap.sm.client.base.autologout.AutoLogoutManager;
import com.swimap.sm.client.base.checkright.AppRightAuthService;
import com.swimap.sm.client.base.checkright.SecurityRightManager;
import com.swimap.sm.client.base.common.CryptUtil;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.common.OptionPaneProxy4SmBase;
import com.swimap.sm.client.base.common.RpcInvoker;
import com.swimap.sm.client.base.config.SecurityConfig;
import com.swimap.sm.client.base.config.UpgradeIntevalParser;
import com.swimap.sm.client.base.event.EventRegisterFactory;
import com.swimap.sm.client.base.event.LogEventDispatch;
import com.swimap.sm.client.base.event.SMEventDispatch;
import com.swimap.sm.client.base.event.handle.RestrictedModeChangedEventHandler;
import com.swimap.sm.client.base.event.handle.UserInactivePolicyChangedEventHandler;
import com.swimap.sm.client.base.policy.service.PolicyService;
import com.swimap.sm.client.base.product.factory.SetLoginInfoToProduct;
import com.swimap.sm.client.base.sessionact.ActivateSessionHandler;
import com.swimap.sm.client.base.sessionact.DoubleHostSwitchHandler;
import com.swimap.sm.client.base.sound.LoginFailSoundManager;
import com.swimap.sm.client.base.upgradecheck.UpgradeCheckTool;
import com.swimap.sm.client.loginui.LoginUIBaseModule;
import com.swimap.sm.client.loginui.auth.LogoutDlg;
import com.swimap.sm.client.loginui.auth.checker.IChecker;
import com.swimap.sm.client.loginui.common.LogoutProxy;
import com.swimap.sm.client.loginui.common.SMTraceProxy;
import com.swimap.sm.client.loginui.common.SecurityRedLineUtil;
import com.swimap.sm.client.loginui.config.LoginUIConfig;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class SecurityBaseModuleImpl {
    private static IviewLogger log = SMTraceProxy.getLogger(SecurityBaseModuleImpl.class);
    private static MDIFrame oMDIFrame = null;
    private SecurityRightManager securityRightManager = null;
    private int upgradeSettingID;
    private int systemModeID;
    private int autoLoginSettingID;
    private static RpcStatusListener securiyShakehandListener = null;
    private AutoLogoutManager autoLogoutMgr;
    private UpgradeCheckTool upgradeTimer = null;
    private SecurityBaseModule baseModule;

    public SecurityBaseModuleImpl(SecurityBaseModule securityModule) {
        this.baseModule = securityModule;
    }

    public SecurityConfig getSecurityConfig() {
        return SecurityConfig.getInstance();
    }

    public SMEventDispatch getSMEventDispatch() {
        return SMEventDispatch.getInstance();
    }

    public LogEventDispatch getLogEventDisptch() {
        return LogEventDispatch.getInstance();
    }

    public AutoLogoutManager getAutoLogoutManager() {
        if (null == this.autoLogoutMgr) {
            this.autoLogoutMgr = new AutoLogoutManager(SessionManager.getInstance().getCurUser());
        }
        return this.autoLogoutMgr;
    }

    public boolean verifyPassword(char[] imtInfo) {
        byte[] transferedImtInfo = CryptUtil.transferPassword(imtInfo);
        SecurityRedLineUtil.clearArray((char[])imtInfo);
        String unlockUserName = FrameworkUtilities.getTerminalManager().getUnlockUsername();
        if (unlockUserName == null || "".equals(unlockUserName)) {
            if (SwingUtilities.isEventDispatchThread()) {
                OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("UnlockFailureType_UNKNOWN_USER"));
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("UnlockFailureType_UNKNOWN_USER"));
                    }
                });
            }
            return false;
        }
        if (unlockUserName != null) {
            unlockUserName = unlockUserName.trim();
        }
        boolean isAdminGroupUser = false;
        boolean bUnlockSuccess = false;
        boolean isUserNameSensitive = false;
        try {
            isUserNameSensitive = SessionService.getInstance().isUserNameSensitive();
            isAdminGroupUser = RpcInvoker.getInstance().isAdminGroupUser(unlockUserName);
            if (!this.isCurUser(unlockUserName, isUserNameSensitive) && !isAdminGroupUser) {
                if (SwingUtilities.isEventDispatchThread()) {
                    OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("UnlockFailureType_UNKNOWN_USER"));
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("UnlockFailureType_UNKNOWN_USER"));
                        }
                    });
                }
                return false;
            }
            if (!this.isCurUser(unlockUserName, isUserNameSensitive) && isAdminGroupUser && 0 != OptionPaneProxy4SmBase.showConfirmDlgFocOnNo(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("unlockSucceedCurUserMustBeLogout"))) {
                return false;
            }
        }
        catch (Exception ex) {
            log.error((Object)"RpcInvoker | isAdminGroupUser | get result with error.", (Throwable)ex);
        }
        try {
            bUnlockSuccess = SessionManager.getInstance().unlockTerminal(unlockUserName, transferedImtInfo, GuiUtilForBase.getInstance());
            if (bUnlockSuccess) {
                LoginUIBaseModule.getLoginUIBaseModuleRef().getDelayMgr().clear();
                if (!this.isCurUser(unlockUserName, isUserNameSensitive)) {
                    GuiUtilForBase.prepareToLogout();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                LogoutProxy.getInstance().logoutImmediately();
                            }
                            catch (Exception e) {
                                log.error((Object)"SecurityBaseModuleImpl | verifyPassword  with error. ", (Throwable)e);
                            }
                        }
                    });
                }
            } else {
                LoginUIBaseModule.getLoginUIBaseModuleRef().getDelayMgr().doDelayAction((RootPaneContainer)FrameworkUtilities.getMainFrame());
            }
        }
        catch (Exception e) {
            if (!GuiUtilForBase.handleException(e)) {
                log.error((Object)"SecurityBaseModuleImpl | veryfyPassword | unlockTerminal with error.", (Throwable)e);
                isAdminGroupUser = false;
            }
            return false;
        }
        return bUnlockSuccess;
    }

    public boolean isCurUser(String unLockUserName, boolean isUserNameSensitive) {
        String userName = SessionManager.getInstance().getCurUserName();
        if (userName != null) {
            return isUserNameSensitive ? userName.equals(unLockUserName) : userName.equalsIgnoreCase(unLockUserName);
        }
        return false;
    }

    public SecurityRightManager getSecurityRightManager() {
        if (this.securityRightManager == null) {
            this.securityRightManager = new SecurityRightManager();
        }
        return this.securityRightManager;
    }

    public StatusBarSettingProxy getStatusBarSettingProxy() {
        return StatusBarSettingProxy.getInstance();
    }

    public void setServerInfoInTitle() {
        String currentIP = SecurityBaseModule.getSecuityModuleRef().getSessionManager().getShowServerIP();
        String serverName = SecurityBaseModule.getSecuityModuleRef().getSessionManager().getServerName();
        String ipAddress = currentIP;
        int showParam = SecurityBaseModule.getSecuityModuleRef().getSecurityConfig().getShowIpParam();
        int showIPorServerName = SecurityBaseModule.getSecuityModuleRef().getSecurityConfig().getShowIPOrServerNameParam();
        oMDIFrame = (MDIFrame)FrameworkUtilities.getMainFrame();
        if (ipAddress != null && "".equals(ipAddress) && serverName != null && "".equals(serverName)) {
            if (showParam == 1) {
                oMDIFrame.setPrefixTitle("");
            } else {
                oMDIFrame.setSuffixTitle("");
            }
            return;
        }
        StringBuilder sbServerInfo = new StringBuilder();
        switch (showIPorServerName) {
            case 0: {
                break;
            }
            case 10: {
                sbServerInfo.append(serverName);
                break;
            }
            case 11: {
                if (serverName != null && !serverName.trim().equals("")) {
                    sbServerInfo.append(serverName);
                    sbServerInfo.append(ResCenter.getInstance().getString("Colon"));
                }
                sbServerInfo.append(ipAddress);
                break;
            }
            case 1: {
                sbServerInfo.append(ipAddress);
                break;
            }
            default: {
                sbServerInfo.append(ipAddress);
            }
        }
        if (showParam == 1) {
            oMDIFrame.setPrefixTitle(sbServerInfo.toString());
        } else {
            oMDIFrame.setSuffixTitle(sbServerInfo.toString());
        }
    }

    public boolean postLogin() {
        try {
            return this.handlePostLogin();
        }
        catch (Exception e) {
            log.error((Object)"postLogin", (Throwable)e);
            OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.RES.getString("LOAD_CURUSER_FAIL"));
            this.logout();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logout() {
        SecurityBaseModuleImpl.removeConnectionStatusListener();
        try {
            this.getStatusBarSettingProxy().cancelTimer();
            this.removeUpgradeSetting();
            this.removeSystemModeSetting();
            this.removeAutoSettings();
        }
        catch (Exception e) {
            log.error((Object)"clear with iview component error.", (Throwable)e);
        }
        if (GuiUtilForBase.isbExit()) {
            SessionManager.clearInstance();
            LoginUIBaseModule.getLoginUIBaseModuleRef().getDelayMgr().clear();
            this.getSMEventDispatch().stop();
            this.getLogEventDisptch().stop();
            this.getAutoLogoutManager().clear();
            EventRegisterFactory.create().unRegisterAll();
            HeartBeatManager.getInstance().stop();
            return true;
        }
        GuiUtilForBase.setToBeingExit();
        GuiUtilForBase.isSetSingleUserModeDelayed = false;
        LoginUIBaseModule.getLoginUIBaseModuleRef().getDelayMgr().clear();
        this.getSMEventDispatch().stop();
        this.getLogEventDisptch().stop();
        this.getAutoLogoutManager().clear();
        EventRegisterFactory.create().unRegisterAll();
        try {
            HeartBeatManager.getInstance().stop();
            DoubleHostSwitchHandler handler = DoubleHostSwitchHandler.getResumeTimeoutHandler();
            if (null != handler && handler.isSwitching()) {
                boolean bl = true;
                return bl;
            }
            SessionManager.getInstance().logout();
        }
        catch (Exception ex) {
            log.error((Object)"logout with error.", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            SessionManager.clearInstance();
        }
        return true;
    }

    public static void removeConnectionStatusListener() {
        try {
            if (securiyShakehandListener != null) {
                RpcRequest.getSocketClient().removeConnectionStatusListener((SocketClient.ConnectionStatusListener)securiyShakehandListener);
                securiyShakehandListener.stopResume();
                securiyShakehandListener = null;
                RpcRequest.getSocketClient().setResumeAction(null);
            }
        }
        catch (Exception ex) {
            log.error((Object)"Removing listener error. ", (Throwable)ex);
        }
    }

    public boolean handlePostLogin() {
        int nReconnectWaitMinutes;
        GuiUtilForBase.resetExitFlag();
        GuiUtilForBase.isLoginFinished = false;
        if (SessionManager.getInstance().isLogout()) {
            this.logout();
            return false;
        }
        this.loadServerAuthConf();
        boolean isRestrictedMode = SessionService.getInstance().isSystemRestricted();
        EventRegisterFactory.create().register("3:17", new RestrictedModeChangedEventHandler(this.getStatusBarSettingProxy(), ResCenter.getInstance(), GuiUtilForBase.getInstance(), RpcInvoker.getInstance()));
        EventRegisterFactory.create().register("3:25", AppRightAuthService.getInstance());
        EventRegisterFactory.create().register("3:8", AppRightAuthService.getInstance());
        EventRegisterFactory.create().register("3:6", AppRightAuthService.getInstance());
        EventRegisterFactory.create().register("2:22", new UserInactivePolicyChangedEventHandler(this.getAutoLogoutManager(), SessionManager.getInstance().getCurUser()));
        this.getStatusBarSettingProxy().setRestrictedMode(isRestrictedMode);
        AppRightAuthService.getInstance().getCurUserInfo();
        SessionManager.getInstance().setHasRightForLicense();
        SessionManager.getInstance().registerEvent();
        this.getSMEventDispatch().setCurSessionId(SessionManager.getInstance().getCurSessionID());
        this.getSMEventDispatch().start();
        this.getLogEventDisptch().start();
        SessionService.getInstance().getCurSessionID();
        if (isRestrictedMode) {
            this.restrictedModeHint();
        }
        if (!LoginUIConfig.isWaitForever((int)(nReconnectWaitMinutes = LoginUIConfig.getInstance().getReconnectWaitTime()))) {
            System.setProperty("RPC_RECONNECT_TIME", "" + (long)nReconnectWaitMinutes * 60L * 1000L);
            RpcRequest.getSocketClient().addConnectionStatusListener((SocketClient.ConnectionStatusListener)securiyShakehandListener);
        } else {
            RpcRequest.getSocketClient().addConnectionStatusListener((SocketClient.ConnectionStatusListener)securiyShakehandListener);
        }
        GuiUtilForBase.isLoginFinished = true;
        return true;
    }

    private void startUpgradeCheckTimer() {
        this.upgradeTimer = new UpgradeCheckTool(RpcInvoker.getInstance(), ResCenter.getInstance());
        UpgradeIntevalParser upgradeIntevalParser = new UpgradeIntevalParser(PluginManager.getInstance().getPlugin("authentication").getCommStyleParser());
        this.upgradeTimer.setUpgradeTimerInterval(upgradeIntevalParser.getUpgradeInterval());
    }

    private void stopUpgradeCheckTimer() {
        if (null != this.upgradeTimer) {
            this.upgradeTimer.stopTimer();
            this.upgradeTimer = null;
        }
    }

    public void restrictedModeHint() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrameworkUtilities.getOutputManager().addMessage(ResCenter.RES.getString("RESTRICTED_MODE_LOGIN_HINT"));
            }
        });
    }

    public boolean checkCommandAreaDesc(DescContainer desc) {
        boolean result = false;
        String security = desc.getParasItemValue("security");
        if (security == null) {
            log.debug((Object)"security is not config");
            return true;
        }
        String objectClassName = desc.getParasItemValue("objectClassName");
        if (objectClassName == null) {
            objectClassName = desc.getParasItemValue("socName");
        }
        String appID = desc.getParasItemValue("appID");
        String accessID = desc.getParasItemValue("accessID");
        switch (Integer.valueOf(security)) {
            case 0: {
                result = false;
                break;
            }
            case 1: {
                result = true;
                break;
            }
            case 2: {
                result = true;
                break;
            }
            case 3: {
                result = CommandManager.getInstance().checkMoiNotRelated(objectClassName, appID, accessID);
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    public void stopHeartBeat() {
        HeartBeatManager.getInstance().stop();
    }

    private void setUnlockDlgAttribute() {
        FrameworkUtilities.getTerminalManager().setUsernameEnabled(true);
        FrameworkUtilities.getTerminalManager().setUserNameLength(32);
        UnlockDialog.setPasswordLength((int)100);
        FrameworkUtilities.getTerminalManager().setUnlockMessage(ResCenter.RES.getString("unlockDlgInfo"));
        FrameworkUtilities.getTerminalManager().setCapsLockTipEnabled(true);
        FrameworkUtilities.getTerminalManager().setRelativeCapsTipPosition(0.0);
    }

    public IPreExitAction getProductIPreExitActionInterface() {
        try {
            String productClassName = this.getSecurityConfig().getProductPreExitActionClassPath();
            if (null == productClassName || productClassName.isEmpty()) {
                return null;
            }
            Class<?> productClass = Class.forName(productClassName);
            IPreExitAction intf = (IPreExitAction)productClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            return intf;
        }
        catch (Exception e) {
            log.error((Object)"SecurityBaseModuleImpl | getProductIPreExitActionInterface with error.", (Throwable)e);
            return null;
        }
    }

    public short[] checkRight(Object[][] rightInfos) {
        return this.checkRight(rightInfos, false);
    }

    public short[] checkRightForSysMonitor(Object[][] rightInfos) {
        return this.checkRight(rightInfos, true);
    }

    private short[] checkRight(Object[][] rightInfos, boolean isSysMonitor) {
        short[] results;
        block5: {
            if (rightInfos == null) {
                return new short[0];
            }
            RightInfo[] rights = new RightInfo[rightInfos.length];
            for (int i = 0; i < rightInfos.length; ++i) {
                rights[i] = new RightInfo((String)rightInfos[i][0], (String)rightInfos[i][1], (String)rightInfos[i][2], (String)rightInfos[i][3]);
            }
            results = new short[rightInfos.length];
            try {
                int[] hasRights = isSysMonitor || SessionService.getInstance().isSystemRestricted() || SessionManager.getInstance().isIPassMode() ? RpcInvoker.getInstance().checkRight(rights) : AppRightAuthService.getInstance().checkRight(rights);
                for (int i = 0; i < results.length; ++i) {
                    results[i] = (short)hasRights[i];
                }
            }
            catch (Exception e) {
                if (GuiUtilForBase.handleException(e)) break block5;
                log.error((Object)"SecurityBaseModuelImpl | checkRight with error.", (Throwable)e);
            }
        }
        return results;
    }

    public String getCurrentUserName() {
        return SessionManager.getInstance().getCurUserName();
    }

    public boolean changePassword() {
        return SessionManager.getInstance().changePassword();
    }

    public Object[] getSecurityInfo() {
        Object[] securityObjects;
        block2: {
            securityObjects = new Object[3];
            try {
                securityObjects[0] = SessionManager.getInstance().getServerIP();
                securityObjects[1] = Integer.valueOf(SessionManager.getInstance().getServerPort());
                securityObjects[2] = SessionManager.getInstance().getCurrentSession().getSessionID();
            }
            catch (Exception ex) {
                if (GuiUtilForBase.handleException(ex)) break block2;
                log.error((Object)"SecurityBaseModuleImpl | getSecurityInfo with error. ", (Throwable)ex);
            }
        }
        return securityObjects;
    }

    public void handleModeSwitch(int waitSeconds) {
        GuiUtilForBase.handleModeSwitch(waitSeconds);
    }

    public void handleKickoutCondition(String kickUser) {
        GuiUtilForBase.handleKickoutCondition(kickUser);
    }

    public void stop() {
    }

    public void lowPriorityInitAfterLoaded() {
        this.setServerInfoInTitle();
        this.getSecurityPolicyFromServer();
    }

    private void getSecurityPolicyFromServer() {
        int autoLockMins = PolicyService.getInstance().getPolicyValue("AutoLockMins");
        PolicyService.saveGlobalAutoLockTimeToLocal(autoLockMins);
        log.info((Object)("load from server, globalAutoLockMins = " + autoLockMins));
    }

    private void setStatusBar() {
        this.getStatusBarSettingProxy().showIPInfo();
        this.getStatusBarSettingProxy().showCurUserInfo();
        this.getStatusBarSettingProxy().showLoginTime();
        this.getStatusBarSettingProxy().setSystemModeStatus();
    }

    public void postSystemLoadingFinished() {
        this.setUnlockDlgAttribute();
        String isSpecificLoadingState = System.getProperty("SpecificLoadingState");
        if ((null == isSpecificLoadingState || !isSpecificLoadingState.equals("1")) && this.isUpgradeModuleLoaded()) {
            this.startUpgradeCheckTimer();
        }
        this.initLoginFailSoundSetting();
        this.menuSpecHandle();
        GuiUtilForBase.isLoginFinished = true;
        this.getAutoLogoutManager().startTimer();
    }

    private void menuSpecHandle() {
        if (FrameworkCommandProcessor.LoadStyle.traditional == FrameworkCommandProcessor.getInstance().getUserLoadStyle()) {
            MenuManager mm = FrameworkUtilities.getMenuManager();
            String isSpecificLoadingState = System.getProperty("SpecificLoadingState");
            if (null != isSpecificLoadingState && isSpecificLoadingState.equals("1")) {
                mm.removeMenuItem("mainMenu", "Help", "UpgradeCheck");
            }
            boolean canChangePXX = SessionManager.getInstance().canChangePXX();
            SecurityBaseModuleImpl.setMenuEnabled(SecurityBaseModuleImpl.getMenuItemByCommand("authentication:Change password"), canChangePXX);
            try {
                WelcomeManager.getWorkbenchManager().setWelcomeButtonEnable("CHANGE_PASSWORD", canChangePXX);
            }
            catch (Exception e) {
                log.error((Object)"set welcome button CHANGE_PASSWORD failed", (Throwable)e);
            }
            SecurityBaseModuleImpl.setMenuEnabled(SecurityBaseModuleImpl.getMenuItemByCommand("authentication:SWITCH_LOGIN_SERVER"), LoginUIConfig.getInstance().getLoginType() != 2);
            SecurityBaseModuleImpl.setMenuEnabled(SecurityBaseModuleImpl.getMenuItemByCommand("lm:Enable_License"), SessionService.getInstance().isAdminUserGroup() || SessionService.getInstance().isSecurityMgrGroupUser());
            if (SessionManager.getInstance().isSystemRestricted()) {
                SecurityBaseModuleImpl.setMenuEnabled(SecurityBaseModuleImpl.getMenuItemByCommand("securitymodule:showExportUserAndGroupInfoDialog"), false);
                SecurityBaseModuleImpl.setMenuEnabled(SecurityBaseModuleImpl.getMenuItemByCommand("securitymodule:showImportUserAndGroupInfoDialog"), false);
            } else if (!SessionManager.getInstance().enableUserManager() && !SessionManager.getInstance().isLocalLoginMode()) {
                SecurityBaseModuleImpl.setMenuEnabled(SecurityBaseModuleImpl.getMenuItemByCommand("securitymodule:showExportUserAndGroupInfoDialog"), SessionService.getInstance().isSecurityMgrGroupUser());
                SecurityBaseModuleImpl.setMenuEnabled(SecurityBaseModuleImpl.getMenuItemByCommand("securitymodule:showImportUserAndGroupInfoDialog"), false);
            } else {
                SecurityBaseModuleImpl.setMenuEnabled(SecurityBaseModuleImpl.getMenuItemByCommand("securitymodule:showExportUserAndGroupInfoDialog"), SessionService.getInstance().isSecurityMgrGroupUser());
                SecurityBaseModuleImpl.setMenuEnabled(SecurityBaseModuleImpl.getMenuItemByCommand("securitymodule:showImportUserAndGroupInfoDialog"), SessionService.getInstance().isSecurityMgrGroupUser());
            }
        }
    }

    private static void setMenuEnabled(MenuItem menu, boolean enable) {
        if (null == menu) {
            return;
        }
        menu.setAbsoluteEnabled(Boolean.valueOf(enable));
        SecurityBaseModuleImpl.setEnabled(menu, enable);
    }

    private static void setEnabled(final MenuItem item, final boolean isEnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            item.setEnabled(isEnable);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    item.setEnabled(isEnable);
                }
            });
        }
    }

    private static MenuItem getMenuItemByCommand(String command) {
        ArrayList list = CommandManager.getInstance().getAbstractButton(command);
        if (list == null || list.isEmpty()) {
            log.info((Object)("nofound:" + command));
        } else {
            Object obj = list.get(0);
            if (obj instanceof MenuItem) {
                return (MenuItem)obj;
            }
            log.info((Object)("isnotmenuitem:" + command));
        }
        return null;
    }

    protected void showHistoryLoginInfoDialog() {
        if (this.getSecurityConfig().isBShowLoginInfo()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    log.info((Object)"showHistoryLoginInfoDlg");
                    HistoryLoginInfoDlg dlg = new HistoryLoginInfoDlg(ResCenter.getInstance(), SecurityBaseModule.getSecuityModuleRef().getSessionManager());
                    if (FrameworkCommandProcessor.getInstance().isLogin()) {
                        GuiUtilForBase.displayCentered(dlg);
                    }
                }
            });
        }
    }

    private boolean isUpgradeModuleLoaded() {
        boolean isUpgradeModuleLodaded = true;
        try {
            this.baseModule.getLocalModule("UpgradeSettingModule", false);
        }
        catch (Exception e) {
            log.info((Object)" UpgradeSettingModule is not loaded. ");
            isUpgradeModuleLodaded = false;
        }
        return isUpgradeModuleLodaded;
    }

    private void initLoginFailSoundSetting() {
        try {
            ISoundSettingModule soundSettingModule = (ISoundSettingModule)this.baseModule.getLocalReference("com.swimap.sound");
            soundSettingModule.addSoundManager((SoundManager)LoginFailSoundManager.getInstance());
        }
        catch (ModuleManagementException e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public void initSystemModeSetting() {
        try {
            SystemSettingsManager ssm = FrameworkUtilities.getSystemSettingsManager();
            this.systemModeID = ssm.addClientModuleSettings("com.swimap.sm.client.base.systemmode.SysModeSetting", "SysModeSetting");
        }
        catch (Exception e) {
            log.error((Object)"SecurityBaseModuleImpl | initSystemModeSetting with error.", (Throwable)e);
        }
    }

    private void removeUpgradeSetting() {
        try {
            SystemSettingsManager ssm = FrameworkUtilities.getSystemSettingsManager();
            ssm.removeSetting(this.upgradeSettingID);
            this.stopUpgradeCheckTimer();
        }
        catch (Exception e) {
            log.error((Object)"SecurityBaseModuleImpl | removeUpgradeSetting with error.", (Throwable)e);
        }
    }

    private void removeSystemModeSetting() {
        try {
            SystemSettingsManager ssm = FrameworkUtilities.getSystemSettingsManager();
            ssm.removeSetting(this.systemModeID);
        }
        catch (Exception e) {
            log.error((Object)"SecurityBaseModuleImpl | removeSystemModeSetting with error.", (Throwable)e);
        }
    }

    private void removeAutoSettings() {
        try {
            SystemSettingsManager ssm = FrameworkUtilities.getSystemSettingsManager();
            ssm.removeSetting(this.autoLoginSettingID);
        }
        catch (Exception e) {
            log.error((Object)"SecurityBaseModuleImpl | removeAutoSettings with error.", (Throwable)e);
        }
    }

    public void handleInvalidTokenException(String tokenInvalidError) {
        GuiUtilForBase.handleInvalidTokenException(tokenInvalidError);
    }

    private void loadServerAuthConf() {
        SessionManager.getInstance().getServerAuthConf();
    }

    public boolean isLocalLoginMode() {
        return SessionManager.getInstance().isLocalLoginMode();
    }

    public boolean canSycnRemoteUserGroup() {
        return SessionManager.getInstance().canSycnRemoteUserGroup();
    }

    public boolean enableUserManager() {
        return SessionManager.getInstance().enableUserManager();
    }

    public int getLoginOrUnlockFailedDelayTime() {
        int delay = 0;
        try {
            delay = RpcInvoker.getInstance().getInvaildLoginDelayTimePolicy();
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        return delay;
    }

    private boolean isValidSSLPath(String SSLPath) {
        try {
            File sslpath = new File(SSLPath);
            return sslpath.exists() && sslpath.isDirectory();
        }
        catch (Exception e) {
            log.error((Object)"SecurityBaseModuleImpl | checkSSLPath error", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login(String userName, char[] imtInfo, String terminal, String[] curIPPort, String curIPName) throws Exception {
        try {
            boolean isStLogin = false;
            boolean result = this.enterLogin(userName, imtInfo, terminal, isStLogin);
            if (!SessionManager.getInstance().isLogout()) {
                this.dealSessionAndRpc(userName, curIPPort, curIPName, result);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.doThingAferLogin(imtInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loginByST(String userName, char[] stInfo, String terminal, String[] curIPPort, String curIPName) throws Exception {
        try {
            boolean isStLogin = true;
            boolean result = this.enterLogin(userName, stInfo, terminal, isStLogin);
            this.dealSessionAndRpc(userName, curIPPort, curIPName, result);
            boolean bl = result;
            return bl;
        }
        finally {
            this.doThingAferLogin(stInfo);
        }
    }

    public boolean checkBeforeLogin(String[] curIPPort, String curIPName) throws Exception {
        if (!this.setSslCertificatesPath(curIPPort)) {
            return false;
        }
        return this.checkThingBeforeLogin(curIPPort, curIPName);
    }

    private void doThingAferLogin(char[] imtInfo) {
        SecurityRedLineUtil.clearArray((char[])imtInfo);
        if (SessionManager.getInstance().isLogout()) {
            return;
        }
        DoubleHostSwitchHandler handler = DoubleHostSwitchHandler.getResumeTimeoutHandler();
        if (null != handler) {
            handler.setSwitchFinish();
        }
    }

    private void dealSessionAndRpc(String userName, String[] curIPPort, String curIPName, boolean result) {
        if (!result) {
            RpcRequest.getSocketClient().close(RpcNaming.getURL());
        } else {
            securiyShakehandListener = new RpcStatusListener(ActivateSessionHandler.createAndRegisterActivateSessionHandler(SessionManager.getInstance().getSecurityToken()), DoubleHostSwitchHandler.createDoudleHostSwitchHandler(SessionManager.getInstance(), curIPName, curIPPort[0], userName, Integer.valueOf(curIPPort[1]), curIPPort[2]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enterLogin(String userName, char[] imtInfo, String terminal, boolean isStLogin) throws Exception {
        try {
            SetLoginInfoToProduct.getInstance().initSetStatus();
            byte[] tmp = CryptUtil.transferPassword(imtInfo);
            boolean result = false;
            DoubleHostSwitchHandler handler = DoubleHostSwitchHandler.getResumeTimeoutHandler();
            if (null != handler && handler.isSwitching()) {
                result = SessionManager.getInstance().getLoginInfo(handler.getToken(), terminal);
            } else {
                int clientType = LoginUIConfig.getInstance().getClientType();
                boolean bl = result = SessionManager.getInstance().login(userName, tmp, terminal, clientType, isStLogin) != null;
                if (result) {
                    SetLoginInfoToProduct.getInstance().set(userName, imtInfo, false);
                }
            }
            boolean bl = result;
            return bl;
        }
        finally {
            SecurityRedLineUtil.clearArray((char[])imtInfo);
        }
    }

    private boolean checkThingBeforeLogin(String[] curIPPort, String curIPName) throws Exception {
        GuiUtilForBase.resetExitFlag();
        List<IChecker> checkerList = CheckerFactory.getInstance().getCheckers(curIPPort, curIPName);
        for (IChecker checker : checkerList) {
            if (checker.check()) continue;
            RpcRequest.getSocketClient().close(RpcNaming.getURL());
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean setSslCertificatesPath(String[] curIPPort) {
        boolean isSupportSSL = curIPPort[2].equals("sslservermode");
        if (isSupportSSL) {
            String sslPath = "";
            if (curIPPort.length > 4) {
                sslPath = curIPPort[4];
            }
            if (null == sslPath || sslPath.trim().equals("")) {
                System.setProperty("imap.sslCertificatesPath", "");
            } else {
                if (!this.isValidSSLPath(sslPath)) {
                    OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.getInstance().getString("SSLPATH_NOT_EXIST"));
                    return false;
                }
                System.setProperty("imap.sslCertificatesPath", sslPath);
            }
        } else {
            System.setProperty("imap.sslCertificatesPath", "");
        }
        log.info((Object)("SecurityBaseModuleImpl | login | System.getProperty(imap.sslCertificatesPath) is " + System.getProperty("imap.sslCertificatesPath")));
        return true;
    }

    public void reinitialize() {
        try {
            this.setStatusBar();
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public class RpcStatusListener
    implements SocketClient.ConnectionStatusListener {
        private ActivateSessionHandler activateSessionHandler = null;
        private DoubleHostSwitchHandler doubleHostSwitchHandler = null;

        public RpcStatusListener(ActivateSessionHandler activateSessionHandler, DoubleHostSwitchHandler doubleHostSwitchHandler) {
            this.activateSessionHandler = activateSessionHandler;
            this.doubleHostSwitchHandler = doubleHostSwitchHandler;
        }

        public void stopResume() {
            this.activateSessionHandler.setStopResume();
        }

        public void connectionBroken(URI arg0) {
            GuiUtilForBase.setToBeingExit();
            log.info((Object)"Receive connection broken.");
            if (FrameworkCommandProcessor.getInstance().isLogin()) {
                this.activateSessionHandler.setStopResume();
                LogoutDlg.show((String)"Test_Reconnet_Server");
            }
        }

        public void connectionResumed(URI arg0) {
            this.connectionResumed(arg0, true);
        }

        public void connectionResumed(URI arg0, boolean isShowDialog) {
            GuiUtilForBase.resetExitFlag();
            log.info((Object)"Receive connection resumed.");
            if (FrameworkCommandProcessor.getInstance().isLogin()) {
                try {
                    log.info((Object)"sendHeartBeat.");
                    RpcInvoker.getInstance().sendHeartBeat();
                }
                catch (RpcErrorSecurity app) {
                    log.info((Object)(" Error while sending heart beat. " + (Object)((Object)app)), (Throwable)app);
                    GuiUtilForBase.handleInvalidTokenException(app.getMessage());
                }
                catch (Exception e) {
                    log.info((Object)"", (Throwable)e);
                }
                if (isShowDialog) {
                    LogoutDlg.close();
                }
                try {
                    int localAuthMode = SessionManager.getInstance().getLoginMode();
                    int asAuthMode = -1;
                    try {
                        asAuthMode = RpcInvoker.getInstance().getServerAuthConf().getLoginMode();
                    }
                    catch (RpcErrorSecurity e) {
                        log.error((Object)"", (Throwable)e);
                        GuiUtilForBase.handleInvalidTokenException(e.getMessage());
                        return;
                    }
                    catch (Exception e) {
                        log.error((Object)"", (Throwable)e);
                        return;
                    }
                    GuiUtilForBase.handleAuthModeChanged(asAuthMode, localAuthMode);
                    GuiUtilForBase.setStatusBarWhenSysModeChange();
                }
                catch (Exception e) {
                    log.error((Object)"", (Throwable)e);
                }
            }
        }

        public void reconnectCountout(URI arg0) {
            log.info((Object)"Receive connection count out.");
            if (this.doubleHostSwitchHandler.isSingleHost()) {
                LogoutDlg.show((String)"Reach_Reconnect_Wait_Time");
                return;
            }
            SecurityBaseModuleImpl.removeConnectionStatusListener();
            RpcRequest.getSocketClient().close(RpcNaming.getURL());
            if (this.doubleHostSwitchHandler.connectSecondHostForTimeout() && this.doubleHostSwitchHandler.startSwitchHost()) {
                log.info((Object)("removeConnectionStatusListener begin:" + this));
                RpcRequest.getSocketClient().removeConnectionStatusListener((SocketClient.ConnectionStatusListener)this);
                RpcRequest.getSocketClient().setResumeAction(null);
                log.info((Object)("removeConnectionStatusListener end:" + this));
            }
        }

        public void restartService(URI arg0) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void statusChange(URI arg0, SocketClient.ConnectionStatus status) {
            RpcStatusListener rpcStatusListener = this;
            synchronized (rpcStatusListener) {
                log.warn((Object)status);
                if (status == SocketClient.ConnectionStatus.BROKEN) {
                    this.connectionBroken(arg0);
                }
                if (status == SocketClient.ConnectionStatus.RESUMED || status == SocketClient.ConnectionStatus.RESTART) {
                    this.connectionResumed(arg0);
                }
                if (status == SocketClient.ConnectionStatus.RESUMEDIMMEDIATELY) {
                    this.connectionResumed(arg0, true);
                }
                if (status == SocketClient.ConnectionStatus.RECONNECTIONCOUNTOUT) {
                    this.reconnectCountout(arg0);
                }
            }
        }
    }
}

