/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base;

import com.swimap.external.dsf.base.rpc.RpcNaming;
import com.swimap.external.dsf.base.rpc.RpcRequest;
import com.swimap.external.sm.client.base.OSSDebugGuideAPI;
import com.swimap.external.sm.client.base.product.interfaces.IOperation;
import com.swimap.external.sm.client.base.product.interfaces.IPreExitAction;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.InternalLocalMsg;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.sm.client.base.AuthorizationService;
import com.swimap.sm.client.base.OSSDebugGuideAPIForBase;
import com.swimap.sm.client.base.SecurityBaseModuleImpl;
import com.swimap.sm.client.base.SessionService;
import com.swimap.sm.client.base.StatusBarSettingProxy;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.auth.SessionManager;
import com.swimap.sm.client.base.auth.checker.InitCommunicationChecker;
import com.swimap.sm.client.base.autologout.AutoLogoutManager;
import com.swimap.sm.client.base.checkright.SecurityRightManager;
import com.swimap.sm.client.base.common.CryptUtil;
import com.swimap.sm.client.base.common.GuiUtilForBase;
import com.swimap.sm.client.base.common.OptionPaneProxy4SmBase;
import com.swimap.sm.client.base.common.RpcInvoker;
import com.swimap.sm.client.base.config.SecurityConfig;
import com.swimap.sm.client.base.event.LogEventDispatch;
import com.swimap.sm.client.base.event.SMEventDispatch;
import com.swimap.sm.client.base.policy.service.PolicyService;
import com.swimap.sm.client.base.product.interfaces.ICheckCommandAreaDesc;
import com.swimap.sm.client.base.product.interfaces.ILogin;
import com.swimap.sm.client.base.switchlogin.SwitchLoginServerDlg;
import com.swimap.sm.client.base.upgradecheck.UpgradeCheckTool;
import com.swimap.sm.client.loginui.auth.CheckableBeforeLogin;
import com.swimap.sm.client.loginui.auth.ILoginByStHandler;
import com.swimap.sm.client.loginui.auth.ILoginHandler;
import com.swimap.sm.client.loginui.delay.ILoginDelayTime;
import java.awt.Component;
import java.util.ResourceBundle;

public class SecurityBaseModule
extends BaseModule
implements ILoginHandler,
ILoginDelayTime,
ILoginByStHandler,
CheckableBeforeLogin {
    private static SecurityBaseModule secuityBaseModule;
    private SecurityBaseModuleImpl moduleImpl = null;
    protected static final String MODULENAME = "authentication";
    private Object lock = new Object();
    private ICheckCommandAreaDesc msgadpChecker = null;

    public boolean login(String userName, char[] imtInfo, String terminal, String[] curIPPort, String curIPName) throws Exception {
        return this.getModuleImpl().login(userName, imtInfo, terminal, curIPPort, curIPName);
    }

    public boolean loginByST(String userName, char[] stInfo, String terminal, String[] curIPPort, String curIPName) throws Exception {
        return this.getModuleImpl().loginByST(userName, stInfo, terminal, curIPPort, curIPName);
    }

    public boolean checkBeforeLogin(String[] curIPPort, String curIPName) throws Exception {
        return this.getModuleImpl().checkBeforeLogin(curIPPort, curIPName);
    }

    public SecurityBaseModule(ModuleManager moduleMgr) throws ModuleManagementException {
        super(moduleMgr);
        secuityBaseModule = this;
        com.swimap.external.sm.client.base.SessionService.getInstance().setSessionServiceImpl(SessionService.getInstance());
        com.swimap.external.sm.client.base.AuthorizationService.getInstance().setAuthorizationServiceImpl(AuthorizationService.getInstance());
        com.swimap.external.sm.client.base.PolicyService.getInstance().setPolicyMgrImpl(PolicyService.getInstance());
        OSSDebugGuideAPI.getInstance().setOSSDebugGuideAPIImpl(OSSDebugGuideAPIForBase.getInstance());
    }

    public String getModuleName() {
        return MODULENAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityBaseModuleImpl getModuleImpl() {
        if (this.moduleImpl == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.moduleImpl == null) {
                    this.moduleImpl = new SecurityBaseModuleImpl(secuityBaseModule);
                }
            }
        }
        return this.moduleImpl;
    }

    public static SecurityBaseModule getSecuityModuleRef() {
        return secuityBaseModule;
    }

    public void registerMsgAdpCheckCommandAreaDesc(ICheckCommandAreaDesc msgadpChecker) {
        this.msgadpChecker = msgadpChecker;
    }

    public boolean checkCommandAreaDesc(DescContainer desc) {
        String operationID;
        if (this.msgadpChecker != null && (operationID = desc.getParasItemValue("operationID")) != null) {
            return this.msgadpChecker.check(desc);
        }
        return this.getModuleImpl().checkCommandAreaDesc(desc);
    }

    public short[] checkRight(Object[][] rightInfos) {
        return this.getModuleImpl().checkRight(rightInfos);
    }

    public short[] checkRightForSysMonitor(Object[][] rightInfos) {
        return this.getModuleImpl().checkRightForSysMonitor(rightInfos);
    }

    public Object[] getSecurityInfo() {
        return this.getModuleImpl().getSecurityInfo();
    }

    public SecurityRightManager getSecurityRightManager() {
        return this.getModuleImpl().getSecurityRightManager();
    }

    public AutoLogoutManager getAutoLogoutManager() {
        return this.getModuleImpl().getAutoLogoutManager();
    }

    public String getUsername() {
        return this.getModuleImpl().getCurrentUserName();
    }

    public boolean postLogin() {
        return this.getModuleImpl().postLogin();
    }

    public boolean logout() {
        boolean result = this.getModuleImpl().logout();
        AuthorizationService.setInstanceNull();
        this.moduleImpl = null;
        return result;
    }

    public boolean changePassword() {
        return this.getModuleImpl().changePassword();
    }

    public boolean verifyPassword(char[] imfInfo) {
        return this.getModuleImpl().verifyPassword(imfInfo);
    }

    public void stopHeartBeat() {
        this.getModuleImpl().stopHeartBeat();
    }

    public ILogin getProductILgoinInterface() {
        return SessionManager.getInstance().getProductILgoinInterface();
    }

    public IPreExitAction getProductIPreExitActionInterface() {
        return this.getModuleImpl().getProductIPreExitActionInterface();
    }

    public SecurityConfig getSecurityConfig() {
        return this.getModuleImpl().getSecurityConfig();
    }

    public SessionManager getSessionManager() {
        return SessionManager.getInstance();
    }

    public SMEventDispatch getSMEventDispatch() {
        return this.getModuleImpl().getSMEventDispatch();
    }

    public LogEventDispatch getLogEventDispatch() {
        return this.getModuleImpl().getLogEventDisptch();
    }

    public IOperation getOperationIntf() {
        return null;
    }

    public StatusBarSettingProxy getStatusBarSettingProxy() {
        return this.getModuleImpl().getStatusBarSettingProxy();
    }

    public void handleModeSwitch(int waitSeconds) {
        this.getModuleImpl().handleModeSwitch(waitSeconds);
    }

    public void handleKickoutCondition(String kickUser) {
        this.getModuleImpl().handleKickoutCondition(kickUser);
    }

    public void stop() {
        this.getModuleImpl().stop();
        AuthorizationService.setInstanceNull();
        this.moduleImpl = null;
    }

    public String getVersionID() {
        return Main.instance().getVersionID();
    }

    public int showOptionPane(Component component, String context, String title) {
        return OptionPaneProxy4SmBase.showConfirmDlgFocOnNo(component, context);
    }

    public ResourceBundle getResourceBundleFromPropertyFile(String path) {
        return ResourceMng.getInstance().getResourceBundleFromPropertyFile(path);
    }

    public void upgradeCheck() {
        UpgradeCheckTool tool = new UpgradeCheckTool(RpcInvoker.getInstance(), ResCenter.getInstance());
        tool.upgradeCheck(false);
    }

    public void switchLoginServer() {
        SwitchLoginServerDlg dlg = new SwitchLoginServerDlg();
        ScreenToolKit.centerLocateToScreen((Component)dlg);
        dlg.setVisible(true);
    }

    public void handleInvalidTokenException(String tokenValidError) {
        this.getModuleImpl().handleInvalidTokenException(tokenValidError);
    }

    public byte[] getSecurityToken() {
        return this.getSessionManager().getSecurityToken();
    }

    public boolean isLocalLoginMode() {
        return this.getModuleImpl().isLocalLoginMode();
    }

    public boolean canSycnRemoteUserGroup() {
        return this.getModuleImpl().canSycnRemoteUserGroup();
    }

    public boolean isSupportSynchronizeUserGroup() {
        if (this.canSycnRemoteUserGroup()) {
            return SessionService.getInstance().isAdminUser() || SessionService.getInstance().isSecurityMgrGroupUser() && SessionManager.getInstance().isRemoteLoginSuccess();
        }
        return false;
    }

    public boolean enableUserManager() {
        return this.getModuleImpl().enableUserManager();
    }

    public int getLoginOrUnlockFailedDelayTime() {
        return this.getModuleImpl().getLoginOrUnlockFailedDelayTime();
    }

    protected void lowPriorityInitAfterLoaded() {
        this.getModuleImpl().lowPriorityInitAfterLoaded();
    }

    protected void postSystemLoadingFinished() {
        this.getModuleImpl().postSystemLoadingFinished();
    }

    public Object processEvent(InternalLocalMsg oMsg) {
        if (oMsg.equals((Object)InternalLocalMsg.MSG_LOAD_FINISH)) {
            this.getModuleImpl().showHistoryLoginInfoDialog();
        }
        return null;
    }

    public int getLoginAuthMode() {
        return SessionManager.getInstance().getLoginAuthMode();
    }

    public String ssoLogin(String userName, char[] imfInfo, String terminal, String[] curIPPort, String curIPName) throws Exception {
        byte[] imtInfo;
        String key = null;
        SessionManager sessionMgr = SecurityBaseModule.getSecuityModuleRef().getSessionManager();
        InitCommunicationChecker checker = new InitCommunicationChecker(sessionMgr, curIPPort, GuiUtilForBase.getInstance(), curIPName);
        if (checker.check() && (imtInfo = CryptUtil.transferPassword(imfInfo)) != null) {
            key = SessionManager.getInstance().ssoLogin(userName, imtInfo, terminal);
        }
        if (key == null) {
            RpcRequest.getSocketClient().close(RpcNaming.getURL());
        }
        return key;
    }

    public void reinitialize() {
        this.getModuleImpl().reinitialize();
    }
}

