/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.sm.client.base;

import com.swimap.external.sm.client.base.IAuthorizationService;
import com.swimap.external.sm.client.base.common.model.RightInfo;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.sm.client.base.SecurityBaseModule;
import com.swimap.sm.client.base.SessionService;
import com.swimap.sm.client.base.auth.ResCenter;
import com.swimap.sm.client.base.checkright.SecurityRightManager;
import com.swimap.sm.client.base.common.OptionPaneProxy4SmBase;
import javax.swing.SwingUtilities;

public final class AuthorizationService
implements IAuthorizationService {
    private static AuthorizationService instance = new AuthorizationService();
    private SecurityRightManager rightManager = SecurityBaseModule.getSecuityModuleRef().getSecurityRightManager();

    private AuthorizationService() {
    }

    public static AuthorizationService getInstance() {
        if (null == instance) {
            instance = new AuthorizationService();
        }
        return instance;
    }

    public static void setInstanceNull() {
        instance = null;
    }

    @Override
    public boolean[] checkRight(RightInfo[] rightInfos) throws Exception {
        int[] tmpResults = this.rightManager.checkRight(rightInfos);
        boolean[] results = new boolean[tmpResults.length];
        for (int i = 0; i < results.length; ++i) {
            results[i] = tmpResults[i] == 1;
        }
        return results;
    }

    public int[] checkRightWithErrorCode(RightInfo[] rightInfos) throws Exception {
        return this.rightManager.checkRight(rightInfos);
    }

    public boolean hasSMRight() {
        return SessionService.getInstance().isSecurityMgrGroupUser() || SessionService.getInstance().isSSAUser();
    }

    public boolean hasSMRightWillPrompt() {
        if (this.hasSMRight()) {
            return true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OptionPaneProxy4SmBase.showInformationDlg(FrameworkUtilities.getMainFrame(), ResCenter.getInstance().getString("errexcrigtxt0"));
            }
        });
        return false;
    }
}

