/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.sm.client.base.common.model;

import com.swimap.external.sm.client.base.common.Constants;
import com.swimap.external.sm.client.base.common.model.BaseInfo;
import com.swimap.external.sm.client.base.common.model.SimpleDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class UserInfo
extends BaseInfo {
    public int id;
    public String fullName;
    public int userType;
    public byte[] imtInfo;
    public Calendar startloginDurationDate;
    public Calendar endloginDurationDate;
    public Calendar startloginDurationTime;
    public Calendar endloginDurationTime;
    public SimpleDateTime loginStartDate;
    public SimpleDateTime loginStartTime;
    public SimpleDateTime loginEndDate;
    public SimpleDateTime loginEndTime;
    public int[] durationWeekDays = new int[7];
    public boolean accountValidity;
    public boolean ignoreDurationFlag;
    public boolean lockFlag;
    public int pwdValidDays;
    public boolean bONLine;
    public long loginTime;
    public long logoutTime;
    public String terminalID;
    public long pwdChangeDate;
    public short pwdStatus;
    public boolean isAutoLogout;
    public int inactiveTime;
    public boolean isStartInactivePolicy;
    public int inactivePolicyAction;
    public int inactivePolicyDay;
    public int maxOnlineCount = -1;
    public int privateGroupId;

    public UserInfo(int _id, String _name, String _des, int _type, byte[] _imtInfo, Calendar _startloginDurationDat, Calendar _endloginDurationDat, Calendar _startloginDurationTim, Calendar _endloginDurationTim, int[] _durationWeekDays_, boolean _valid, boolean _ignoreDurationFlag, boolean _lockFlag, int _maxPwdValidDays, short _pwdStatus) {
        super(12, _name, _des);
        this.id = _id;
        this.name = _name;
        this.description = _des;
        this.userType = _type;
        this.imtInfo = _imtInfo;
        this.startloginDurationDate = _startloginDurationDat;
        this.endloginDurationDate = _endloginDurationDat;
        this.startloginDurationTime = _startloginDurationTim;
        this.endloginDurationTime = _endloginDurationTim;
        this.durationWeekDays = _durationWeekDays_;
        this.accountValidity = _valid;
        this.ignoreDurationFlag = _ignoreDurationFlag;
        this.lockFlag = _lockFlag;
        this.pwdValidDays = _maxPwdValidDays;
        this.pwdStatus = _pwdStatus;
        this.isAutoLogout = false;
        this.inactiveTime = Constants.UserAccount.AUTOLOGOUT_DEFAULT_TIME;
    }

    public UserInfo(int _id, String _name, String _des, int _type, byte[] _imtInfo, Calendar _startloginDurationDat, Calendar _endloginDurationDat, Calendar _startloginDurationTim, Calendar _endloginDurationTim, int[] _durationWeekDays_, boolean _valid, boolean _ignoreDurationFlag, boolean _lockFlag, int _maxPwdValidDays, boolean _bONLine, long _loginTime, long _logoutTime, String _terminalID, long _changePwdDate, short _pwdStatus) {
        this(_id, _name, _des, _type, _imtInfo, _startloginDurationDat, _endloginDurationDat, _startloginDurationTim, _endloginDurationTim, _durationWeekDays_, _valid, _ignoreDurationFlag, _lockFlag, _maxPwdValidDays, _pwdStatus);
        this.bONLine = _bONLine;
        this.loginTime = _loginTime;
        this.logoutTime = _logoutTime;
        this.terminalID = _terminalID;
        this.pwdChangeDate = _changePwdDate;
    }

    public UserInfo() {
    }

    public UserInfo(int _id, String _name) {
        this.id = _id;
        this.name = _name;
        this.fullName = "";
        this.description = "";
        this.type = 0;
        this.imtInfo = new byte[0];
        this.startloginDurationDate = null;
        this.endloginDurationDate = null;
        this.startloginDurationTime = null;
        this.endloginDurationTime = null;
        this.durationWeekDays = new int[0];
        this.accountValidity = false;
        this.ignoreDurationFlag = false;
        this.lockFlag = false;
        this.pwdValidDays = 0;
        this.pwdStatus = 0;
        this.bONLine = true;
        this.loginTime = 0L;
        this.logoutTime = 0L;
        this.terminalID = "";
        this.pwdChangeDate = 0L;
    }

    public UserInfo(int _id, int nodeType, String _name) {
        this(_id, _name);
        this.type = nodeType;
    }

    public UserInfo clone(UserInfo info) {
        UserInfo userInfo = new UserInfo(info.id, info.name, info.description, info.userType, info.imtInfo, (GregorianCalendar)info.startloginDurationDate.clone(), (GregorianCalendar)info.endloginDurationDate.clone(), (GregorianCalendar)info.startloginDurationTime.clone(), (GregorianCalendar)info.endloginDurationTime.clone(), info.durationWeekDays, info.accountValidity, info.ignoreDurationFlag, info.lockFlag, info.pwdValidDays, info.pwdStatus);
        userInfo.logoutTime = info.logoutTime;
        userInfo.loginTime = info.loginTime;
        userInfo.terminalID = info.terminalID;
        userInfo.pwdChangeDate = info.pwdChangeDate;
        userInfo.bONLine = info.bONLine;
        return userInfo;
    }

    public Integer getKey() {
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public String getUserName() {
        return this.name;
    }

    public String getFullUserName() {
        return this.fullName;
    }

    public int getUserType() {
        return this.userType;
    }

    public void setUserType(int userType) {
        this.userType = userType;
    }

    public boolean isSuperUser() {
        return this.userType == 1;
    }

    public boolean isRemoteUser() {
        return this.userType == 3;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public void setFullName(String fullname) {
        this.fullName = fullname;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + this.id;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserInfo other = (UserInfo)obj;
        return this.id == other.id;
    }
}

