/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.external.sm.client.base.common.model;

import com.swimap.external.dsf.base.rpc.DataRecord;
import com.swimap.external.dsf.base.rpc.DataTable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class AccBit {
    public int segment;
    public int[] bits = new int[4];
    private static final int BITS_OF_INT = 32;
    private static final int X_ONE = 1;

    public AccBit() {
    }

    public AccBit(int[] _bits, int _seg) {
        this.bits = _bits;
        this.segment = _seg;
    }

    public List<Integer> toBitSites() {
        return AccBit.toBitSites(this);
    }

    public boolean hasRight(int bitSite) {
        return AccBit.segment(bitSite) == this.segment && bitSite != 0 && AccBit.hasRight(this, bitSite);
    }

    public boolean addBit(int bitSite) {
        if (AccBit.segment(bitSite) != this.segment || bitSite == 0) {
            return false;
        }
        bitSite = AccBit.site(bitSite);
        int segment = bitSite - 1 >> 5;
        int site = bitSite - 1 & 0x1F;
        int n = segment;
        this.bits[n] = this.bits[n] | 1 << site;
        return true;
    }

    public boolean unite(AccBit _accBit) {
        if (this.segment != _accBit.segment) {
            return false;
        }
        for (int i = 0; i < this.bits.length; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] | _accBit.bits[i];
        }
        return true;
    }

    public String toString() {
        return "AccBit: segment = " + this.segment + " bits = " + Arrays.toString(this.bits);
    }

    public static int segment(int bitSite) {
        return bitSite - 1 >> 7;
    }

    public static int site(int bitSite) {
        return (bitSite & 0x7F) == 0 ? 128 : bitSite & 0x7F;
    }

    public static boolean hasRight(AccBit[] _accBits, int bitSite) {
        boolean result = false;
        for (AccBit _accBit : _accBits) {
            if (_accBit.segment != AccBit.segment(bitSite)) continue;
            result = AccBit.hasRight(_accBit, bitSite);
            break;
        }
        return result;
    }

    private static boolean hasRight(AccBit _accBit, int bitSite) {
        int site;
        int segment = (bitSite = AccBit.site(bitSite)) - 1 >> 5;
        return (_accBit.bits[segment] & 1 << (site = bitSite - 1 & 0x1F)) != 0;
    }

    public static List<Integer> toBitSites(AccBit _accBit) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (int i = 0; i < _accBit.bits.length; ++i) {
            for (int j = 0; j < 32; ++j) {
                if (0 == (1 << j & _accBit.bits[i])) continue;
                list.add(j + 1 + (i << 5) + (_accBit.segment << 7));
            }
        }
        return list;
    }

    public static List<Integer> toBitSites(AccBit[] _accBits) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (AccBit accBit : _accBits) {
            list.addAll(AccBit.toBitSites(accBit));
        }
        return list;
    }

    public static List<AccBit> readTable(DataTable accBitTable) {
        LinkedList<AccBit> accBitList = new LinkedList<AccBit>();
        if (accBitTable == null) {
            return accBitList;
        }
        for (DataRecord record : accBitTable) {
            accBitList.add(new AccBit(record.getIntArray("bits"), record.getInt("segment")));
        }
        return accBitList;
    }

    public static DataTable createTable(AccBit[] accBits) {
        DataTable accBitTable = new DataTable("accbittable");
        accBitTable.setColumns(new String[]{"bits", "segment"});
        for (AccBit accBit : accBits) {
            accBitTable.add(new Object[]{accBit.bits, accBit.segment});
        }
        return accBitTable;
    }

    public static AccBit[] getAccessBits(List<Integer> acc) {
        LinkedList<AccBit> list = new LinkedList<AccBit>();
        HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
        for (int a : acc) {
            AccBit.getAccBitMap(map, a);
        }
        Set set = map.keySet();
        for (Integer key : set) {
            list.add(new AccBit((int[])map.get(key), key));
        }
        return list.toArray(new AccBit[0]);
    }

    private static void getAccBitMap(Map<Integer, int[]> map, int acc) {
        int seg = AccBit.segment(acc);
        int[] accBit = AccBit.constructAccessBit(AccBit.site(acc));
        if (seg < 0) {
            return;
        }
        if (map.containsKey(seg)) {
            int[] src = map.get(seg);
            AccBit.mergeBits(src, accBit);
        } else {
            map.put(seg, accBit);
        }
    }

    public static void mergeBits(int[] src, int[] tar) {
        if (src == null || tar == null || src.length != tar.length) {
            return;
        }
        int len = src.length;
        for (int i = 0; i < len; ++i) {
            int n = i;
            src[n] = src[n] | tar[i];
        }
    }

    private static int[] constructAccessBit(int bitSite) {
        int[] accessBit = new int[]{0, 0, 0, 0};
        if (0 == bitSite) {
            return accessBit;
        }
        int segment = (bitSite - 1) / 32;
        int site = (bitSite - 1) % 32;
        int n = segment;
        accessBit[n] = accessBit[n] | 1 << site;
        return accessBit;
    }

    public static AccBit getManagedAccBit() {
        return new AccBit(new int[]{1, 0, 0, 0}, 0);
    }

    public boolean equals(AccBit accBit) {
        boolean result = false;
        if (super.equals(accBit)) {
            result = true;
        } else if (this.segment == accBit.segment && accBit.bits.length == 4 && this.bits[0] == accBit.bits[0] && this.bits[1] == accBit.bits[1] && this.bits[2] == accBit.bits[2] && this.bits[3] == accBit.bits[3]) {
            result = true;
        }
        return result;
    }
}

