/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.te.toolkit;

import com.huawei.te.toolkit.AsnToolkitErrorSeqOf;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnToolkitError
implements FStruct {
    public BigInteger errCode;
    public byte[] reason = null;
    public AsnToolkitErrorSeqOf parameters = null;

    public AsnToolkitError() {
    }

    public AsnToolkitError(AsnToolkitError arg) {
        this.errCode = arg.errCode;
        if (arg.reason != null) {
            this.reason = new byte[arg.reason.length];
            System.arraycopy(arg.reason, 0, this.reason, 0, arg.reason.length);
        }
        if (arg.parameters != null) {
            this.parameters = new AsnToolkitErrorSeqOf(arg.parameters);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.errCode);
        if (this.reason != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.reason);
        }
        if (this.parameters != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            this.parameters.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.errCode = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.reason = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.parameters = new AsnToolkitErrorSeqOf();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.parameters.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("errCode = ");
        os.print(this.errCode.toString());
        os.println(',');
        if (this.reason != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("reason = ");
            os.print(FStruFormat.convertToString((byte[])this.reason));
            os.println(',');
        }
        if (this.parameters != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("parameters = ");
            this.parameters.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

