/*
 * Decompiled with CFR 0.152.
 */
package JACE.netsvcs.Token;

import JACE.OS.ACE;
import JACE.netsvcs.Handler;
import JACE.netsvcs.Token.LockHandler;
import JACE.netsvcs.Token.TokenAcceptor;
import JACE.netsvcs.Token.TokenReply;
import JACE.netsvcs.Token.TokenRequest;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Vector;

class TokenRequestHandler
extends Handler {
    private Vector clients_ = new Vector(10);
    private String lastTokenName_ = null;
    private String lastClientID_ = null;
    private LockHandler handler_ = null;

    @Override
    public Object newRequest() {
        return new TokenRequest();
    }

    protected void sendAbortMessage(TokenRequest tokenRequest) {
        TokenReply tokenReply = new TokenReply(5, tokenRequest.arg());
        try {
            tokenReply.streamOutTo(this.peer().dataOutputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized int close() {
        if (!this.done()) {
            TokenAcceptor tokenAcceptor = (TokenAcceptor)this.parent();
            Enumeration enumeration = this.clients_.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Enumeration enumeration2 = tokenAcceptor.getClientLockHandlers(string);
                if (enumeration2 == null) continue;
                int n = 0;
                while (enumeration2.hasMoreElements()) {
                    LockHandler lockHandler = (LockHandler)enumeration2.nextElement();
                    lockHandler.abandonLock(string);
                    ++n;
                }
                tokenAcceptor.removeClient(string);
            }
            return super.close();
        }
        return 0;
    }

    @Override
    public void processRequest(Object object) throws SocketException, EOFException, IOException {
        TokenRequest tokenRequest = (TokenRequest)object;
        TokenAcceptor tokenAcceptor = (TokenAcceptor)this.parent();
        try {
            tokenRequest.streamInFrom(this.peer().dataInputStream());
            if (!tokenRequest.tokenName().equals(this.lastTokenName_)) {
                this.handler_ = tokenAcceptor.getLockHandler(tokenRequest.tokenName(), tokenRequest.tokenType());
                if (this.handler_ == null) {
                    ACE.ERROR("Unknown lock type: " + tokenRequest.tokenType());
                    TokenReply tokenReply = new TokenReply(22, tokenRequest.arg());
                    tokenReply.streamOutTo(this.peer().dataOutputStream());
                    return;
                }
                tokenAcceptor.addClientLockHandler(tokenRequest.clientID(), this.handler_);
            }
            if (!tokenRequest.clientID().equals(this.lastClientID_)) {
                if (!this.clients_.contains(tokenRequest.clientID())) {
                    this.clients_.addElement(tokenRequest.clientID());
                }
                tokenAcceptor.addClientLockHandler(tokenRequest.clientID(), this.handler_);
            }
            this.lastClientID_ = tokenRequest.clientID();
            this.lastTokenName_ = tokenRequest.tokenName();
            TokenReply tokenReply = this.handler_.handleRequest(this, tokenRequest);
            tokenReply.streamOutTo(this.peer().dataOutputStream());
        }
        catch (NullPointerException nullPointerException) {
            this.sendAbortMessage(tokenRequest);
            throw nullPointerException;
        }
        catch (IOException iOException) {
            this.sendAbortMessage(tokenRequest);
            throw iOException;
        }
    }
}

