/*
 * Decompiled with CFR 0.152.
 */
package JACE.netsvcs.Token;

import JACE.ASX.TimeValue;
import JACE.OS.ACE;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class TokenRequest {
    public static final int MAX_TOKEN_NAME_LEN = 40;
    public static final int MAX_CLIENT_ID_LEN = 276;
    protected static final int HEADER_LEN = 40;
    protected static final int MAX_LEN = 359;
    private int tokenType_ = 0;
    private int proxyType_ = 0;
    private int operationType_ = 0;
    private int requeuePosition_ = 0;
    private int notify_ = 0;
    private int useTimeout_ = 0;
    private int sec_ = 0;
    private int usec_ = 0;
    private int arg_ = 0;
    private String tokenName_ = "";
    private String clientID_ = "";
    private byte[] buffer_ = new byte[359];
    protected String charEncoding_ = "US-ASCII";

    public String toString() {
        return "TokenRequest(" + this.length() + ", " + this.tokenType_ + ", " + this.proxyType_ + ", " + this.operationType_ + ", " + this.requeuePosition_ + ", " + this.notify_ + ", " + this.useTimeout_ + ", " + this.sec_ + ", " + this.usec_ + ", " + this.arg_ + ", " + this.tokenName_ + ", " + this.clientID_ + ")";
    }

    public TokenRequest() {
    }

    public TokenRequest(int n, int n2, int n3, String string, String string2) {
        this();
        this.tokenType_ = n;
        this.proxyType_ = n2;
        this.operationType_ = n3;
        this.tokenName_ = string;
        this.clientID_ = string2;
    }

    public TokenRequest(int n, int n2, int n3, String string, String string2, TimeValue timeValue) {
        this(n, n2, n3, string, string2);
        this.useTimeout_ = 1;
        this.sec_ = (int)timeValue.sec();
        this.usec_ = timeValue.nanos() / 1000;
    }

    public int length() {
        return 40 + this.tokenName_.length() + this.clientID_.length() + 3;
    }

    public int tokenType() {
        return this.tokenType_;
    }

    public void tokenType(int n) {
        this.tokenType_ = n;
    }

    public int proxyType() {
        return this.proxyType_;
    }

    public void proxyType(int n) {
        this.proxyType_ = n;
    }

    public int operationType() {
        return this.operationType_;
    }

    public void operationType(int n) {
        this.operationType_ = n;
    }

    public int requeuePosition() {
        return this.requeuePosition_;
    }

    public void requeuePosition(int n) {
        this.requeuePosition_ = n;
    }

    public boolean useTimeout() {
        return this.useTimeout_ == 1;
    }

    public void useTimeout(boolean bl) {
        this.useTimeout_ = bl ? 1 : 0;
    }

    public void useTimeout(TimeValue timeValue) {
        this.useTimeout_ = 1;
        this.sec_ = (int)timeValue.sec();
        this.usec_ = timeValue.nanos() / 1000;
    }

    public int sec() {
        return this.sec_;
    }

    public void sec(int n) {
        this.sec_ = n;
    }

    public int usec() {
        return this.usec_;
    }

    public void usec(int n) {
        this.usec_ = n;
    }

    public int arg() {
        return this.arg_;
    }

    public void arg(int n) {
        this.arg_ = n;
    }

    public String tokenName() {
        return this.tokenName_;
    }

    public void tokenName(String string) {
        this.tokenName_ = string;
    }

    public String clientID() {
        return this.clientID_;
    }

    public void clientID(String string) {
        this.clientID_ = string;
    }

    protected String stringFromBuffer(int n, int n2) {
        int n3;
        String string = null;
        for (n3 = n; n3 < n2 && this.buffer_[n3] != 0; ++n3) {
        }
        try {
            string = new String(this.buffer_, n, n3 - n, this.charEncoding_);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ACE.ERROR(this.charEncoding_ + " is not supported!");
            string = new String(this.buffer_, n, n3 - n);
        }
        return string;
    }

    public void streamInFrom(InputStream inputStream) throws IOException, EOFException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 359);
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        this.streamInFrom(dataInputStream);
    }

    public void streamInFrom(DataInputStream dataInputStream) throws IOException, EOFException {
        int n = dataInputStream.readInt();
        if (n > 359 || n < 45) {
            throw new IOException("Invalid TokenRequest length: " + n);
        }
        this.tokenType_ = dataInputStream.readInt();
        this.proxyType_ = dataInputStream.readInt();
        this.operationType_ = dataInputStream.readInt();
        this.requeuePosition_ = dataInputStream.readInt();
        this.notify_ = dataInputStream.readInt();
        this.useTimeout_ = dataInputStream.readInt();
        this.sec_ = dataInputStream.readInt();
        this.usec_ = dataInputStream.readInt();
        this.arg_ = dataInputStream.readInt();
        int n2 = dataInputStream.read(this.buffer_, 0, n - 40);
        this.tokenName_ = this.stringFromBuffer(0, n2);
        this.clientID_ = this.stringFromBuffer(this.tokenName_.length() + 2, n2);
        if (this.tokenName_.length() > 40 || this.clientID_.length() > 276) {
            throw new IOException("Exceeds maximum token name or client ID");
        }
    }

    public void streamOutTo(OutputStream outputStream) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
        this.streamOutTo(dataOutputStream);
    }

    public void streamOutTo(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.length());
        dataOutputStream.writeInt(this.tokenType_);
        dataOutputStream.writeInt(this.proxyType_);
        dataOutputStream.writeInt(this.operationType_);
        dataOutputStream.writeInt(this.requeuePosition_);
        dataOutputStream.writeInt(this.notify_);
        dataOutputStream.writeInt(this.useTimeout_);
        dataOutputStream.writeInt(this.sec_);
        dataOutputStream.writeInt(this.usec_);
        dataOutputStream.writeInt(this.arg_);
        StringBuffer stringBuffer = new StringBuffer(this.tokenName_.length() + this.clientID_.length() + 3);
        stringBuffer.append(this.tokenName_);
        stringBuffer.append('\u0000');
        stringBuffer.append(':');
        stringBuffer.append(this.clientID_);
        stringBuffer.append('\u0000');
        byte[] byArray = null;
        String string = stringBuffer.toString();
        try {
            byArray = string.getBytes(this.charEncoding_);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ACE.ERROR(this.charEncoding_ + " is unsupported, trying to use default");
            byArray = string.getBytes();
        }
        dataOutputStream.write(byArray, 0, byArray.length);
        dataOutputStream.flush();
    }
}

