/*
 * Decompiled with CFR 0.152.
 */
package JACE.netsvcs.Token;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TokenReply {
    public static final int NO_ERRORS = 0;
    public static final int ETIME = 62;
    public static final int EINTR = 4;
    public static final int EDEADLK = 45;
    public static final int EWOULDBLOCK = 11;
    public static final int ENAMETOOLONG = 78;
    public static final int ENOTSUP = 48;
    public static final int EACCES = 13;
    public static final int EIO = 5;
    public static final int EFAULT = 14;
    public static final int EINVAL = 22;
    private static final int LENGTH = 12;
    private int errno_;
    private int arg_;

    public String toString() {
        return "TokenReply(" + this.length() + ", " + this.errno_ + ", " + this.arg_ + ")";
    }

    public TokenReply() {
        this.errno_ = 0;
        this.arg_ = 0;
    }

    public TokenReply(int n, int n2) {
        this.errno_ = n;
        this.arg_ = n2;
    }

    public int length() {
        return 12;
    }

    public int errno() {
        return this.errno_;
    }

    public void errno(int n) {
        this.errno_ = n;
    }

    public int arg() {
        return this.arg_;
    }

    public void arg(int n) {
        this.arg_ = n;
    }

    public void streamInFrom(InputStream inputStream) throws IOException, EOFException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 12);
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        this.streamInFrom(dataInputStream);
    }

    public void streamInFrom(DataInputStream dataInputStream) throws IOException, EOFException {
        int n = dataInputStream.readInt();
        if (n != 12) {
            throw new IOException("Invalid TokenReply length " + n);
        }
        this.errno_ = dataInputStream.readInt();
        this.arg_ = dataInputStream.readInt();
    }

    public void streamOutTo(OutputStream outputStream) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 12);
        DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
        this.streamOutTo(dataOutputStream);
    }

    public void streamOutTo(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(12);
        dataOutputStream.writeInt(this.errno_);
        dataOutputStream.writeInt(this.arg_);
        dataOutputStream.flush();
    }
}

