/*
 * Decompiled with CFR 0.152.
 */
package JACE.netsvcs.Token;

import JACE.Connection.SvcHandler;
import JACE.Misc.GetOpt;
import JACE.OS.ACE;
import JACE.netsvcs.Server;
import JACE.netsvcs.Token.LockHandler;
import JACE.netsvcs.Token.TokenRequestHandler;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TokenAcceptor
extends Server {
    private Hashtable lockHandlerMap_;
    private Hashtable handlerFactoryMap_;
    private Hashtable clientHandlerMap_;

    protected void addDefaultFactories() throws ClassNotFoundException {
        this.addHandlerFactory(0, (Class)Class.forName("JACE.netsvcs.Token.MutexHandler"));
        this.addHandlerFactory(1, (Class)Class.forName("JACE.netsvcs.Token.RWMutexHandler"));
    }

    public TokenAcceptor() {
        this.name("Token Service");
        this.lockHandlerMap_ = new Hashtable();
        this.handlerFactoryMap_ = new Hashtable();
        this.clientHandlerMap_ = new Hashtable();
    }

    public void addHandlerFactory(Integer n, Class clazz) {
        this.handlerFactoryMap_.put(n, clazz);
    }

    public void addHandlerFactory(int n, Class clazz) {
        this.addHandlerFactory(new Integer(n), clazz);
    }

    public Object removeHandlerFactory(Integer n) {
        return this.handlerFactoryMap_.remove(n);
    }

    public Object removeHandlerFactory(int n) {
        return this.handlerFactoryMap_.remove(new Integer(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockHandler getLockHandler(String string, int n) {
        Hashtable hashtable = this.lockHandlerMap_;
        synchronized (hashtable) {
            Object v = this.lockHandlerMap_.get(string);
            if (v != null) {
                return (LockHandler)v;
            }
            LockHandler lockHandler = this.newHandler(n);
            this.lockHandlerMap_.put(string, lockHandler);
            return lockHandler;
        }
    }

    protected LockHandler newHandler(int n) {
        ACE.DEBUG("Creating new handler of type " + n);
        Object v = this.handlerFactoryMap_.get(new Integer(n));
        if (v == null) {
            return null;
        }
        Class clazz = (Class)v;
        LockHandler lockHandler = null;
        try {
            lockHandler = (LockHandler)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            ACE.ERROR("Can't create a handler of type " + n);
        }
        catch (IllegalAccessException illegalAccessException) {
            ACE.ERROR("Handler of type " + n + " must have a default constructor");
        }
        return lockHandler;
    }

    public static void main(String[] stringArray) {
        TokenAcceptor tokenAcceptor = new TokenAcceptor();
        tokenAcceptor.init(stringArray);
    }

    @Override
    protected SvcHandler makeSvcHandler() {
        return new TokenRequestHandler();
    }

    @Override
    public int init(String[] stringArray) {
        try {
            this.addDefaultFactories();
        }
        catch (ClassNotFoundException classNotFoundException) {
            ACE.ERROR("Can't find default factory " + classNotFoundException.getMessage());
            return -1;
        }
        return super.init(stringArray);
    }

    @Override
    protected void printUsage() {
        ACE.ERROR("Valid options:\n");
        ACE.ERROR("-f <class name>:<type>  Specify a handler for a type of lock");
        ACE.ERROR("-p <port number>        Port to listen on for clients");
        ACE.ERROR("-d                      Enable debugging messages");
    }

    @Override
    protected int parseArgs(String[] stringArray) {
        int n = 0;
        GetOpt getOpt = new GetOpt(stringArray, "p:f:d", true);
        try {
            block7: while ((n = getOpt.next()) != -1) {
                switch (n) {
                    case 100: {
                        ACE.enableDebugging();
                        ACE.DEBUG("Debugging is enabled");
                        continue block7;
                    }
                    case 112: {
                        if (this.port(getOpt.optarg())) continue block7;
                        return -1;
                    }
                    case 102: {
                        if (this.newHandlerFactory(getOpt.optarg()) >= 0) continue block7;
                        return -1;
                    }
                }
                ACE.ERROR("Unknown argument: " + (char)n);
                return -1;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ACE.ERROR("Option -" + (char)n + " requires an argument");
            return -1;
        }
        return 0;
    }

    protected int newHandlerFactory(String string) {
        Class<?> clazz;
        int n = string.lastIndexOf(58);
        if (n < 1) {
            ACE.ERROR("Invalid -f <class name>:<type num> for handler: " + string);
            return -1;
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string.substring(n + 1));
        }
        catch (NumberFormatException numberFormatException) {
            ACE.ERROR("Invalid token type: " + numberFormatException.getMessage());
            return -1;
        }
        String string2 = string.substring(0, n);
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ACE.ERROR(classNotFoundException.getMessage());
            return -1;
        }
        this.addHandlerFactory(n2, (Class)clazz);
        ACE.DEBUG("New handler " + string2 + " with type " + n2);
        return 0;
    }

    void addClientLockHandler(String string, LockHandler lockHandler) {
        Object v = this.clientHandlerMap_.get(string);
        if (v == null) {
            Vector<LockHandler> vector = new Vector<LockHandler>(10);
            vector.addElement(lockHandler);
            this.clientHandlerMap_.put(string, vector);
        } else {
            Vector vector = (Vector)v;
            int n = vector.indexOf(lockHandler);
            if (n == -1) {
                vector.addElement(lockHandler);
            }
        }
    }

    void removeClient(String string) {
        this.clientHandlerMap_.remove(string);
    }

    Enumeration getClientLockHandlers(String string) {
        Object v = this.clientHandlerMap_.get(string);
        if (v == null) {
            return null;
        }
        return ((Vector)v).elements();
    }
}

