/*
 * Decompiled with CFR 0.152.
 */
package JACE.netsvcs.Token;

import JACE.ASX.TimeValue;
import JACE.ASX.TimeoutException;
import JACE.Concurrency.AbstractLock;
import JACE.Concurrency.LockException;
import JACE.Connection.Connector;
import JACE.Connection.SvcHandler;
import JACE.netsvcs.Token.TokenReply;
import JACE.netsvcs.Token.TokenRequest;
import java.io.IOException;

public class RemoteLock
extends SvcHandler
implements AbstractLock {
    protected boolean connected_ = false;
    protected TokenRequest request_;
    protected TokenReply reply_;
    protected String host_;
    protected int port_;

    public String tokenName() {
        return this.request_.tokenName();
    }

    public void tokenName(String string) {
        this.request_.tokenName(string);
    }

    public String clientID() {
        return this.request_.clientID();
    }

    public void clientID(String string) {
        this.request_.clientID(string);
    }

    public RemoteLock(int n, int n2, String string, String string2, String string3, int n3) {
        this.host_ = string3;
        this.port_ = n3;
        this.reply_ = new TokenReply();
        this.request_ = new TokenRequest(n, n2, 0, string, string2);
    }

    protected void reconnect() throws LockException {
        Connector connector = new Connector();
        connector.open(this.host_, this.port_);
        try {
            connector.connect(this);
        }
        catch (InstantiationException instantiationException) {
            throw new LockException(instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new LockException(illegalAccessException.getMessage());
        }
        catch (IOException iOException) {
            throw new LockException(iOException.getMessage());
        }
    }

    public boolean connected() {
        return this.connected_;
    }

    @Override
    public int open(Object object) {
        this.connected_ = true;
        return 0;
    }

    @Override
    public int close(long l) {
        return this.close();
    }

    public int close() {
        if (this.connected()) {
            try {
                this.connected_ = false;
                this.peer().close();
            }
            catch (IOException iOException) {
                return -1;
            }
        }
        return 0;
    }

    protected void sendRequest(TokenRequest tokenRequest) throws LockException {
        try {
            if (!this.connected()) {
                this.reconnect();
            }
            tokenRequest.streamOutTo(this.peer().dataOutputStream());
        }
        catch (IOException iOException) {
            this.close();
            throw new LockException(iOException.getMessage());
        }
    }

    protected void receiveReply(TokenReply tokenReply) throws LockException {
        if (!this.connected()) {
            throw new LockException("Proxy wasn't connected, any replies lost");
        }
        try {
            tokenReply.streamInFrom(this.peer().dataInputStream());
        }
        catch (IOException iOException) {
            this.close();
            throw new LockException(iOException.getMessage());
        }
    }

    protected int processErrno(TokenReply tokenReply) {
        switch (tokenReply.errno()) {
            case 0: {
                return 0;
            }
            case 5: {
                this.close();
                return -1;
            }
        }
        return -1;
    }

    protected int makeRequest(int n, int n2, int n3) throws LockException {
        this.request_.operationType(n);
        this.request_.proxyType(n2);
        this.request_.requeuePosition(n3);
        this.request_.useTimeout(false);
        this.sendRequest(this.request_);
        this.receiveReply(this.reply_);
        this.request_.arg(this.reply_.arg());
        return this.processErrno(this.reply_);
    }

    protected int makeRequest(int n, int n2, int n3, TimeValue timeValue) throws LockException, TimeoutException {
        this.request_.operationType(n);
        this.request_.proxyType(n2);
        this.request_.requeuePosition(n3);
        this.request_.useTimeout(timeValue);
        this.sendRequest(this.request_);
        this.receiveReply(this.reply_);
        this.request_.arg(this.reply_.arg());
        if (this.reply_.errno() == 62) {
            throw new TimeoutException(timeValue, "Remote Lock");
        }
        return this.processErrno(this.reply_);
    }

    @Override
    public int acquire() throws LockException {
        return this.makeRequest(0, 0, 0);
    }

    @Override
    public int acquire(TimeValue timeValue) throws LockException, TimeoutException {
        return this.makeRequest(0, 0, 0, timeValue);
    }

    @Override
    public int acquireRead() throws LockException {
        return this.makeRequest(0, 0, 0);
    }

    @Override
    public int acquireRead(TimeValue timeValue) throws LockException, TimeoutException {
        return this.makeRequest(0, 0, 0, timeValue);
    }

    @Override
    public int acquireWrite() throws LockException {
        return this.makeRequest(0, 1, 0);
    }

    @Override
    public int acquireWrite(TimeValue timeValue) throws LockException, TimeoutException {
        return this.makeRequest(0, 1, 0, timeValue);
    }

    @Override
    public int renew(int n) throws LockException {
        return this.makeRequest(2, 0, n);
    }

    @Override
    public int renew(int n, TimeValue timeValue) throws LockException, TimeoutException {
        return this.makeRequest(2, 0, n, timeValue);
    }

    @Override
    public int tryAcquire() throws LockException {
        return this.makeRequest(4, 0, 0);
    }

    @Override
    public int tryAcquireRead() throws LockException {
        return this.makeRequest(4, 0, 0);
    }

    @Override
    public int tryAcquireWrite() throws LockException {
        return this.makeRequest(4, 1, 0);
    }

    @Override
    public int release() throws LockException {
        return this.makeRequest(1, 0, 0);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public void sleepHook() {
    }
}

