/*
 * Decompiled with CFR 0.152.
 */
package JACE.netsvcs.Token;

import JACE.ASX.TimeValue;
import JACE.ASX.TimeoutException;
import JACE.Concurrency.AbstractLock;
import JACE.Concurrency.LockException;
import JACE.OS.ACE;
import JACE.netsvcs.Token.LockHandler;
import JACE.netsvcs.Token.TokenReply;
import JACE.netsvcs.Token.TokenRequest;
import JACE.netsvcs.Token.TokenRequestHandler;

public class LockHandlerAdapter
implements LockHandler {
    protected AbstractLock lock_;

    public LockHandlerAdapter(AbstractLock abstractLock) {
        this.lock_ = abstractLock;
    }

    public LockHandlerAdapter() {
        this.lock_ = null;
    }

    @Override
    public TokenReply handleRequest(TokenRequestHandler tokenRequestHandler, TokenRequest tokenRequest) {
        String string = tokenRequest.clientID();
        String string2 = tokenRequest.tokenName();
        TokenReply tokenReply = null;
        switch (tokenRequest.operationType()) {
            case 0: {
                ACE.DEBUG(string + " begins ACQUIRE for " + string2);
                tokenReply = this.acquireDispatcher(tokenRequest);
                break;
            }
            case 1: {
                ACE.DEBUG(string + " begins RELEASE for " + string2);
                tokenReply = this.release(tokenRequest);
                break;
            }
            case 2: {
                ACE.DEBUG(string + " begins RENEW for " + string2);
                tokenReply = this.renew(tokenRequest);
                break;
            }
            case 3: {
                ACE.DEBUG(string + " begins REMOVE for " + string2);
                tokenReply = this.remove(tokenRequest);
                break;
            }
            case 4: {
                ACE.DEBUG(string + " begins TRY_ACQUIRE for " + string2);
                tokenReply = this.tryAcquireDispatcher(tokenRequest);
                break;
            }
            default: {
                ACE.ERROR("Unknown operation: " + tokenRequest.operationType());
            }
        }
        ACE.DEBUG(string + " result: " + tokenReply);
        return tokenReply;
    }

    protected TimeValue getTimeout(TokenRequest tokenRequest) {
        if (tokenRequest.useTimeout()) {
            return new TimeValue(tokenRequest.sec(), tokenRequest.usec() * 1000);
        }
        return null;
    }

    protected int acquireWrite(TokenRequest tokenRequest, TimeValue timeValue) throws LockException, TimeoutException, InterruptedException {
        int n = timeValue != null ? this.lock_.acquireWrite(timeValue) : this.lock_.acquireWrite();
        return n;
    }

    protected int acquireRead(TokenRequest tokenRequest, TimeValue timeValue) throws LockException, TimeoutException, InterruptedException {
        int n = timeValue != null ? this.lock_.acquireRead(timeValue) : this.lock_.acquireRead();
        return n;
    }

    protected int acquire(TokenRequest tokenRequest, TimeValue timeValue) throws LockException, TimeoutException, InterruptedException {
        int n = timeValue != null ? this.lock_.acquire(timeValue) : this.lock_.acquire();
        return n;
    }

    protected TokenReply acquireDispatcher(TokenRequest tokenRequest) {
        int n;
        TimeValue timeValue = this.getTimeout(tokenRequest);
        try {
            n = tokenRequest.tokenType() == 1 ? (tokenRequest.proxyType() == 0 ? this.acquireRead(tokenRequest, timeValue) : this.acquireWrite(tokenRequest, timeValue)) : this.acquire(tokenRequest, timeValue);
        }
        catch (LockException lockException) {
            return new TokenReply(14, tokenRequest.arg());
        }
        catch (TimeoutException timeoutException) {
            return new TokenReply(62, tokenRequest.arg());
        }
        catch (InterruptedException interruptedException) {
            return new TokenReply(4, tokenRequest.arg());
        }
        if (n == -1) {
            return new TokenReply(14, tokenRequest.arg());
        }
        return new TokenReply(0, tokenRequest.arg());
    }

    protected TokenReply release(TokenRequest tokenRequest) {
        int n;
        try {
            n = this.lock_.release();
        }
        catch (LockException lockException) {
            return new TokenReply(14, tokenRequest.arg());
        }
        if (n == -1) {
            return new TokenReply(13, tokenRequest.arg());
        }
        return new TokenReply(0, tokenRequest.arg());
    }

    protected TokenReply renew(TokenRequest tokenRequest) {
        int n = -1;
        TimeValue timeValue = this.getTimeout(tokenRequest);
        try {
            n = timeValue != null ? this.lock_.renew(tokenRequest.requeuePosition(), timeValue) : this.lock_.renew(tokenRequest.requeuePosition());
        }
        catch (LockException lockException) {
            return new TokenReply(14, tokenRequest.arg());
        }
        catch (TimeoutException timeoutException) {
            return new TokenReply(62, tokenRequest.arg());
        }
        catch (InterruptedException interruptedException) {
            return new TokenReply(4, tokenRequest.arg());
        }
        if (n == -1) {
            return new TokenReply(13, tokenRequest.arg());
        }
        return new TokenReply(0, tokenRequest.arg());
    }

    protected TokenReply remove(TokenRequest tokenRequest) {
        ACE.ERROR("Remove is unimplemented");
        return new TokenReply(48, tokenRequest.arg());
    }

    protected int tryAcquireWrite(TokenRequest tokenRequest) throws LockException {
        return this.lock_.tryAcquireWrite();
    }

    protected int tryAcquireRead(TokenRequest tokenRequest) throws LockException {
        return this.lock_.tryAcquireRead();
    }

    protected int tryAcquire(TokenRequest tokenRequest) throws LockException {
        return this.lock_.tryAcquire();
    }

    protected TokenReply tryAcquireDispatcher(TokenRequest tokenRequest) {
        int n;
        try {
            n = tokenRequest.tokenType() == 1 ? (tokenRequest.proxyType() == 0 ? this.tryAcquireRead(tokenRequest) : this.tryAcquireWrite(tokenRequest)) : this.tryAcquire(tokenRequest);
        }
        catch (LockException lockException) {
            return new TokenReply(14, tokenRequest.arg());
        }
        if (n == -1) {
            return new TokenReply(11, tokenRequest.arg());
        }
        return new TokenReply(0, tokenRequest.arg());
    }

    @Override
    public void abandonLock(String string) {
        ACE.DEBUG(string + " abandoning lock");
        try {
            int n = 0;
            while (this.lock_.release() != -1) {
                ++n;
            }
            if (n == 0) {
                ACE.DEBUG(string + " was not the owner");
            } else {
                ACE.DEBUG(string + " had " + n + " locks");
            }
        }
        catch (LockException lockException) {
            ACE.ERROR("While abandoning lock: " + lockException.getMessage());
        }
    }
}

