/*
 * Decompiled with CFR 0.152.
 */
package JACE.netsvcs.Time;

import JACE.Connection.ActivateStrategy;
import JACE.Connection.SvcHandler;
import JACE.Misc.GetOpt;
import JACE.OS.ACE;
import JACE.netsvcs.Server;
import JACE.netsvcs.Time.TSServerHandler;

public class TSServerAcceptor
extends Server {
    public TSServerAcceptor() {
        this.name("Time Service");
    }

    public static void main(String[] stringArray) {
        TSServerAcceptor tSServerAcceptor = new TSServerAcceptor();
        tSServerAcceptor.init(stringArray);
    }

    @Override
    protected SvcHandler makeSvcHandler() {
        return new TSServerHandler();
    }

    @Override
    protected void printUsage() {
        ACE.ERROR("Valid options:\n");
        ACE.ERROR("-p <port>        Port to listen on for clients");
        ACE.ERROR("-d               Enable debugging messages");
        ACE.ERROR("-a <class name>  Specify ActivateStrategy");
        ACE.ERROR("                 (Default is multi-threaded");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int parseArgs(String[] stringArray) {
        int n = 0;
        GetOpt getOpt = new GetOpt(stringArray, "p:da:", true);
        try {
            block7: while (true) {
                n = getOpt.next();
                if (n == -1) return 0;
                switch (n) {
                    case 100: {
                        ACE.enableDebugging();
                        ACE.DEBUG("Debugging is enabled");
                        continue block7;
                    }
                    case 112: {
                        if (this.port(getOpt.optarg())) continue block7;
                        return -1;
                    }
                    case 97: {
                        Object object = this.newStrategyInstance(getOpt.optarg(), "ActivateStrategy");
                        if (object == null) {
                            return -1;
                        }
                        this.activateStrategy((ActivateStrategy)object);
                        continue block7;
                    }
                }
                break;
            }
            ACE.ERROR("Unknown argument: " + (char)n);
            return -1;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ACE.ERROR("Option -" + (char)n + " requires an argument");
            return -1;
        }
    }
}

