/*
 * Decompiled with CFR 0.152.
 */
package JACE.netsvcs.Time;

import JACE.ASX.TimeValue;
import JACE.Connection.Connector;
import JACE.Misc.GetOpt;
import JACE.OS.ACE;
import JACE.Reactor.EventHandler;
import JACE.Reactor.TimerQueue;
import JACE.netsvcs.Time.TSClerkHandler;
import JACE.netsvcs.Time.TimeInfo;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;

public class TSClerkProcessor
implements EventHandler,
Runnable {
    private boolean done_ = false;
    private Vector handlerSet_ = new Vector();
    private TimerQueue tq_ = null;
    private TimeValue updateInterval_ = new TimeValue(300L, 0);
    TimeInfo status_ = new TimeInfo();

    public void printUsage() {
        ACE.ERROR("Valid options:");
        ACE.ERROR("-h <host name>:<port>  Specify a time server to contact");
        ACE.ERROR("-t <time in seconds>   How often to query the servers");
        ACE.ERROR("-d                     Enable debugging messages");
    }

    protected int parseArgs(String[] stringArray) {
        int n;
        GetOpt getOpt = new GetOpt(stringArray, "h:t:d", true);
        block5: while ((n = getOpt.next()) != -1) {
            switch (n) {
                case 104: {
                    if (this.newHandler(getOpt.optarg()) != -1) continue block5;
                    this.printUsage();
                    return -1;
                }
                case 116: {
                    int n2 = Integer.parseInt(getOpt.optarg());
                    this.updateInterval_ = new TimeValue(n2);
                    continue block5;
                }
                case 100: {
                    ACE.enableDebugging();
                    ACE.DEBUG("Debugging is enabled");
                    continue block5;
                }
            }
            ACE.ERROR("Unknown argument: " + (char)n);
            this.printUsage();
            return -1;
        }
        return 0;
    }

    public synchronized void close() {
        if (!this.done_) {
            this.done_ = true;
            this.tq_.cancelTimer(this);
            for (int i = 0; i < this.handlerSet_.size(); ++i) {
                TSClerkHandler tSClerkHandler = (TSClerkHandler)this.handlerSet_.elementAt(i);
                tSClerkHandler.close();
            }
        }
    }

    @Override
    public void run() {
        if (this.handlerSet_.size() == 0) {
            ACE.DEBUG("No servers are registered.  Call init first.");
            return;
        }
        if (!this.tq_.eventLoopRunning()) {
            this.tq_.handleEvents();
        }
    }

    public int init(String[] stringArray) {
        if (stringArray.length < 2) {
            this.printUsage();
            return -1;
        }
        if (this.parseArgs(stringArray) == -1) {
            return -1;
        }
        if (this.handlerSet_.size() == 0) {
            ACE.ERROR("No servers are registered.");
            this.done_ = true;
            return -1;
        }
        if (this.tq_ == null) {
            this.tq_ = new TimerQueue(true);
        }
        this.tq_.scheduleTimer(this, "Time Service Processor", TimeValue.zero, this.updateInterval_);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectHandler(TSClerkHandler tSClerkHandler, String string, int n) {
        if (this.done_) {
            return;
        }
        ACE.DEBUG("Connecting handler to " + string + " on port " + n);
        try {
            Connector connector = new Connector();
            connector.open(string, n);
            connector.connect(tSClerkHandler);
        }
        catch (UnknownHostException unknownHostException) {
            TSClerkProcessor tSClerkProcessor = this;
            synchronized (tSClerkProcessor) {
                this.handlerSet_.removeElement(tSClerkHandler);
            }
            ACE.ERROR(unknownHostException);
        }
        catch (SocketException socketException) {
            ACE.ERROR(socketException);
        }
        catch (InstantiationException instantiationException) {
            ACE.ERROR(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ACE.ERROR(illegalAccessException);
        }
        catch (IOException iOException) {
            ACE.ERROR(iOException);
        }
    }

    protected int newHandler(String string) {
        int n = string.lastIndexOf(58);
        if (n < 1) {
            ACE.ERROR("Invalid -h <host>:<port> parameter: " + string);
            return -1;
        }
        int n2 = Integer.parseInt(string.substring(n + 1));
        String string2 = string.substring(0, n);
        ACE.DEBUG("New handler for server " + string2 + " on port " + n2);
        TSClerkHandler tSClerkHandler = new TSClerkHandler(this, string2, n2);
        this.handlerSet_.addElement(tSClerkHandler);
        return 0;
    }

    @Override
    public synchronized int handleTimeout(TimeValue timeValue, Object object) {
        if (this.done_) {
            return -1;
        }
        int n = this.status_.sequenceNumber() + 1;
        Enumeration enumeration = this.handlerSet_.elements();
        long l = 0L;
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            TSClerkHandler tSClerkHandler = (TSClerkHandler)enumeration.nextElement();
            if (tSClerkHandler.sendRequest() < 0) continue;
            l += tSClerkHandler.delta();
            ++n2;
        }
        if (n2 == 0) {
            ACE.ERROR("Could not reach any time servers, will keep trying.");
            return 0;
        }
        this.timeStatus(new TimeInfo(n, l / (long)n2));
        ACE.DEBUG("Status: " + this.timeStatus());
        return 0;
    }

    public synchronized TimeInfo timeStatus() {
        return this.status_;
    }

    protected synchronized void timeStatus(TimeInfo timeInfo) {
        this.status_ = timeInfo;
    }

    public TSClerkProcessor() {
    }

    public TSClerkProcessor(TimerQueue timerQueue) {
        this.tq_ = timerQueue;
    }
}

