/*
 * Decompiled with CFR 0.152.
 */
package JACE.netsvcs.Time;

import JACE.ASX.TimeValue;
import JACE.Connection.SvcHandler;
import JACE.OS.ACE;
import JACE.netsvcs.Time.TSClerkProcessor;
import JACE.netsvcs.Time.TimeRequest;
import java.io.IOException;

public class TSClerkHandler
extends SvcHandler {
    private long delta_;
    private TSClerkProcessor parent_;
    private boolean connected_ = false;
    private String host_;
    private int port_;

    public TSClerkHandler(TSClerkProcessor tSClerkProcessor, String string, int n) {
        this.parent_ = tSClerkProcessor;
        this.host_ = string;
        this.port_ = n;
    }

    @Override
    public int open(Object object) {
        ACE.DEBUG("Successful connection to " + this.host());
        this.connected(true);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int close() {
        if (!this.connected()) {
            return 0;
        }
        ACE.DEBUG("Shutting down connection to " + this.host());
        try {
            this.peer().close();
        }
        catch (IOException iOException) {
            int n = -1;
            return n;
        }
        finally {
            this.connected(false);
        }
        return 0;
    }

    public int port() {
        return this.port_;
    }

    public String host() {
        return this.host_;
    }

    public synchronized boolean connected() {
        return this.connected_;
    }

    protected synchronized void connected(boolean bl) {
        this.connected_ = bl;
    }

    @Override
    public int handleTimeout(TimeValue timeValue, Object object) {
        return -1;
    }

    @Override
    public void run() {
        ACE.ERROR("TSClerkHandler is not setup to run in its own thread");
    }

    public int sendRequest() {
        long l;
        long l2;
        if (!this.connected()) {
            this.parent_.connectHandler(this, this.host_, this.port_);
        }
        TimeRequest timeRequest = new TimeRequest();
        try {
            l2 = System.currentTimeMillis();
            timeRequest.streamOutTo(this.peer().outputStream());
            timeRequest.streamInFrom(this.peer().inputStream());
            l = System.currentTimeMillis();
        }
        catch (NullPointerException nullPointerException) {
            this.close();
            return -1;
        }
        catch (IOException iOException) {
            this.close();
            return -1;
        }
        long l3 = (long)timeRequest.time() - l / 1000L;
        long l4 = (l - l2) / 2000L;
        this.delta(l3 += l4);
        return 0;
    }

    public synchronized long delta() {
        return this.delta_;
    }

    protected synchronized void delta(long l) {
        this.delta_ = l;
    }
}

