/*
 * Decompiled with CFR 0.152.
 */
package JACE.netsvcs;

import JACE.Connection.Acceptor;
import JACE.Connection.ActivateStrategy;
import JACE.Connection.SvcHandler;
import JACE.OS.ACE;
import JACE.netsvcs.Handler;
import java.io.IOException;
import java.util.Vector;

public abstract class Server
extends Acceptor
implements Runnable {
    private boolean done_ = true;
    protected Vector handlers_ = new Vector();
    private ActivateStrategy activateStrategy_ = null;

    @Override
    public synchronized int fini() {
        if (!this.done()) {
            ACE.DEBUG("Shutting down " + this.name());
            try {
                this.done_ = true;
                for (int i = this.handlers_.size() - 1; i >= 0; --i) {
                    ((Handler)this.handlers_.elementAt(i)).close();
                }
                this.sockAcceptor_.close();
            }
            catch (IOException iOException) {
                ACE.ERROR(iOException);
                return -1;
            }
        }
        return 0;
    }

    @Override
    public String info() {
        if (this.suspended()) {
            return "suspended";
        }
        if (this.done()) {
            return "not running";
        }
        return "running on port " + this.port_;
    }

    protected int initialize() {
        if (this.activateStrategy_ == null) {
            this.activateStrategy(new ThreadPerConnection());
        }
        return 0;
    }

    @Override
    public int init(String[] stringArray) {
        if (this.parseArgs(stringArray) == -1) {
            this.printUsage();
            return -1;
        }
        if (this.initialize() < 0) {
            ACE.ERROR(this.name() + " failed initializing");
            return -1;
        }
        ACE.DEBUG("Using " + this.activateStrategy_.getClass().getName());
        ACE.DEBUG("Starting " + this.name() + " on port: " + this.port_);
        this.done_ = false;
        new Thread(this).start();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.open(this.port_);
            while (!this.done()) {
                this.accept();
            }
        }
        catch (InstantiationException instantiationException) {
            ACE.ERROR(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ACE.ERROR(illegalAccessException);
        }
        catch (IOException iOException) {
            if (!this.done()) {
                ACE.ERROR(iOException);
            }
        }
        finally {
            this.fini();
        }
    }

    @Override
    protected int activateSvcHandler(SvcHandler svcHandler) {
        if (this.done()) {
            return -1;
        }
        this.addHandler(svcHandler);
        ((Handler)svcHandler).parent(this);
        while (this.suspended() && !this.done()) {
            Thread.yield();
        }
        if (this.activateStrategy_.activateSvcHandler(svcHandler) != 0) {
            this.removeHandler(svcHandler);
            return -1;
        }
        return 0;
    }

    protected void addHandler(SvcHandler svcHandler) {
        this.handlers_.addElement(svcHandler);
    }

    public void removeHandler(SvcHandler svcHandler) {
        this.handlers_.removeElement(svcHandler);
    }

    protected abstract int parseArgs(String[] var1);

    @Override
    protected abstract SvcHandler makeSvcHandler();

    protected abstract void printUsage();

    protected void activateStrategy(ActivateStrategy activateStrategy) {
        this.activateStrategy_ = activateStrategy;
    }

    protected ActivateStrategy activateStrategy() {
        return this.activateStrategy_;
    }

    protected synchronized boolean done() {
        return this.done_;
    }

    protected boolean port(String string) {
        try {
            this.port_ = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            ACE.ERROR("Invalid port specified: " + numberFormatException.getMessage());
            return false;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ACE.ERROR("Port option requires an argument");
            return false;
        }
        return true;
    }

    protected Object newStrategyInstance(String string, String string2) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            ACE.ERROR("Unable to find " + string2 + ": " + classNotFoundException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            ACE.ERROR("Instantiating " + string2 + ": " + instantiationException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            ACE.ERROR("Illegal access on " + string2 + ": " + illegalAccessException.getMessage());
        }
        return null;
    }

    protected void finalize() throws Throwable {
        this.fini();
    }

    public static class SingleThreaded
    extends ActivateStrategy {
        @Override
        public int activateSvcHandler(SvcHandler svcHandler) {
            if (svcHandler.open(null) < 0) {
                return -1;
            }
            ((Handler)svcHandler).handleRequest();
            ((Handler)svcHandler).close();
            return 0;
        }
    }

    public static class ThreadPerConnection
    extends ActivateStrategy {
        @Override
        public int activateSvcHandler(SvcHandler svcHandler) {
            if (svcHandler.open(null) < 0) {
                return -1;
            }
            new Thread(svcHandler).start();
            return 0;
        }
    }
}

