/*
 * Decompiled with CFR 0.152.
 */
package JACE.netsvcs.Naming;

import JACE.ASX.TimeValue;
import JACE.SOCK_SAP.SOCKStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NameRequest {
    public static final int BIND = 1;
    public static final int REBIND = 2;
    public static final int RESOLVE = 3;
    public static final int UNBIND = 4;
    public static final int LIST_NAMES = 5;
    public static final int LIST_VALUES = 13;
    public static final int LIST_TYPES = 21;
    public static final int LIST_NAME_ENTRIES = 6;
    public static final int LIST_VALUE_ENTRIES = 14;
    public static final int LIST_TYPE_ENTRIES = 22;
    public static final int MAX_ENUM = 11;
    public static final int MAX_LEN = 6182;
    int length_;
    int requestType_;
    int blockForever_;
    int secTimeout_;
    int usecTimeout_;
    String name_;
    String value_;
    String type_;

    public NameRequest() {
        this.type_ = null;
        this.value_ = null;
        this.name_ = null;
        this.length_ = 32;
    }

    public NameRequest(int n, String string, String string2, String string3, TimeValue timeValue) {
        this.requestType_ = n;
        if (timeValue == null) {
            this.blockForever_ = 1;
            this.secTimeout_ = 0;
            this.usecTimeout_ = 0;
        } else {
            this.blockForever_ = 0;
            this.secTimeout_ = (int)timeValue.sec();
            this.usecTimeout_ = (int)timeValue.getMilliTime() * 1000;
        }
        this.name_ = string == null ? new String("") : new String(string);
        this.value_ = string2 == null ? new String("") : new String(string2);
        this.type_ = string3 == null ? new String("") : new String(string3);
        this.calculateLength();
    }

    private void calculateLength() {
        this.length_ = 34 + this.type_.length() + 2 * (this.name_.length() + this.value_.length());
    }

    public int length() {
        return this.length_;
    }

    public String name() {
        return new String(this.name_);
    }

    public void name(String string) {
        this.name_ = string == null ? new String("") : new String(string);
        this.calculateLength();
    }

    public String value() {
        return new String(this.value_);
    }

    public void value(String string) {
        this.value_ = string == null ? new String("") : new String(string);
        this.calculateLength();
    }

    public String type() {
        return new String(this.type_);
    }

    public void type(String string) {
        this.type_ = string == null ? new String("") : new String(string);
        this.calculateLength();
    }

    public void streamInFrom(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        this.streamInFrom(dataInputStream);
    }

    public void streamInFrom(SOCKStream sOCKStream) throws IOException {
        this.streamInFrom(sOCKStream.dataInputStream());
    }

    public void streamInFrom(DataInputStream dataInputStream) throws IOException {
        int n;
        this.length_ = dataInputStream.readInt();
        if (this.length_ > 6182) {
            throw new IOException("Invalid NameRequest length " + this.length_);
        }
        this.requestType_ = dataInputStream.readInt();
        this.blockForever_ = dataInputStream.readInt();
        this.secTimeout_ = dataInputStream.readInt();
        this.usecTimeout_ = dataInputStream.readInt();
        int n2 = dataInputStream.readInt() / 2;
        int n3 = dataInputStream.readInt() / 2;
        int n4 = dataInputStream.readInt();
        char[] cArray = new char[n2];
        for (n = 0; n < n2; ++n) {
            cArray[n] = dataInputStream.readChar();
        }
        this.name_ = new String(cArray);
        cArray = new char[n3];
        for (n = 0; n < n3; ++n) {
            cArray[n] = dataInputStream.readChar();
        }
        this.value_ = new String(cArray);
        byte[] byArray = new byte[n4];
        dataInputStream.readFully(byArray);
        this.type_ = new String(byArray);
        dataInputStream.skipBytes(2);
    }

    public void streamOutTo(SOCKStream sOCKStream) throws IOException {
        this.streamOutTo(sOCKStream.dataOutputStream());
    }

    public void streamOutTo(OutputStream outputStream) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
        this.streamOutTo(dataOutputStream);
    }

    public void streamOutTo(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.length_);
        dataOutputStream.writeInt(this.requestType_);
        dataOutputStream.writeInt(this.blockForever_);
        dataOutputStream.writeInt(this.secTimeout_);
        dataOutputStream.writeInt(this.usecTimeout_);
        dataOutputStream.writeInt(this.name_.length() * 2);
        dataOutputStream.writeInt(this.value_.length() * 2);
        dataOutputStream.writeInt(this.type_.length());
        dataOutputStream.writeChars(this.name_);
        dataOutputStream.writeChars(this.value_);
        dataOutputStream.writeBytes(this.type_);
        dataOutputStream.writeChar(0);
        dataOutputStream.flush();
    }

    public void requestType(int n) {
        this.requestType_ = n;
    }

    public int requestType() {
        return this.requestType_;
    }

    public boolean blockForever() {
        return this.blockForever_ != 0;
    }

    public int secTimeout() {
        return this.secTimeout_;
    }
}

