/*
 * Decompiled with CFR 0.152.
 */
package JACE.netsvcs.Naming;

import JACE.Connection.Connector;
import JACE.Connection.SvcHandler;
import JACE.SOCK_SAP.SOCKStream;
import JACE.netsvcs.Naming.NameReply;
import JACE.netsvcs.Naming.NameRequest;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;

public class NameProxy
extends SvcHandler {
    private boolean connected_ = false;

    public NameProxy(String string, int n) throws UnknownHostException, SocketException, InstantiationException, IllegalAccessException, IOException {
        Connector connector = new Connector();
        connector.open(string, n);
        connector.connect(this);
    }

    public NameProxy() {
    }

    public NameProxy(SOCKStream sOCKStream) {
        this.stream_ = sOCKStream;
    }

    @Override
    public int open(Object object) {
        this.connected_ = true;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int close() {
        if (!this.connected_) {
            return 0;
        }
        try {
            this.peer().close();
        }
        catch (IOException iOException) {
            int n = -1;
            return n;
        }
        finally {
            this.connected_ = false;
        }
        return 0;
    }

    public boolean bind(String string, String string2) throws IOException {
        return this.bind(string, string2, null, false);
    }

    public boolean bind(String string, String string2, String string3) throws IOException {
        return this.bind(string, string2, string3, false);
    }

    boolean bind(String string, String string2, String string3, boolean bl) throws IOException {
        NameRequest nameRequest = new NameRequest(bl ? 2 : 1, string, string2, string3, null);
        nameRequest.streamOutTo(this.stream_);
        NameReply nameReply = new NameReply();
        nameReply.streamInFrom(this.stream_);
        return nameReply.type() == 0;
    }

    public boolean rebind(String string, String string2) throws IOException {
        return this.bind(string, string2, null, true);
    }

    public boolean rebind(String string, String string2, String string3) throws IOException {
        return this.bind(string, string2, string3, true);
    }

    public Vector resolve(String string) throws IOException {
        NameRequest nameRequest = new NameRequest(3, string, null, null, null);
        nameRequest.streamOutTo(this.stream_);
        nameRequest.streamInFrom(this.stream_);
        Vector<String> vector = new Vector<String>();
        vector.addElement(nameRequest.name());
        vector.addElement(nameRequest.value());
        vector.addElement(nameRequest.type());
        vector.trimToSize();
        return vector;
    }

    public boolean unbind(String string) throws IOException {
        NameRequest nameRequest = new NameRequest(4, string, null, null, null);
        nameRequest.streamOutTo(this.stream_);
        NameReply nameReply = new NameReply();
        nameReply.streamInFrom(this.stream_);
        return nameReply.type() == 0;
    }

    public Vector listNames(String string) throws IOException {
        return this.requestSimpleList(string, 5);
    }

    public Vector listTypes(String string) throws IOException {
        return this.requestSimpleList(string, 21);
    }

    public Vector listValues(String string) throws IOException {
        return this.requestSimpleList(string, 13);
    }

    Vector requestSimpleList(String string, int n) throws IOException {
        NameRequest nameRequest = new NameRequest(n, string, null, null, null);
        nameRequest.streamOutTo(this.stream_);
        DataInputStream dataInputStream = new DataInputStream(this.stream_.inputStream());
        nameRequest.streamInFrom(dataInputStream);
        Vector<String> vector = new Vector<String>();
        while (nameRequest.requestType() != 11) {
            if (n == 5) {
                vector.addElement(new String(nameRequest.name()));
            } else if (n == 13) {
                vector.addElement(new String(nameRequest.value()));
            } else {
                vector.addElement(new String(nameRequest.type()));
            }
            nameRequest.streamInFrom(dataInputStream);
        }
        vector.trimToSize();
        return vector;
    }

    public Vector listNameEntries(String string) throws IOException {
        return this.requestComplexList(string, 6);
    }

    public Vector listValueEntries(String string) throws IOException {
        return this.requestComplexList(string, 14);
    }

    public Vector listTypeEntries(String string) throws IOException {
        return this.requestComplexList(string, 22);
    }

    Vector requestComplexList(String string, int n) throws IOException {
        NameRequest nameRequest = new NameRequest(n, string, null, null, null);
        nameRequest.streamOutTo(this.stream_);
        DataInputStream dataInputStream = new DataInputStream(this.stream_.inputStream());
        nameRequest.streamInFrom(dataInputStream);
        Vector vector = new Vector();
        while (nameRequest.requestType() != 11) {
            Vector<String> vector2 = new Vector<String>();
            vector2.addElement(nameRequest.name());
            vector2.addElement(nameRequest.value());
            vector2.addElement(nameRequest.type());
            vector2.trimToSize();
            vector.addElement(vector2);
            nameRequest.streamInFrom(dataInputStream);
        }
        vector.trimToSize();
        return vector;
    }
}

