/*
 * Decompiled with CFR 0.152.
 */
package JACE.netsvcs.Logger;

import JACE.Connection.ActivateStrategy;
import JACE.Connection.SvcHandler;
import JACE.Misc.GetOpt;
import JACE.OS.ACE;
import JACE.netsvcs.Logger.LoggingStrategy;
import JACE.netsvcs.Logger.ServerLoggingHandler;
import JACE.netsvcs.Logger.StderrStrategy;
import JACE.netsvcs.Server;

public class ServerLoggingAcceptor
extends Server {
    private LoggingStrategy logStrategy_;

    public ServerLoggingAcceptor() {
        this.name("Logging Service");
        this.logStrategy_ = new StderrStrategy();
    }

    public static void main(String[] stringArray) {
        ServerLoggingAcceptor serverLoggingAcceptor = new ServerLoggingAcceptor();
        serverLoggingAcceptor.init(stringArray);
    }

    public LoggingStrategy loggingStrategy() {
        return this.logStrategy_;
    }

    @Override
    protected SvcHandler makeSvcHandler() {
        return new ServerLoggingHandler();
    }

    @Override
    protected void printUsage() {
        ACE.ERROR("Valid options:\n");
        ACE.ERROR("-r <class name>  Specify a LoggingStrategy");
        ACE.ERROR("                 (Default is StdErrStrategy");
        ACE.ERROR("-p <port>        Port to listen on for clients");
        ACE.ERROR("-d               Enable debugging messages");
        ACE.ERROR("-a <class name>  Specify ActivateStrategy");
        ACE.ERROR("                 (Default is single threaded");
    }

    @Override
    protected int parseArgs(String[] stringArray) {
        GetOpt getOpt = new GetOpt(stringArray, "p:r:da:", true);
        int n = 0;
        try {
            block8: while ((n = getOpt.next()) != -1) {
                switch (n) {
                    case 100: {
                        ACE.enableDebugging();
                        ACE.DEBUG("Debugging is enabled");
                        continue block8;
                    }
                    case 112: {
                        if (this.port(getOpt.optarg())) continue block8;
                        return -1;
                    }
                    case 97: {
                        Object object = this.newStrategyInstance(getOpt.optarg(), "ActivateStrategy");
                        if (object == null) {
                            return -1;
                        }
                        this.activateStrategy((ActivateStrategy)object);
                        continue block8;
                    }
                    case 114: {
                        Object object = this.newStrategyInstance(getOpt.optarg(), "LoggingStrategy");
                        if (object == null) {
                            return -1;
                        }
                        this.logStrategy_ = (LoggingStrategy)object;
                        continue block8;
                    }
                }
                ACE.ERROR("Unknown argument: " + n);
                return -1;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ACE.ERROR("Option -" + (char)n + " requires an argument");
            return -1;
        }
        return 0;
    }
}

