/*
 * Decompiled with CFR 0.152.
 */
package JACE.netsvcs.Logger;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;

public class LogRecord {
    public final int MAXLOGMSGLEN = 4096;
    private int type_;
    private int length_;
    private long msec_;
    private int pid_;
    private byte[] msgData_;
    private static final int numIntMembers = 5;
    private static final int sizeofIntInBytes = 4;

    public LogRecord() {
        this.type(0);
        this.timeStamp((int)new Date().getTime());
        this.length(0);
        this.pid(0);
    }

    public LogRecord(int n, long l, int n2) {
        this.type(n);
        this.timeStamp(l);
        this.length(0);
        this.pid(n2);
    }

    public LogRecord(String string) {
        this();
        this.msgData(string);
    }

    public String toString() {
        String string = null;
        try {
            string = new String(this.msgData_, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(this.msgData_);
        }
        return string;
    }

    public void print(String string, boolean bl, PrintStream printStream) {
        String string2;
        if (bl) {
            Date date = new Date(this.timeStamp());
            string2 = date.toString().substring(4) + "@" + string + "@" + this.pid_ + "@" + this.type_ + "@" + this.toString();
        } else {
            string2 = this.toString();
        }
        printStream.println(string2);
    }

    public void streamInFrom(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        this.streamInFrom(dataInputStream);
    }

    public void streamInFrom(DataInputStream dataInputStream) throws IOException {
        this.length(dataInputStream.readInt());
        this.type(dataInputStream.readInt());
        this.timeStamp((long)dataInputStream.readInt() * 1000L);
        dataInputStream.skipBytes(4);
        this.pid(dataInputStream.readInt());
        int n = this.length_ - 20;
        this.msgData_ = new byte[n];
        dataInputStream.readFully(this.msgData_, 0, n);
    }

    public void streamOutTo(OutputStream outputStream) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
        this.streamOutTo(dataOutputStream);
    }

    public void streamOutTo(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.length());
        dataOutputStream.writeInt(this.type());
        dataOutputStream.writeInt((int)(this.msec_ / 1000L));
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(this.pid());
        dataOutputStream.write(this.msgData_);
        dataOutputStream.flush();
    }

    public int type() {
        return this.type_;
    }

    public void type(int n) {
        this.type_ = n;
    }

    public int length() {
        return this.length_;
    }

    public void length(int n) {
        this.length_ = n;
    }

    private void setLen(int n) {
        this.length(n + 20);
    }

    public long timeStamp() {
        return this.msec_;
    }

    public void timeStamp(long l) {
        this.msec_ = l;
    }

    public int pid() {
        return this.pid_;
    }

    public void pid(int n) {
        this.pid_ = n;
    }

    public byte[] msgData() {
        return this.msgData_;
    }

    public void msgData(byte[] byArray) {
        int n = byArray.length;
        if (n > 4096) {
            n = 4096;
        }
        this.msgData_ = new byte[n];
        System.arraycopy(byArray, 0, this.msgData_, 0, n);
        this.setLen(n);
    }

    public void msgData(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        if (byArray.length > 4096) {
            this.msgData_ = new byte[4096];
            System.arraycopy(byArray, 0, this.msgData_, 0, 4096);
        } else {
            this.msgData_ = byArray;
        }
        this.setLen(this.msgData_.length);
    }
}

