/*
 * Decompiled with CFR 0.152.
 */
package JACE.netsvcs;

import JACE.Connection.SvcHandler;
import JACE.OS.ACE;
import JACE.netsvcs.Server;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;

public abstract class Handler
extends SvcHandler {
    private boolean done_ = true;
    private Server parent_;

    @Override
    public int open(Object object) {
        this.done_ = false;
        return 0;
    }

    @Override
    public int close(long l) {
        return this.close();
    }

    public synchronized int close() {
        if (!this.done()) {
            try {
                this.done_ = true;
                this.parent_.removeHandler(this);
                this.peer().close();
            }
            catch (IOException iOException) {
                return -1;
            }
        }
        return 0;
    }

    public String hostName() {
        if (this.done()) {
            return null;
        }
        return this.peer().socket().getInetAddress().getHostName();
    }

    public void handleRequest() {
        this.handleRequest(this.newRequest());
    }

    public void handleRequest(Object object) {
        block8: {
            try {
                this.processRequest(object);
            }
            catch (NullPointerException nullPointerException) {
                if (!this.done()) {
                    ACE.ERROR("Failure: " + nullPointerException);
                    this.close();
                }
            }
            catch (SocketException socketException) {
                if (!this.done()) {
                    ACE.DEBUG(this.hostName() + " disconnected");
                    this.close();
                }
            }
            catch (EOFException eOFException) {
                if (!this.done()) {
                    ACE.DEBUG(this.hostName() + " disconnected");
                    this.close();
                }
            }
            catch (IOException iOException) {
                if (this.done()) break block8;
                ACE.ERROR("Lost connection: " + iOException);
                this.close();
            }
        }
    }

    protected abstract void processRequest(Object var1) throws SocketException, EOFException, IOException;

    public abstract Object newRequest();

    @Override
    public void run() {
        Object object = this.newRequest();
        while (!this.done()) {
            this.handleRequest(object);
        }
        this.close();
    }

    public void parent(Server server) {
        this.parent_ = server;
    }

    public Server parent() {
        return this.parent_;
    }

    protected synchronized boolean done() {
        return this.done_;
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

