/*
 * Decompiled with CFR 0.152.
 */
package JACE.ServiceConfigurator;

import JACE.ServiceConfigurator.Service;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class ServiceRepository {
    Vector serviceNames_;
    Hashtable serviceMap_;

    public ServiceRepository() {
        this.serviceMap_ = new Hashtable();
        this.serviceNames_ = new Vector();
    }

    public ServiceRepository(int n) {
        this.serviceMap_ = new Hashtable(n);
        this.serviceNames_ = new Vector(n);
    }

    public int close() {
        int n = 0;
        for (int i = this.size() - 1; i >= 0; --i) {
            String string = (String)this.serviceNames_.elementAt(i);
            Service service = (Service)this.serviceMap_.get(string);
            n = service.fini() == -1 ? -1 : n;
        }
        this.serviceMap_.clear();
        this.serviceNames_.removeAllElements();
        return n;
    }

    public void insert(Service service) {
        String string = service.name();
        Service service2 = this.find(string);
        if (service2 != null) {
            service2.fini();
            this.remove(service2);
        } else {
            this.serviceMap_.put(string, service);
            this.serviceNames_.addElement(string);
        }
    }

    public Enumeration services() {
        return this.serviceMap_.elements();
    }

    public Enumeration serviceNames() {
        return this.serviceMap_.keys();
    }

    public Service find(String string) {
        Object v = this.serviceMap_.get(string);
        if (v == null) {
            return null;
        }
        return (Service)v;
    }

    protected Service findService(String string) throws NoSuchElementException {
        Object v = this.serviceMap_.get(string);
        if (v == null) {
            throw new NoSuchElementException("Service " + string + " not found.");
        }
        return (Service)v;
    }

    protected int remove(Service service) {
        String string = service.name();
        this.serviceMap_.remove(string);
        int n = this.serviceNames_.indexOf(string);
        this.serviceNames_.removeElementAt(n);
        return service.fini();
    }

    public int fini(String string) {
        Service service = this.findService(string);
        return service.fini();
    }

    public int remove(String string) {
        Service service = this.findService(string);
        return this.remove(service);
    }

    public int resume(String string) {
        Service service = this.findService(string);
        return service.resume();
    }

    public int suspend(String string) {
        Service service = this.findService(string);
        if (service.suspended()) {
            return 0;
        }
        return service.suspend();
    }

    public String info(String string) {
        Service service = this.findService(string);
        return service.info();
    }

    public boolean suspended(String string) {
        Service service = this.findService(string);
        return service.suspended();
    }

    public int init(String string, String[] stringArray) {
        Service service = this.findService(string);
        return service.init(stringArray);
    }

    public int size() {
        return this.serviceNames_.size();
    }
}

