/*
 * Decompiled with CFR 0.152.
 */
package JACE.ServiceConfigurator;

import JACE.Misc.GetOpt;
import JACE.OS.ACE;
import JACE.OS.OS;
import JACE.ServiceConfigurator.Service;
import JACE.ServiceConfigurator.ServiceLoader;
import JACE.ServiceConfigurator.ServiceRepository;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Vector;

public class ServiceConfig {
    private static boolean beADaemon_ = false;
    private static String serviceConfigFile_ = "svc.conf";
    private static ServiceRepository svcRep_ = new ServiceRepository();
    private static ServiceLoader loader_ = new ServiceLoader();
    private static final int COMMAND_NAME = 0;
    private static final int SERVICE_NAME = 1;
    private static final int CLASS_NAME = 2;
    private static final int SERVICE_TYPE = 3;
    private static final int ARGS = 4;
    private static final int CODE_BASE = 5;

    public static int open(String[] stringArray) throws FileNotFoundException, IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (ServiceConfig.parseArgs(stringArray) < 0) {
            ServiceConfig.printUsage();
            return -1;
        }
        return ServiceConfig.processDirectives();
    }

    protected static void printUsage() {
        ACE.ERROR("Valid options:\n");
        ACE.ERROR("-f <filename>     Specify name of the service config file");
        ACE.ERROR("-d                Enable debugging");
        ACE.ERROR("-p <URL path>     If not found locally, search this URL path");
        ACE.ERROR("                  for classes (multiple -p options allowed)");
    }

    protected static int parseArgs(String[] stringArray) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        int n;
        GetOpt getOpt = new GetOpt(stringArray, "df:p:", true);
        block7: while ((n = getOpt.next()) != -1) {
            switch (n) {
                case 112: {
                    try {
                        loader_.addURLPath(getOpt.optarg());
                    }
                    catch (MalformedURLException malformedURLException) {
                        ACE.ERROR("Invalid URL: " + getOpt.optarg());
                    }
                    continue block7;
                }
                case 100: {
                    ACE.enableDebugging();
                    ACE.DEBUG("Debugging is enabled");
                    continue block7;
                }
                case 102: {
                    serviceConfigFile_ = getOpt.optarg();
                    continue block7;
                }
            }
            ACE.ERROR((char)n + " is not a ServiceConfig option");
            return -1;
        }
        return 0;
    }

    public static int suspend(String string) {
        return svcRep_.suspend(string);
    }

    public static int resume(String string) {
        return svcRep_.resume(string);
    }

    public static int remove(String string) {
        return svcRep_.remove(string);
    }

    public static String info(String string) {
        return svcRep_.info(string);
    }

    public static int fini(String string) {
        return svcRep_.fini(string);
    }

    public static int init(String string, String[] stringArray) {
        return svcRep_.init(string, stringArray);
    }

    public static void insert(Service service) {
        svcRep_.insert(service);
    }

    public static boolean suspended(String string) {
        return svcRep_.suspended(string);
    }

    public static boolean contains(String string) {
        return svcRep_.find(string) != null;
    }

    public static Enumeration serviceNames() {
        return svcRep_.serviceNames();
    }

    public static Enumeration services() {
        return svcRep_.services();
    }

    public static int load(String string, String string2, String[] stringArray) throws ClassNotFoundException, IllegalAccessException, InstantiationException, IOException {
        Class<?> clazz = loader_.loadClass(string2);
        Service service = (Service)clazz.newInstance();
        service.name(string);
        svcRep_.insert(service);
        return svcRep_.init(string, stringArray);
    }

    public static int load(String string, String string2, String string3) throws ClassNotFoundException, IllegalAccessException, InstantiationException, IOException {
        return ServiceConfig.load(string, string2, OS.createStringArray(string3, " "));
    }

    protected static int processDirectives() throws FileNotFoundException, IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        ACE.DEBUG("Processing directives in file " + serviceConfigFile_);
        File file = new File(serviceConfigFile_);
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException("File " + serviceConfigFile_ + " not found");
        }
        if (!file.canRead()) {
            throw new IOException("File " + serviceConfigFile_ + " not readable");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.wordChars(46, 47);
        streamTokenizer.wordChars(58, 64);
        streamTokenizer.wordChars(91, 96);
        streamTokenizer.wordChars(123, 126);
        streamTokenizer.quoteChar(34);
        streamTokenizer.commentChar(35);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.lowerCaseMode(false);
        Vector<String> vector = new Vector<String>();
        int n = 1;
        while (streamTokenizer.nextToken() != -1) {
            if (streamTokenizer.ttype == 10) {
                String string = ((String)vector.elementAt(0)).toLowerCase();
                String string2 = (String)vector.elementAt(1);
                if (vector.size() == 2) {
                    if (string.equals("remove")) {
                        ServiceConfig.remove(string2);
                    } else if (string.equals("suspend")) {
                        ServiceConfig.suspend(string2);
                    } else if (string.equals("resume")) {
                        ServiceConfig.resume(string2);
                    }
                } else {
                    if (!string.equals("load")) {
                        throw new IOException("Unknown command: " + string + " at line " + n);
                    }
                    if (vector.size() < 5) {
                        throw new IOException("Line " + n + " requires 5 values, not " + vector.size());
                    }
                    String string3 = (String)vector.elementAt(2);
                    if (vector.size() > 5) {
                        try {
                            String string4 = (String)vector.elementAt(5);
                            loader_.addURLPath(string4);
                        }
                        catch (MalformedURLException malformedURLException) {
                            ACE.ERROR("Bad code base on line " + n);
                        }
                    }
                    ServiceConfig.load(string2, string3, (String)vector.elementAt(4));
                }
                ++n;
                vector.removeAllElements();
                continue;
            }
            if (streamTokenizer.ttype == -3 || streamTokenizer.ttype == 34) {
                vector.addElement(new String(streamTokenizer.sval));
                continue;
            }
            ACE.DEBUG("Invalid string on line " + n + " element " + vector.size() + " type " + streamTokenizer.ttype);
        }
        return 0;
    }

    public static void close() {
        svcRep_.close();
    }

    public static ServiceLoader loader() {
        return loader_;
    }

    public static void loader(ServiceLoader serviceLoader) {
        loader_ = serviceLoader;
    }
}

